/* This is y4vmshell.c
   An example of the use of the  Y4vm library
   Copyright (C) 1998 Daniel Spangberg
   */

/*
  $Log$
  Revision 1.2  2006/03/06 13:33:53  daniels
  fixed include stdlib.h

  Revision 1.1.1.1  2001/10/30 13:52:34  daniels
  Initial checkin

  Revision 1.10  1998/11/11 20:53:59  daniels
  Changed to new external interface.

  Revision 1.9  1998/08/10 22:37:55  daniels
  Added simple file management.

  Revision 1.8  1998/06/23 10:51:40  daniels
  *** empty log message ***

  Revision 1.7  1998/06/22 16:11:46  daniels
  *** empty log message ***

  Revision 1.6  1998/02/23 23:39:12  daniels
  Forgot to include types.h

  Revision 1.5  1998/02/02 20:35:50  daniel
  *** empty log message ***

  Revision 1.4  1998/01/31 21:27:39  daniel
  Fixed bug. Forgot to include y4vmload

  Revision 1.3  1998/01/31 20:03:33  daniel
  Added loading

  Revision 1.2  1998/01/31 14:00:14  daniel
  A simple but working shell

  Revision 1.1  1998/01/31 12:41:16  daniel
  Initial revision

  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <y4vm.h>
#include <y4vmmath.h>
#include <y4vmfile.h>
#include <y4vmload.h>

static void vmshellinit();

static void my_quit()
{
  exit(0);
}

static void my_reset()
{
  vmshellinit();
  save_vm_state();
}

static int vm_is_running;

static void data_from_vm(char *str)
{
  printf("%s",str);
}

static void vmshellinit()
{
  char cstr[1000];
  vm_clear();
  add_vm_send_data_handler(data_from_vm);
  vm_parse_and_compile("stop");
  save_vm_state();
  init_vmload();
  init_vmfile();
  vmload_add_search_dir("./");
  init_vmmath();
  add_y4_word("quit",my_quit);
  add_y4_word("reset",my_reset);
  sprintf(cstr,"Y4vm shell. Y4vm version %s\n",vm_get_version_string());
  vmputs(cstr);
}

static void run_vm()
{
  while(1)
    {
      char mybuf[256];
      while (vm_is_running)
	vm_is_running=vm_tick();
      restore_vm_state();
      if (fgets(mybuf,256,stdin)!=NULL)
	{
	  vm_run();
	  vm_is_running=1;
	  vm_parse_and_compile(mybuf);
	  vm_parse_and_compile("stop");
	  save_vm_state();
	}
    }
}

int main()
{
  vm_init();
  vmshellinit();
  vm_run();
  vm_is_running=1;
  run_vm();
  return 0;
}

