/* This is y4vmmath.c
   A part of the Y4vm library
   Copyright (C) 1998 Daniel Spangberg
   */

/*
  $Log$
  Revision 1.1  2001/10/30 13:52:34  daniels
  Initial revision

  Revision 1.11  1998/11/11 21:18:48  daniels
  Changed to new interface.

  Revision 1.10  1998/06/26 11:52:18  daniels
  Added boolean operators.

  Revision 1.9  1998/06/23 10:50:26  daniels
  *** empty log message ***

  Revision 1.8  1998/06/22 16:02:41  daniels
  ***empty log message***

  Revision 1.7  1998/06/03 15:34:33  daniels
  Added word random.

  Revision 1.6  1998/03/03 15:47:53  daniels
  Added more math functions

  Revision 1.5  1998/02/09 13:24:24  daniel
  Added neg function

  Revision 1.4  1998/02/04 19:52:14  daniel
  Check for definition of pi

  Revision 1.3  1998/01/31 23:11:58  daniel
  Added modulus

  Revision 1.2  1998/01/31 18:01:20  daniel
  Added some math functions

  Revision 1.1  1998/01/31 17:40:24  daniel
  Initial revision

  */

#include <stdlib.h>
#include <math.h>
#include <y4vm.h>
#include <y4vmmath.h>

#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI 3.14159265359
#endif
#endif

static void my_sin()
{
  if (test_pop_stack("sin"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=sin(data.data.mydouble);
      push_stack(data);
    }
}

static void my_cos()
{
  if (test_pop_stack("cos"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=cos(data.data.mydouble);
      push_stack(data);
    }
}

static void my_degrees()
{
  if (test_pop_stack("degrees"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=data.data.mydouble*PI/180.;
      push_stack(data);
    }
}

static void my_neg()
{
  if (test_pop_stack("neg"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=-data.data.mydouble;
      push_stack(data);
    }
}

static void my_pi()
{
  if (test_push_stack("pi"))
    {
      vm_data data;
      data.type=DATA_FLOAT;
      data.data.mydouble=PI;
      push_stack(data);
    }
}

static void my_mod()
{
  if (test_pop_stack("%"))
    {
      vm_data p1=pop_stack();
      if (test_pop_stack("%"))
	{
	  long i1,i2;
	  vm_data p2=pop_stack();
	  i1=(int)(p1.data.mydouble+0.5);
	  i2=(int)(p2.data.mydouble+0.5);
	  if (i1!=0)
	    {
	      p1.data.mydouble=(double)(i2%i1);
	      push_stack(p1);
	    }
	  else
	    {
	      vmputs("Division by 0 in %\n");
	      vm_stop();
	    }
	}
    }
}

static void my_tan()
{
  if (test_pop_stack("tan"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=tan(data.data.mydouble);
      push_stack(data);
    }
}

static void my_sqrt()
{
  if (test_pop_stack("sqrt"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=sqrt(data.data.mydouble);
      push_stack(data);
    }
}

static void my_acos()
{
  if (test_pop_stack("acos"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=acos(data.data.mydouble);
      push_stack(data);
    }
}

static void my_asin()
{
  if (test_pop_stack("asin"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=asin(data.data.mydouble);
      push_stack(data);
    }
}

static void my_atan()
{
  if (test_pop_stack("atan"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=atan(data.data.mydouble);
      push_stack(data);
    }
}

static void my_cosh()
{
  if (test_pop_stack("cosh"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=cosh(data.data.mydouble);
      push_stack(data);
    }
}

static void my_sinh()
{
  if (test_pop_stack("sinh"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=sinh(data.data.mydouble);
      push_stack(data);
    }
}

static void my_tanh()
{
  if (test_pop_stack("tanh"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=tanh(data.data.mydouble);
      push_stack(data);
    }
}

static void my_acosh()
{
  if (test_pop_stack("acosh"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=acosh(data.data.mydouble);
      push_stack(data);
    }
}

static void my_asinh()
{
  if (test_pop_stack("asinh"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=asinh(data.data.mydouble);
      push_stack(data);
    }
}

static void my_atanh()
{
  if (test_pop_stack("atanh"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=atanh(data.data.mydouble);
      push_stack(data);
    }
}

static void my_exp()
{
  if (test_pop_stack("exp"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=exp(data.data.mydouble);
      push_stack(data);
    }
}

static void my_log()
{
  if (test_pop_stack("log"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=log(data.data.mydouble);
      push_stack(data);
    }
}

static void my_log10()
{
  if (test_pop_stack("log10"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=log10(data.data.mydouble);
      push_stack(data);
    }
}

static void my_pow()
{
  if (test_pop_stack("pow"))
    {
      vm_data data=pop_stack();
      if (test_pop_stack("pow"))
	{
	  vm_data data2=pop_stack();
	  data.data.mydouble=pow(data2.data.mydouble,data.data.mydouble);
	  push_stack(data);
	}
    }
}

static void my_abs()
{
  if (test_pop_stack("abs"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=abs(data.data.mydouble);
      push_stack(data);
    }
}

static void my_ceil()
{
  if (test_pop_stack("ceil"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=ceil(data.data.mydouble);
      push_stack(data);
    }
}

static void my_floor()
{
  if (test_pop_stack("floor"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=floor(data.data.mydouble);
      push_stack(data);
    }
}

static void my_rad2deg()
{
  if (test_pop_stack("rad2deg"))
    {
      vm_data data=pop_stack();
      data.data.mydouble=data.data.mydouble*180./PI;
      push_stack(data);
    }
}

static void my_random()
{
  if (test_push_stack("random"))
    {
      vm_data data;
      data.type=DATA_FLOAT;
      data.data.mydouble=((double)rand()/(RAND_MAX+1.));
      push_stack(data);
    }
}

static void my_or()
{
  if (test_pop_stack("or"))
    {
      vm_data data=pop_stack();
      vm_data data2=pop_stack();
      data.data.mydouble=(int)(data.data.mydouble) | (int)(data2.data.mydouble);
      push_stack(data);
    }
}

static void my_and()
{
  if (test_pop_stack("and"))
    {
      vm_data data=pop_stack();
      vm_data data2=pop_stack();
      data.data.mydouble=(int)(data.data.mydouble) & (int)(data2.data.mydouble);
      push_stack(data);
    }
}

static void my_xor()
{
  if (test_pop_stack("xor"))
    {
      vm_data data=pop_stack();
      vm_data data2=pop_stack();
      data.data.mydouble=(int)(data.data.mydouble) ^ (int)(data2.data.mydouble);
      push_stack(data);
    }
}

static void my_not()
{
  if (test_pop_stack("not"))
    {
      vm_data data=pop_stack();
      if((int)(data.data.mydouble))
	data.data.mydouble=0;
      else
	data.data.mydouble=1;
      push_stack(data);
    }
}

void init_vmmath()
{
  add_y4_word("sin",my_sin);
  add_y4_word("cos",my_cos);
  add_y4_word("degrees",my_degrees);
  add_y4_word("pi",my_pi);
  add_y4_word("%",my_mod);
  add_y4_word("neg",my_neg);
  add_y4_word("tan",my_tan);
  add_y4_word("sqrt",my_sqrt);
  add_y4_word("acos",my_acos);
  add_y4_word("asin",my_asin);
  add_y4_word("atan",my_atan);
  add_y4_word("cosh",my_cosh);
  add_y4_word("sinh",my_sinh);
  add_y4_word("tanh",my_tanh);
  add_y4_word("acosh",my_acosh);
  add_y4_word("asinh",my_asinh);
  add_y4_word("atanh",my_atanh);
  add_y4_word("exp",my_exp);
  add_y4_word("log",my_log);
  add_y4_word("log10",my_log10);
  add_y4_word("pow",my_pow);
  add_y4_word("abs",my_abs);
  add_y4_word("ceil",my_ceil);
  add_y4_word("floor",my_floor);
  add_y4_word("rad2deg",my_rad2deg);
  add_y4_word("random",my_random);
  add_y4_word("or",my_or);
  add_y4_word("and",my_and);
  add_y4_word("xor",my_xor);
  add_y4_word("not",my_not);
}

