/* This is y4vmload.c
   A part of the Y4vm library
   Copyright (C) 1998 Daniel Spangberg
   */

/*
  $Log$
  Revision 1.1  2001/10/30 13:52:34  daniels
  Initial revision

  Revision 1.16  1998/11/11 21:19:38  daniels
  New interface.

  Revision 1.15  1998/06/23 10:49:55  daniels
  *** empty log message ***

  Revision 1.14  1998/06/22 15:41:59  daniels
  *** empty log message ***

  Revision 1.13  1998/06/18 10:35:46  daniels
  Change to make things work better on win32??

  Revision 1.12  1998/03/03 18:06:28  daniels
  Update for better string management

  Revision 1.11  1998/02/23 23:39:09  daniels
  Forgot to include types.h

  Revision 1.10  1998/02/09 13:24:00  daniel
  Made search routine global

  Revision 1.9  1998/02/08 13:45:13  daniel
  *** empty log message ***

  Revision 1.8  1998/02/03 15:33:22  daniel
  Forgot to append string terminator after load

  Revision 1.7  1998/02/03 14:39:39  daniel
  Fixed load function.

  Revision 1.6  1998/02/02 20:35:46  daniel
  *** empty log message ***

  Revision 1.5  1998/02/01 19:41:25  daniel
  Changed way of setting machine parameters when loading

  Revision 1.4  1998/02/01 15:10:02  daniel
  Added file extension

  Revision 1.3  1998/01/31 21:27:21  daniel
  Fixed bug

  Revision 1.2  1998/01/31 20:03:04  daniel
  Load seems to work

  Revision 1.1  1998/01/31 19:34:14  daniel
  Initial revision

  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <y4vm.h>
#include <y4vmload.h>

#define EXT ".y4"

typedef struct searchdir
{
  char *dir;
  struct searchdir *next;
} searchdir;

static searchdir *mysearchdir=NULL;

void vmload_add_search_dir(char *dir)
{
  searchdir *new=malloc(sizeof(searchdir));
  new->dir=malloc((strlen(dir)+1));
  strcpy(new->dir,dir);
  new->next=mysearchdir;
  mysearchdir=new;
}

FILE *vmload_get_fileptr(char *file,char *extension,char **fullname, off_t *fsize)
{
  char tmp[4096];
  FILE *fptr=NULL;
  if (file!=NULL)
    {
      /* Now we must search for the file in the search path */
      int file_found=0;
      searchdir *ptr=mysearchdir;
      char *fname;
      while ((ptr!=NULL) && (file_found==0))
	{
	  struct stat mystat;
	  fname=malloc((strlen(ptr->dir)+strlen(file)+strlen(extension)+1));
	  strcpy(fname,ptr->dir);
	  strcat(fname,file);
	  strcat(fname,extension);
	  fptr=fopen(fname,"r");
	  if (fptr!=NULL)
	    {
	      if (!stat(fname,&mystat))
		{
		  *fsize=mystat.st_size;
		  file_found=1;
		}
	      else
		{
		  /* Can't stat file */
		  fclose(fptr);
		}
	    }
	  if (!file_found)
	    {
	      free(fname);
	      ptr=ptr->next;
	    }
	}
      if (!file_found)
	{
	  sprintf(tmp,"Cannot load file %s\n",file);
	  vmputs(tmp);
	  fptr=NULL;
	}
      else
	{
	  *fullname=fname;
	}
    }
  return(fptr);
}

static void load_file()
{
  if (test_pop_stack("load"))
    {
      vm_data data=pop_stack();
      if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	{
	  vmputs("load needs a pointer to a string on the stack\n");
	  vm_stop();
	}
      else
	{
	  char *fullname;
	  FILE *fptr;
	  off_t fsize;
	  char *file=vm_get_string_from_vm(data.type,data.data.myint);
	  if (file!=NULL)
	    {
	      fptr=vmload_get_fileptr(file,EXT,&fullname,&fsize);
	      if (fptr!=NULL)
		{
		  int myfsz;
		  char tmp[4096];
		  char *mybuf=malloc((fsize+1));
		  sprintf(tmp,"Loading %s. Filesize is %d bytes\n",file,(int)fsize);
		  vmputs(tmp);
		  restore_vm_state(); /* Drop old data */
		  vm_run();
		  if ((myfsz=fread(mybuf,1,(int)fsize,fptr))!=((int)fsize))
		    {
		      sprintf(tmp,"Warning: only read %d bytes\n",myfsz);
		      vmputs(tmp);
		      fsize=myfsz;
		    }
		  mybuf[fsize]='\0';
		  vm_parse_and_compile(mybuf);
		  vm_parse_and_compile("stop");
		  save_vm_state();
		  /* This one was hard to catch:
		     When this function returns to vm_tick(), vm_pc is going to be increased.
		     Therefore it is necessary to decrease it's size with 1 here... phuu... */
		  fiddle_with_pc(-1);
		  free(mybuf);
		  fclose(fptr);
		  free(fullname);
		}
	      free(file);
	    }
	}
    }
}

static void add_searchdir()
{
  if (test_pop_stack("search-dir"))
    {
      vm_data data=pop_stack();
      if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	{
	  vmputs("search-dir needs a pointer to a string on the stack\n");
	  vm_stop();
	}
      else
	{
	  char *sdir=vm_get_string_from_vm(data.type,data.data.myint);
	  vmload_add_search_dir(sdir);  
	}
    }
}

static void list_searchdir()
{
  searchdir *ptr=mysearchdir;
  while (ptr!=NULL)
    {
      vmputs(ptr->dir);
      vmputs("\n");
      ptr=ptr->next;
    }
}

void init_vmload()
{
  add_y4_word("load",load_file);
  add_y4_word("search-dir",add_searchdir);
  add_y4_word("list-search-dir",list_searchdir);
}

