/* This is y4vmfile.c
   A part of the Y4vm library
   Copyright (C) 1998 Daniel Spangberg
   */

/*
  $Log$
  Revision 1.2  2006/03/06 19:22:00  daniels
  removed ugly message.

  Revision 1.1.1.1  2001/10/30 13:52:34  daniels
  Initial checkin

  Revision 1.2  1998/11/11 21:07:42  daniels
  New interface.

  Revision 1.1  1998/08/10 22:37:39  daniels
  Initial revision

  */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <y4vm.h>
#include <y4vmfile.h>

#define NOT_OPEN 0
#define OPEN_FOR_INPUT 1
#define OPEN_FOR_OUTPUT 2

typedef struct vm_file_t
{
  char *filename;
  char open_mode;
  int id;
  FILE *thefile;
  struct vm_file_t *next;
} vm_file_t;

static vm_file_t *vm_file=NULL;

static void vm_open()
{
  if (test_pop_stack("open"))
    {
      vm_data p1=pop_stack();
      if ((p1.type!=DATA_POINTER_TO_STRING) && (p1.type!=DATA_POINTER_TO_CODE_STRING))
	{
	  vmputs("open needs string on stack\n");
	  vm_stop();
	}
      else
	{
	  vm_file_t *ptr=vm_file;
	  vm_file_t *new=malloc(sizeof(vm_file_t));
	  new->filename=vm_get_string_from_vm(p1.type,p1.data.myint);
	  if (ptr==NULL)
	    {
	      new->id=0;
	      new->next=ptr;
	      vm_file=new;
	    }
	  else
	    {
	      int id=-1;
	      int found=0;
	      vm_file_t *tmp=NULL;
	      while (!found)
		{
		  if (ptr==NULL)
		    found=1;
		  else
		    if (ptr->id>(id+1))
		      found=1;
		    else
		      {
			tmp=ptr;
			id=ptr->id;
			ptr=ptr->next;
		      }
		}
	      new->id=id+1;
	      new->next=ptr;
	      if (tmp==NULL)
		vm_file=new;
	      else
		tmp->next=new;
	    }
	  new->open_mode=NOT_OPEN;
	  p1.type=DATA_FLOAT;
	  p1.data.mydouble=new->id;
	  push_stack(p1);
	}
    }
}

static void vm_close()
{
  if (test_pop_stack("close"))
    {
      vm_data p1=pop_stack();
      if (p1.type!=DATA_FLOAT)
	{
	  vmputs("close needs id on stack\n");
	  vm_stop();
	}
      else
	{
	  int id=(int)(p1.data.mydouble+0.5);
	  vm_file_t *ptr=vm_file,*tmp=NULL;
	  while ((ptr!=NULL) && (ptr->id!=id))
	    {
	      tmp=ptr;
	      ptr=ptr->next;
	    }
	  if (ptr==NULL)
	    {
	      vmputs("Cannot close file that is not opened.\n");
	      vm_stop();
	    }
	  else
	    {
	      if (ptr->open_mode==NOT_OPEN)
		printf("Nothing was written to or read from file %s.\n",ptr->filename);
	      else
		fclose(ptr->thefile);
	      free(ptr->filename);
	      if (tmp==NULL)
		vm_file=ptr->next;
	      else
		tmp->next=ptr->next;
	      free(ptr);
	    }
	}
    }
}

static vm_file_t *get_file_struct(int id)
{
  vm_file_t *ptr=vm_file;
  while ((ptr!=NULL) && (ptr->id!=id))
    ptr=ptr->next;
  if (ptr==NULL)
    return NULL;
  return ptr;
}

static void output_to_file()
{
  if (test_pop_stack("<<"))
    {
      vm_data p1=pop_stack();      
      if (test_pop_stack("<<"))
	{
	  vm_data p2=pop_stack();      
	  if ((p1.type!=DATA_FLOAT) ||
	      ((p2.type!=DATA_FLOAT) &&
	       (p2.type!=DATA_POINTER_TO_STRING) &&
	       (p2.type!=DATA_POINTER_TO_CODE_STRING)))
	    {
	      vmputs("<< needs two parameters on stack.\n");
	      vm_stop();
	    }
	  else
	    {
	      vm_file_t *ptr=get_file_struct((int)(p1.data.mydouble+0.5));
	      if (ptr==NULL)
		{
		  vmputs("Cannot produce output to file that wasn't opened with open.\n");
		  vm_stop();
		}
	      else
		{
		  if (ptr->open_mode==NOT_OPEN)
		    {
		      ptr->thefile=fopen(ptr->filename,"w");
		      if (ptr->thefile!=NULL)
			ptr->open_mode=OPEN_FOR_OUTPUT;
		    }
		  if (ptr->open_mode!=OPEN_FOR_OUTPUT)
		    {
		      vmputs("Cannot produce output to file that has been read from, or unable to open file.\n");
		      vm_stop();
		    }
		  else
		    {
		      if (p2.type==DATA_FLOAT)
			fprintf(ptr->thefile,"%16e",p2.data.mydouble);
		      else
			{
			  char *d=vm_get_string_from_vm(p2.type,p2.data.myint);
			  fprintf(ptr->thefile,"%s",d);
			  free(d);
			}
		    }
		}
	    }
	}
    }
}

static void input_from_file()
{
  if (test_pop_stack(">>"))
    {
      vm_data p1=pop_stack();      
      if (p1.type!=DATA_FLOAT)
	{
	  vmputs(">> needs a parameter on stack.\n");
	  vm_stop();
	}
      else
	{
	  vm_file_t *ptr=get_file_struct((int)(p1.data.mydouble+0.5));
	  if (ptr==NULL)
	    {
	      vmputs("Cannot input from file that wasn't opened with open.\n");
	      vm_stop();
	    }
	  else
	    {
	      if (ptr->open_mode==NOT_OPEN)
		{
		  ptr->thefile=fopen(ptr->filename,"r");
		  if (ptr->thefile!=NULL)
		    ptr->open_mode=OPEN_FOR_INPUT;
		}
	      if (ptr->open_mode!=OPEN_FOR_INPUT)
		{
		  vmputs("Cannot input from file that has been written to, or unable to open file.\n");
		  vm_stop();
		}
	      else
		{
		  fscanf(ptr->thefile,"%lf",&p1.data.mydouble);
		  push_stack(p1);
		}
	    }
	}
    }
}

static void inquire_file()
{
  if (test_pop_stack("inquire"))
    {
      vm_data p1=pop_stack();
      if ((p1.type!=DATA_POINTER_TO_STRING) && (p1.type!=DATA_POINTER_TO_CODE_STRING))
	{
	  vmputs("inquire needs string on stack\n");
	  vm_stop();
	}
      else
	{
	  char *fname=vm_get_string_from_vm(p1.type,p1.data.myint);
	  struct stat mystat;
	  p1.type=DATA_FLOAT;
	  if (stat(fname,&mystat))
	    p1.data.mydouble=0;
	  else
	    p1.data.mydouble=1;
	  push_stack(p1);
	}
    }
}

static void do_system_call()
{
  if (test_pop_stack("system"))
    {
      vm_data data=pop_stack();
      if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	{
	  vmputs("system needs a pointer to a string on the stack\n");
	  vm_stop();
	}
      else
	{
	  char *file=vm_get_string_from_vm(data.type,data.data.myint);
	  if (file!=NULL)
	    {
		system(file);
	    }
	  else
	      printf("No string for system!\n");
	}
    }
}

void init_vmfile()
{
  add_y4_word("open",vm_open);
  add_y4_word("close",vm_close);
  add_y4_word(">>",input_from_file);
  add_y4_word("<<",output_to_file);
  add_y4_word("inquire",inquire_file);
  add_y4_word("system",do_system_call);
}

