#!/bin/sh
MYUSER=`whoami`
UNAME=`uname`
UNAMEM=`uname -m |sed 's/i.86/i386/'`
UNAME=$UNAME.$UNAMEM
if [ $MYUSER = root ]; then
# Special root install. Install binary to /usr/local/bin, libraries to /usr/local/lib,
# include files to /usr/local/include and files needed by ymol to /usr/local/lib/ymol
# You are of course free to change these to whatever you like... :-)
# if you do not want the libraries and include files installed. Set DOLIBINCLUDEINSTALL to 0
    BININSTALL=/usr/local/bin
    DOLIBINCLUDEINSTALL=1
    LIBINSTALL=/usr/local/lib
    INCLUDEINSTALL=/usr/local/include
else
    BININSTALL=$HOME/bin
    DOLIBINCLUDEINSTALL=1
    LIBINSTALL=$HOME/lib/$UNAME
    INCLUDEINSTALL=$HOME/lib/$UNAME
fi

if [ $DOLIBINCLUDEINSTALL = 1 ]; then
    if [ -d $LIBINSTALL ]; then
	echo Directory $LIBINSTALL already exists
    else
	echo Creating directory $LIBINSTALL
	mkdir -p $LIBINSTALL
    fi
    echo Installing libraries to $LIBINSTALL
    cp liby4vm.a $LIBINSTALL

    if [ -d $INCLUDEINSTALL ]; then
	echo Directory $INCLUDEINSTALL already exists
    else
	echo Creating directory $INCLUDEINSTALL
	mkdir -p $INCLUDEINSTALL
    fi
    echo Installing include files to $INCLUDEINSTALL
    cp y4vm*.h $INCLUDEINSTALL
fi

if [ -d $BININSTALL ]; then
    echo Directory $BININSTALL already exists
else
    echo Creating directory $BININSTALL
    mkdir -p $BININSTALL
fi
echo Installing binary to $BININSTALL
strip y4vm
rm -f $BININSTALL/y4vm.$UNAME
cp y4vm $BININSTALL/y4vm.$UNAME
cp oswrap.sh $BININSTALL
rm -f $BININSTALL/y4vm
ln -s oswrap.sh $BININSTALL/y4vm

echo Installation complete
echo Make sure you have $BININSTALL in the path

