/* This is ymolvm.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <Xco.h>
#include <signal.h>
#include <y4vm.h>
#include <y4vmload.h>
#include "vmconsole.h"
#include "ymolvm.h"
#include "ccinterface.h"
#include "fstring.h"
#include "userinterface.h"
#include "triangleworld.h"
#include "defaults.h"
#include "filenamegood.h"
#include "render_params.h"
#include "ymolrc.h"
#include "rotpanel.h"
#include "ymolsignal.h"
#include "xinterface.h"
#include "povraywrite.h"
#include "postscript.h"
#include "labeldraw.h"
#include "dxexport.h"

#define W_SYNC 0
#define W_WUPD 1
#define W_FUPD 2
#define W_FOGPROP 3
#define W_FOGPROP2 4
#define W_QUIT 5
#define W_RESET 6
#define W_FADE 7
#define W_MOVIEPLAY 8
#define W_MOVIELOAD 9
#define W_MATRIXOP 10
#define W_MATRIXSET 11
#define W_SETIMPORTFLAG 12
#define W_MOVIEIMPORT 13
#define W_TESTSIGNAL 14
#define W_RESETSIGNAL 15
#define W_SETDEFAULTBONDRULES 16
#define W_APPLYBONDRULES 17
#define W_MATRIXINIT 18
#define W_PPMLOAD 19
#define W_GETTIMEOFDAY 20
#define W_PPMSAVE 21
#define W_ADDTOOLMENU 22
#define W_FILEDIALOG 23
#define W_POVRAY 24
#define W_DOSIGNAL 25
#define W_GETNATOMS 26
#define W_GETATOM 27
#define W_SETCK 28
#define W_SETZMIN 29
#define W_SETZMAX 30
#define W_SETLABELFONT 31
#define W_MOVIELOADSTYLE 32
#define W_DXEXPORT 33
#define W_LABEL_Z_OFFSET 34
#define W_LABEL_COLOR 35
#define W_LABEL_SCALE 36
#define W_LABEL_XY_OFFSET 37
#define W_POVSAVE 38
#define W_STEPAR 39
#define W_PSSAVE 40
#define MAXWORDS 41 /* *Must* be larger than all words */

static unsigned int words[MAXWORDS];
static char *names[MAXWORDS]=
{
  "sync",
  "world-update",
  "frame-update",
  "fog-amount",
  "fog-origin",
  "quit",
  "reset",
  "fade",
  "movie-play",
  "movie-load",
  "matrix-op",
  "matrix-set",
  "set-import-flag",
  "movie-import",
  "test-signal",
  "reset-signal",
  "set-default-bond-rules",
  "apply-bond-rules",
  "global-matrix-init",
  "ppm-load",
  "get-time-of-day",
  "ppm-save",
  "add-tool-menu",
  "file-dialog",
  "use-povray",
  "do-signal",
  "get-number-of-atoms",
  "get-atom",
  "set-ck",
  "set-zmin",
  "set-zmax",
  "set-labelfont",
  "movie-load-style",
  "dx-export",
  "label-z-offset",
  "label-color",
  "label-scale",
  "label-xy-offset",
  "pov-save",
  "stereo-parameters",
  "ps-save",
};

static char *filedialogext;
static unsigned int filedialogaddress;

static int filedialog_sub(char *name)
{
  int rval=1;
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+2+strlen(filedialogext));
      char *fixname=malloc(strlen(name)+4+strlen(filedialogext));
      strcpy(myname,name);
      filenamegood(myname,filedialogext,filedialogext);
      strcpy(fixname,"'");
      strcat(fixname,myname);
      strcat(fixname,"'");
      vmconsole_call(filedialogaddress,fixname);
      free(fixname);
      free(myname);
    }
  return (rval);
}

static void ymol_words(unsigned int handle)
{
  if (handle==words[W_SYNC])
    {
      vm_sync();
    }
  else if (handle==words[W_WUPD])
    {
      wupd_();
    }
  else if (handle==words[W_FUPD])
    {
      fupd_();
    }
  else if (handle==words[W_QUIT])
    {
      quit_app();
    }
  else if (handle==words[W_RESET])
    {
      vmconsoleinit();
      save_vm_state();
      load_ymolrc();
      vm_invalidate();
    }
  else if (handle==words[W_FOGPROP])
    {
      if (test_pop_stack("fog-amount"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("fog-amount requires a float\n");
	  else
	    set_fogging_prop(data.data.mydouble);
	}
    }
  else if (handle==words[W_FOGPROP2])
    {
      if (test_pop_stack("fog-origin"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("fog-origin requires a float\n");
	  else
	    set_fogging_prop2(data.data.mydouble);
	}
    }
  else if (handle==words[W_FADE])
    {
      if (test_pop_stack("fade"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("fade requires a float\n");
	  else
	    set_fading((int)(.5+data.data.mydouble*255));
	}
    }
  else if (handle==words[W_LABEL_Z_OFFSET])
    {
      if (test_pop_stack("label-z-offset"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("label-z-offset requires a float\n");
	  else
	  {
	    set_label_z_offset(data.data.mydouble);
	    wupd_();
	  }
	}
    }
  else if (handle==words[W_LABEL_SCALE])
    {
      if (test_pop_stack("label-scale"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("label-scale requires a float\n");
	  else
	  {
	    set_label_scale(data.data.mydouble);
	    wupd_();
	  }
	}
    }
  else if (handle==words[W_LABEL_COLOR])
    {
      if (test_pop_stack("label-color"))
	{
	    int irgb;
	    double rgb[3];
	    int igotall=0;
	    for (irgb=0; irgb<3; irgb++)
	    {
		vm_data data=pop_stack();
		if (data.type!=DATA_FLOAT)
		{
		    display_line("label-color requires a float\n");
		    break;
		}
		rgb[2-irgb]=data.data.mydouble;
		if (irgb==2)
		    igotall=1;
	    }
	    if (igotall)
	    {
		set_label_color(rgb);
		wupd_();
	    }
	}
    }
  else if (handle==words[W_STEPAR])
    {
      if (test_pop_stack("stereo-parameters"))
	{
	    int ip;
	    double sp[3];
	    int igotall=0;
	    for (ip=0; ip<3; ip++)
	    {
		vm_data data=pop_stack();
		if (data.type!=DATA_FLOAT)
		{
		    display_line("stereo-parameters requires a float\n");
		    break;
		}
		sp[2-ip]=data.data.mydouble;
		if (ip==2)
		    igotall=1;
	    }
	    if (igotall)
	    {
		stepar_(sp,sp+1,sp+2);
		wupd_();
	    }
	}
    }
  else if (handle==words[W_LABEL_XY_OFFSET])
    {
      if (test_pop_stack("label-xy-offset"))
	{
	    int irgb;
	    double rgb[2];
	    int igotall=0;
	    for (irgb=0; irgb<2; irgb++)
	    {
		vm_data data=pop_stack();
		if (data.type!=DATA_FLOAT)
		{
		    display_line("label-xy-offset requires a float\n");
		    break;
		}
		rgb[1-irgb]=data.data.mydouble;
		if (irgb==1)
		    igotall=1;
	    }
	    if (igotall)
	    {
		set_label_xy_offset(rgb);
		wupd_();
	    }
	}
    }
  else if (handle==words[W_SETCK])
    {
      if (test_pop_stack("set-ck"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("set-ck requires a float\n");
	  else
	      setck(data.data.mydouble);
	}
    }
  else if (handle==words[W_SETZMIN])
    {
      if (test_pop_stack("set-zmin"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("set-zmin requires a float\n");
	  else
	      setZMIN(data.data.mydouble);
	}
    }
  else if (handle==words[W_SETZMAX])
    {
      if (test_pop_stack("set-zmax"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("set-zmax requires a float\n");
	  else
	      setZMAX(data.data.mydouble);
	}
    }
  else if (handle==words[W_MOVIEPLAY])
    {
      if (test_pop_stack("movie-play"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("movie-play requires value on stack\n");
	  else
	    {
	      int i=0;
	      if (data.data.mydouble>0)
		i=1;
	      if (data.data.mydouble<0)
		i=-1;
	      rotpanel_set_movieplay(i);
	    }
	}
    }
  else if (handle==words[W_MOVIELOAD])
    {
      if (test_pop_stack("movie-load"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("movie-load needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      FILE *fptr;
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  char *fullname;
		  off_t fsize;
		  fptr=vmload_get_fileptr(file,".ymol",&fullname,&fsize);
		  if (fptr!=NULL)
		    {
		      fclose(fptr);
		      open_and_read_file(fullname);
		      free(fullname);
		    }
		}
	    }
	}
    }
  else if (handle==words[W_MOVIELOADSTYLE])
    {
      if (test_pop_stack("movie-load-style"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("movie-load-style needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      FILE *fptr;
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  int ok=0;
		  char *fullname=malloc(strlen(file)+5);
		  sprintf(fullname,"%s.ymol",file);
		  fload_file_style(fullname,&ok);
		  free(fullname);
		  mabr_(); /* Apply bond rules */
		  mapr_(); /* Apply poly rules */
		}
	    }
	}
    }
  else if (handle==words[W_DXEXPORT])
    {
      if (test_pop_stack("dx-export"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("dx-export needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      FILE *fptr;
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		    dx_save(file);
		}
	    }
	}
    }
  else if (handle==words[W_MATRIXOP])
    {
      se2mat_();
    }
  else if (handle==words[W_MATRIXSET])
    {
      int i;
      for (i=15; i>=0; i--)
	{
	  if (test_pop_stack("matrix-set"))
	    {
	      vm_data data=pop_stack();
	      if (data.type!=DATA_FLOAT)
		{
		  vmputs("matrix-set requires value on stack\n");
		  vm_stop();
		}
	      else
		{
		  se2mel_(&i,&data.data.mydouble);
		}
	    }
	}
    }
  else if (handle==words[W_SETIMPORTFLAG])
    {
      if (test_pop_stack("set-import-flag"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    {
	      vmputs("set-import-flag requires value on stack\n");
	      vm_stop();
	    }
	  else
	    {
	      if (test_pop_stack("set-import-flag"))
		{
		  vm_data data2=pop_stack();
		  if (data2.type!=DATA_FLOAT)
		    {
		      vmputs("set-import-flag requires value on stack\n");
		      vm_stop();
		    }
		  else
		    {
		      int i=(int)data.data.mydouble;
		      fiflag_(&i,&data2.data.mydouble);
		    }
		}
	    }
	}
      
    }
  else if (handle==words[W_MOVIEIMPORT])
    {
      if (test_pop_stack("movie-import"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("movie-import needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      FILE *fptr;
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  char *fullname;
		  off_t fsize;
		  fptr=vmload_get_fileptr(file,"",&fullname,&fsize);
		  if (fptr!=NULL)
		    {
		      fclose(fptr);
		      sfimport_file(fullname);
		      free(fullname);
		    }
		}
	    }
	}
    }
  else if (handle==words[W_TESTSIGNAL])
    {
      if (test_push_stack("test-signal"))
	{
	  vm_data data;
	  data.type=DATA_FLOAT;
	  data.data.mydouble=get_signal_value();
	  push_stack(data);
	}
    }
  else if (handle==words[W_DOSIGNAL])
    {
      if (test_pop_stack("do-signal"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    {
	      vmputs("do-signal need a pid on stack\n");
	      vm_stop();
	    }
	  else
	    {
	      kill((pid_t)(data.data.mydouble+0.5),SIGUSR1);
	    }
	}
      else
	{
	  vmputs("do-signal need a pid on stack\n");
	}
    }
  else if (handle==words[W_RESETSIGNAL])
    {
      reset_signal_test();
    }
  else if (handle==words[W_SETDEFAULTBONDRULES])
    {
      sdefbr_();
    }
  else if (handle==words[W_APPLYBONDRULES])
    {
      mabrns_();
      maprns_();
    }
  else if (handle==words[W_MATRIXINIT])
    {
      itmatr_();
    }
  else if (handle==words[W_SETLABELFONT])
  {
      if (test_pop_stack("set-labelfont"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("set-labelfont needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      char *fname=vm_get_string_from_vm(data.type,data.data.myint);
	      if (fname!=NULL)
	      {
		  labeldraw_set_eface(fname);
	      }
	    }
	}
  }
  else if (handle==words[W_PPMLOAD])
    {
      if (test_pop_stack("ppm-load"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("ppm-load needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      FILE *fptr;
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  char *fullname;
		  off_t fsize;
		  fptr=vmload_get_fileptr(file,".ppm",&fullname,&fsize);
		  if (fptr!=NULL)
		    {
		      fclose(fptr);
		      ymol_load_ppm_image(fullname);
		      free(fullname);
		    }
		}
	    }
	}
    }
  else if (handle==words[W_PPMSAVE])
    {
      if (test_pop_stack("ppm-save"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("ppm-save needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  ymol_save_ppm_image(file);
		}
	    }
	}
    }
  else if (handle==words[W_PSSAVE])
    {
      if (test_pop_stack("ps-save"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("ps-save needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  ymol_save_ps_image(file);
		}
	    }
	}
    }
  else if (handle==words[W_POVSAVE])
    {
      if (test_pop_stack("pov-save"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("pov-save needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      char *file=vm_get_string_from_vm(data.type,data.data.myint);
	      if (file!=NULL)
		{
		  povray_save(file,0.);
		}
	    }
	}
    }
  else if (handle==words[W_GETTIMEOFDAY])
    {
      if (test_push_stack("get-time-of-day"))
	{
	  vm_data data;
	  struct timeval tv;
	  struct timezone tz;
	  gettimeofday(&tv,&tz);
	  data.type=DATA_FLOAT;
	  data.data.mydouble=tv.tv_sec+1e-6*tv.tv_usec;
	  push_stack(data);
	}
    }
  else if (handle==words[W_POVRAY])
    {
      set_draw_style(DRAW_STYLE_3D_SPHERES);
      set_3d_mode(MODE_STYLE_POVRAY);
      update_em();
    }
  else if (handle==words[W_ADDTOOLMENU])
    {
      if (test_pop_stack("add-tool-menu"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("add-tool-menu needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      char *nm=vm_get_string_from_vm(data.type,data.data.myint);
	      if (nm!=NULL)
		{
		  if (test_pop_stack("add-tool-menu"))
		    {
		      vm_data d2=pop_stack();
		      if (d2.type!=DATA_FLOAT)
			{
			  vmputs("add-tool-menu needs to know the number of menu items.\n");
			  vm_stop();
			}
		      else
			{
			  int nitems=(int)d2.data.mydouble;
			  char **names=malloc(sizeof(char*)*nitems);
			  unsigned int *addresses=malloc(sizeof(unsigned int)*nitems);
			  int i;
			  for (i=0; i<nitems; i++)
			    {
			      if (test_pop_stack("add-tool-menu"))
				{
				  vm_data d2=pop_stack();
				  if ((d2.type!=DATA_POINTER_TO_STRING) && (d2.type!=DATA_POINTER_TO_CODE_STRING))
				    {
				      vmputs("add-tool-menu needs a menu item name.\n");
				      vm_stop();
				    }
				  else
				    {
				      names[i]=vm_get_string_from_vm(d2.type,d2.data.myint);
				    }
				}
			      if (test_pop_stack("add-tool-menu"))
				{
				  vm_data d2=pop_stack();
				  if (d2.type!=DATA_POINTER_TO_FUNCTION)
				    {
				      vmputs("add-tool-menu needs a menu item function.\n");
				      vm_stop();
				    }
				  else
				    {
				      addresses[i]=d2.data.myint;
				    }
				}
			    }
			  AddToolMenu(nm,names,nitems,addresses);
			  for (i=0; i<nitems; i++)
			    free(names[i]);
			  free(names);
			  free(addresses);
			}
		    }
		}
	    }
	}      
    }
  else if (handle==words[W_FILEDIALOG])
    {
      if (test_pop_stack("file-dialog"))
	{
	  vm_data data=pop_stack();
	  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
	    {
	      vmputs("file-dialog needs a pointer to a string on the stack\n");
	      vm_stop();
	    }
	  else
	    {
	      char *name=vm_get_string_from_vm(data.type,data.data.myint);
	      if (test_pop_stack("file-dialog"))
		{
		  vm_data data=pop_stack();
		  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
		    {
		      vmputs("file-dialog needs a pointer to a string on the stack\n");
		      vm_stop();
		    }
		  else
		    {
		      char *bname=vm_get_string_from_vm(data.type,data.data.myint);
		      if (test_pop_stack("file-dialog"))
			{
			  vm_data data=pop_stack();
			  if ((data.type!=DATA_POINTER_TO_STRING) && (data.type!=DATA_POINTER_TO_CODE_STRING))
			    {
			      vmputs("file-dialog needs a pointer to a string on the stack\n");
			      vm_stop();
			    }
			  else
			    {
			      char *ext[2];
			      filedialogext=vm_get_string_from_vm(data.type,data.data.myint);
			      ext[0]=filedialogext;
			      ext[1]="";
			      if (test_pop_stack("file-dialog"))
				{
				  vm_data data=pop_stack();
				  if (data.type!=DATA_POINTER_TO_FUNCTION)
				    {
				      vmputs("file-dialog needs a function on stack.\n");
				      vm_stop();
				    }
				  else
				    {
				      filedialogaddress=data.data.myint;
				      XcoFileDialog(name,bname,ext,2,filedialog_sub);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
  else if (handle==words[W_GETNATOMS])
    {
      if (test_push_stack("get-number-of-atoms"))
	{
	  vm_data data;
	  int natoms;
	  qna_(&natoms);
	  data.type=DATA_FLOAT;
	  data.data.mydouble=natoms;
	  push_stack(data);
	}
    }
  else if (handle==words[W_GETATOM])
    {
      if (test_pop_stack("get-atom"))
	{
	  vm_data data=pop_stack();
	  if (data.type!=DATA_FLOAT)
	    display_line("get-atom requires a float\n");
	  else
	    {
	      int thisatom=(int)(.5+data.data.mydouble);
	      int issel,id,n;
	      double x,y,z;
	      qasel_(&thisatom,&issel);
	      qaxyz_(&thisatom,&x,&y,&z);
	      qaid_(&thisatom,&id);
	      qan_(&thisatom,&n);
	      data.type=DATA_FLOAT;
	      if (test_push_stack("get-atom"))
		{
		  data.data.mydouble=issel;
		  push_stack(data);
		  if (test_push_stack("get-atom"))
		    {
		      data.data.mydouble=id;
		      push_stack(data);
		      if (test_push_stack("get-atom"))
			{
			  data.data.mydouble=n;
			  push_stack(data);
			  if (test_push_stack("get-atom"))
			    {
			      data.data.mydouble=z;
			      push_stack(data);
			      if (test_push_stack("get-atom"))
				{
				  data.data.mydouble=y;
				  push_stack(data);
				  if (test_push_stack("get-atom"))
				    {
				      data.data.mydouble=x;
				      push_stack(data);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
}


static void y_set_oversampling()
{
  if (test_pop_stack("set-oversampling"))
    {
      vm_data data=pop_stack();
      if (data.type!=DATA_FLOAT)
	display_line("set-oversampling requires a float\n");
      else
	{
	  set_global_oversampling((int)(.5+data.data.mydouble));
	  set_oversampling(get_global_oversampling());
	}
    }
}

static void y_write_pov()
{
  set_writeinc(1);
}

static void y_no_write_pov()
{
  set_writeinc(0);
}

static void y_write_pov2()
{
  set_writeinc2(1);
}

static void y_no_write_pov2()
{
  set_writeinc2(0);
}

void init_ymol_words()
{
  int i;
  add_external_interface(ymol_words);
  for (i=0; i<MAXWORDS; i++)
    words[i]=add_external_word(names[i]);

  add_y4_word("set-oversampling",y_set_oversampling);
  add_y4_word("povray-write-header",y_write_pov);
  add_y4_word("povray-no-write-header",y_no_write_pov);
  add_y4_word("povray-write-header2",y_write_pov2);
  add_y4_word("povray-no-write-header2",y_no_write_pov2);
}
