/* This is ymolsignal.c
   A part of the Ymol program
   Copyright (C) 1997-2002 Daniel Spangberg
   */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include "vmconsole.h"

#define MYSIGNAL SIGUSR1

static int signal_was_caught=0;

static void myhandler(int sig)
{
  vmconsole_interrupt(1);
  signal_was_caught=1;
}


void install_signal_handler()
{
  FILE *myfile;
  struct sigaction old_action;
  struct sigaction new_action;
  sigset_t sigset;
  /* Catch SIGUSR1 */
  sigemptyset(&sigset);
  new_action.sa_handler=myhandler;
  new_action.sa_mask=sigset;
  new_action.sa_flags=SA_RESTART; /* This is important! */
  sigaction(MYSIGNAL,&new_action,&old_action);
  /* Write my pid to file */
  myfile=fopen("ymolpid","w");
  fprintf(myfile,"%lu\n",(unsigned long) getpid());
  fclose(myfile);
}

void reset_signal_test()
{
  signal_was_caught=0;
}

int get_signal_value()
{
  return(signal_was_caught);
}

