      /* This is worldmemory.h
      A part of the Ymol program
      Copyright (C) 1997-1998 Daniel Spangberg
      */

#ifndef __worldmemory__
#define __worldmemory__

#if defined(USCORE2)
void initialize_memory__(int *frames);
#else
void initialize_memory_(int *frames);
#endif

#if defined(USCORE2)
void deinitialize_memory__();
#else
void deinitialize_memory_();
#endif

#if defined(USCORE2)
void initialize_frame__(int *nframe, int *atomsx, int *bondsx, int *trianglesx);
#else
void initialize_frame_(int *nframe, int *atomsx, int *bondsx, int *trianglesx);
#endif

#if defined(USCORE2)
void deinitialize_frame__(int *nframe);
#else
void deinitialize_frame_(int *nframe);
#endif

#if defined(USCORE2)
void get_frame_is_initialized__(int *frame,int *n);
#else
void get_frame_is_initialized_(int *frame,int *n);
#endif

#if defined(USCORE2)
void initialize_temporary__(int *natoms, int *ntriangles);
#else
void initialize_temporary_(int *natoms, int *ntriangles);
#endif

#if defined(USCORE2)
void deinitialize_temporary__();
#else
void deinitialize_temporary_();
#endif

#define MEASURE_NONE 0
#define MEASURE_DISTANCE 1
#define MEASURE_ANGLE 2
#define MEASURE_DIHEDRAL 3

void add_measure(int frame,int type,int *p,int x,int y);
void remove_measure(int frame);

#if defined(USCORE2)
void get_atoms__(int *frame,int *n);
#else
void get_atoms_(int *frame,int *n);
#endif

#if defined(USCORE2)
void get_atomid__(int *frame, int *natom, int *id);
#else
void get_atomid_(int *frame, int *natom, int *id);
#endif

#if defined(USCORE2)
void set_frametextxy__(int *frame,double *x,double *y);
#else
void set_frametextxy_(int *frame,double *x,double *y);
#endif

#if defined(USCORE2)
void set_frametext__(int *frame, char *label,int length);
#else
void set_frametext_(int *frame,  char *label,int length);
#endif

#if defined(USCORE2)
void get_frametext__(int *frame, char *label,int length);
#else
void get_frametext_(int *frame,  char *label,int length);
#endif

#if defined(USCORE2)
void set_hasframetext__(int *frame,int *n);
#else
void set_hasframetext_(int *frame,int *n);
#endif

#if defined(USCORE2)
void get_atomrsv__(int *frame, int *natom, double *rsv);
#else
void get_atomrsv_(int *frame, int *natom, double *rsv);
#endif

#if defined(USCORE2)
void get_atomn__(int *frame, int *natom, int *n);
#else
void get_atomn_(int *frame, int *natom, int *n);
#endif

#if defined(USCORE2)
void get_deflabel__(int *frame, int *natom, int *b);
#else
void get_deflabel_(int *frame, int *natom, int *b);
#endif

#if defined(USCORE2)
void get_atomlabel__(int *frame, int *natom, char *label,int length);
#else
void get_atomlabel_(int *frame, int *natom, char *label,int length);
#endif

#if defined(USCORE2)
void set_atomxyz__(int *frame, int *nbond, double *x, double *y, double *z);
#else
void set_atomxyz_(int *frame, int *nbond, double *x, double *y, double *z);
#endif

#if defined(USCORE2)
void set_atomnr__(int *frame, int *nbond, int *nr);
#else
void set_atomnr_(int *frame, int *nbond, int *nr);
#endif

#if defined(USCORE2)
void set_atomid__(int *frame, int *nbond, int *id);
#else
void set_atomid_(int *frame, int *nbond, int *id);
#endif

#if defined(USCORE2)
void set_defradweight__(int *frame, int *nbond, int *b);
#else
void set_defradweight_(int *frame, int *nbond, int *b);
#endif

#if defined(USCORE2)
void set_defcol__(int *frame, int *nbond, int *b);
#else
void set_defcol_(int *frame, int *nbond, int *b);
#endif

#if defined(USCORE2)
void set_deflabel__(int *frame, int *nbond, int *b);
#else
void set_deflabel_(int *frame, int *nbond, int *b);
#endif

#if defined(USCORE2)
void set_atomlabel__(int *frame, int *nbond, char *label,int length);
#else
void set_atomlabel_(int *frame, int *nbond, char *label,int length);
#endif

#if defined(USCORE2)
void set_frametext__(int *frame, char *label,int length);
#else
void set_frametext_(int *frame,  char *label,int length);
#endif

#if defined(USCORE2)
void set_atomdrawstyle__(int *frame, int *nbond, int *drawstyle);
#else
void set_atomdrawstyle_(int *frame, int *nbond, int *drawstyle);
#endif

#if defined(USCORE2)
void set_atomhasmessage__(int *frame, int *nbond, int *hasmessage);
#else
void set_atomhasmessage_(int *frame, int *nbond, int *hasmessage);
#endif

#if defined(USCORE2)
void set_drawbond__(int *frame, int *nbond, int *bondb);
#else
void set_drawbond_(int *frame, int *nbond, int *bondb);
#endif

#if defined(USCORE2)
void set_bondp__(int *frame, int *nbond, int *bond1x,int *bond2x,int *bond3x,int *bond4x);
#else
void set_bondp_(int *frame, int *nbond, int *bond1x,int *bond2x,int *bond3x,int *bond4x);
#endif

#if defined(USCORE2)
void set_bond1__(int *frame, int *nbond, int *bond1x);
#else
void set_bond1_(int *frame, int *nbond, int *bond1x);
#endif

#if defined(USCORE2)
void set_bond2__(int *frame, int *nbond, int *bond2x);
#else
void set_bond2_(int *frame, int *nbond, int *bond2x);
#endif

#if defined(USCORE2)
void set_defbcol__(int *frame, int *nbond, int *bondb);
#else
void set_defbcol_(int *frame, int *nbond, int *bondb);
#endif

#if defined(USCORE2)
void set_bondrsv1__(int *frame, int *nbond, double *bondrsvx);
#else
void set_bondrsv1_(int *frame, int *nbond, double *bondrsvx);
#endif

#if defined(USCORE2)
void set_bondrad1__(int *frame, int *nbond, double *bondradx);
#else
void set_bondrad1_(int *frame, int *nbond, double *bondradx);
#endif

#if defined(USCORE2)
void set_bondr1__(int *frame, int *nbond, int *bondrx);
#else
void set_bondr1_(int *frame, int *nbond, int *bondrx);
#endif

#if defined(USCORE2)
void set_bondg1__(int *frame, int *nbond, int *bondgx);
#else
void set_bondg1_(int *frame, int *nbond, int *bondgx);
#endif

#if defined(USCORE2)
void set_bondb1__(int *frame, int *nbond, int *bondbx);
#else
void set_bondb1_(int *frame, int *nbond, int *bondbx);
#endif

#if defined(USCORE2)
void set_bondn1__(int *frame, int *nbond, int *bondnx);
#else
void set_bondn1_(int *frame, int *nbond, int *bondnx);
#endif

#if defined(USCORE2)
void set_bondnslice__(int *frame, int *nbond, int *bondnx);
#else
void set_bondnslice_(int *frame, int *nbond, int *bondnx);
#endif


/* "C" interface (incomplete) */
void get_nframes(int *n);
void get_atoms(int *frame,int *n);
void get_bonds(int *frame,int *n);
void get_atomnr(int *frame, int *natom, int *nr);
void get_atomxyz(int *frame, int *natom, double *x, double *y, double *z);
void get_atomrad(int *frame, int *natom, double *rad);
void get_bond1(int *frame, int *nbond, int *bond1x);
void get_bond2(int *frame, int *nbond, int *bond2x);
void get_defradweight(int *frame, int *natom, int *b);
void compute_pairs_frame(int frame, double rmax, int *npairs);
void reallocate_triangles(int frame,int ntriangles);
void set_frame_triangle(int frame, int nt, double x, double y, double z,
			double nx, double ny, double nz, double fr,
			double opaq,
			int r, int g, int b, int n, int twosid);
void get_atomscalerad(int *frame, int *natom, double *rad);
void set_atomscalerad(int *frame, int *nbond, double *rad);

#endif
