      /* This is world.F
      A part of the Ymol program
      Copyright (C) 1997-1998 Daniel Spangberg
      */


#include "maxs.h"

#include "phongdef.h"

#include "defaults.h"

#define WORLDFILE 10
#define WORLDTEMPFILE 11

#define BALL_STICK_FACTOR 0.6d0
#define SPACEFILL_FACTOR 1.3d0

#define PI 3.14159265359d0

#include "tempfileformat.h"

c     load orientation
      subroutine florif(filename,ok)
      implicit double precision (a-h,o-z)
      character*(*) filename
      integer ok
#include "transformationmatrix.commonblock"
      ok=1
      call getany(isany)
      if (isany.ne.0) then
        iflen=LEN(filename)
        open(unit=WORLDFILE,file=filename(1:iflen),
     x       status='old',
     x       form='formatted',err=112)
        do i=1,4
          read(WORLDFILE,*) (t_matrix(j,i),j=1,4)
        enddo
        do i=1,4
          read(WORLDFILE,*) (r_matrix(j,i),j=1,4)
        enddo
        close(WORLDFILE)
      endif
      call wupd
      return
 112  continue
      ok=0
      return
      end
      
c     save orientation
      subroutine fsorif(filename)
      implicit double precision (a-h,o-z)
      character*(*) filename
#include "transformationmatrix.commonblock"
      call getany(isany)
      if (isany.ne.0) then
        iflen=LEN(filename)
        open(unit=WORLDFILE,file=filename(1:iflen),
     x       status='unknown',
     x       form='formatted')
        do i=1,4
          write(WORLDFILE,*) (t_matrix(j,i),j=1,4)
        enddo
        do i=1,4
          write(WORLDFILE,*) (r_matrix(j,i),j=1,4)
        enddo
        close(WORLDFILE)
      endif
      return
      end

      subroutine compute_crystal_matrix
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      a=a_crystal
      b=b_crystal
      c=c_crystal
      alpha=PI*alpha_crystal/180.d0
      beta=PI*beta_crystal/180.d0
      gamma=PI*gamma_crystal/180.d0
      cosalpha=cos(alpha)
      cosbeta=cos(beta)
      cosgamma=cos(gamma)
      sinbeta=sin(beta)
      singamma=sin(gamma)
      xcrystal(1)=a
      xcrystal(2)=b*cosgamma
      xcrystal(3)=c*cosbeta
      xcrystal(4)=0.d0
      xcrystal(5)=b*singamma
      xcrystal(6)=c*(cosalpha-cosbeta*cosgamma)/singamma
      xcrystal(7)=0.d0
      xcrystal(8)=0.d0
      xcrystal(9)=c*(sqrt(sinbeta*sinbeta-((cosalpha-
     x     cosbeta*cosgamma)/(singamma*singamma))))
      return
      end

      subroutine crystal_atom_pos(x,y,z)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      xout=xcrystal(1)*x+xcrystal(2)*y+xcrystal(3)*z
      yout=xcrystal(4)*x+xcrystal(5)*y+xcrystal(6)*z
      zout=xcrystal(7)*x+xcrystal(8)*y+xcrystal(9)*z
      x=xout
      y=yout
      z=zout
      return
      end

      subroutine gicrys(ic)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      ic=icrystal
      return
      end

      subroutine snbdr(n)
      implicit double precision (a-h,o-z)
#include "bondrule.commonblock"
      nbondrules=n
      return
      end

      subroutine gnbdr(n)
      implicit double precision (a-h,o-z)
#include "bondrule.commonblock"
      n=nbondrules
      return
      end

      subroutine pctrf(iframe,xdiff,ydiff,zdiff)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      dimension xcrystalinv(9)
C     Inverse of H matrix using cofactor equation
      xdet=xcrystal(1)*(xcrystal(5)*xcrystal(9)-
     x     xcrystal(6)*xcrystal(8))- 
     x     xcrystal(2)*(xcrystal(4)*xcrystal(9)-
     x     xcrystal(6)*xcrystal(7))+ 
     x     xcrystal(3)*(xcrystal(4)*xcrystal(8)-
     x     xcrystal(5)*xcrystal(7))
      xidet=1.d0/xdet
      xcrystalinv(1)=xidet*(xcrystal(5)*xcrystal(9)-
     x     xcrystal(6)*xcrystal(8)); 
      xcrystalinv(2)=xidet*(xcrystal(3)*xcrystal(8)-
     x     xcrystal(2)*xcrystal(9)); 
      xcrystalinv(3)=xidet*(xcrystal(2)*xcrystal(6)-
     x     xcrystal(3)*xcrystal(5)); 
      xcrystalinv(4)=xidet*(xcrystal(6)*xcrystal(7)-
     x     xcrystal(4)*xcrystal(9)); 
      xcrystalinv(5)=xidet*(xcrystal(1)*xcrystal(9)-
     x     xcrystal(3)*xcrystal(7)); 
      xcrystalinv(6)=xidet*(xcrystal(3)*xcrystal(4)-
     x     xcrystal(1)*xcrystal(6)); 
      xcrystalinv(7)=xidet*(xcrystal(4)*xcrystal(8)-
     x     xcrystal(5)*xcrystal(7)); 
      xcrystalinv(8)=xidet*(xcrystal(2)*xcrystal(7)-
     x     xcrystal(1)*xcrystal(8)); 
      xcrystalinv(9)=xidet*(xcrystal(1)*xcrystal(5)-
     x     xcrystal(2)*xcrystal(4)); 
      xmove=0.05d0
      call get_atoms(iframe,natoms)
      do i=1,natoms
        call get_atomnr(iframe,i-1,inr)
        if (inr.ne.256) then
          call get_atomxyz(iframe,i-1,x,y,z)
c     Transform into fractional coordinates
          call mymatmul(xcrystalinv,x,y,z)
c     Move the atom
          x=x+xmove*xdiff
          y=y+xmove*ydiff
          z=z+xmove*zdiff
c     keep the atom in the box
          if (x.gt.1.d0) x=x-1.d0
          if (x.lt.0.d0) x=x+1.d0
          if (y.gt.1.d0) y=y-1.d0
          if (y.lt.0.d0) y=y+1.d0
          if (z.gt.1.d0) z=z-1.d0
          if (z.lt.0.d0) z=z+1.d0
c     Transform into real coordinates
          call mymatmul(xcrystal,x,y,z)
          call set_atomxyz(iframe,i-1,x,y,z)
        endif
      enddo
      return
      end

      subroutine mymatmul(xmat,x,y,z)
      implicit double precision (a-h,o-z)
      dimension xmat(9)
      xnew=xmat(1)*x+xmat(2)*y+xmat(3)*z
      ynew=xmat(4)*x+xmat(5)*y+xmat(6)*z
      znew=xmat(7)*x+xmat(8)*y+xmat(9)*z
      x=xnew
      y=ynew
      z=znew
      return 
      end

      subroutine pctr(xdiff,ydiff,zdiff)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      call get_nframes(n)
      do i=1,n
        call pctrf(i,xdiff,ydiff,zdiff)
      enddo
      return
      end


      subroutine fload_x(filename,ok,iloadstyle)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
#include "bondrule.commonblock"
#include "transformationmatrix.commonblock"
#include "stereo.commonblock"
      character*(*) filename
      character*80 tempfilename
      character*120 tempdirname
      character*5 ymolidstring
      character*120 mymsg
      character*FMAXCHARSPERLABEL labeltext
      character*FMAXCHARSINFRAMETEXT frametext
      character*64 polyrulename
      integer object,ok,ip(10),iloadstyle
      dimension xxrgb(3)
      integer iloadcrystal

 1000 format(a MAXCHARSINFRAMETEXT)
 1010 format(a MAXCHARSPERLABEL)
 1020 format(a64)
 2000 format(1x,a)

      ok=1

      object=ixcopw('Loading...')

#if 0
      call init_action
      call init_status
      call init_t_matrix
#endif

      iflen=LEN(filename)
      open(unit=WORLDFILE,file=filename(1:iflen),status='old',
     x     form='formatted',err=112)
c     compute mass centrum and bounds
c     store all data in temporary file
      bound_xmin=HUGE_FACTOR
      bound_ymin=HUGE_FACTOR
      bound_zmin=HUGE_FACTOR
      bound_xmax=-HUGE_FACTOR
      bound_ymax=-HUGE_FACTOR
      bound_zmax=-HUGE_FACTOR

      av_x=0
      av_y=0
      av_z=0


      read(WORLDFILE,'(1x,a5)',err=112,end=112) ymolidstring
      if (ymolidstring(1:4).ne.'Ymol') then
         call errmsg('Fatal: This is not an Ymol file')
         goto 113
      endif
      icanread=0
      ireadstyle=0

      if (ymolidstring(5:5).eq.'B') then
         icanread=1
         ireadstyle=2
      endif

      if (ymolidstring(5:5).eq.'C') then
         icanread=1
         ireadstyle=3
      endif

      if (ymolidstring(5:5).eq.'D') then
         icanread=1
         ireadstyle=4
      endif

      if (ymolidstring(5:5).eq.'E') then
         icanread=1
         ireadstyle=5
      endif

      if (ymolidstring(5:5).eq.'F') then
         icanread=1
         ireadstyle=6
      endif

      if (ymolidstring(5:5).eq.'G') then
         icanread=1
         ireadstyle=7
      endif
      if (ymolidstring(5:5).eq.'H') then
         icanread=1
         ireadstyle=8
      endif
      if (ymolidstring(5:5).eq.'I') then
         icanread=1
         ireadstyle=9
      endif
      if (ymolidstring(5:5).eq.'J') then
         icanread=1
         ireadstyle=10
      endif
      if (ymolidstring(5:5).eq.'K') then
         icanread=1
         ireadstyle=11
      endif
      if (ymolidstring(5:5).eq.'L') then
         icanread=1
         ireadstyle=12
      endif
      if (ymolidstring(5:5).eq.'M') then
         icanread=1
         ireadstyle=13
      endif
      if (ymolidstring(5:5).eq.'N') then
         icanread=1
         ireadstyle=14
      endif
      if (ymolidstring(5:5).eq.'O') then
         icanread=1
         ireadstyle=15
      endif
      if (ymolidstring(5:5).eq.'P') then
         icanread=1
         ireadstyle=16
      endif
      if (ymolidstring(5:5).eq.'Q') then
         icanread=1
         ireadstyle=17
      endif
c        1         2         3         4         5         6         7
c     789012345678901234567890123456789012345678901234567890123456789012
      if (icanread.eq.0) then
         call errmsg('Fatal: I can only read Ymol file format'//
     x        'B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, or Q')
         mymsg='You seem to have an Ymol file format '//
     x        ymolidstring(5:5)
         call errmsg(mymsg(1:38))
         goto 113
      endif
      read(WORLDFILE,*,err=112,end=112) nframes
      if (iloadstyle.eq.0) call initialize_memory(nframes)
c      nmovieframes=nframes
      xframepart=1.d0/dble(nframes)
      if (ireadstyle.ge.8) then
         read(WORLDFILE,*,err=112,end=112) ipersp
      else
         ipersp=1
      endif
      call spersp(ipersp)
      if (ireadstyle.ge.6) then
         read(WORLDFILE,*,err=112,end=112) iloadcrystal
      else
         iloadcrystal=0
      endif
      if (ireadstyle.ge.15) then
        read(WORLDFILE,*,err=112,end=112) iforcetriangles
        read(WORLDFILE,*,err=112,end=112) itriqual
      else
        iforcetriangles=0
        itriqual=10
      endif
      do iframe=1,nframes
         xhandle=dble(iframe-1)*xframepart
         call xcopws(object,xhandle)
         xlocal=0
         ylocal=0
         zlocal=0
         weight=0
         if (ireadstyle.ge.9) then
            read(WORLDFILE,*,err=112,end=112) natoms,ntriangles
         else
            read(WORLDFILE,*,err=112,end=112) natoms
            ntriangles=0
         endif
c         write(WORLDTEMPFILE TEMPRW,err=112) natoms
c     Initialize temporary frame
         if (iloadstyle.eq.0)
     x        call initialize_temporary(natoms,ntriangles)
         if (ireadstyle.ge.6) then
            if (iloadcrystal.ne.0) then
               read(WORLDFILE,*,err=112,end=112) 
     x              (xcrystal(k),k=1,9)
               if (iloadstyle.eq.0) call set_crystal_matrix(0,xcrystal)
               if (iloadstyle.eq.0) icrystal=1
            endif
         endif
         do iatom=1,natoms
            read(WORLDFILE,*,err=112,end=112) id,inr,x,y,z
            if (ireadstyle.ge.17) then
              read(WORLDFILE,*,err=112,end=112) xrad
            else
              xrad=1.d0
            endif
            if (iloadstyle.eq.0) then
               call set_atomid(0,iatom-1,id)
               call set_atomnr(0,iatom-1,inr)
               call set_atomxyz(0,iatom-1,x,y,z)
               if (x.lt.bound_xmin) bound_xmin=x
               if (y.lt.bound_ymin) bound_ymin=y
               if (z.lt.bound_zmin) bound_zmin=z
               if (x.gt.bound_xmax) bound_xmax=x
               if (y.gt.bound_ymax) bound_ymax=y
               if (z.gt.bound_zmax) bound_zmax=z
               call set_atomscalerad(0,iatom-1,xrad)
            endif
            read(WORLDFILE,*,err=112,end=112) idef
            if (iloadstyle.eq.0) call set_defradweight(0,iatom-1,idef)
c            write(WORLDTEMPFILE TEMPRW,err=112) idef
            if (idef.ne.1) then
               read(WORLDFILE,*,err=112,end=112) xrad,xweight
               if (iloadstyle.eq.0) then
                  call set_atomrad(0,iatom-1,xrad)
                  call set_atomweight(0,iatom-1,xrad)
               endif
c               write(WORLDTEMPFILE TEMPRW,err=112) xrad,xweight
            endif
            read(WORLDFILE,*,err=112,end=112) idefc
            if (iloadstyle.eq.0) call set_defcol(0,iatom-1,idefc)
c            write(WORLDTEMPFILE TEMPRW,err=112) idefc
            if (idefc.ne.1) then
               read(WORLDFILE,*,err=112,end=112) ir,ig,ib,xrsv,n
               if (iloadstyle.eq.0) then
                  call set_atomr(0,iatom-1,ir)
                  call set_atomg(0,iatom-1,ig)
                  call set_atomb(0,iatom-1,ib)
                  call set_atomrsv(0,iatom-1,xrsv)
                  call set_atomn(0,iatom-1,n)
               endif
c               write(WORLDTEMPFILE TEMPRW,err=112) ir,ig,ib,xrsv,n
            endif
            read(WORLDFILE,*,err=112,end=112) idrawtype
            if (iloadstyle.eq.0)
     x           call set_atomdrawstyle(0,iatom-1,idrawtype)
c            write(WORLDTEMPFILE TEMPRW,err=112) idrawtype
            if (idef.eq.1) then
               w=atom_weight(inr)
            else
               w=xweight
            endif
            read(WORLDFILE,*,err=112,end=112) iatomlabel
            if (iloadstyle.eq.0)
     x           call set_deflabel(0,iatom-1,iatomlabel)
c            write(WORLDTEMPFILE TEMPRW,err=112) iatomlabel
            if (iatomlabel.ne.0) then
               read(WORLDFILE,*,err=112,end=112) labeltext
               if (iloadstyle.eq.0)
     x              call set_atomlabel(0,iatom-1,labeltext)
c               write(WORLDTEMPFILE TEMPRW,err=112) labeltext
            else
               if (iloadstyle.eq.0) call set_atomlabel(0,iatom-1,' ')
            endif
            read(WORLDFILE,*,err=112,end=112) iatommsg
            if (iloadstyle.eq.0) 
     x           call set_atomhasmessage(0,iatom-1,iatommsg)
c            write(WORLDTEMPFILE TEMPRW,err=112) iatommsg
            xlocal=xlocal+x*w
            ylocal=ylocal+y*w
            zlocal=zlocal+z*w
            weight=weight+w
         enddo
         ibondcount=0         
 10      continue
         read(WORLDFILE,*,err=112,end=112) ibond
         if (ibond.eq.1) then
            ibondcount=ibondcount+1
            if (iloadstyle.eq.0) call add_temporary_bond
            read(WORLDFILE,*,err=112,end=112) idrawbond
            if (iloadstyle.eq.0)
     x           call set_drawbond(0,ibondcount-1,idrawbond)
            read(WORLDFILE,*,err=112,end=112) int1,int2,int3,int4
            if (iloadstyle.eq.0) then
               call set_bondp(0,ibondcount-1,int1,int2,int3,int4)
               call set_bond1(0,ibondcount-1,int1)
               call set_bond2(0,ibondcount-1,int2)
            endif
            read(WORLDFILE,*,err=112,end=112) idef
            if (iloadstyle.eq.0) call set_defbcol(0,ibondcount-1,idef)
            if (idef.ne.1) then
              if (ireadstyle.ge.16) then
                read(WORLDFILE,*,err=112,end=112) ir,ig,ib,xrsv,n,xra,
     x               inslice
              else
                read(WORLDFILE,*,err=112,end=112) ir,ig,ib,xrsv,n,xra
                inslice=0
              endif
               if (iloadstyle.eq.0) then
                  call set_bondr1(0,ibondcount-1,ir)
                  call set_bondg1(0,ibondcount-1,ig)
                  call set_bondb1(0,ibondcount-1,ib)
                  call set_bondrsv1(0,ibondcount-1,xrsv)
                  call set_bondn1(0,ibondcount-1,n)
                  call set_bondnslice(0,ibondcount-1,inslice)
                  call set_bondrad1(0,ibondcount-1,xra)
               endif
c               write(WORLDTEMPFILE TEMPRW,err=112) ir,ig,ib,xrsv,
c     x              n,xra
            endif
            goto 10
         endif
         if (ireadstyle.ge.9) then
            do it=1,ntriangles
               read(WORLDFILE,*) x,y,z,tnx,tny,tnz,rsv1,opaq,
     x              nr,ng,nb,nn,ntwo
               if (iloadstyle.eq.0) then
                  call set_triangle(0,it-1,x,y,z,tnx,tny,tnz,
     x                 rsv1,opaq,nr,ng,nb,nn,ntwo)
                  xlocal=xlocal+x*0.1
                  ylocal=ylocal+y*0.1
                  zlocal=zlocal+z*0.1
                  weight=weight+0.1

                  if (x.lt.bound_xmin) bound_xmin=x
                  if (y.lt.bound_ymin) bound_ymin=y
                  if (z.lt.bound_zmin) bound_zmin=z
                  if (x.gt.bound_xmax) bound_xmax=x
                  if (y.gt.bound_ymax) bound_ymax=y
                  if (z.gt.bound_zmax) bound_zmax=z
               endif
            enddo
         endif
         if (weight.gt.0.0) then
            av_x=av_x+xlocal/weight
            av_y=av_y+ylocal/weight
            av_z=av_z+zlocal/weight
         endif
         if (ireadstyle.ge.5) then
 2001       continue
            read(WORLDFILE,*,err=112,end=112) imeasure
            if (imeasure.ne.0) then
               read(WORLDFILE,*,err=112,end=112) itype
               if (itype.eq.1) then
                  np=4
               else if (itype.eq.2) then
                  np=6
               else if (itype.eq.3) then
                  np=8
               endif
               read(WORLDFILE,*,err=112,end=112) (ip(k),k=1,np),ix,iy
               if (iloadstyle.eq.0) call add_measure(0,itype,ip,ix,iy)
               goto 2001
            endif
c     No more measures

            
         endif
c     frametext
         read(WORLDFILE,*,err=112,end=112) iframetext
c         write(WORLDTEMPFILE TEMPRW,err=112) iframetext
         if (iloadstyle.eq.0) call set_hasframetext(0,iframetext)
         if (iframetext.ne.0) then
            if (ireadstyle.ge.7) then
               read(WORLDFILE,*) xmy,ymy
               if (iloadstyle.eq.0) call set_frametextxy(0,xmy,ymy)
            else
               if (iloadstyle.eq.0) call set_frametextxy(0,0.5d0,0.1d0)
            endif
            read(WORLDFILE,*,err=112,end=112) frametext
            if (iloadstyle.eq.0) call set_frametext(0,frametext)
         else
            frametext='  '
            if (iloadstyle.eq.0) call set_frametext(0,frametext)
         endif
         if (iloadstyle.eq.0) call copy_temporary_to_frame(iframe)
         if (iloadstyle.eq.0) call deinitialize_temporary

c         close(WORLDTEMPFILE)
      enddo
c     read bondrules
      read(WORLDFILE,*,err=112,end=112) nbondrules
      if (nbondrules.gt.0) then
         do i=1,nbondrules
            read(WORLDFILE,*,err=112,end=112) ndonors(i),nacceptors(i)
            if (ndonors(i).gt.0) then
               do j=1,ndonors(i)
                  read(WORLDFILE,*,err=112,end=112) donors(i,j)
               enddo
            endif
            if (nacceptors(i).gt.0) then
               do j=1,nacceptors(i)
                  read(WORLDFILE,*,err=112,end=112) acceptors(i,j)
               enddo
            endif
            read(WORLDFILE,*,err=112,end=112) fuzzfactor(i)
            read(WORLDFILE,*,err=112,end=112) colors(i)
            read(WORLDFILE,2000,err=112,end=112) bondrulename(i)
            read(WORLDFILE,*,err=112,end=112) bondrulen(i)
            read(WORLDFILE,*,err=112,end=112) bondrulersv(i)
            read(WORLDFILE,*,err=112,end=112) bondrulewidth(i)
c     If we are reading YmolD:
            if (ireadstyle.ge.4) then
               read(WORLDFILE,*,err=112,end=112) vdwsub(i)
            else
c     Otherwise:
               vdwsub(i)=1
            endif
            if (ireadstyle.ge.16) then
              read(WORLDFILE,*,err=112,end=112) bondrulenslice(i)
            else
              bondrulenslice(i)=0
            endif
         enddo
      endif
      read(WORLDFILE,*,err=112,end=112) nmessages
      if (nmessages.gt.0) then
         do i=1,nmessages
            read(WORLDFILE,2000,err=112,end=112) atommessage(i)
         enddo
      endif
      call read_tables
c     If we are reading YmolC there's an atom table
      if (ireadstyle.ge.3) then
         do i=1,256
            read(WORLDFILE,*,err=112,end=112) rgb(i,1),rgb(i,2),rgb(i,3),
     x           rsv(i),nfactor(i),atom_radius(i),atom_weight(i)
         enddo
c     And transformation matrices
         if (iloadstyle.eq.0) then
            do i=1,4
               read (WORLDFILE,*,err=112,end=112) (r_matrix(j,i),j=1,4)
            enddo
            do i=1,4
               read (WORLDFILE,*,err=112,end=112) (t_matrix(j,i),j=1,4)
            enddo
         else
            do i=1,4
               read (WORLDFILE,*,err=112,end=112) rnul,rnul,rnul,rnul
            enddo
            do i=1,4
               read (WORLDFILE,*,err=112,end=112) rnul,rnul,rnul,rnul
            enddo
         endif
c     And some misc params
         read (WORLDFILE,*,err=112,end=112) if,xf1,xf2
         call sufog(if)
         call sfogp(xf1)
         call sfogp2(xf2)
         read (WORLDFILE,*,err=112,end=112) if
         call sfade(if)
         read (WORLDFILE,*,err=112,end=112) if
         call dsset(if)
         read (WORLDFILE,*,err=112,end=112) ic
         call sbkgrc(ic)
         read (WORLDFILE,*,err=112,end=112) ic
         call dlbl(ic)
         read (WORLDFILE,*,err=112,end=112) if
         if (iloadstyle.eq.0) then
            call sframe(if)
         endif
      endif
      if (ireadstyle.ge.10) then
         read(WORLDFILE,*) ilamps
         call lnew(ilamps)
         do iilamp=1,ilamps
            read (WORLDFILE,*) xlmp,ylmp,zlmp,irlmp,iglmp,iblmp
            call lmpadd(xlmp,ylmp,zlmp,
     x           irlmp,iglmp,iblmp)
         enddo
         call sylamp
      else
         call init_phongtables
      endif
      if (ireadstyle.ge.11) then
        read(WORLDFILE,*) camerak,zmin,zmax
        read(WORLDFILE,*) ndots,xfar
      else
        camerak=0.5
        zmin=0.1
        zmax=0.9
        ndots=3
        xfar=1.
      endif
      call setck(camerak)
      call setzmn(zmin)
      call setzmx(zmax)
      call sndots(ndots)
      call sxfar(xfar)
      if (ireadstyle.ge.12) then
        read(WORLDFILE,*) (xxrgb(i),i=1,3)
        read(WORLDFILE,*) xsc
        read(WORLDFILE,*) xzo
      else
        xxrgb(1)=0.
        xxrgb(2)=0.
        xxrgb(3)=0.
        xsc=1.
        xzo=0.
      endif
      call slabcl(xxrgb)
      call slabsc(xsc)
      call slabzo(xzo)
      if (ireadstyle.ge.13) then
        read(WORLDFILE,*) (xxrgb(i),i=1,2)
      else
        xxrgb(1)=0.
        xxrgb(2)=0.
      endif
      call slabxy(xxrgb)

      if (ireadstyle.ge.14) then
        read(WORLDFILE,*) nstereo,stereoangle,
     x        stereoscale,stereotranslate
        if (nstereo.eq.0) then
          currentscale=1.d0
        else
          currentscale=stereoscale
        endif
      else
        call steini
      endif

      if (ireadstyle.ge.17) then
c     Read YmolQ
        read (WORLDFILE,*) numpolyrules
        call snpr(numpolyrules)
        do i=1,numpolyrules
          read (WORLDFILE,1020) polyrulename
c     "Fix" nasty saving bug
          polyrulename=polyrulename(1:63)
          call sprnam(i-1,polyrulename(1:islen(polyrulename)))
          read (WORLDFILE,*) nats
          call sprnc(i-1,nats)
          do j=1,nats
            read (WORLDFILE,*) iz
            call sprcz(i-1,j-1,iz)
          enddo
          read (WORLDFILE,*) nats
          call sprnl(i-1,nats)
          do j=1,nats
            read (WORLDFILE,*) iz
            call sprlz(i-1,j-1,iz)
          enddo
          read (WORLDFILE,*) r_central_ligand,r_ligand_ligand,
     x         r_min_distance,xrsv,scalerad,
     x         centralscalerad,otherscalerad,n,xtrans,ir,ig,ib
          call sprp(i-1,r_central_ligand,
     x         r_ligand_ligand,r_min_distance,xrsv,scalerad,
     x         centralscalerad,otherscalerad,n,xtrans,ir,ig,ib)
        enddo
      else
        numpolyrules=0
        call snpr(numpolyrules)
      endif

      close(WORLDFILE)
      if (iloadstyle.eq.0) then
         mass_x=av_x/dble(nframes)
         mass_y=av_y/dble(nframes)
         mass_z=av_z/dble(nframes)
         bound_xmin=bound_xmin-mass_x
         bound_ymin=bound_ymin-mass_y
         bound_zmin=bound_zmin-mass_z
         bound_xmax=bound_xmax-mass_x
         bound_ymax=bound_ymax-mass_y
         bound_zmax=bound_zmax-mass_z
         bound=dabs(bound_xmin)
         if (dabs(bound_ymin).gt.bound) bound=dabs(bound_ymin)
         if (dabs(bound_zmin).gt.bound) bound=dabs(bound_zmin)
         if (dabs(bound_xmax).gt.bound) bound=dabs(bound_xmax)
         if (dabs(bound_ymax).gt.bound) bound=dabs(bound_ymax)
         if (dabs(bound_zmax).gt.bound) bound=dabs(bound_zmax)
         call def_unit(bound+0.5d0)
      endif
c      write(*,*) 'COM:',mass_x,mass_y,mass_z
      call setany(1)
      call xcodel(object)
      call wupd
      call execute_update_functions
      return
 112  continue
c      write(*,*) 'An error has occured while loading'
      call errmsg('Input file is not an ymol file or it is corrupt.')
 113  continue
      call upderr
      call xcodel(object)
      ok=0
      close(WORLDFILE)
c      close(WORLDTEMPFILE)
      call execute_update_functions
      return
      end

      subroutine fload(filename,ok)
      character*(*) filename
      integer ok
      call fload_x(filename,ok,0)
      return
      end

      subroutine floads(filename,ok)
      character*(*) filename
      integer ok
      call fload_x(filename,ok,1)
      return
      end

      subroutine redef_unit
      implicit double precision (a-h,o-z)
#include "world.commonblock"
c      write(*,*) 'redef:'
      call def_unit(bound+0.5d0)
      return
      end

      subroutine framefilename(base,iframe,filename)
      implicit double precision (a-h,o-z)
      character*(*) base,filename
      integer iframe
      character*10 myformat
      i=index(base,' ')
      if (i.eq.0) i=len(base)
      j=1
      k=iframe
 10   continue
      if (k.lt.10) goto 20
      k=k/10
      j=j+1
      goto 10
 20   continue
      myformat='(i )'
      write(myformat(3:3),'(i1)') j
      filename=base(1:i)
      write(filename(i+1:i+j),myformat) iframe
      filename=filename(1:i+j)//'.tmp '
      return
      end

c     Save as normal file
      subroutine fsave(filename)
      implicit double precision (a-h,o-z)
      character*(*) filename
      call fsave_both(filename,0)
      return 
      end

c     Save as style
      subroutine fsaves(filename)
      implicit double precision (a-h,o-z)
      character*(*) filename
      call fsave_both(filename,1)
      return 
      end

c     this routine saves the world into a file
c     this is both "save as" and "save". it does not care
c     whether files already exist or not. it is up to the
c     gui routines to decide this
      subroutine fsave_both(filename,isavestyle)
      implicit double precision (a-h,o-z)

#include "world.commonblock"
#include "table.commonblock"
#include "bondrule.commonblock"
#include "transformationmatrix.commonblock"
#include "stereo.commonblock"
      character*(*) filename
      character*80 tempfilename
      character*120 tempdirname
      character*FMAXCHARSPERLABEL labeltext
      character*FMAXCHARSINFRAMETEXT frametext
      integer ip(10)
      dimension xxrgb(3)
      character*64 polyrulename
 1000 format(a MAXCHARSINFRAMETEXT)
 1010 format(a MAXCHARSPERLABEL)
 1020 format(a64)

      call getany(isany)
      if (isany.ne.0) then
         iflen=LEN(filename)
         open(unit=WORLDFILE,file=filename(1:iflen),
     x        status='unknown',
     x        form='formatted')
         call get_nframes(nmovieframes)
         ixcoobject=ixcopw('Saving file...')
         write(WORLDFILE,*) 'YmolQ'
         if (isavestyle.ne.0) then
           write(WORLDFILE,*) 1
         else
           write(WORLDFILE,*) nmovieframes
         endif
         call gpersp(ipers)
         write(WORLDFILE,*) ipers
         write(WORLDFILE,*) icrystal
         write(WORLDFILE,*) iforcetriangles
         write(WORLDFILE,*) itriqual
         nloopmovieframes=nmovieframes
         if (isavestyle.ne.0) nloopmovieframes=1
         do iframe=1,nloopmovieframes
            call xcopws(ixcoobject,dble(iframe)/dble(nmovieframes))

c            call gettempdir(tempdirname)
c            iz=index(tempdirname,' ')-1
c            tempdirname=tempdirname(1:iz)//'world'
c            call framefilename(tempdirname(1:iz+5),
c     x           iframe,tempfilename)
c            open(unit=WORLDTEMPFILE,file=tempfilename,
c     x           form=TEMPFORMAT,status='old')
c            read(WORLDTEMPFILE TEMPRW) natoms
            
            call get_atoms(iframe,natoms)
            if (isavestyle.ne.0) natoms=1
            call get_triangles(iframe,ntriangles)
            if (isavestyle.ne.0) ntriangles=0
            write(WORLDFILE,*) natoms,ntriangles
            if (icrystal.ne.0) then
               call get_crystal_matrix(iframe,xcrystal)
               write(WORLDFILE,*) (xcrystal(k),k=1,9)
            endif
            do iatom=1,natoms
c               read(WORLDTEMPFILE TEMPRW) id,inr,x,y,z
               call get_atomid(iframe,iatom-1,id)
               call get_atomnr(iframe,iatom-1,inr)
               call get_atomxyz(iframe,iatom-1,x,y,z)
               write(WORLDFILE,*) id,inr,x,y,z
               call get_atomscalerad(iframe,iatom-1,xrad)
               write(WORLDFILE,*) xrad
c               read(WORLDTEMPFILE TEMPRW) idef
               call get_defradweight(iframe,iatom-1,idef)
               write(WORLDFILE,*) idef
               if (idef.ne.1) then
                  call get_atomrad(iframe,iatom-1,xrad)
                  call get_atomweight(iframe,iatom-1,xweight)
c                  read(WORLDTEMPFILE TEMPRW) xrad,xweight
                  write(WORLDFILE,*) xrad,xweight
               endif
c               read(WORLDTEMPFILE TEMPRW) idefc
               call get_defcol(iframe,iatom-1,idefc)
               write(WORLDFILE,*) idefc
               if (idefc.ne.1) then
                  call get_atomr(iframe,iatom-1,ir)
                  call get_atomg(iframe,iatom-1,ig)
                  call get_atomb(iframe,iatom-1,ib)
                  call get_atomrsv(iframe,iatom-1,xrsv)
                  call get_atomn(iframe,iatom-1,n)
c                  read(WORLDTEMPFILE TEMPRW) ir,ig,ib,xrsv,n
                  write(WORLDFILE,*) ir,ig,ib,xrsv,n
               endif
c               read(WORLDTEMPFILE TEMPRW) idrawtype
               call get_atomdrawstyle(iframe,iatom-1,idrawtype)
               write(WORLDFILE,*) idrawtype
c               read(WORLDTEMPFILE TEMPRW) ialabel
               call get_deflabel(iframe,iatom-1,ialabel)
               write(WORLDFILE,*) ialabel
               if (ialabel.ne.0) then
                  call get_atomlabel(iframe,iatom-1,labeltext)
c                  read(WORLDTEMPFILE TEMPRW) labeltext
                  write(WORLDFILE,*) '"',
     x                 labeltext(1:islen(labeltext)),'"'
               endif
c               read(WORLDTEMPFILE TEMPRW) iamsg
               call get_atomhasmessage(iframe,iatom-1,iamsg)
               write(WORLDFILE,*) iamsg
            enddo
            call get_bonds(iframe,nbonds)
            if (isavestyle.ne.0) nbonds=0
            do ibond=1,nbonds
               write(WORLDFILE,*) 1
               call get_drawbond(iframe,ibond-1,idrawbond)
               write(WORLDFILE,*) idrawbond
               call get_bondp(iframe,ibond-1,int1,int2,int3,int4)
               write(WORLDFILE,*) int1,int2,int3,int4
               call get_defbcol(iframe,ibond-1,idef)
               write(WORLDFILE,*) idef
               if (idef.ne.1) then
                  call get_bondr1(iframe,ibond-1,ir)
                  call get_bondg1(iframe,ibond-1,ig)
                  call get_bondb1(iframe,ibond-1,ib)
                  call get_bondn1(iframe,ibond-1,n)
                  call get_bondnslice(iframe,ibond-1,nslice)
                  call get_bondrad1(iframe,ibond-1,xra)
                  call get_bondrsv1(iframe,ibond-1,xrsv)
                  
                  write(WORLDFILE,*) ir,ig,ib,xrsv,
     x                 n,xra,nslice
               endif

            enddo
c     No more bonds
            write(WORLDFILE,*) 0
            do it=1,ntriangles
              call get_triangle(iframe,it-1,x,y,z,tnx,tny,tnz,
     x             rsv1,opaq,nr,ng,nb,nn,ntwo)
              write(WORLDFILE,*) x,y,z,tnx,tny,tnz,rsv1,opaq,
     x             nr,ng,nb,nn,ntwo
            enddo
            if (isavestyle.eq.0) then
              call get_first_measure(iframe,itype,ip,ix,iy)
 2001         continue
              if (itype.ne.0) then
                write(WORLDFILE,*) 1
                if (itype.eq.1) then
                  np=4
                else if (itype.eq.2) then
                  np=6
                else if (itype.eq.3) then
                  np=8
                endif
                write(WORLDFILE,*) itype
                write(WORLDFILE,*) (ip(k),k=1,np),ix,iy
                call get_next_measure(iframe,itype,ip,ix,iy)
                goto 2001
              endif
            endif
c     No more measures
            write(WORLDFILE,*) 0

            call get_hasframetext(iframe,iframetext)
            if (isavestyle.ne.0) iframetext=0
            write(WORLDFILE,*) iframetext
            if (iframetext.ne.0) then
               call get_frametextxy(iframe,xmy,ymy)
               write(WORLDFILE,*) xmy,ymy
               call get_frametext(iframe,frametext)
               write(WORLDFILE,*) '"',frametext(1:islen(frametext)),'"'
            endif
         enddo
         write(WORLDFILE,*) nbondrules
         do i=1,nbondrules
            write(WORLDFILE,*) ndonors(i),nacceptors(i)
            if (ndonors(i).gt.0) then
               do j=1,ndonors(i)
                  write(WORLDFILE,*) donors(i,j)
               enddo
            endif
            if (nacceptors(i).gt.0) then
               do j=1,nacceptors(i)
                  write(WORLDFILE,*) acceptors(i,j)
               enddo
            endif
            write(WORLDFILE,*) fuzzfactor(i)
            write(WORLDFILE,*) colors(i)
            write(WORLDFILE,*) bondrulename(i)(1:islen(bondrulename(i)))
            write(WORLDFILE,*) bondrulen(i)
            write(WORLDFILE,*) bondrulersv(i)
            write(WORLDFILE,*) bondrulewidth(i)
c     Added to YmolD ->
            write(WORLDFILE,*) vdwsub(i)
c     <- Added to YmolD
c     Added to YmolP ->
            write(WORLDFILE,*) bondrulenslice(i)
c     <- Added to YmolP
         enddo
         write(WORLDFILE,*) nmessages
         if (isavestyle.ne.0) nmessages=0
         if (nmessages.gt.0) then
            do i=1,nmessages
               write(WORLDFILE,1000) '"',atommessage(i),'"'
            enddo
         endif

c     Added to YmolC ->
         do i=1,256
            write(WORLDFILE,*) rgb(i,1),rgb(i,2),rgb(i,3),
     x           rsv(i),nfactor(i),atom_radius(i),atom_weight(i)
         enddo
         do i=1,4
            write (WORLDFILE,*) (r_matrix(j,i),j=1,4)
         enddo
         do i=1,4
            write (WORLDFILE,*) (t_matrix(j,i),j=1,4)
         enddo

         call gufog(if)
         call gfogp(xf1)
         call gfogp2(xf2)
         write (WORLDFILE,*) if,xf1,xf2
         call gfade(if)
         write (WORLDFILE,*) if
         call dsget(if)
         write (WORLDFILE,*) if
         call gbkgrc(ic)
         write (WORLDFILE,*) ic
         call dlqry(ic)
         write (WORLDFILE,*) ic
         call gframe(if,iftot)
         write (WORLDFILE,*) if
c      <- Added to YmolC

c     -> Added to YmolJ
         call gtlmps(ilamps)
         write (WORLDFILE,*) ilamps
         do i=1,ilamps
            call lmpget(i-1,xx,xy,xz,
     x           ir,ig,ib)
            write (WORLDFILE,*) xx,xy,xz,ir,ig,ib
         enddo
c     <- Added to YmolJ


c     -> Added to YmolK
         camerak=getck()
         call getzmn(zmin)
         call getzmx(zmax)
         write (WORLDFILE,*) camerak,zmin,zmax
         call gndots(ndots)
         call gxfar(xfar)
         write (WORLDFILE,*) ndots,xfar
c     <- Added to YmolK


c     -> Added to YmolL
         call glabcl(xxrgb)
         write (WORLDFILE,*) (xxrgb(i),i=1,3)
         call glabsc(xsc)
         write (WORLDFILE,*) xsc
         call glabzo(xzo)
         write (WORLDFILE,*) xzo
c     <- Added to YmolL

c     -> Added to YmolM
         call glabxy(xxrgb)
         write (WORLDFILE,*) (xxrgb(i),i=1,2)
c     <- Added to YmolM

c     -> Added to YmolN
         write (WORLDFILE,*) nstereo,stereoangle,
     x        stereoscale,stereotranslate
c     <- Added to YmolN

c     -> Added to YmolQ
         call gnpr(numpolyrules)
         write (WORLDFILE,*) numpolyrules
         do i=1,numpolyrules
          call gprnam(i-1,polyrulename)
          write (WORLDFILE,1020) polyrulename

           call gprnc(i-1,nats)
           write (WORLDFILE,*) nats
           do j=1,nats
             call gprcz(i-1,j-1,iz)
             write (WORLDFILE,*) iz
           enddo
           call gprnl(i-1,nats)
           write (WORLDFILE,*) nats
           do j=1,nats
             call gprlz(i-1,j-1,iz)
             write (WORLDFILE,*) iz
           enddo
           call gprp(i-1,r_central_ligand,
     x          r_ligand_ligand,r_min_distance,xrsv,scalerad,
     x          centralscalerad,otherscalerad,n,xtrans,ir,ig,ib)
           write (WORLDFILE,*) r_central_ligand,r_ligand_ligand,
     x          r_min_distance,xrsv,scalerad,centralscalerad,
     x          otherscalerad,n,xtrans,ir,ig,ib
         enddo
c     <- Added to YmolQ

         close(WORLDFILE)
         call xcodel(ixcoobject)
      endif

      return
      end

      subroutine crdtri(iframe,itri,x1,y1,z1,
     x     x2,y2,z2,x3,y3,z3)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      dimension p1(3),p2(3),r(3)
      integer triangles
      call get_triangles(iframe,triangles)
      call get_nframes(nframes)
      nworld=nframes+1
      p1(1)=x2-x1
      p1(2)=y2-y1
      p1(3)=z2-z1
      p2(1)=x3-x1
      p2(2)=y3-y1
      p2(3)=z3-z1
      call crossp(p1,p2,r)
      rn=r(1)*r(1)+r(2)*r(2)+r(3)*r(3)
      rn=1.d0/rn
      r(1)=r(1)*rn
      r(2)=r(2)*rn
      r(3)=r(3)*rn
      call set_triangle(nworld,triangles+itri*3,x1,y1,z1,
     x     r(1),r(2),r(3),
     x     0.7d0,1.0d0,200,200,200,20,1)
      call set_triangle(nworld,triangles+itri*3+1,x2,y2,z2,
     x     r(1),r(2),r(3),
     x     0.7d0,1.0d0,200,200,200,20,1)
      call set_triangle(nworld,triangles+itri*3+2,x3,y3,z3,
     x     r(1),r(2),r(3),
     x     0.7d0,1.0d0,200,200,200,20,1)      
      return
      end

#define MAXQUAL 200
c     this subroutine builds a world from the next frame
      subroutine build_world(iframe,ihardupdate)
      implicit double precision (a-h,o-z)

#include "world.commonblock"
#include "table.commonblock"
      integer iframe,atoms,bonds,triangles
      character*80 ctmp
      character*FMAXCHARSPERLABEL lbl
      character*FMAXCHARSINFRAMETEXT frametext

      dimension trianglepoint(6,MAXQUAL,MAXQUAL*2)
      dimension rmat(16)
      
c      iforcetriangles=1
c      itriqual=25

      call clear_selectorder

c     read(WORLDTEMPFILE TEMPRW) atoms
      call get_atoms(iframe,atoms)
      call get_bonds(iframe,bonds)
      call get_triangles(iframe,triangles)
      call get_nframes(nframes)

      nworld=nframes+1

      if (ihardupdate.eq.0) then
c     remember the selected atoms
         do iatom=1,atoms
            call get_atomselected(nworld,iatom-1,isel)
            if (isel.ne.0) then
               call get_atomid(nworld,iatom-1,id)
               call add_to_selectorder(id)
            endif
         enddo
      endif

      ishowaxes=0

      inatoms=atoms
      inbonds=bonds
      intriangles=triangles
      if (ishowaxes.eq.1) then
        intriangles=intriangles+3*9
      endif

c      write(*,*) 'bonds=',bonds

      call dsget(idstyle)

      if ((iforcetriangles.eq.1).and.
     x     (.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES))) then
        intriangles=intriangles+inatoms*(6*(itriqual*2*(itriqual-2)))
     x       +inbonds*3*2*itriqual*(itriqual-1)
c        write (*,*) 'intriangles=',intriangles
      endif

      call initialize_frame(nworld,inatoms,inbonds,intriangles)

c      write(*,*) '(build) atoms,bonds,triangles=',atoms,bonds,triangles

      do it=1,triangles
         call get_triangle(iframe,it-1,tx,ty,tz,tnx,tny,tnz,
     x        tfr,opaq,nr,ng,nb,nn,ntwo)
         tx=tx-mass_x
         ty=ty-mass_y
         tz=tz-mass_z
         call set_triangle(nworld,it-1,tx,ty,tz,tnx,tny,tnz,
     x        tfr,opaq,nr,ng,nb,nn,ntwo)
      enddo

      icurtriangles=triangles


C     Show coordinate axes...
      if (ishowaxes.eq.1) then
        u1=bound*0.05d0
        u2=bound*1.1d0
        u3=u1*sqrt(2.d0)*0.5d0
        u4=u1*0.5d0
        u5=u2+u1*2.d0
        u6=u1*sqrt(2.d0)/3.d0
        
C     x axis:
        call crdtri(iframe,0,
     x       mass_x-u2  ,mass_y-u2   ,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2   ,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2+u1,mass_z-u2  )
        call crdtri(iframe,1,
     x       mass_x-u2  ,mass_y-u2   ,mass_z-u2  ,
     x       mass_x-u2  ,mass_y-u2+u1,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2+u1,mass_z-u2  )

        call crdtri(iframe,2,
     x       mass_x-u2  ,mass_y-u2   ,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2   ,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2+u4,mass_z-u2+u3)
        call crdtri(iframe,3,
     x       mass_x-u2  ,mass_y-u2   ,mass_z-u2  ,
     x       mass_x-u2  ,mass_y-u2+u4,mass_z-u2+u3,
     x       mass_x+u2  ,mass_y-u2+u4,mass_z-u2+u3)

        call crdtri(iframe,4,
     x       mass_x-u2  ,mass_y-u2+u1,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2+u1,mass_z-u2  ,
     x       mass_x+u2  ,mass_y-u2+u4,mass_z-u2+u3)
        call crdtri(iframe,5,
     x       mass_x-u2  ,mass_y-u2+u1,mass_z-u2  ,
     x       mass_x-u2  ,mass_y-u2+u4,mass_z-u2+u3,
     x       mass_x+u2  ,mass_y-u2+u4,mass_z-u2+u3)


        call crdtri(iframe,6,
     x       mass_x+u5  ,mass_y-u2+u4,mass_z-u2+u6  ,
     x       mass_x+u2,mass_y-u2-u1  ,mass_z-u2  ,
     x       mass_x+u2,mass_y-u2+u1*2,mass_z-u2-u3)

        call crdtri(iframe,7,
     x       mass_x+u5  ,mass_y-u2+u4,mass_z-u2+u6  ,
     x       mass_x+u2,mass_y-u2-u4 ,mass_z-u2-u3,
     x       mass_x+u2,mass_y-u2+u4*2,mass_z-u2+u3*2)

        call crdtri(iframe,8,
     x       mass_x+u5  ,mass_y-u2+u4,mass_z-u2+u6  ,
     x       mass_x+u2,mass_y-u2+u1*2,mass_z-u2-u3,
     x       mass_x+u2,mass_y-u2+u4*2,mass_z-u2+u3*2)


        icurtriangles=icurtriangles+3*9
      endif


      imaxatomid=0
      do iatom=1,atoms
         call get_atomid(iframe,iatom-1,itmp)
         if (itmp.gt.imaxatomid) imaxatomid=itmp
         
         call set_atomid(nworld,iatom-1,itmp)
         call get_atomnr(iframe,iatom-1,itmpatomnr)
         call set_atomnr(nworld,iatom-1,itmpatomnr)
         call get_atomxyz(iframe,iatom-1,x,y,z)
         x=x-mass_x
         y=y-mass_y
         z=z-mass_z
         call set_atomxyz(nworld,iatom-1,x,y,z)
         call get_atomscalerad(iframe,iatom-1,xtmp)
         call set_atomscalerad(nworld,iatom-1,xtmp)
         call get_defradweight(iframe,iatom-1,idef)
         if (idef.eq.1) then
            call set_atomrad(nworld,iatom-1,atom_radius(itmpatomnr))
         else
            call get_atomrad(iframe,iatom-1,xtmp)
            call set_atomrad(nworld,iatom-1,xtmp)
         endif
         call get_defcol(iframe,iatom-1,idef)
         call set_defcol(nworld,iatom-1,idef)
         if (idef.eq.1) then
            call set_atomr(nworld,iatom-1,rgb(atom_color(itmpatomnr),1))
            call set_atomg(nworld,iatom-1,rgb(atom_color(itmpatomnr),2))
            call set_atomb(nworld,iatom-1,rgb(atom_color(itmpatomnr),3))
            call set_atomrsv(nworld,iatom-1,rsv(itmpatomnr))
            call set_atomn(nworld,iatom-1,nfactor(itmpatomnr))
         else
            call get_atomr(iframe,iatom-1,it2)
            call set_atomr(nworld,iatom-1,it2)
            call get_atomg(iframe,iatom-1,it2)
            call set_atomg(nworld,iatom-1,it2)
            call get_atomb(iframe,iatom-1,it2)
            call set_atomb(nworld,iatom-1,it2)
            call get_atomrsv(iframe,iatom-1,xtmp)
            call set_atomrsv(nworld,iatom-1,xtmp)
            call get_atomn(iframe,iatom-1,it2)
            call set_atomn(nworld,iatom-1,it2)
         endif
         call get_atomdrawstyle(iframe,iatom-1,itmpds)
         call set_atomdrawstyle(nworld,iatom-1,itmpds)
#if 0 
         itmpds=0
#endif
         if (itmpds.eq.1) then
c     ball and stick model. smaller balls...
            call get_atomrad(nworld,iatom-1,xtmp)
            call set_atomrad(nworld,iatom-1,xtmp*BALL_STICK_FACTOR)
         else
c     Spacefill model. Larger balls...
            call get_atomrad(nworld,iatom-1,xtmp)
            call set_atomrad(nworld,iatom-1,xtmp*SPACEFILL_FACTOR)
         endif
         
         call get_deflabel(iframe,iatom-1,ialabel)
         if (ialabel.eq.1) then
            call get_atomlabel(iframe,iatom-1,lbl)
            call set_atomlabel(nworld,iatom-1,lbl)
         else
            call set_atomlabel(nworld,iatom-1,
     x           default_atom_text(itmpatomnr))
         endif
         call get_atomhasmessage(iframe,iatom-1,itmp)
         call set_atomhasmessage(nworld,iatom-1,itmp)
         call set_atomselected(nworld,iatom-1,0)


         if ((iforcetriangles.eq.1)
     x        .and.((.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES)))) then
           call get_atomxyz(nworld,iatom-1,x,y,z)
           call get_atomr(nworld,iatom-1,ir)
           call get_atomg(nworld,iatom-1,ig)
           call get_atomb(nworld,iatom-1,ib)
           call get_atomrsv(nworld,iatom-1,rsv)
           call get_atomn(nworld,iatom-1,in)
           call get_atomrad(nworld,iatom-1,rad)
           pi2=PI*2
           do iring=1,itriqual
             ta=rad*(1.-cos((PI*(iring-1))/
     x            (itriqual-1.d0)))
             tr=sqrt(rad*rad-(rad-ta)*(rad-ta))
             do iring2=1,itriqual*2
               ry=-rad+ta
               if ((iring.eq.1).or.(iring.eq.itriqual)) then
                 rx=0.d0
                 rz=0.d0
               else
                 rx=cos((pi2*(iring2-1))/(itriqual*2))*tr
                 rz=sin((pi2*(iring2-1))/(itriqual*2))*tr
               endif
               trianglepoint(1,iring2,iring)=rx+x
               trianglepoint(2,iring2,iring)=ry+y
               trianglepoint(3,iring2,iring)=rz+z
               trianglepoint(4,iring2,iring)=rx/rad
               trianglepoint(5,iring2,iring)=ry/rad
               trianglepoint(6,iring2,iring)=rz/rad
             enddo
           enddo
           do iring=1,itriqual-1
             do iring2=1,itriqual*2
               isecn=iring2+1
               if (isecn.eq.itriqual*2+1) isecn=1
               if (iring.eq.1) then
                 call set_triangle(nworld,icurtriangles,
     x                trianglepoint(1,1,1),
     x                trianglepoint(2,1,1),
     x                trianglepoint(3,1,1),
     x                trianglepoint(4,1,1),
     x                trianglepoint(5,1,1),
     x                trianglepoint(6,1,1),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+1,
     x                trianglepoint(1,iring2,2),
     x                trianglepoint(2,iring2,2),
     x                trianglepoint(3,iring2,2),
     x                trianglepoint(4,iring2,2),
     x                trianglepoint(5,iring2,2),
     x                trianglepoint(6,iring2,2),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+2,
     x                trianglepoint(1,isecn,2),
     x                trianglepoint(2,isecn,2),
     x                trianglepoint(3,isecn,2),
     x                trianglepoint(4,isecn,2),
     x                trianglepoint(5,isecn,2),
     x                trianglepoint(6,isecn,2),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 icurtriangles=icurtriangles+3
               else if (iring.eq.(itriqual-1)) then
                 call set_triangle(nworld,icurtriangles,
     x                trianglepoint(1,1,itriqual),
     x                trianglepoint(2,1,itriqual),
     x                trianglepoint(3,1,itriqual),
     x                trianglepoint(4,1,itriqual),
     x                trianglepoint(5,1,itriqual),
     x                trianglepoint(6,1,itriqual),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+1,
     x                trianglepoint(1,iring2,itriqual-1),
     x                trianglepoint(2,iring2,itriqual-1),
     x                trianglepoint(3,iring2,itriqual-1),
     x                trianglepoint(4,iring2,itriqual-1),
     x                trianglepoint(5,iring2,itriqual-1),
     x                trianglepoint(6,iring2,itriqual-1),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+2,
     x                trianglepoint(1,isecn,itriqual-1),
     x                trianglepoint(2,isecn,itriqual-1),
     x                trianglepoint(3,isecn,itriqual-1),
     x                trianglepoint(4,isecn,itriqual-1),
     x                trianglepoint(5,isecn,itriqual-1),
     x                trianglepoint(6,isecn,itriqual-1),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 icurtriangles=icurtriangles+3
               else
                 call set_triangle(nworld,icurtriangles,
     x                trianglepoint(1,iring2,iring),
     x                trianglepoint(2,iring2,iring),
     x                trianglepoint(3,iring2,iring),
     x                trianglepoint(4,iring2,iring),
     x                trianglepoint(5,iring2,iring),
     x                trianglepoint(6,iring2,iring),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+1,
     x                trianglepoint(1,iring2,iring+1),
     x                trianglepoint(2,iring2,iring+1),
     x                trianglepoint(3,iring2,iring+1),
     x                trianglepoint(4,iring2,iring+1),
     x                trianglepoint(5,iring2,iring+1),
     x                trianglepoint(6,iring2,iring+1),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+2,
     x                trianglepoint(1,isecn,iring+1),
     x                trianglepoint(2,isecn,iring+1),
     x                trianglepoint(3,isecn,iring+1),
     x                trianglepoint(4,isecn,iring+1),
     x                trianglepoint(5,isecn,iring+1),
     x                trianglepoint(6,isecn,iring+1),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 icurtriangles=icurtriangles+3
                 call set_triangle(nworld,icurtriangles,
     x                trianglepoint(1,iring2,iring),
     x                trianglepoint(2,iring2,iring),
     x                trianglepoint(3,iring2,iring),
     x                trianglepoint(4,iring2,iring),
     x                trianglepoint(5,iring2,iring),
     x                trianglepoint(6,iring2,iring),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+1,
     x                trianglepoint(1,isecn,iring),
     x                trianglepoint(2,isecn,iring),
     x                trianglepoint(3,isecn,iring),
     x                trianglepoint(4,isecn,iring),
     x                trianglepoint(5,isecn,iring),
     x                trianglepoint(6,isecn,iring),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 call set_triangle(nworld,icurtriangles+2,
     x                trianglepoint(1,isecn,iring+1),
     x                trianglepoint(2,isecn,iring+1),
     x                trianglepoint(3,isecn,iring+1),
     x                trianglepoint(4,isecn,iring+1),
     x                trianglepoint(5,isecn,iring+1),
     x                trianglepoint(6,isecn,iring+1),
     x                rsv,1.d0,ir,ig,ib,in,0)
                 icurtriangles=icurtriangles+3
               endif
             enddo
           enddo
           
c           write (*,*) 'icurtriangles=',icurtriangles
           
         endif
      enddo
      do ibond=1,bonds
         call get_bond1(iframe,ibond-1,itmp)
         call set_bond1(nworld,ibond-1,itmp)
         call get_bond2(iframe,ibond-1,itmp)
         call set_bond2(nworld,ibond-1,itmp)
         call get_drawbond(iframe,ibond-1,itmp)
         call set_drawbond(nworld,ibond-1,itmp)
         call set_bondselected(nworld,ibond-1,0)
         call get_bondp(iframe,ibond-1,int1,int2,int3,int4)
         call set_bondp(nworld,ibond-1,int1,int2,int3,int4)
c         write (*,*) ibond,int1,int2,int3,int4
         call get_atomxyz(nworld,int1-1,x1,y1,z1)
         call set_bond1xyz(nworld,ibond-1,x1,y1,z1)
         call get_atomxyz(nworld,int2-1,x2,y2,z2)
         call set_bond2xyz(nworld,ibond-1,x2,y2,z2)
         call dsget(idstyle)
         if ((idstyle.eq.DRAW_STYLE_2D_CIRCLES).or.
     x        ((iforcetriangles.eq.1)
     x        .and.((.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES))))) then
c     compute new end coordinates for bond: 
            vecx=x2-x1
            vecy=y2-y1
            vecz=z2-z1
            vecl=sqrt(vecx*vecx+vecy*vecy+vecz*vecz)
            vecx=vecx/vecl
            vecy=vecy/vecl
            vecz=vecz/vecl
            call get_atomrad(nworld,int1-1,xrad1)
            call get_atomscalerad(nworld,int1-1,rmyscale)
            xrad1=xrad1*rmyscale
            call get_atomrad(nworld,int2-1,xrad2)
            call get_atomscalerad(nworld,int2-1,rmyscale)
            xrad2=xrad2*rmyscale
            call set_bond1xyz(nworld,ibond-1,x1+vecx*xrad1,
     x           y1+vecy*xrad1,
     x           z1+vecz*xrad1)
            call set_bond2xyz(nworld,ibond-1,x2-vecx*xrad2,
     x           y2-vecy*xrad2,
     x           z2-vecz*xrad2)
         endif
         call get_defbcol(iframe,ibond-1,idef)
         call set_defbcol(nworld,ibond-1,idef)
c         read(WORLDTEMPFILE TEMPRW) idef
         if (idef.eq.0) then
            call get_bondr1(iframe,ibond-1,itmp)
            call set_bondr1(nworld,ibond-1,itmp)
            call get_bondg1(iframe,ibond-1,itmp)
            call set_bondg1(nworld,ibond-1,itmp)
            call get_bondb1(iframe,ibond-1,itmp)
            call set_bondb1(nworld,ibond-1,itmp)
            call get_bondrsv1(iframe,ibond-1,xtmp)
            call set_bondrsv1(nworld,ibond-1,xtmp)
            call get_bondn1(iframe,ibond-1,itmp)
            call set_bondn1(nworld,ibond-1,itmp)
            call get_bondnslice(iframe,ibond-1,itmp)
            call set_bondnslice(nworld,ibond-1,itmp)
            call get_bondrad1(iframe,ibond-1,xtmp)
            call set_bondrad1(nworld,ibond-1,xtmp)
         else
            call set_bondr1(nworld,ibond-1,BOND_DEFAULT_R)
            call set_bondg1(nworld,ibond-1,BOND_DEFAULT_G)
            call set_bondb1(nworld,ibond-1,BOND_DEFAULT_B)
            call set_bondn1(nworld,ibond-1,BOND_DEFAULT_N)
            call set_bondnslice(nworld,ibond-1,BOND_DEFAULT_NSLICE)
            call set_bondrsv1(nworld,ibond-1,BOND_DEFAULT_RSV)
            call set_bondrad1(nworld,ibond-1,BOND_DEFAULT_RAD)
         endif         
c     if any of the atoms connected to this bond are space filled
c     we do not want the bond...
         call get_atomdrawstyle(nworld,int1-1,isty1)
         call get_atomdrawstyle(nworld,int2-1,isty2)
         if ((isty1.eq.0).or.
     x        (isty2.eq.0)) then
            call set_drawbond(nworld,ibond-1,0)
         endif
         if ((iforcetriangles.eq.1)
     x        .and.((.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES)))) then
           call get_bondrad1(nworld,ibond-1,rad)
           call get_bondr1(nworld,ibond-1,ir)
           call get_bondg1(nworld,ibond-1,ig)
           call get_bondb1(nworld,ibond-1,ib)
           call get_bondrsv1(nworld,ibond-1,rsv)
           call get_bondn1(nworld,ibond-1,in)
           call get_bondnslice(nworld,ibond-1,inslice)
           call get_bond1xyz(nworld,ibond-1,x1,y1,z1)
           call get_bond2xyz(nworld,ibond-1,x2,y2,z2)
           pi2=PI*2
           do iseg=1,itriqual
             x1seg=x1+(iseg-1)*(x2-x1)/itriqual
             x2seg=x1+iseg*(x2-x1)/itriqual
             y1seg=y1+(iseg-1)*(y2-y1)/itriqual
             y2seg=y1+iseg*(y2-y1)/itriqual
             z1seg=z1+(iseg-1)*(z2-z1)/itriqual
             z2seg=z1+iseg*(z2-z1)/itriqual
             x21=x2seg-x1seg
             y21=y2seg-y1seg
             z21=z2seg-z1seg
             xyzlen=sqrt(x21*x21+y21*y21+z21*z21)
             xyzi=1.d0/xyzlen
             x21=x21*xyzi
             y21=y21*xyzi
             z21=z21*xyzi
             call crrtmt(1.d0,0.d0,0.d0,x21,y21,z21,rmat)
             do iring=1,itriqual-1
               sy1=cos((pi2*(iring-1))/itriqual)*rad
               sz1=sin((pi2*(iring-1))/itriqual)*rad
               sx1=0.d0
               sy2=sy1
               sz2=sz1
               sx2=xyzlen
               call mmtvd(sx1,sy1,sz1,rmat)
               call mmtvd(sx2,sy2,sz2,rmat)
               sx1=sx1+x1seg
               sx2=sx2+x1seg
               sy1=sy1+y1seg
               sy2=sy2+y1seg
               sz1=sz1+z1seg
               sz2=sz2+z1seg
               xn=sx1-x1seg
               yn=sy1-y1seg
               zn=sz1-z1seg
               trianglepoint(1,iring,1)=sx1
               trianglepoint(2,iring,1)=sy1
               trianglepoint(3,iring,1)=sz1
               trianglepoint(4,iring,1)=xn
               trianglepoint(5,iring,1)=yn
               trianglepoint(6,iring,1)=zn
               trianglepoint(1,iring,2)=sx2
               trianglepoint(2,iring,2)=sy2
               trianglepoint(3,iring,2)=sz2
               trianglepoint(4,iring,2)=xn
               trianglepoint(5,iring,2)=yn
               trianglepoint(6,iring,2)=zn
             enddo
             do iring=1,itriqual-1
               isecn=iring+1
               if (isecn.eq.itriqual) isecn=1
               call set_triangle(nworld,icurtriangles,
     x              trianglepoint(1,iring,1),
     x              trianglepoint(2,iring,1),
     x              trianglepoint(3,iring,1),
     x              trianglepoint(4,iring,1),
     x              trianglepoint(5,iring,1),
     x              trianglepoint(6,iring,1),
     x              rsv,1.d0,ir,ig,ib,in,0)
               call set_triangle(nworld,icurtriangles+1,
     x              trianglepoint(1,iring,2),
     x              trianglepoint(2,iring,2),
     x              trianglepoint(3,iring,2),
     x              trianglepoint(4,iring,2),
     x              trianglepoint(5,iring,2),
     x              trianglepoint(6,iring,2),
     x              rsv,1.d0,ir,ig,ib,in,0)
               call set_triangle(nworld,icurtriangles+2,
     x              trianglepoint(1,isecn,1),
     x              trianglepoint(2,isecn,1),
     x              trianglepoint(3,isecn,1),
     x              trianglepoint(4,isecn,1),
     x              trianglepoint(5,isecn,1),
     x              trianglepoint(6,isecn,1),
     x              rsv,1.d0,ir,ig,ib,in,0)
               call set_triangle(nworld,icurtriangles+3,
     x              trianglepoint(1,iring,2),
     x              trianglepoint(2,iring,2),
     x              trianglepoint(3,iring,2),
     x              trianglepoint(4,iring,2),
     x              trianglepoint(5,iring,2),
     x              trianglepoint(6,iring,2),
     x              rsv,1.d0,ir,ig,ib,in,0)
               call set_triangle(nworld,icurtriangles+4,
     x              trianglepoint(1,isecn,2),
     x              trianglepoint(2,isecn,2),
     x              trianglepoint(3,isecn,2),
     x              trianglepoint(4,isecn,2),
     x              trianglepoint(5,isecn,2),
     x              trianglepoint(6,isecn,2),
     x              rsv,1.d0,ir,ig,ib,in,0)
               call set_triangle(nworld,icurtriangles+5,
     x              trianglepoint(1,isecn,1),
     x              trianglepoint(2,isecn,1),
     x              trianglepoint(3,isecn,1),
     x              trianglepoint(4,isecn,1),
     x              trianglepoint(5,isecn,1),
     x              trianglepoint(6,isecn,1),
     x              rsv,1.d0,ir,ig,ib,in,0)
               icurtriangles=icurtriangles+6
             enddo
           enddo
         endif
      enddo

      call get_hasframetext(iframe,ihasframetext)
      call set_hasframetext(nworld,ihasframetext)
      if (ihasframetext.ne.0) then
         call get_frametextxy(iframe,xmy,ymy)
         call set_frametextxy(nworld,xmy,ymy)
         call get_frametext(iframe,frametext)
         call set_frametext(nworld,frametext)
      endif
      call copy_measures(iframe,nworld)


      if (ihardupdate.eq.0) then
c     remember the selected atoms
         call get_first_selectorder(id)
 100     continue
         if (id.ne.-1) then
            do iatom=1,atoms
               call get_atomid(nworld,iatom-1,id2)
               if (id2.eq.id) then
                  call set_atomselected(nworld,iatom-1,1)
               endif
            enddo
            call get_next_selectorder(id)
            goto 100
         endif
      endif
      call clear_selectorder
      return
      end

      subroutine sort_world
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      integer atoms,bonds,triangles
c     sort atoms
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atoms(nworld,atoms)
      call get_bonds(nworld,bonds)
      call get_triangles(nworld,triangles)

      if (atoms.gt.0) then
         do i=1,atoms
            call set_atomsort(nworld,i-1,i)
         enddo
         call cqsortda
      endif
      if (triangles.gt.0) then
         do i=1,triangles/3
            zzsum=0.d0
            call get_triangle(nworld,(i-1)*3,
     x           tx,ty,tz,
     x           tnx,tny,tnz,tfr,opaq,
     x           nr,ng,nb,nn,ntwo)
            zzsum=zzsum+tz
            call get_triangle(nworld,(i-1)*3+1,
     x           tx,ty,tz,
     x           tnx,tny,tnz,tfr,opaq,
     x           nr,ng,nb,nn,ntwo)
            zzsum=zzsum+tz
            call get_triangle(nworld,(i-1)*3+2,
     x           tx,ty,tz,
     x           tnx,tny,tnz,tfr,opaq,
     x           nr,ng,nb,nn,ntwo)
            zzsum=zzsum+tz
            zzsum=zzsum/3.0d0
            call set_trianglesort(nworld,i-1,i)
            call set_trianglecompare(nworld,i-1,zzsum)
         enddo
         call cqsortdt
      endif
      if (bonds.gt.0) then

c     sort bonds:
c     sort bond midpoint
         do i=1,bonds
            call get_bond1xyz(nworld,i-1,x,y,z1)
            call get_bond2xyz(nworld,i-1,x,y,z2)
            if (z1.gt.z2) then
               bz=z2-0.0001d0
            else
               bz=z1-0.0001d0
            endif
            call set_bondcompare(nworld,i-1,bz)
         enddo
c     
         do i=1,bonds
            call set_bondsort(nworld,i-1,i)
c     bondsort(i)=i
         enddo

         call cqsortdb
      endif
      return
      end

      subroutine find_best_msg_pos(imyposx,imyposy,ianr,
     x     xsize,ysize)
      implicit double precision (a-h,o-z)
      integer xsize,ysize
#include "transformationmatrix.commonblock"
      dimension vector(3)
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomxyz(nworld,ianr-1,vector(1),vector(2),vector(3))
c      vector(1)=atomx(ianr)
c      vector(2)=atomy(ianr)
c      vector(3)=atomz(ianr)
      call multiply_vector(t_matrix,vector)
      xmy=vector(1)
      ymy=vector(2)
      zmy=vector(3)
      call get_atomrad(nworld,ianr-1,rmy)
c      rmy=atomrad(ianr)
      call coord_convert(xmy,ymy,zmy,rmy)
      imyposx=int(xmy)
      imyposy=int(ymy)
c     Should search for best position
      isgnx=-1
      isgny=-1

      if ((imyposx-xsize/2).gt.0) isgnx=1
      if ((imyposy-ysize/2).gt.0) isgny=1
      imyposx=imyposx+int(rmy*isgnx*2)
      imyposy=imyposy+int(rmy*isgny*2)

      return
      end

      subroutine crossp(p1,p2,r)
      implicit double precision (a-h,o-z)
      dimension p1(3),p2(3),r(3)
      r(1)=p1(2)*p2(3)-p2(2)*p1(3)
      r(2)=p1(3)*p2(1)-p2(3)*p1(1)
      r(3)=p1(1)*p2(2)-p2(1)*p1(2)
      return
      end

      subroutine torsionangle(x1,y1,z1,
     x     x2,y2,z2,
     x     x3,y3,z3,
     x     x4,y4,z4,
     x     angle)
      implicit double precision (a-h,o-z)
      dimension p1(3),p2(3),p3(3),p4(3),
     x     p12(3),p23(3),p34(3),
     x     r1(3),r2(3),r3(3)
      p1(1)=x1
      p1(2)=y1
      p1(3)=z1

      p2(1)=x2
      p2(2)=y2
      p2(3)=z2

      p3(1)=x3
      p3(2)=y3
      p3(3)=z3

      p4(1)=x4
      p4(2)=y4
      p4(3)=z4

      do i=1,3
        p12(i)=p2(i)-p1(i)
        p23(i)=p3(i)-p2(i)
        p34(i)=p4(i)-p3(i)
      enddo

      call crossp(p12,p23,r1)
      call crossp(p23,p34,r2)
      
      rl1i=1.d0/sqrt(r1(1)*r1(1)+r1(2)*r1(2)+r1(3)*r1(3))
      rl2i=1.d0/sqrt(r2(1)*r2(1)+r2(2)*r2(2)+r2(3)*r2(3))
      
      angle=acos(rl1i*rl2i*(r1(1)*r2(1)+r1(2)*r2(2)+r1(3)*r2(3)))

      call crossp(r1,r2,r3)
      if (p23(1)/r3(1).le.0.d0) then
        if (p23(2)/r3(2).le.0.d0) then
          if (p23(3)/r3(3).le.0.d0) then
            angle=-angle
          endif
        endif
      endif
      return
      end

      subroutine init_stereo_matrix(xmatrix)
      implicit double precision (a-h,o-z)
      dimension xmatrix(4,4)
      do is=1,4
        do js=1,4
          xmatrix(js,is)=0.d0
        enddo
      enddo
      do is=1,4
        xmatrix(is,is)=1.0d0
      enddo
      return
      end

      subroutine steini
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      nstereo=0
      currentscale=1.d0
      stereoscale=0.85d0
      stereoangle=0.d0
      stereotranslate=-1.d0
      return
      end

      subroutine setste(n)
      implicit double precision (a-h,o-z)
#include "coordinates.commonblock"
#include "stereo.commonblock"
      nstereo=n
      if (nstereo.eq.1) then 
         currentscale=stereoscale
      else
         currentscale=1.d0
      endif

c      write (*,*) 'Calling def_res:',xrescp,yres
      call def_res(xrescp,yres)

      call stesmo(nstereo)
      
      call redef_unit
      return
      end

      subroutine sterei
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      call setste(nstereo)
      return 
      end

      subroutine steqry(n)
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      n=nstereo
      return
      end

      subroutine tglste
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      call setste(1-nstereo)
      return 
      end

      subroutine sttriz(n)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      iforcetriangles=n
      return
      end

      subroutine tgtriz
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      iforcetriangles=1-iforcetriangles
      return 
      end

      subroutine trzqry(n)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      n=iforcetriangles
      return
      end

      subroutine stntrz(n)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      itriqual=n
      return
      end

      subroutine tznqry(n)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      n=itriqual
      return
      end

      subroutine stepar(sa,ss,st)
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      stereoangle=sa
      stereoscale=ss
      stereotranslate=st
      return
      end

      subroutine stepqy(sa,ss,st)
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      sa=stereoangle
      ss=stereoscale
      st=stereotranslate
      return
      end

      subroutine stainc
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      stereotranslate=stereotranslate+0.1d0
      return
      end

      subroutine stadec
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      stereotranslate=stereotranslate-0.1d0
      return
      end

      subroutine draw_molbuffer(framebuffer,zbuffer,xsize,ysize)
      implicit double precision (a-h,o-z)
      integer framebuffer,zbuffer,xsize,ysize
      dimension framebuffer(*),zbuffer(*)

#include "world.commonblock"
#include "coordinates.commonblock"
#include "transformationmatrix.commonblock"
#include "psflag.commonblock"
#include "stereo.commonblock"
      dimension vector(3)
      dimension ixcoord(4),iycoord(4)
      dimension dxcoord(4),dycoord(4)
      dimension irgb(3)
      dimension xxrgb(3)
      dimension irgb2(3)
      dimension ip(16)
      integer draw_label,ybankstart,ybankend,ybanksize
      integer atoms,bonds,triangles,pcolor
      character*80 ctmp
      character*FMAXCHARSPERLABEL lbl
      character*FMAXCHARSINFRAMETEXT frametext
      dimension stereo_matrix(4,4)


      call dsget(i)
      if (i.eq.DRAW_STYLE_3D_SPHERES) then
        call gtdsty(i)
        if (i.eq.2) then
          if (nstereo.eq.1) then
            call psave('povraymode0',-stereotranslate)
            call psave('povraymode1',stereotranslate)
          else
            call psave('povraymode0',0.d0)
          endif
          return
        endif
      endif

      call dsget(idrawstyle)
      
c      write(*,*) idrawstyle,xsize,xmid,xc2xr

      if (nstereo.eq.1) then
         if (idrawstyle.ne.DRAW_STYLE_3D_SPHERES) then
            xsize=xsize/2
         endif
      endif

#ifdef USEOPENGL
      if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
        call oglget(iuseopengl)
      endif
#endif

      call govsmp(myoversample)

      call gufog(iusefog)
      call gfogp(xfoglevel)
      call gfogp2(xfoglevel2)
      call gfade(ifade)

      call dlqry(draw_label)
c     draw all atoms and bonds
c     sort them with some kind of insertion sort (although nothing is really
c     inserted.)

c     Split drawing of world into smaller pieces to save memory
      call getbsz(ybanksize)
      if ((idrawstyle.eq.DRAW_STYLE_2D_CIRCLES).or.
     x     (idrawstyle.eq.DRAW_STYLE_WIREFRAME))  then
        ybanksize=ysize
#ifdef USEOPENGL
      else
        if (iuseopengl.ne.0) then
          ybanksize=ysize
        endif
#endif
      endif

c     Clear selected animation list
      call sanl

      diddraw=1
      ybankstart=0
      ifirstdeclare=1
 100  continue

      ixtrans=0
      ixtranssel=0

      do istereo=0,nstereo
         if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
            call tnew
         endif
         if (istereo.eq.0) then
            if (iprintps.ne.0) then
               call gbkgrv(ir,ig,ib)
               call psyfp(0.d0,0.d0,
     x              dble(xsize),0.d0,
     x              dble(xsize),dble(ysize),
     x              0.d0,dble(ysize),
     x              ir,ig,ib)
            endif
         endif
         if (nstereo.eq.1) then
            if (iprintps.eq.1) then
               call psgsav
               call psclip(istereo*xsize,(istereo+1)*xsize,ysize)
            endif
C     Now create new modified matrix for stereo image istereo
C     Rotate
          call init_stereo_matrix(stereo_matrix)
          stereo_matrix(1,1)=cos((istereo*2-1)*stereoangle)
          stereo_matrix(1,3)=-sin((istereo*2-1)*stereoangle)
          stereo_matrix(3,1)=sin((istereo*2-1)*stereoangle)
          stereo_matrix(3,3)=cos((istereo*2-1)*stereoangle)
          call multiply_molbuffer(stereo_matrix)
C     Translate
          call init_stereo_matrix(stereo_matrix)
          stereo_matrix(4,1)=(istereo*2-1)*stereotranslate
          call multiply_molbuffer(stereo_matrix)

          if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
             ixtrans=((istereo*2-1)*xsize/4)
             ixtranssel=ixtrans
          else
             if (iprintps.eq.1) then
                ixtrans=istereo*xsize
             else
                ixtrans=0
             endif
             ixtranssel=istereo*xsize
          endif

          call stesbu(istereo)
        endif

        call stixtr(ixtrans)
        call sort_world
        call get_nframes(nframes)
        nworld=nframes+1
        call get_atoms(nworld,atoms)
        call get_bonds(nworld,bonds)
        call get_triangles(nworld,triangles)
c        write(*,*) 'draw_molbuffer. atoms:',atoms,'bonds:',bonds
c        write(*,*) 'draw_molbuffer. triangles:',triangles


c     write(*,*) 'In it'
        if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
           call gbkgrc(imybackgroundcolor)
c           if (diddraw.eq.1) then
c              write (*,*) 'clearing buffers'
              call sclear(imybackgroundcolor)
c           endif
        endif
        
        diddraw=1
c     diddraw=0
c        if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
c           write(*,*) 'Drawing bank with base:',ybankstart
c        endif
        ybankend=ybankstart+ybanksize-1
        if (ybankend.ge.ysize) ybankend=ysize-1
        

        iatomcount=1
        ibondcount=1
        itrianglecount=1
        istop=0
 10     continue
        if ((atoms.gt.0).and.(iatomcount.le.atoms))
     x       call get_atomsort(nworld,iatomcount-1,iatomsort)
        if ((bonds.gt.0).and.(ibondcount.le.bonds))
     x       call get_bondsort(nworld,ibondcount-1,ibondsort)
        if ((triangles.gt.0).and.(itrianglecount.le.(triangles/3)))
     x       call get_trianglesort(nworld,itrianglecount-1,
     x       itrianglesort)

        if ((iatomcount.le.atoms)
     x       .and.(ibondcount.le.bonds)
     x       .and.(itrianglecount.le.(triangles/3))) then
c     write(*,*) '*** ',iatomcount,ibondcount,':',iatomsort,ibondsort
          call get_atomxyz(nworld,iatomsort-1,xt,yt,az)
          if ((iforcetriangles.eq.1)
     x         .and.((.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES)))) then
            call get_atomrad(nworld,iatomsort-1,rad)
            az=az+rad*1.05
          endif
          call get_bondcompare(nworld,ibondsort-1,bz)
          call get_trianglecompare(nworld,itrianglesort-1,tz)
          if (az.lt.bz) then
            if (tz.lt.az) then
              idrawatom=2
            else
              idrawatom=1
            endif
          else
            if (tz.lt.bz) then
              idrawatom=2
            else
              idrawatom=0
            endif
          endif
        else if ((iatomcount.le.atoms)
     x         .and.(ibondcount.le.bonds)) then
          call get_atomxyz(nworld,iatomsort-1,xt,yt,az)
          if ((iforcetriangles.eq.1)
     x         .and.((.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES)))) then
            call get_atomrad(nworld,iatomsort-1,rad)
            az=az+rad*1.05
          endif
          call get_bondcompare(nworld,ibondsort-1,bz)
          if (az.lt.bz) then
            idrawatom=1
          else
            idrawatom=0
          endif
        else if ((iatomcount.le.atoms)
     x         .and.(itrianglecount.le.(triangles/3))) then
          call get_atomxyz(nworld,iatomsort-1,xt,yt,az)
          if ((iforcetriangles.eq.1)
     x        .and.((.not.(idstyle.eq.DRAW_STYLE_3D_SPHERES)))) then
            call get_atomrad(nworld,iatomsort-1,rad)
            az=az+rad*1.05
          endif
          call get_trianglecompare(nworld,itrianglesort-1,tz)
          if (az.lt.tz) then
            idrawatom=1
          else
            idrawatom=2
          endif
        else if ((itrianglecount.le.(triangles/3))
     x         .and.(ibondcount.le.bonds)) then
          call get_trianglecompare(nworld,itrianglesort-1,tz)
          call get_bondcompare(nworld,ibondsort-1,bz)
          if (tz.lt.bz) then
            idrawatom=2
          else
            idrawatom=0
          endif
        else if (iatomcount.le.atoms) then
          idrawatom=1
        else if (ibondcount.le.bonds) then
          idrawatom=0
        else if (itrianglecount.le.(triangles/3)) then
          idrawatom=2
        else
          istop=1
c     write(*,*) 'STOP'
        endif
        if (istop.eq.0) then
          if (idrawatom.eq.2) then
            rmy=0.d0
            isort=1+(itrianglesort-1)*3
            call get_triangle(nworld,isort-1,
     x           tx1,ty1,tz1,tnx1,tny1,tnz1,
     x           tfr1,opaq1,nr1,ng1,nb1,nn1,ntwo1)
            call get_triangle(nworld,isort,
     x           tx2,ty2,tz2,tnx2,tny2,tnz2,
     x           tfr2,opaq2,nr2,ng2,nb2,nn2,ntwo2)
            call get_triangle(nworld,isort+1,
     x           tx3,ty3,tz3,tnx3,tny3,tnz3,
     x           tfr3,opaq3,nr3,ng3,nb3,nn3,ntwo3)

            tnx1=tnx1+tx1
            tny1=tny1+ty1
            tnz1=tnz1+tz1
            vector(1)=tx1
            vector(2)=ty1
            vector(3)=tz1
            call multiply_vector(t_matrix,vector)
            tx1=vector(1)
            ty1=vector(2)
            tz1=vector(3)
            vector(1)=tnx1
            vector(2)=tny1
            vector(3)=tnz1
            call multiply_vector(t_matrix,vector)
            tnx1=vector(1)-tx1
            tny1=vector(2)-ty1
            tnz1=vector(3)-tz1

            tnx2=tnx2+tx2
            tny2=tny2+ty2
            tnz2=tnz2+tz2
            vector(1)=tx2
            vector(2)=ty2
            vector(3)=tz2
            call multiply_vector(t_matrix,vector)
            tx2=vector(1)
            ty2=vector(2)
            tz2=vector(3)
            vector(1)=tnx2
            vector(2)=tny2
            vector(3)=tnz2
            call multiply_vector(t_matrix,vector)

            tnx2=vector(1)-tx2
            tny2=vector(2)-ty2
            tnz2=vector(3)-tz2

            tnx3=tnx3+tx3
            tny3=tny3+ty3
            tnz3=tnz3+tz3
            vector(1)=tx3
            vector(2)=ty3
            vector(3)=tz3
            call multiply_vector(t_matrix,vector)
            tx3=vector(1)
            ty3=vector(2)
            tz3=vector(3)
            vector(1)=tnx3
            vector(2)=tny3
            vector(3)=tnz3
            call multiply_vector(t_matrix,vector)
            tnx3=vector(1)-tx3
            tny3=vector(2)-ty3
            tnz3=vector(3)-tz3

            call coord_convert(tx1,ty1,tz1,rmy)
            call coord_convert(tx2,ty2,tz2,rmy)
            call coord_convert(tx3,ty3,tz3,rmy)

            if ((iclip(int(tz1),xsize,ysize).eq.0).and.
     x           (iclip(int(tz2),xsize,ysize).eq.0).and.
     x           (iclip(int(tz3),xsize,ysize).eq.0)) then
              
              call fperspectivef(tx1,ty1,tz1,xsize,ysize)
              call fperspectivef(tx2,ty2,tz2,xsize,ysize)
              call fperspectivef(tx3,ty3,tz3,xsize,ysize)
              
c     Normalize
              xn=tnx1*tnx1+tny1*tny1+tnz1*tnz1
              xn=1.d0/xn
              tnx1=tnx1*xn
              tny1=tny1*xn
              tnz1=tnz1*xn

              xn=tnx2*tnx2+tny2*tny2+tnz2*tnz2
              xn=1.d0/xn
              tnx2=tnx2*xn
              tny2=tny2*xn
              tnz2=tnz2*xn

              xn=tnx3*tnx3+tny3*tny3+tnz3*tnz3
              xn=1.d0/xn
              tnx3=tnx3*xn
              tny3=tny3*xn
              tnz3=tnz3*xn

              if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
                call tadtri(tx1,ty1,tz1,tnx1,tny1,tnz1,
     x               nr1,ng1,nb1,tfr1,opaq1,nn1,ntwo1,
     x               tx2,ty2,tz2,tnx2,tny2,tnz2,
     x               nr2,ng2,nb2,tfr2,opaq2,nn2,ntwo2,
     x               tx3,ty3,tz3,tnx3,tny3,tnz3,
     x               nr3,ng3,nb3,tfr3,opaq3,nn3,ntwo3)
              else if (idrawstyle.eq.DRAW_STYLE_2D_CIRCLES) then
                txav=(tnx1+tnx2+tnx3)/3.
                tyav=(tny1+tny2+tny3)/3.
                tzav=(tnz1+tnz2+tnz3)/3.
                if (tzav.lt.0) then
                  txav=-txav
                  tyav=-tyav
                  tzav=-tzav
                endif
                nrav=(nr1+nr2+nr3)/3
                ngav=(ng1+ng2+ng3)/3
                nbav=(nb1+nb2+nb3)/3
                tfrav=(tfr1+tfr2+tfr3)/3.
                nnav=(nn1+nn2+nn3)/3
                nc=pcolor(nrav,ngav,nbav,tfrav,tfrav,tfrav,
     x               nnav,txav,tyav,tzav)
                nbav=nc/65536
                ngav=(nc-nbav*65536)/256
                nrav=(nc-nbav*65536-ngav*256)
                dxcoord(1)=tx1
                dxcoord(2)=tx2
                dxcoord(3)=tx3
                dycoord(1)=ty1
                dycoord(2)=ty2
                dycoord(3)=ty3
                if (iusefog.ne.0) then
                  call fog(int((tz1+tz2+tz3)/3),
     x                 nrav,ngav,nbav,xsize,ysize,
     x                 xfoglevel,xfoglevel2)
                endif
                call fade(nrav,ngav,nbav,ifade)
                if (iprintps.ne.0) then
                  call psyfpt(dxcoord(1)+ixtrans,
     x                 dycoord(1),
     x                 dxcoord(2)+ixtrans,
     x                 dycoord(2),
     x                 dxcoord(3)+ixtrans,
     x                 dycoord(3),
     x                 nrav,ngav,nbav)
                endif
                do idi=1,3
                  ixcoord(idi)=int(dxcoord(idi))+ixtrans
                  iycoord(idi)=int(dycoord(idi))
                enddo
                call fpoly(ixcoord,iycoord,3,nrav,ngav,nbav)
              else if (idrawstyle.eq.DRAW_STYLE_WIREFRAME) then
                nrav=(nr1+nr2+nr3)/3
                ngav=(ng1+ng2+ng3)/3
                nbav=(nb1+nb2+nb3)/3
                dxcoord(1)=tx1
                dxcoord(2)=tx2
                dxcoord(3)=tx3
                dycoord(1)=ty1
                dycoord(2)=ty2
                dycoord(3)=ty3
                if (iusefog.ne.0) then
                  call fog(int((tz1+tz2+tz3)/3),
     x                 nrav,ngav,nbav,xsize,ysize,
     x                 xfoglevel,xfoglevel2)
                endif
                call fade(nrav,ngav,nbav,ifade)
                if (iprintps.ne.0) then
                  call psypt(dxcoord(1)+ixtrans,
     x                 dycoord(1),
     x                 dxcoord(2)+ixtrans,
     x                 dycoord(2),
     x                 dxcoord(3)+ixtrans,
     x                 dycoord(3),
     x                 dble(1),
     x                 nrav,ngav,nbav)
                endif
                do idi=1,3
                  ixcoord(idi)=int(dxcoord(idi))+ixtrans
                  iycoord(idi)=int(dycoord(idi))
                enddo
                call poly(ixcoord,iycoord,3,nrav,ngav,nbav)
              endif
            endif
            itrianglecount=itrianglecount+1
          else if (idrawatom.eq.1) then
c     write(*,*) 'Drawing atom'
            isort=iatomsort
            call get_atomnr(nworld,isort-1,inr)
            if (inr.ne.256) then
              call get_atomxyz(nworld,isort-1,
     x             vector(1),vector(2),vector(3))
c     isort=atomsort(iatomcount)
c     vector(1)=atomx(isort)
c     vector(2)=atomy(isort)
c     vector(3)=atomz(isort)
              call multiply_vector(t_matrix,vector)
              xmy=vector(1)
              ymy=vector(2)
              zmy=vector(3)
              call get_atomrad(nworld,isort-1,rmy)
              if (rmy.lt.0.00001d0) goto 550
              call get_atomscalerad(nworld,isort-1,rmyscale)
c              write (*,*) 'rmyscale=',rmyscale
              rmy=rmy*rmyscale
              call coord_convert(xmy,ymy,zmy,rmy)
              if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
                call get_atomr(nworld,isort-1,irgb(1))
                call get_atomg(nworld,isort-1,irgb(2))
                call get_atomb(nworld,isort-1,irgb(3))
c     do iset=1,3
c     irgb(iset)=atomrgb(isort,iset)
c     enddo
                if (ifirstdeclare.eq.1) then
                  call get_atomrsv(nworld,isort-1,xrsv)
                  call get_atomn(nworld,isort-1,in)
c     write(*,*) 'world.F got',in
c                  write (*,*) 'draw 3d sphere at ',xmy
                  call tadsph(xmy,ymy,zmy,rmy,
     x                 irgb,xrsv,in,10,10,xsize,ysize)
                endif
                call get_atomhasmessage(nworld,isort-1,itmp)
                if (itmp.ne.0) then
                  call find_best_msg_pos(imyposx,imyposy,isort,
     x                 xsize,ysize)
                  zmy=zmy+rmy*2
                  irgb(1)=170
                  irgb(2)=170
                  irgb(3)=170
                  call get_atomrsv(nworld,isort-1,xrsv)
                  call get_atomn(nworld,isort-1,in)
                  call tadcyl(dble(imyposx),dble(imyposy),
     x                 zmy,1.d0+rmy*0.1d0,
     x                 xmy,ymy,zmy,1.d0+rmy*0.1d0,
     x                 irgb,xrsv,in,
     x                 irgb,xrsv,in,
     x                 16,xsize,ysize)
                  call fperspective(imyposx,imyposy,izmy,xsize,ysize)
                  ipos=-1
                  if (imyposx.lt.int(xmy))
     x                 ipos=1
                  call dpin3d(framebuffer,zbuffer,xsize,ysize,
     x                 imyposx+ixtrans,
     x                 imyposy,
     x                 izmy,
     x                 atommessage(itmp),
     x                 ipos,1+int(rmy/2),ybankstart,ybankend)
                endif
                if (draw_label.ne.0) then
                  znew=zmy+rmy+1
                  ixmy1=int(xmy-rmy)
                  iymy1=int(ymy-rmy)
                  izmy1=int(zmy)
                  ixmy2=int(xmy+rmy)
                  iymy2=int(ymy+rmy)
                  izmy2=int(zmy)
                  call glabxy(xxrgb)
                  if ((xxrgb(1)**2+xxrgb(2)**2)>0.01) then
C     Use xy-offset
                    ixmy1=int(xmy+0*rmy*xxrgb(1))
                    iymy1=int(ymy+0*rmy*xxrgb(2))
                    ixmy2=int(xmy+2*rmy*xxrgb(1))
                    iymy2=int(ymy+2*rmy*xxrgb(2))
                  endif
                  call fperspective(ixmy1,iymy1,izmy1,xsize,ysize)
                  call fperspective(ixmy2,iymy2,izmy2,xsize,ysize)
                  ixmyp=(ixmy1+ixmy2)/2
                  iymyp=(iymy1+iymy2)/2
                  irmyp=(ixmy2-ixmy1)/2

                  ixmy1=0
                  iymy1=0
                  call glabzo(zoffset)
                  znew=znew+zoffset
                  izmy1=int(znew)
                  call fperspective(ixmy1,iymy1,izmy1,xsize,ysize)

                  call glabcl(xxrgb)
                  if (xxrgb(1).lt.0) then
                    ir1=int(-xxrgb(1)*255)
                    ig1=int(xxrgb(2)*255)
                    ib1=int(xxrgb(3)*255)
                    ir2=ir1
                    ig2=ig1
                    ib2=ib1
                  else
                    ir1=int(xxrgb(1)*255)
                    ig1=int(xxrgb(2)*255)
                    ib1=int(xxrgb(3)*255)
                    ir2=255-ir1
                    ig2=255-ig1
                    ib2=255-ib1
                  endif
                  
                  if (iusefog.ne.0) then
                    call fog(izmy1,ir1,ig1,ib1,xsize,ysize,
     x                   xfoglevel,xfoglevel2)
                    call fog(izmy1,ir2,ig2,ib2,xsize,ysize,
     x                   xfoglevel,xfoglevel2)
                  endif
                  call fade(ir1,ig1,ib1,ifade)
                  call fade(ir2,ig2,ib2,ifade)
                  call get_atomlabel(nworld,isort-1,lbl)

                  call glabsc(rscale)
                  if (rscale.gt.0) then
                    irmyp=int(irmyp*rscale)
                  else
                    irmyp=int(-rscale)
                  endif
C     write (*,*) 'scale:',irmyp,rscale
c                  write (*,*) 'draw 3d text at ',ixmyp+ixtrans
                  call dtxt3d(framebuffer,zbuffer,xsize,ysize,
     x                 ixmyp+ixtrans,
     x                 iymyp,
     x                 izmy1,
     x                 lbl,
     x                 ir1,ig1,ib1,
     x                 ir2,ig2,ib2,0,
     x                 irmyp,ybankstart,ybankend)
                endif


              else if (idrawstyle.eq.DRAW_STYLE_2D_CIRCLES) then

c     Clipping:               
                if (iclip(int(zmy),xsize,ysize).eq.0) then
c     Perspective:
                  xmy1=xmy-rmy
                  ymy1=ymy-rmy
                  zmy1=zmy
                  xmy2=xmy+rmy
                  ymy2=ymy+rmy
                  zmy2=zmy
                  call fperspectivef(xmy1,ymy1,zmy1,xsize,ysize)
                  call fperspectivef(xmy2,ymy2,zmy2,xsize,ysize)
                  xmyp=(xmy1+xmy2)/2
                  ymyp=(ymy1+ymy2)/2
                  rmyp=(xmy2-xmy1)/2
                  call get_atomr(nworld,isort-1,ir)
                  call get_atomg(nworld,isort-1,ig)
                  call get_atomb(nworld,isort-1,ib)
c     ir=atomrgb(isort,1)
c     ig=atomrgb(isort,2)
c     ib=atomrgb(isort,3)
                  if (iusefog.ne.0) then
c     nmyz=int(zmy)
                    nmyz=int(zmy1)
                    call fog(nmyz,ir,ig,ib,xsize,ysize,xfoglevel,
     x                   xfoglevel2)
                  endif
                  call fade(ir,ig,ib,ifade)
                  if (iforcetriangles.ne.1) then
                    if (iprintps.ne.0) then
                      call psyfc(xmyp+ixtrans,
     x                     ymyp,
     x                     rmyp,
     x                     ir,ig,ib)
                    endif
                    call fcirc(int(xmyp)+ixtrans,int(ymyp),
     x                   int(rmyp),
     x                   ir,ig,ib)
                  endif
c     Add selected animation
                  call get_atomselected(nworld,isort-1,itmp)
                  if (itmp.ne.0) then
                    call saac(int(xmyp)+ixtranssel,int(ymyp),int(rmyp))
                  endif

c     small white dot(s)
c     number of dots=ndots
c     the dots become whiter if xhowfar=1, the larger xhowfar is the less
c     white does the dots become
C     xhowfar=3
C     ndots=20
                  call gndots(ndots)
                  call gxfar(xhowfar)

                  call get_atomr(nworld,isort-1,ir)
                  call get_atomg(nworld,isort-1,ig)
                  call get_atomb(nworld,isort-1,ib)
                  if (iforcetriangles.ne.1) then
                    do idots=1,ndots
                      xmy=xmyp-0.7d0*rmyp*0.3d0*idots/
     x                     (ndots+1)
                      ymy=ymyp+0.7d0*rmyp*0.3d0*idots/
     x                     (ndots+1)
                      rmy=rmyp*(ndots-idots+1)/(ndots+1)
                      icr=ir+
     x                     ((255-ir)*idots)/(ndots*xhowfar)
                      icg=ig+
     x                     ((255-ig)*idots)/(ndots*xhowfar)
                      icb=ib+
     x                     ((255-ib)*idots)/(ndots*xhowfar)
                      if (iusefog.ne.0) then
                        call fog(nmyz,icr,icg,icb,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(icr,icg,icb,ifade)
                      if (iprintps.ne.0) then
                        call psyfc(xmy+ixtrans,
     x                       ymy,
     x                       rmy,
     x                       icr,icg,icb)
                      endif
                      call fcirc(int(xmy)+ixtrans,int(ymy),int(rmy),
     x                     icr,icg,
     x                     icb)
                    enddo
                    icr=0
                    icg=0
                    icb=0
                    if (iusefog.ne.0) then
                      call fog(nmyz,icr,icg,icb,xsize,ysize,
     x                     xfoglevel,xfoglevel2)
                    endif
                    call fade(icr,icg,icb,ifade)
                    if (iprintps.ne.0) then
                      call psyc(xmyp+ixtrans,
     x                     ymyp,
     x                     rmyp,
     x                     dble(1),
     x                     icr,icg,icb)
                    endif
                    call circ(int(xmyp)+ixtrans,int(ymyp),int(rmyp),
     x                   icr,icg,icb)
                  endif
                  call get_atomhasmessage(nworld,isort-1,itmp)
                  if (itmp.ne.0) then
                    call find_best_msg_pos(imyposx,imyposy,isort,
     x                   xsize,ysize)
                    zmy=zmy+rmy*2
                    call fperspectivef(dble(imyposx),dble(imyposy),
     x                   zmy,
     x                   xsize,ysize)
                    call line(imyposx+ixtrans,imyposy,
     x                   int(xmy)+ixtrans,int(ymy),
     x                   170,170,170)
                    ipos=-1
                    if (imyposx.lt.int(xmy))
     x                   ipos=1
                    call dtxt(imyposx+ixtrans,imyposy,
     x                   atommessage(itmp),
     x                   0,0,0,ipos,1+int(rmyp)/2)
                  endif
                  if (draw_label.ne.0) then
                    call get_atomlabel(nworld,isort-1,lbl)
                    call glabcl(xxrgb)
                    icr=int(xxrgb(1)*255)
                    icg=int(xxrgb(2)*255)
                    icb=int(xxrgb(3)*255)
                    if (iusefog.ne.0) then
                      call fog(nmyz,icr,icg,icb,xsize,ysize,
     x                     xfoglevel,xfoglevel2)
                    endif
                    call fade(icr,icg,icb,ifade)

                    call glabxy(xxrgb)
                    if ((xxrgb(1)**2+xxrgb(2)**2).gt.0.01) then
C     Use xy-offset
                      xmyp=xmyp+0.5*(xmy2-xmy1)*xxrgb(1)
                      ymyp=ymyp+0.5*(ymy2-ymy1)*xxrgb(2)
                    endif
                    call glabsc(rscale)
                    if (rscale.gt.0) then
                      rmyp=rmyp*rscale
                    else
                      rmyp=-rscale
                    endif
                    if (iprintps.ne.0) then
                      call psycts(xmyp+ixtrans,ymyp,
     x                     rmyp,lbl,icr,icg,icb)
                    endif
                    call dtxt(int(xmyp)+ixtrans,int(ymyp),lbl,
     x                   icr,icg,icb,0,int(rmyp))
                  endif
                endif
              else if (idrawstyle.eq.DRAW_STYLE_WIREFRAME) then
#if 0 


c     Clipping:               
                if (iclip(int(zmy),xsize,ysize).eq.0) then
c     Perspective:
                  xmy1=xmy
                  ymy1=ymy
                  zmy1=zmy
                  call fperspectivef(xmy1,ymy1,zmy1,xsize,ysize)
                  call get_atomr(nworld,isort-1,ir)
                  call get_atomg(nworld,isort-1,ig)
                  call get_atomb(nworld,isort-1,ib)
                  if (iusefog.ne.0) then
                    call fog(int(zmy1),ir,ig,ib,xsize,ysize,
     x                   xfoglevel,xfoglevel2)
                  endif
                  call fade(ir,ig,ib,ifade)
                  call point(int(xmy1)+ixtrans,int(ymy1),
     x                 ir,ig,ib)


c     Add selected animation
                  call get_atomselected(nworld,isort-1,itmp)
                  if (itmp.ne.0) then
                    call saac(int(xmy1)+ixtranssel,int(ymy1),1)
                  endif
                endif
#endif
              endif
            endif
 550        continue
            iatomcount=iatomcount+1
          else
c     write(*,*) 'Drawing bond'
            isort=ibondsort
            call get_drawbond(nworld,isort-1,idraw)
            if (idraw.eq.0) goto 555
            call get_bond1xyz(nworld,isort-1,
     x           vector(1),vector(2),vector(3))
c     vector(1)=bondx(isort,1)
c     vector(2)=bondy(isort,1)
c     vector(3)=bondz(isort,1)
            call multiply_vector(t_matrix,vector)
            xmy1=vector(1)
            ymy1=vector(2)
            zmy1=vector(3)
            call get_bond2xyz(nworld,isort-1,
     x           vector(1),vector(2),vector(3))
c     vector(1)=bondx(isort,2)
c     vector(2)=bondy(isort,2)
c     vector(3)=bondz(isort,2)
            call multiply_vector(t_matrix,vector)
            xmy2=vector(1)
            ymy2=vector(2)
            zmy2=vector(3)
            call get_bondrad1(nworld,isort-1,rmy1)
            rmy2=rmy1
            if (rmy1.lt.0.00001d0) goto 555
c     rmy1=bondrad(isort)
c     rmy2=bondrad(isort)
            call get_bondnslice(nworld,isort-1,inslice)
            if (inslice.eq.1) then
              call get_bond1(nworld,isort-1,iatom1)
              call get_bond2(nworld,isort-1,iatom2)
              call get_atomrad(nworld,iatom1-1,xrad1)
              call get_atomscalerad(nworld,iatom1-1,rmyscale)
              xrad1=xrad1*rmyscale
              call get_atomrad(nworld,iatom2-1,xrad2)
              call get_atomscalerad(nworld,iatom2-1,rmyscale)
              xrad2=xrad2*rmyscale
              rbondlen=sqrt((xmy2-xmy1)**2+
     x             (ymy2-ymy1)**2+(zmy2-zmy1)**2)
              apos=0.5d0*(rbondlen-xrad1-xrad2)
              rmy3=rmy1
              xmy3=((xrad1+apos)*xmy2+(xrad2+apos)*xmy1)/rbondlen
              ymy3=((xrad1+apos)*ymy2+(xrad2+apos)*ymy1)/rbondlen
              zmy3=((xrad1+apos)*zmy2+(xrad2+apos)*zmy1)/rbondlen
              call coord_convert(xmy3,ymy3,zmy3,rmy3)
            endif
            call coord_convert(xmy1,ymy1,zmy1,rmy1)         
            call coord_convert(xmy2,ymy2,zmy2,rmy2)
            if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
              call get_bondr1(nworld,isort-1,irgb(1))
              call get_bondg1(nworld,isort-1,irgb(2))
              call get_bondb1(nworld,isort-1,irgb(3))
              call get_bondrsv1(nworld,isort-1,xrsv)
              call get_bondn1(nworld,isort-1,in)
              if (inslice.eq.1) then
c     draw two cylinders
c     find the color of the first atom
                call get_bond1(nworld,isort-1,iatom1)
                call get_atomr(nworld,iatom1-1,irgb(1))
                call get_atomg(nworld,iatom1-1,irgb(2))
                call get_atomb(nworld,iatom1-1,irgb(3))
                do iset=1,3
                  irgb2(iset)=irgb(iset)
                enddo
                if (ifirstdeclare.eq.1) then
                  call tadcyl(xmy1,ymy1,zmy1,rmy1,
     x                 xmy3,ymy3,zmy3,rmy3,
     x                 irgb,xrsv,in,
     x                 irgb2,xrsv,in,
     x                 16,xsize,ysize)
                endif
c     find the color of the second atom
                call get_bond2(nworld,isort-1,iatom1)
                call get_atomr(nworld,iatom1-1,irgb(1))
                call get_atomg(nworld,iatom1-1,irgb(2))
                call get_atomb(nworld,iatom1-1,irgb(3))
                do iset=1,3
                  irgb2(iset)=irgb(iset)
                enddo
                if (ifirstdeclare.eq.1) then
                  call tadcyl(xmy3,ymy3,zmy3,rmy3,
     x                 xmy2,ymy2,zmy2,rmy2,
     x                 irgb,xrsv,in,
     x                 irgb2,xrsv,in,
     x                 16,xsize,ysize)
                endif
              else
                do iset=1,3
c     irgb(iset)=bondrgb(isort,iset)
                  irgb2(iset)=irgb(iset)
                enddo
                if (ifirstdeclare.eq.1) then
                  call tadcyl(xmy1,ymy1,zmy1,rmy1,
     x                 xmy2,ymy2,zmy2,rmy2,
     x                 irgb,xrsv,in,
     x                 irgb2,xrsv,in,
     x                 16,xsize,ysize)
                endif
              endif
            else if (idrawstyle.eq.DRAW_STYLE_2D_CIRCLES) then
c     compute coordinates of polygon
              if ((xmy1.ne.xmy2).or.(ymy1.ne.ymy2)) then
c     Clipping:               
                if (iclip(int(zmy1),xsize,ysize).eq.0) then
                  if (iclip(int(zmy2),xsize,ysize).eq.0) then
                    if (inslice.eq.1) then
c     Draw first filled polygon
c     find the color of the first atom
                      call get_bond1(nworld,isort-1,iatom1)
                      call get_atomr(nworld,iatom1-1,ir)
                      call get_atomg(nworld,iatom1-1,ig)
                      call get_atomb(nworld,iatom1-1,ib)
                      dx=xmy2-xmy1
                      dy=ymy2-ymy1
                      dx2=dx*dx
                      dy2=dy*dy
                      dlen=sqrt(dx2+dy2)
                      if (dx2.gt.dy2) then
                        ry=sqrt(dble(dx2)/(dble(dx2)+dble(dy2)))
                        rx=-(ry*dble(dy)/dble(dx))
                      else
                        rx=sqrt(dble(dy2)/(dble(dy2)+dble(dx2)))
                        ry=-(rx*dble(dx)/dble(dy))
                      endif
                      rlen=sqrt(rx*rx+ry*ry)
                      rx=rx/rlen
                      ry=ry/rlen
                      dinv=0.5d0*1.d0/dlen
                      dxcoord(1)=xmy1+rx*rmy1-dinv*dx*rmy1
                      dycoord(1)=ymy1+ry*rmy1-dinv*dy*rmy1
                      dxcoord(2)=xmy1-rx*rmy1-dinv*dx*rmy1
                      dycoord(2)=ymy1-ry*rmy1-dinv*dy*rmy1
                      dxcoord(3)=0.5d0*(xmy2-rx*rmy2+dinv*dx*rmy2
     x                     +xmy1-rx*rmy1-dinv*dx*rmy1)
                      dycoord(3)=0.5d0*(ymy2-ry*rmy2+dinv*dy*rmy2
     x                     +ymy1-ry*rmy1-dinv*dy*rmy1)
                      dxcoord(4)=0.5d0*(xmy2+rx*rmy2+dinv*dx*rmy2
     x                     +xmy1+rx*rmy1-dinv*dx*rmy1)
                      dycoord(4)=0.5d0*(ymy2+ry*rmy2+dinv*dy*rmy2
     x                     +ymy1+ry*rmy1-dinv*dy*rmy1)
c     Perspective:
                      zmyx1=zmy1
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmyx1,xsize,ysize)
                      zmyx1=zmy1
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmyx1,xsize,ysize)
                      zmyx2=0.5d0*(zmy1+zmy2)
                      call fperspectivef(dxcoord(3),
     x                     dycoord(3),zmyx2,xsize,ysize)
                      zmyx2=0.5d0*(zmy1+zmy2)
                      call fperspectivef(dxcoord(4),
     x                     dycoord(4),zmyx2,xsize,ysize)
                      
                      if (iusefog.ne.0) then
                        nmyz=int((zmyx1+zmyx2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iforcetriangles.ne.1) then
                        if (iprintps.ne.0) then
                          call psyfp(dxcoord(1)+ixtrans,
     x                         dycoord(1),
     x                         dxcoord(2)+ixtrans,
     x                         dycoord(2),
     x                         dxcoord(3)+ixtrans,
     x                         dycoord(3),
     x                         dxcoord(4)+ixtrans,
     x                         dycoord(4),
     x                         ir,ig,ib)
                        endif
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                        
                        call fpoly(ixcoord,iycoord,4,
     x                       ir,ig,ib)
                      else
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                      endif
c     Draw second filled polygon
                      call get_bond2(nworld,isort-1,iatom1)
                      call get_atomr(nworld,iatom1-1,ir)
                      call get_atomg(nworld,iatom1-1,ig)
                      call get_atomb(nworld,iatom1-1,ib)
                      dx=xmy2-xmy1
                      dy=ymy2-ymy1
                      dx2=dx*dx
                      dy2=dy*dy
                      dlen=sqrt(dx2+dy2)
                      if (dx2.gt.dy2) then
                        ry=sqrt(dble(dx2)/(dble(dx2)+dble(dy2)))
                        rx=-(ry*dble(dy)/dble(dx))
                      else
                        rx=sqrt(dble(dy2)/(dble(dy2)+dble(dx2)))
                        ry=-(rx*dble(dx)/dble(dy))
                      endif
                      rlen=sqrt(rx*rx+ry*ry)
                      rx=rx/rlen
                      ry=ry/rlen
                      dinv=0.5d0*1.d0/dlen
                      dxcoord(1)=0.5d0*(xmy1+rx*rmy1-dinv*dx*rmy1
     x                     +xmy2+rx*rmy2+dinv*dx*rmy2)
                      dycoord(1)=0.5d0*(ymy1+ry*rmy1-dinv*dy*rmy1
     x                     +ymy2+ry*rmy2+dinv*dy*rmy2)
                      dxcoord(2)=0.5d0*(xmy1-rx*rmy1-dinv*dx*rmy1
     x                     +xmy2-rx*rmy2+dinv*dx*rmy2)
                      dycoord(2)=0.5d0*(ymy1-ry*rmy1-dinv*dy*rmy1
     x                     +ymy2-ry*rmy2+dinv*dy*rmy2)
                      dxcoord(3)=xmy2-rx*rmy2+dinv*dx*rmy2
                      dycoord(3)=ymy2-ry*rmy2+dinv*dy*rmy2
                      dxcoord(4)=xmy2+rx*rmy2+dinv*dx*rmy2
                      dycoord(4)=ymy2+ry*rmy2+dinv*dy*rmy2
c     Perspective:
                      zmyx1=0.5d0*(zmy1+zmy2)
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmyx1,xsize,ysize)
                      zmyx1=0.5d0*(zmy1+zmy2)
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmyx1,xsize,ysize)
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(3),
     x                     dycoord(3),zmyx2,xsize,ysize)
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(4),
     x                     dycoord(4),zmyx2,xsize,ysize)
                      
                      if (iusefog.ne.0) then
                        nmyz=int((zmyx1+zmyx2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iforcetriangles.ne.1) then
                        if (iprintps.ne.0) then
                          call psyfp(dxcoord(1)+ixtrans,
     x                         dycoord(1),
     x                         dxcoord(2)+ixtrans,
     x                         dycoord(2),
     x                         dxcoord(3)+ixtrans,
     x                         dycoord(3),
     x                         dxcoord(4)+ixtrans,
     x                         dycoord(4),
     x                         ir,ig,ib)
                        endif
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                        
                        call fpoly(ixcoord,iycoord,4,
     x                       ir,ig,ib)
                      else
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                      endif
c     Draw the unfilled polygon
                      dx=xmy2-xmy1
                      dy=ymy2-ymy1
                      dx2=dx*dx
                      dy2=dy*dy
                      dlen=sqrt(dx2+dy2)
                      if (dx2.gt.dy2) then
                        ry=sqrt(dble(dx2)/(dble(dx2)+dble(dy2)))
                        rx=-(ry*dble(dy)/dble(dx))
                      else
                        rx=sqrt(dble(dy2)/(dble(dy2)+dble(dx2)))
                        ry=-(rx*dble(dx)/dble(dy))
                      endif
                      rlen=sqrt(rx*rx+ry*ry)
                      rx=rx/rlen
                      ry=ry/rlen
                      dinv=0.5d0*1.d0/dlen
                      dxcoord(1)=xmy1+rx*rmy1-dinv*dx*rmy1
                      dycoord(1)=ymy1+ry*rmy1-dinv*dy*rmy1
                      dxcoord(2)=xmy1-rx*rmy1-dinv*dx*rmy1
                      dycoord(2)=ymy1-ry*rmy1-dinv*dy*rmy1
                      dxcoord(3)=xmy2-rx*rmy2+dinv*dx*rmy2
                      dycoord(3)=ymy2-ry*rmy2+dinv*dy*rmy2
                      dxcoord(4)=xmy2+rx*rmy2+dinv*dx*rmy2
                      dycoord(4)=ymy2+ry*rmy2+dinv*dy*rmy2
c     Perspective:
                      zmyx1=zmy1
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmyx1,xsize,ysize)
                      zmyx1=zmy1
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmyx1,xsize,ysize)
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(3),
     x                     dycoord(3),zmyx2,xsize,ysize)
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(4),
     x                     dycoord(4),zmyx2,xsize,ysize)
                      
                      call get_bondr1(nworld,isort-1,ir)
                      call get_bondg1(nworld,isort-1,ig)
                      call get_bondb1(nworld,isort-1,ib)
c     ir=bondrgb(isort,1)
c     ig=bondrgb(isort,2)
c     ib=bondrgb(isort,3)
                      if (iusefog.ne.0) then
c     nmyz=int(zmy1+zmy2)/2
                        nmyz=int((zmyx1+zmyx2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iforcetriangles.ne.1) then
                        icr=0
                        icg=0
                        icb=0
                        if (iusefog.ne.0) then
                          call fog(nmyz,icr,icg,icb,
     x                         xsize,ysize,xfoglevel,xfoglevel2)
                        endif
                        call fade(icr,icg,icb,ifade)
                        if (iprintps.ne.0) then
                          call psyp(dxcoord(1)+ixtrans,
     x                         dycoord(1),
     x                         dxcoord(2)+ixtrans,
     x                         dycoord(2),
     x                         dxcoord(3)+ixtrans,
     x                         dycoord(3),
     x                         dxcoord(4)+ixtrans,
     x                         dycoord(4),
     x                         dble(1),
     x                         icr,icg,icb)
                        endif
                        
                        
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                        
                        call poly(ixcoord,iycoord,4,icr,icg,icb)
                      else
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                      endif
                      call get_bondselected(nworld,isort-1,itmp)
                      if (itmp.ne.0) then
c     Add selected animation
                        call saal(ixcoord(4)+ixtranssel,iycoord(4),
     x                       ixcoord(1)+ixtranssel,iycoord(1))
                        call saal(ixcoord(1)+ixtranssel,iycoord(1),
     x                       ixcoord(2)+ixtranssel,iycoord(2))
                        call saal(ixcoord(2)+ixtranssel,iycoord(2),
     x                       ixcoord(3)+ixtranssel,iycoord(3))
                        call saal(ixcoord(3)+ixtranssel,iycoord(3),
     x                       ixcoord(4)+ixtranssel,iycoord(4))
                      endif
                    else
                      dx=xmy2-xmy1
                      dy=ymy2-ymy1
                      dx2=dx*dx
                      dy2=dy*dy
                      dlen=sqrt(dx2+dy2)
                      if (dx2.gt.dy2) then
                        ry=sqrt(dble(dx2)/(dble(dx2)+dble(dy2)))
                        rx=-(ry*dble(dy)/dble(dx))
                      else
                        rx=sqrt(dble(dy2)/(dble(dy2)+dble(dx2)))
                        ry=-(rx*dble(dx)/dble(dy))
                      endif
                      rlen=sqrt(rx*rx+ry*ry)
                      rx=rx/rlen
                      ry=ry/rlen
                      dinv=0.5d0*1.d0/dlen
                      dxcoord(1)=xmy1+rx*rmy1-dinv*dx*rmy1
                      dycoord(1)=ymy1+ry*rmy1-dinv*dy*rmy1
                      dxcoord(2)=xmy1-rx*rmy1-dinv*dx*rmy1
                      dycoord(2)=ymy1-ry*rmy1-dinv*dy*rmy1
                      dxcoord(3)=xmy2-rx*rmy2+dinv*dx*rmy2
                      dycoord(3)=ymy2-ry*rmy2+dinv*dy*rmy2
                      dxcoord(4)=xmy2+rx*rmy2+dinv*dx*rmy2
                      dycoord(4)=ymy2+ry*rmy2+dinv*dy*rmy2
c     Perspective:
                      zmyx1=zmy1
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmyx1,xsize,ysize)
                      zmyx1=zmy1
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmyx1,xsize,ysize)
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(3),
     x                     dycoord(3),zmyx2,xsize,ysize)
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(4),
     x                     dycoord(4),zmyx2,xsize,ysize)
                      
                      call get_bondr1(nworld,isort-1,ir)
                      call get_bondg1(nworld,isort-1,ig)
                      call get_bondb1(nworld,isort-1,ib)
c     ir=bondrgb(isort,1)
c     ig=bondrgb(isort,2)
c     ib=bondrgb(isort,3)
                      if (iusefog.ne.0) then
c     nmyz=int(zmy1+zmy2)/2
                        nmyz=int((zmyx1+zmyx2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iforcetriangles.ne.1) then
                        if (iprintps.ne.0) then
                          call psyfp(dxcoord(1)+ixtrans,
     x                         dycoord(1),
     x                         dxcoord(2)+ixtrans,
     x                         dycoord(2),
     x                         dxcoord(3)+ixtrans,
     x                         dycoord(3),
     x                         dxcoord(4)+ixtrans,
     x                         dycoord(4),
     x                         ir,ig,ib)
                        endif
                        
                        
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                        
                        call fpoly(ixcoord,iycoord,4,
     x                       ir,ig,ib)
                        
                        icr=0
                        icg=0
                        icb=0
                        if (iusefog.ne.0) then
                          call fog(nmyz,icr,icg,icb,
     x                         xsize,ysize,xfoglevel,xfoglevel2)
                        endif
                        call fade(icr,icg,icb,ifade)
                        if (iprintps.ne.0) then
                          call psyp(dxcoord(1)+ixtrans,
     x                         dycoord(1),
     x                         dxcoord(2)+ixtrans,
     x                         dycoord(2),
     x                         dxcoord(3)+ixtrans,
     x                         dycoord(3),
     x                         dxcoord(4)+ixtrans,
     x                         dycoord(4),
     x                         dble(1),
     x                         icr,icg,icb)
                        endif
                        
                        
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                        
                        call poly(ixcoord,iycoord,4,icr,icg,icb)
                      else
                        do idi=1,4
                          ixcoord(idi)=int(dxcoord(idi))+ixtrans
                          iycoord(idi)=int(dycoord(idi))
                        enddo
                      endif
                      call get_bondselected(nworld,isort-1,itmp)
                      if (itmp.ne.0) then
c     Add selected animation
                        call saal(ixcoord(4)+ixtranssel,iycoord(4),
     x                       ixcoord(1)+ixtranssel,iycoord(1))
                        call saal(ixcoord(1)+ixtranssel,iycoord(1),
     x                       ixcoord(2)+ixtranssel,iycoord(2))
                        call saal(ixcoord(2)+ixtranssel,iycoord(2),
     x                       ixcoord(3)+ixtranssel,iycoord(3))
                        call saal(ixcoord(3)+ixtranssel,iycoord(3),
     x                       ixcoord(4)+ixtranssel,iycoord(4))
                      endif
                    endif
                  endif
                endif
              endif
            else if (idrawstyle.eq.DRAW_STYLE_WIREFRAME) then

c     compute coordinates of line
              if ((xmy1.ne.xmy2).or.(ymy1.ne.ymy2)) then
c     Clipping:               
                if (iclip(int(zmy1),xsize,ysize).eq.0) then
                  if (iclip(int(zmy2),xsize,ysize).eq.0) then
                    if (inslice.eq.1) then
c     get color of first atom
                      call get_bond1(nworld,isort-1,iatom1)
                      call get_atomr(nworld,iatom1-1,ir)
                      call get_atomg(nworld,iatom1-1,ig)
                      call get_atomb(nworld,iatom1-1,ib)

                      dxcoord(1)=xmy1
                      dycoord(1)=ymy1
                      dxcoord(2)=xmy2
                      dycoord(2)=ymy2
c     Perspective:
                      
                      zmyx1=zmy1
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmyx1,xsize,ysize)
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmyx2,xsize,ysize)

                      dxcoord(2)=(dxcoord(1)+dxcoord(2))/2
                      dycoord(2)=(dycoord(1)+dycoord(2))/2
                      
                      if (iusefog.ne.0) then
c     nmyz=int(zmy1+zmy2)/2
                        nmyz=int((zmyx1+zmyx2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iprintps.ne.0) then
                        call psyl(dxcoord(1)+ixtrans,dycoord(1),
     x                       dxcoord(2)+ixtrans,dycoord(2),
     x                       dble(1),
     x                       ir,ig,ib)
                      endif
                      do idi=1,2
                        ixcoord(idi)=int(dxcoord(idi))+ixtrans
                        iycoord(idi)=int(dycoord(idi))
                      enddo
                      call line(ixcoord(1),iycoord(1),
     x                     ixcoord(2),iycoord(2),
     x                     ir,ig,ib)


c     get color of second atom
                      call get_bond2(nworld,isort-1,iatom1)
                      call get_atomr(nworld,iatom1-1,ir)
                      call get_atomg(nworld,iatom1-1,ig)
                      call get_atomb(nworld,iatom1-1,ib)

                      dxcoord(1)=xmy1
                      dycoord(1)=ymy1
                      dxcoord(2)=xmy2
                      dycoord(2)=ymy2
c     Perspective:
                      
                      zmyx1=zmy1
                      zmyx2=zmy2
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmyx1,xsize,ysize)
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmyx2,xsize,ysize)

                      dxcoord(1)=(dxcoord(1)+dxcoord(2))/2
                      dycoord(1)=(dycoord(1)+dycoord(2))/2
                      
                      if (iusefog.ne.0) then
c     nmyz=int(zmy1+zmy2)/2
                        nmyz=int((zmyx1+zmyx2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iprintps.ne.0) then
                        call psyl(dxcoord(1)+ixtrans,dycoord(1),
     x                       dxcoord(2)+ixtrans,dycoord(2),
     x                       dble(1),
     x                       ir,ig,ib)
                      endif
                      do idi=1,2
                        ixcoord(idi)=int(dxcoord(idi))+ixtrans
                        iycoord(idi)=int(dycoord(idi))
                      enddo
                      call line(ixcoord(1),iycoord(1),
     x                     ixcoord(2),iycoord(2),
     x                     ir,ig,ib)


c     selections etc

                      dxcoord(1)=xmy1
                      dycoord(1)=ymy1
                      dxcoord(2)=xmy2
                      dycoord(2)=ymy2
c     Perspective:
                      
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmy1,xsize,ysize)
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmy2,xsize,ysize)
                      
                      do idi=1,2
                        ixcoord(idi)=int(dxcoord(idi))+ixtrans
                        iycoord(idi)=int(dycoord(idi))
                      enddo
                      
                      call get_bondselected(nworld,isort-1,itmp)
                      if (itmp.ne.0) then
c     Add selected animation
                        call saal(ixcoord(1)+ixtranssel,iycoord(1),
     x                       ixcoord(2)+ixtranssel,iycoord(2))
                      endif
                    else
                      dxcoord(1)=xmy1
                      dycoord(1)=ymy1
                      dxcoord(2)=xmy2
                      dycoord(2)=ymy2
c     Perspective:
                      
                      call fperspectivef(dxcoord(1),
     x                     dycoord(1),zmy1,xsize,ysize)
                      call fperspectivef(dxcoord(2),
     x                     dycoord(2),zmy2,xsize,ysize)
                      
                      call get_bondr1(nworld,isort-1,ir)
                      call get_bondg1(nworld,isort-1,ig)
                      call get_bondb1(nworld,isort-1,ib)
                      if (iusefog.ne.0) then
c     nmyz=int(zmy1+zmy2)/2
                        nmyz=int((zmy1+zmy2)*0.5)
                        call fog(nmyz,ir,ig,ib,xsize,ysize,
     x                       xfoglevel,xfoglevel2)
                      endif
                      call fade(ir,ig,ib,ifade)
                      if (iprintps.ne.0) then
                        call psyl(dxcoord(1)+ixtrans,dycoord(1),
     x                       dxcoord(2)+ixtrans,dycoord(2),
     x                       dble(1),
     x                       ir,ig,ib)
                      endif
                      do idi=1,2
                        ixcoord(idi)=int(dxcoord(idi))+ixtrans
                        iycoord(idi)=int(dycoord(idi))
                      enddo
                      call line(ixcoord(1),iycoord(1),
     x                     ixcoord(2),iycoord(2),
     x                     ir,ig,ib)
                      
                      call get_bondselected(nworld,isort-1,itmp)
                      if (itmp.ne.0) then
c     Add selected animation
                        call saal(ixcoord(1)+ixtranssel,iycoord(1),
     x                       ixcoord(2)+ixtranssel,iycoord(2))
                      endif
                    endif
                  endif
                endif
              endif



            endif
 555        continue
            ibondcount=ibondcount+1
          endif
c     write(*,*) 'GOTO 10'
          goto 10
        endif

c     Draw measures
        call get_first_measure(nworld,itype,ip,ix,iy)
 2000   continue
        if (itype.ne.0) then
c     Compute true position
          ix=(ix*xsize)/65536
          iy=(iy*ysize)/65536
          if (itype.eq.1) then
c     Measure distance
            call get_atomxyz(nworld,ip(1)-1,
     x           x1,y1,z1)
            call get_atomxyz(nworld,ip(2)-1,
     x           x2,y2,z2)
            dist=sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1))
c     Compute atom com positions
            vector(1)=x1
            vector(2)=y1
            vector(3)=z1
            call multiply_vector(t_matrix,vector)            
            x1=vector(1)
            y1=vector(2)
            z1=vector(3)
            call get_atomrad(nworld,ip(1)-1,rmy)
            call get_atomscalerad(nworld,ip(1)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x1,y1,z1,rmy)
            vector(1)=x2
            vector(2)=y2
            vector(3)=z2
            call multiply_vector(t_matrix,vector)            
            x2=vector(1)
            y2=vector(2)
            z2=vector(3)
            call get_atomrad(nworld,ip(2)-1,rmy)
            call get_atomscalerad(nworld,ip(2)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x2,y2,z2,rmy)
            ixmy1=x1
            iymy1=y1
            izmy1=z1
            call fperspective(ixmy1,iymy1,izmy1,xsize,ysize)            
            ixmy2=x2
            iymy2=y2
            izmy2=z2
            call fperspective(ixmy2,iymy2,izmy2,xsize,ysize)            
            if (idrawstyle.ne.DRAW_STYLE_3D_SPHERES) then
              call gbkgrv(irb,igb,ibb)
              if ((irb+igb+ibb).gt.381) then
                ir=0
                ig=0
                ib=0
              else
                ir=255
                ig=255
                ib=255
              endif
              write(ctmp,'(f7.3)') dist
              if (iprintps.ne.0) then
                call psyl(dble(ix+ixtrans),dble(iy),
     x               dble(ixmy1+ixtrans),dble(iymy1),
     x               dble(1),
     x               ir,ig,ib)
                call psyl(dble(ix+ixtrans),dble(iy),
     x               dble(ixmy2+ixtrans),dble(iymy2),
     x               dble(1),
     x               ir,ig,ib)
                call psyits(dble(ix+ixtrans),dble(iy),
     x               dble(12),ctmp(1:8),ir,ig,ib,irb,igb,ibb)
              endif
              call line(ix+ixtrans,iy,
     x             ixmy1+ixtrans,iymy1,
     x             ir,ig,ib)
              call line(ix+ixtrans,iy,
     x             ixmy2+ixtrans,iymy2,
     x             ir,ig,ib)
c     One more length. Will convert to 7 + zero termination
              call ditxt(ix+ixtrans,iy,ctmp(1:8),
     x             ir,ig,ib,irb,igb,ibb,0,12)
            endif
          else if (itype.eq.2) then
c     Measure angle
            call get_atomxyz(nworld,ip(1)-1,
     x           x1,y1,z1)
            call get_atomxyz(nworld,ip(2)-1,
     x           x2,y2,z2)
            call get_atomxyz(nworld,ip(3)-1,
     x           x3,y3,z3)

            
            dista=sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1))
            distb=sqrt((x3-x1)*(x3-x1)+(y3-y1)*(y3-y1)+(z3-z1)*(z3-z1))
            distc=sqrt((x2-x3)*(x2-x3)+(y2-y3)*(y2-y3)+(z2-z3)*(z2-z3))
            twoac=2*dista*distc
            if (twoac.ne.0) then
              angle=acos(-(distb*distb-dista*dista-distc*distc)/twoac)*
     x             180/3.1415926
            else
              angle=0.d0
            endif
c     Compute atom com positions
            vector(1)=x1
            vector(2)=y1
            vector(3)=z1
            call multiply_vector(t_matrix,vector)
            x1=vector(1)
            y1=vector(2)
            z1=vector(3)
            call get_atomrad(nworld,ip(1)-1,rmy)
            call get_atomscalerad(nworld,ip(1)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x1,y1,z1,rmy)
            vector(1)=x2
            vector(2)=y2
            vector(3)=z2
            call multiply_vector(t_matrix,vector)            
            x2=vector(1)
            y2=vector(2)
            z2=vector(3)
            call get_atomrad(nworld,ip(2)-1,rmy)
            call get_atomscalerad(nworld,ip(2)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x2,y2,z2,rmy)
            vector(1)=x3
            vector(2)=y3
            vector(3)=z3
            call multiply_vector(t_matrix,vector)            
            x3=vector(1)
            y3=vector(2)
            z3=vector(3)
            call get_atomrad(nworld,ip(3)-1,rmy)
            call get_atomscalerad(nworld,ip(3)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x3,y3,z3,rmy)
            ixmy1=x1
            iymy1=y1
            izmy1=z1
            call fperspective(ixmy1,iymy1,izmy1,xsize,ysize)            
            ixmy2=x2
            iymy2=y2
            izmy2=z2
            call fperspective(ixmy2,iymy2,izmy2,xsize,ysize)            
            ixmy3=x3
            iymy3=y3
            izmy3=z3
            call fperspective(ixmy3,iymy3,izmy3,xsize,ysize)            
            if (idrawstyle.ne.DRAW_STYLE_3D_SPHERES) then
              call gbkgrv(irb,igb,ibb)
              if ((irb+igb+ibb).gt.381) then
                ir=0
                ig=0
                ib=0
              else
                ir=255
                ig=255
                ib=255
              endif
              write(ctmp,'(f7.3)') angle
              if (iprintps.ne.0) then
                call psyl(dble(ix+ixtrans),dble(iy),
     x               dble(ixmy1+ixtrans),dble(iymy1),
     x               dble(1),
     x               ir,ig,ib)
                call psyl(dble(ix+ixtrans),dble(iy),
     x               dble(ixmy3+ixtrans),dble(iymy3),
     x               dble(1),
     x               ir,ig,ib)
                call psyl(dble(ixmy1+ixtrans),dble(iymy1),
     x               dble(ixmy2+ixtrans),dble(iymy2),
     x               dble(1),
     x               ir,ig,ib)
                call psyl(dble(ixmy2+ixtrans),dble(iymy2),
     x               dble(ixmy3+ixtrans),dble(iymy3),
     x               dble(1),
     x               ir,ig,ib)
                call psyits(dble(ix+ixtrans),dble(iy),
     x               dble(12),ctmp(1:8),ir,ig,ib,irb,igb,ibb)
              endif
              call line(ix+ixtrans,iy,
     x             ixmy1+ixtrans,iymy1,
     x             ir,ig,ib)
              call line(ix+ixtrans,iy,
     x             ixmy3+ixtrans,iymy3,
     x             ir,ig,ib)
              call line(ixmy1+ixtrans,iymy1,
     x             ixmy2+ixtrans,iymy2,
     x             ir,ig,ib)
              call line(ixmy2+ixtrans,iymy2,
     x             ixmy3+ixtrans,iymy3,
     x             ir,ig,ib)
c     One more length. Will convert to 7 + zero termination
              call ditxt(ix+ixtrans,iy,ctmp(1:8),
     x             ir,ig,ib,irb,igb,ibb,0,12)
            endif
          else if (itype.eq.3) then
c     Measure dihedral
            call get_atomxyz(nworld,ip(1)-1,
     x           x1,y1,z1)
            call get_atomxyz(nworld,ip(2)-1,
     x           x2,y2,z2)
            call get_atomxyz(nworld,ip(3)-1,
     x           x3,y3,z3)
            call get_atomxyz(nworld,ip(4)-1,
     x           x4,y4,z4)

            call torsionangle(x1,y1,z1,
     x           x2,y2,z2,
     x           x3,y3,z3,
     x           x4,y4,z4,
     x           angle)

            angle=angle*180.d0/3.1415926

c     Compute atom com positions
            vector(1)=x1
            vector(2)=y1
            vector(3)=z1
            call multiply_vector(t_matrix,vector)
            x1=vector(1)
            y1=vector(2)
            z1=vector(3)
            call get_atomrad(nworld,ip(1)-1,rmy)
            call get_atomscalerad(nworld,ip(1)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x1,y1,z1,rmy)
            call fperspectivef(x1,y1,z1,xsize,ysize)

            vector(1)=x2
            vector(2)=y2
            vector(3)=z2
            call multiply_vector(t_matrix,vector)            
            x2=vector(1)
            y2=vector(2)
            z2=vector(3)
            call get_atomrad(nworld,ip(2)-1,rmy)
            call get_atomscalerad(nworld,ip(2)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x2,y2,z2,rmy)
            call fperspectivef(x2,y2,z2,xsize,ysize)

            vector(1)=x3
            vector(2)=y3
            vector(3)=z3
            call multiply_vector(t_matrix,vector)            
            x3=vector(1)
            y3=vector(2)
            z3=vector(3)
            call get_atomrad(nworld,ip(3)-1,rmy)
            call get_atomscalerad(nworld,ip(3)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x3,y3,z3,rmy)
            call fperspectivef(x3,y3,z3,xsize,ysize)

            vector(1)=x4
            vector(2)=y4
            vector(3)=z4
            call multiply_vector(t_matrix,vector)            
            x4=vector(1)
            y4=vector(2)
            z4=vector(3)
            call get_atomrad(nworld,ip(4)-1,rmy)
            call get_atomscalerad(nworld,ip(4)-1,rmyscale)
            rmy=rmy*rmyscale
            call coord_convert(x4,y4,z4,rmy)
            call fperspectivef(x4,y4,z4,xsize,ysize)

            if (idrawstyle.ne.DRAW_STYLE_3D_SPHERES) then
              call gbkgrv(irb,igb,ibb)
              if ((irb+igb+ibb).gt.381) then
                ir=0
                ig=0
                ib=0
              else
                ir=255
                ig=255
                ib=255
              endif
              write(ctmp,'(f8.3)') angle
              if (iprintps.ne.0) then
                call psyl(dble(ix+ixtrans),dble(iy),
     x               x1+ixtrans,y1,
     x               dble(1),
     x               ir,ig,ib)
                call psyl(dble(ix+ixtrans),dble(iy),
     x               x4+ixtrans,y4,
     x               dble(1),
     x               ir,ig,ib)
                call psyl(x1+ixtrans,y1,
     x               x2+ixtrans,y2,
     x               dble(1),
     x               ir,ig,ib)
                call psyl(x2+ixtrans,y2,
     x               x3+ixtrans,y3,
     x               dble(1),
     x               ir,ig,ib)
                call psyl(x3+ixtrans,y3,
     x               x4+ixtrans,y4,
     x               dble(1),
     x               ir,ig,ib)
                call psyits(dble(ix+ixtrans),dble(iy),
     x               dble(12),ctmp(1:8),ir,ig,ib,irb,igb,ibb)
              endif
              call line(ix+ixtrans,iy,
     x             int(x1+ixtrans),int(y1),
     x             ir,ig,ib)
              call line(ix+ixtrans,iy,
     x             int(x4+ixtrans),int(y4),
     x             ir,ig,ib)
              call line(int(x1+ixtrans),int(y1),
     x             int(x2+ixtrans),int(y2),
     x             ir,ig,ib)
              call line(int(x2+ixtrans),int(y2),
     x             int(x3+ixtrans),int(y3),
     x             ir,ig,ib)
              call line(int(x3+ixtrans),int(y3),
     x             int(x4+ixtrans),int(y4),
     x             ir,ig,ib)
c     One more length. Will convert to 7 + zero termination
              call ditxt(ix+ixtrans,iy,ctmp(1:8),
     x             ir,ig,ib,irb,igb,ibb,0,12)
            endif

          endif
          call get_next_measure(nworld,itype,ip,ix,iy)
          goto 2000
        endif

c     Frametext:
        call get_hasframetext(nworld,iftext)
        if (iftext.ne.0) then
          call get_frametextxy(nworld,xmy,ymy)
          ix=nint(xmy*xsize)
          iy=nint(ymy*ysize)
          call get_frametext(nworld,frametext)
          call gbkgrv(irb,igb,ibb)
          if ((irb+igb+ibb).gt.381) then
            ir=0
            ig=0
            ib=0
          else
            ir=255
            ig=255
            ib=255
          endif
          call get_frametext_size(frametext,
     x         dble(xsize),dble(ysize),tsize)
          if (idrawstyle.ne.DRAW_STYLE_3D_SPHERES) then
            if (iprintps.ne.0) then
              call psyits(dble(ix+ixtrans),dble(iy),
     x             tsize,frametext(1:MAXCHARSINFRAMETEXT),
     x             ir,ig,ib,irb,igb,ibb)
            endif
            call ditxt(ix+ixtrans,iy,frametext(1:MAXCHARSINFRAMETEXT),
     x           ir,ig,ib,irb,igb,ibb,0,int(tsize))
          else
            call dtxt3d(framebuffer,zbuffer,xsize,ysize,
     x           ix+ixtrans,
     x           iy,
     x           2147483647,
     x           frametext(1:MAXCHARSINFRAMETEXT),
     x           irb,igb,ibb,
     x           ir,ig,ib,0,
     x           int(tsize),
     x           ybankstart,ybankend)
          endif
        endif
        
        if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
          call tdraw(framebuffer,zbuffer,xsize,ysize,ybankstart,
     x         ybankend)
#ifdef USEOPENGL
          if (iuseopengl.eq.0) then
#endif
            call doaa(ybankstart,ybankend,istereo,nstereo)
#ifdef USEOPENGL
          endif
#endif
          if (istereo.eq.1) then
            ifirstdeclare=1
          endif
        endif

C     End of stereo image. Reverse operations...
        if (nstereo.eq.1) then 
           if (iprintps.eq.1) then
              call psgres
           endif
C     Back translate
          call init_stereo_matrix(stereo_matrix)
          stereo_matrix(4,1)=-(istereo*2-1)*stereotranslate
          call multiply_molbuffer(stereo_matrix)

C     Back rotate
          call init_stereo_matrix(stereo_matrix)
          stereo_matrix(1,1)=cos(-(istereo*2-1)*stereoangle)
          stereo_matrix(1,3)=-sin(-(istereo*2-1)*stereoangle)
          stereo_matrix(3,1)=sin(-(istereo*2-1)*stereoangle)
          stereo_matrix(3,3)=cos(-(istereo*2-1)*stereoangle)
          call multiply_molbuffer(stereo_matrix)
C     Copy the stereo buffer
          call stecpy
        endif
      enddo


      ybankstart=ybankstart+ybanksize
      if (ybankstart.lt.ysize) goto 100
      call vmint(0)
      return
      end

      subroutine pssave(xsize,ysize)
      implicit double precision (a-h,o-z)
      integer xsize,ysize
      integer dummy1(10),dummy2(10)
#include "psflag.commonblock"
      call pshead
      call dsget(idrawstyle)
      if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
         call psimg
      else
         iprintps=1
         call draw_molbuffer(dummy1,dummy2,xsize,ysize)
         iprintps=0
      endif
      call psfoot
      return
      end

      subroutine flook(ix,iy,xsize,ysize,itype,iobject)
      implicit double precision (a-h,o-z)
      integer ix,iy,xsize,ysize
      dimension ixcoord(4),iycoord(4)
#include "stereo.commonblock"
#include "world.commonblock"
#include "transformationmatrix.commonblock"
      dimension vector(3)
      integer atoms,bonds,nframes
      dimension stereo_matrix(4,4)
      dimension my_matrix(4,4)
      double precision my_matrix

      do i=1,4
        do j=1,4
          my_matrix(j,i)=t_matrix(j,i)
        enddo
      enddo

      ixtrans=0
      if (nstereo.eq.1) then
        call dsget(i)
        if (i.ne.DRAW_STYLE_3D_SPHERES) then
          xsize=xsize/2
        endif
      endif
c     write(*,*) 'sizes are ',xsize,ysize
c     search for atom/bond to be selected
      itype=-1
      call getany(isany)
      if (isany.ne.0) then
        call dsget(i)
        if (i.eq.DRAW_STYLE_3D_SPHERES) then
          call gtdsty(i)
          if (i.eq.2) isany=0
        endif
      endif
      if (isany.ne.0) then
        
        call get_nframes(nframes)
        nworld=nframes+1
        call get_frame_is_initialized(nworld,no)
        if (no.eq.1) then
c     write(*,*) 'Ok there is a world!'
c     call fflush
          call get_atoms(nworld,atoms)
          call get_bonds(nworld,bonds)
c     write(*,*) 'Claims to be ',atoms,' atoms and ',bonds, 'bonds'
          iselectedatom=-1
          iselectednumber=0
          do istereo=0,nstereo
            
            if (nstereo.eq.1) then
C     Now create new modified matrix for stereo image istereo
              do i=1,4
                do j=1,4
                  my_matrix(j,i)=t_matrix(j,i)
                enddo
              enddo
C     Rotate
              call init_stereo_matrix(stereo_matrix)
              stereo_matrix(1,1)=cos((istereo*2-1)*stereoangle)
              stereo_matrix(1,3)=-sin((istereo*2-1)*stereoangle)
              stereo_matrix(3,1)=sin((istereo*2-1)*stereoangle)
              stereo_matrix(3,3)=cos((istereo*2-1)*stereoangle)
              call multiply_local_matrix(stereo_matrix,my_matrix)
C     Translate
              call init_stereo_matrix(stereo_matrix)
              stereo_matrix(4,1)=(istereo*2-1)*stereotranslate
              call multiply_local_matrix(stereo_matrix,my_matrix)
              
              if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
                ixtrans=((istereo*2-1)*xsize/4)
              else
                ixtrans=istereo*xsize
              endif
            endif

            iatomcount=1
            ibondcount=1
            istop=0
 10         continue
            if ((atoms.gt.0).and.(iatomcount.le.atoms))
     x           call get_atomsort(nworld,iatomcount-1,iatomsort)
            if ((bonds.gt.0).and.(ibondcount.le.bonds))
     x           call get_bondsort(nworld,ibondcount-1,ibondsort)
            if ((iatomcount.le.atoms).and.(ibondcount.le.bonds)) then
              call get_atomxyz(nworld,iatomsort-1,xt,yt,az)
              call get_bondcompare(nworld,ibondsort-1,bz)
              
c     az=atomz(atomsort(iatomcount))
c     bz=(bondz(bondsort(ibondcount),1)+
c     x        bondz(bondsort(ibondcount),2))/2

              if (az.lt.bz) then
                idrawatom=1
              else
                idrawatom=0
              endif
            else if (iatomcount.le.atoms) then
              idrawatom=1
            else if (ibondcount.le.bonds) then
              idrawatom=0
            else
              istop=1
            endif
            if (istop.eq.0) then
              if (idrawatom.eq.1) then
                isort=iatomsort

                call get_atomxyz(nworld,isort-1,
     x               vector(1),
     x               vector(2),
     x               vector(3))
                call multiply_vector(my_matrix,vector)
                xmy=vector(1)
                ymy=vector(2)
                zmy=vector(3)
                call get_atomrad(nworld,isort-1,rmy)
                call get_atomscalerad(nworld,isort-1,rmyscale)
                rmy=rmy*rmyscale
                call coord_convert(xmy,ymy,zmy,rmy)
                ixmy1=int(xmy-rmy)
                iymy1=int(ymy-rmy)
                izmy1=int(zmy)
                ixmy2=int(xmy+rmy)
                iymy2=int(ymy+rmy)
                izmy2=int(zmy)
                call fperspective(ixmy1,iymy1,izmy1,xsize,ysize)
                call fperspective(ixmy2,iymy2,izmy2,xsize,ysize)
                ixmy=(ixmy1+ixmy2)/2
                iymy=(iymy1+iymy2)/2
                irmy=(ixmy2-ixmy1)/2
                idx=ixmy-ix+ixtrans
                idy=iymy-iy
                id=idx*idx+idy*idy
c                write (*,*) 'Mouse at ',ix,
c     x               ' Testing atom at ',ixmy,' id=',id,
c     x               ' irmy=',irmy
                if (id.lt.irmy*irmy) then
                  iselectedatom=1
                  iselectednumber=isort
                endif
                iatomcount=iatomcount+1
              else
                isort=ibondsort
                call get_bond1xyz(nworld,isort-1,
     x               vector(1),
     x               vector(2),
     x               vector(3))
                call multiply_vector(my_matrix,vector)
                xmy1=vector(1)
                ymy1=vector(2)
                zmy1=vector(3)
                call get_bond2xyz(nworld,isort-1,
     x               vector(1),
     x               vector(2),
     x               vector(3))
                call multiply_vector(my_matrix,vector)
                xmy2=vector(1)
                ymy2=vector(2)
                zmy2=vector(3)
                call get_bondrad1(nworld,isort-1,rmy1)
                rmy2=rmy1
                call coord_convert(xmy1,ymy1,zmy1,rmy1)         
                call coord_convert(xmy2,ymy2,zmy2,rmy2)
c     Fast fix but not completely correct:
                ixmy1=int(xmy1)
                iymy1=int(ymy1)
                izmy1=int(zmy1)
                ixmy2=int(xmy2)
                iymy2=int(ymy2)
                izmy2=int(zmy2)
                call fperspective(ixmy1,iymy1,izmy1,xsize,ysize)
                call fperspective(ixmy2,iymy2,izmy2,xsize,ysize)
                xmy1=dble(ixmy1)
                ymy1=dble(iymy1)
                zmy1=dble(izmy1)
                xmy2=dble(ixmy2)
                ymy2=dble(iymy2)
                zmy2=dble(izmy2)


c     compute coordinates of polygon
                if ((xmy1.ne.xmy2).or.(ymy1.ne.ymy2)) then
                  dx=xmy2-xmy1
                  dy=ymy2-ymy1
                  dx2=dx*dx
                  dy2=dy*dy
                  dlen=sqrt(dx2+dy2)
                  if (dx2.gt.dy2) then
                    ry=sqrt(dble(dx2)/(dble(dx2)+dble(dy2)))
                    rx=-(ry*dble(dy)/dble(dx))
                  else
                    rx=sqrt(dble(dy2)/(dble(dy2)+dble(dx2)))
                    ry=-(rx*dble(dx)/dble(dy))
                  endif
                  rlen=sqrt(rx*rx+ry*ry)
                  rx=rx/rlen
                  ry=ry/rlen
                  dinv=0.5d0*1.d0/dlen
                  ixcoord(1)=int(xmy1+rx*rmy1-dinv*dx*rmy1)
                  iycoord(1)=int(ymy1+ry*rmy1-dinv*dy*rmy1)
                  ixcoord(2)=int(xmy1-rx*rmy1-dinv*dx*rmy1)
                  iycoord(2)=int(ymy1-ry*rmy1-dinv*dy*rmy1)
                  ixcoord(3)=int(xmy2-rx*rmy2+dinv*dx*rmy2)
                  iycoord(3)=int(ymy2-ry*rmy2+dinv*dy*rmy2)
                  ixcoord(4)=int(xmy2+rx*rmy2+dinv*dx*rmy2)
                  iycoord(4)=int(ymy2+ry*rmy2+dinv*dy*rmy2)

c     quite simple but cpu time consuming code. better ways??
c     split into two triangles:
                  ixtest1=ix-ixcoord(1)-ixtrans
                  iytest1=iy-iycoord(1)
                  ix11=ixcoord(2)-ixcoord(1)
                  iy11=iycoord(2)-iycoord(1)
                  ix12=ixcoord(3)-ixcoord(1)
                  iy12=iycoord(3)-iycoord(1)
                  ixtest2=ix-ixcoord(4)-ixtrans
                  iytest2=iy-iycoord(4)
                  ix21=ixcoord(1)-ixcoord(4)
                  iy21=iycoord(1)-iycoord(4)
                  ix22=ixcoord(3)-ixcoord(4)
                  iy22=iycoord(3)-iycoord(4)
c     compute new coordinates for triangle 1
                  tdiv1=dble(ix11)*dble(iy12)-dble(ix12)*dble(iy11)
                  tdiv2=-tdiv1
                  t1=dble(ixtest1)*dble(iy12)
     x                 -dble(ix12)*dble(iytest1)
                  t1=t1/tdiv1
                  t2=dble(ixtest1)*dble(iy11)
     x                 -dble(ix11)*dble(iytest1)
                  t2=t2/tdiv2
c     write(*,*) 
c     x              'triangle1: ix,iy,ix11,iy11,ix12,iy12,t1,t2:',
c     x              ixtest1,iytest1,ix11,iy11,ix12,iy12,t1,t2
                  if ((t1.ge.0.d0).and.(t1.le.1.d0).and.
     x                 (t2.ge.0.d0).and.(t2.le.1.d0)) goto 100
c     compute new coordinates for triangle 2
                  tdiv1=dble(ix21)*dble(iy22)
     x                 -dble(ix22)*dble(iy21)
                  tdiv2=-tdiv1
                  t1=dble(ixtest2)*dble(iy22)
     x                 -dble(ix22)*dble(iytest2)
                  t1=t1/tdiv1
                  t2=dble(ixtest2)*dble(iy21)
     x                 -dble(ix21)*dble(iytest2)
                  t2=t2/tdiv2
c     write(*,*) 
c     x              'triangle2: ix,iy,ix21,iy21,ix22,iy22,t1,t2:',
c     x              ixtest2,iytest2,ix21,iy21,ix22,iy22,t1,t2
                  if ((t1.ge.0.d0).and.(t1.le.1.d0).and.
     x                 (t2.ge.0.d0).and.(t2.le.1.d0)) goto 100
c     do not select this bond
                  goto 200
 100              continue
c     select this bond
                  iselectedatom=0
                  iselectednumber=isort
 200              continue
                endif
                ibondcount=ibondcount+1
              endif
              goto 10
            endif
          enddo

          itype=iselectedatom
        else
c     write(*,*) 'Whoops. No world is built!'
c     call fflush
          itype=-1
        endif

c     if (itype.eq.1) then
c     iobject=atomid(iselectednumber)
c     else
        iobject=iselectednumber
c     endif
      endif

      return
      end


      subroutine aid(i,atid)
      implicit double precision (a-h,o-z)
      integer i,atid
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomid(nworld,i-1,atid)
      return
      end

      subroutine bnrs(i,bondatomnr1,bondatomnr2)
      implicit double precision (a-h,o-z)
      integer i,bondatomnr1,bondatomnr2
      call get_nframes(nframes)
      nworld=nframes+1
      call get_bond1(nworld,i-1,bondatomnr1)
      call get_bond2(nworld,i-1,bondatomnr2)
      return
      end

      subroutine qasel(i,selected)
      implicit double precision (a-h,o-z)
      integer i,selected
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomselected(nworld,i-1,selected)
      return
      end

      subroutine qaid(i,selected)
      implicit double precision (a-h,o-z)
      integer i,selected
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomid(nworld,i-1,selected)
      return
      end

      subroutine qan(i,selected)
      implicit double precision (a-h,o-z)
      integer i,selected
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomn(nworld,i-1,selected)
      return
      end

      subroutine qaxyz(i,x,y,z)
      implicit double precision (a-h,o-z)
      integer i
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomxyz(nworld,i-1,x,y,z)
      return
      end

      subroutine qsfill(i,sfill)
      implicit double precision (a-h,o-z)
      integer i,sfill
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomdrawstyle(nworld,i-1,sfill)
      return
      end

      subroutine qbsel(i,selected)
      implicit double precision (a-h,o-z)
      integer i,selected
      call get_nframes(nframes)
      nworld=nframes+1
      call get_bondselected(nworld,i-1,selected)
      return
      end

      subroutine qna(na)
      implicit double precision (a-h,o-z)
      integer na
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atoms(nworld,na)
      return
      end

      subroutine qnb(nb)
      implicit double precision (a-h,o-z)
      integer nb
      call get_nframes(nframes)
      nworld=nframes+1
      call get_bonds(nworld,nb)
      return
      end

      function qargb(na)
      implicit double precision (a-h,o-z)
      integer qargb,na
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atomr(nworld,na-1,ir)
      call get_atomg(nworld,na-1,ig)
      call get_atomb(nworld,na-1,ib)
      qargb=ir+ig*256+ib*65536
      return
      end

      function qbrgb(nb)
      implicit double precision (a-h,o-z)
      integer qbrgb,nb
      call get_nframes(nframes)
      nworld=nframes+1
      call get_bondr1(nworld,nb-1,ir)
      call get_bondg1(nworld,nb-1,ig)
      call get_bondb1(nworld,nb-1,ib)
      qbrgb=ir+ig*256+ib*65536
      return
      end

      function qbrad(nb)
      implicit double precision (a-h,o-z)
      integer nb
      double precision qbrad
      call get_nframes(nframes)
      nworld=nframes+1
      call get_bondrad1(nworld,nb-1,qbrad)
      return
      end

      function qbrns(nb)
      implicit double precision (a-h,o-z)
      integer nb
      integer qbrns
      call get_nframes(nframes)
      nworld=nframes+1
      call get_bondnslice(nworld,nb-1,qbrns)
      return
      end

      subroutine fsel(ix,iy,xsize,ysize)
      implicit double precision (a-h,o-z)
      integer ix,iy,xsize,ysize,xsizecp
      call get_nframes(nframes)
      nworld=nframes+1
      xsizecp=xsize
      call flook(ix,iy,xsizecp,ysize,iselectedatom,iselectednumber)
      if (iselectedatom.eq.-1) then
c         write(*,*) 'Nothing selected'
      else
         if (iselectedatom.eq.1) then
c     atom
            call get_atomselected(nworld,iselectednumber-1,i)
            call set_atomselected(nworld,iselectednumber-1,1-i)
            call get_atomid(nworld,iselectednumber-1,isel)
            if (i.eq.0) then
               call add_to_selectorder(isel)
            else
               call remove_from_selectorder(isel)
            endif
         else
c     bond
            call get_bondselected(nworld,iselectednumber-1,i)
            call set_bondselected(nworld,iselectednumber-1,1-i)
         endif
         call fupd
      endif

      return
      end

      subroutine unsel
      implicit double precision (a-h,o-z)
      integer atoms,bonds
      call getany(isany)
      if (isany.ne.0) then
         call get_nframes(nframes)
         nworld=nframes+1
         call get_atoms(nworld,atoms)
         call get_bonds(nworld,bonds)
         do i=1,atoms
            call set_atomselected(nworld,i-1,0)
         enddo
         do i=1,bonds
            call set_bondselected(nworld,i-1,0)
         enddo
         call fupd
      endif
      return
      end


      subroutine allsel
      implicit double precision (a-h,o-z)
      integer atoms,bonds
      call getany(isany)
      if (isany.ne.0) then
         call get_nframes(nframes)
         nworld=nframes+1
         call get_atoms(nworld,atoms)
         call get_bonds(nworld,bonds)
         do i=1,atoms
            call set_atomselected(nworld,i-1,1)
         enddo
         do i=1,bonds
            call set_bondselected(nworld,i-1,1)
         enddo
         call fupd
      endif
      return
      end

      subroutine invsel
      implicit double precision (a-h,o-z)
      integer atoms,bonds
      call getany(isany)
      if (isany.ne.0) then
        call clear_selectorder
        call get_nframes(nframes)
        nworld=nframes+1
        call get_atoms(nworld,atoms)
        call get_bonds(nworld,bonds)
        do i=1,atoms
          call get_atomselected(nworld,i-1,j)
          if (j.ne.0) then
            j=0
          else
            j=1
            call get_atomid(nworld,i-1,isel)
            call add_to_selectorder(isel)
          endif
          call set_atomselected(nworld,i-1,j)
        enddo
        do i=1,bonds
          call get_bondselected(nworld,i-1,j)
          if (j.ne.0) then
            j=0
          else
            j=1
          endif
          call set_bondselected(nworld,i-1,j)
        enddo
        call fupd
      endif
      return
      end

      subroutine multiply_molbuffer(matrix)
      implicit double precision (a-h,o-z)
      double precision matrix(4,4)
      double precision vector(3)
      integer atoms,bonds,triangles
      call get_nframes(nframes)
      nworld=nframes+1
      call get_atoms(nworld,atoms)
      call get_bonds(nworld,bonds)
      call get_triangles(nworld,triangles)
      do i=1,atoms
         call get_atomxyz(nworld,i-1,vector(1),vector(2),vector(3))
         call multiply_vector(matrix,vector)
         call set_atomxyz(nworld,i-1,vector(1),vector(2),vector(3))
      enddo
      do i=1,triangles
         call get_triangle(nworld,i-1,
     x        tx1,ty1,tz1,tnx1,tny1,tnz1,
     x        tfr1,opaq1,nr1,ng1,nb1,nn1,ntwo1)
         tnx1=tnx1+tx1
         tny1=tny1+ty1
         tnz1=tnz1+tz1
         vector(1)=tx1
         vector(2)=ty1
         vector(3)=tz1
         call multiply_vector(matrix,vector)
         tx1=vector(1)
         ty1=vector(2)
         tz1=vector(3)
         vector(1)=tnx1
         vector(2)=tny1
         vector(3)=tnz1
         call multiply_vector(matrix,vector)
         tnx1=vector(1)-tx1
         tny1=vector(2)-ty1
         tnz1=vector(3)-tz1
         call set_triangle(nworld,i-1,
     x        tx1,ty1,tz1,tnx1,tny1,tnz1,
     x        tfr1,opaq1,nr1,ng1,nb1,nn1,ntwo1)
      enddo
      do i=1,bonds
         call get_bond1xyz(nworld,i-1,vector(1),vector(2),vector(3))
         call multiply_vector(matrix,vector)
         call set_bond1xyz(nworld,i-1,vector(1),vector(2),vector(3))
         call get_bond2xyz(nworld,i-1,vector(1),vector(2),vector(3))
         call multiply_vector(matrix,vector)
         call set_bond2xyz(nworld,i-1,vector(1),vector(2),vector(3))
      enddo
      return
      end

      subroutine transform_molbuffer
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
      double precision my_matrix(4,4)
c     Just cannot imagine how this could work!!
c      do i=1,4
c         do j=1,4
c            my_matrix(j,i)=r_matrix(j,i)
c         enddo
c      enddo
c      call multiply_local_matrix(t_matrix,my_matrix)
c      call multiply_molbuffer(my_matrix)
      call multiply_molbuffer(r_matrix)
      return
      end


      subroutine init_atomlabels
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      do i=1,200
         call galbl(i,default_atom_text(i))
      enddo
      return
      end

      subroutine write_transformation_matrix
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
#include "world.commonblock"
      write (*,*) 'Current mass_x,mass_y,mass_z:'
      write (*,*) mass_x,mass_y,mass_z
      write (*,*) 'Current r_matrix:'
      do i=1,4
        write (*,*) (r_matrix(j,i),j=1,4)
      enddo
      write (*,*) 'Current t_matrix:'
      do i=1,4
        write (*,*) (t_matrix(j,i),j=1,4)
      enddo
      return
      end

      subroutine psave(filename, cshift)
      implicit double precision (a-h,o-z)
      character*(*) filename

#include "world.commonblock"
#include "coordinates.commonblock"
#include "phong.commonblock"
      dimension ixcoord(4),iycoord(4)
      dimension irgb(3)
      dimension irgb2(3)
      integer draw_label,ybankstart,ybankend,ybanksize,triangles
      character*FMAXCHARSPERLABEL lbl
      character*FMAXCHARSINFRAMETEXT frametext

      call write_transformation_matrix

      call get_nframes(nframes)
      nworld=nframes+1

      call get_atoms(nworld,natoms)
      call get_bonds(nworld,nbonds)
      call get_triangles(nworld,triangles)

      do ipass=0,1
         call povini(filename,ipass,xcoord,ycoord,zcoord,cshift)
         call dlqry(draw_label)
         do isort=1,natoms
            call get_atomnr(nworld,isort-1,inr)
            if (inr.ne.256) then
               call get_atomxyz(nworld,isort-1,xmy,ymy,zmy)
               call get_atomrad(nworld,isort-1,rmy)
               call get_atomscalerad(nworld,isort-1,rmyscale)
               rmy=rmy*rmyscale
               call get_atomr(nworld,isort-1,ir)
               call get_atomg(nworld,isort-1,ig)
               call get_atomb(nworld,isort-1,ib)
               call povwa(xmy,ymy,zmy,rmy,ir,ig,ib)
               if (draw_label.ne.0) then
                  call get_atomlabel(nworld,isort-1,lbl)
                  call povwt(xmy,ymy,zmy,rmy,255,255,255,lbl)
               endif
            endif
         enddo
         do isort=1,nbonds
            call get_bondnslice(nworld,isort-1,inslice)
            call get_bond1xyz(nworld,isort-1,x1,y1,z1)
            call get_bond2xyz(nworld,isort-1,x2,y2,z2)
            call get_bondrad1(nworld,isort-1,rad)
            if (inslice.eq.1) then
              call get_bond1(nworld,isort-1,iatom1)
              call get_bond2(nworld,isort-1,iatom2)
              call get_atomrad(nworld,iatom1-1,xrad1)
              call get_atomscalerad(nworld,iatom1-1,rmyscale)
              xrad1=xrad1*rmyscale
              call get_atomrad(nworld,iatom2-1,xrad2)
              call get_atomscalerad(nworld,iatom2-1,rmyscale)
              xrad2=xrad2*rmyscale
              rbondlen=sqrt((x2-x1)**2+
     x             (y2-y1)**2+(z2-z1)**2)
              apos=0.5d0*(rbondlen-xrad1-xrad2)
              x3=((xrad1+apos)*x2+(xrad2+apos)*x1)/rbondlen
              y3=((xrad1+apos)*y2+(xrad2+apos)*y1)/rbondlen
              z3=((xrad1+apos)*z2+(xrad2+apos)*z1)/rbondlen
              call get_atomr(nworld,iatom1-1,ir)
              call get_atomg(nworld,iatom1-1,ig)
              call get_atomb(nworld,iatom1-1,ib)
              call povwb(x1,y1,z1,x3,y3,z3,rad,ir,ig,ib)
              call get_atomr(nworld,iatom2-1,ir)
              call get_atomg(nworld,iatom2-1,ig)
              call get_atomb(nworld,iatom2-1,ib)
              call povwb(x3,y3,z3,x2,y2,z2,rad,ir,ig,ib)
            else
              call get_bondr1(nworld,isort-1,ir)
              call get_bondg1(nworld,isort-1,ig)
              call get_bondb1(nworld,isort-1,ib)
              call povwb(x1,y1,z1,x2,y2,z2,rad,ir,ig,ib)
            endif
         enddo
         do isort=1,triangles/3
           itri=1+(isort-1)*3
           call get_triangle(nworld,itri-1,
     x          tx1,ty1,tz1,tnx1,tny1,tnz1,
     x          tfr1,opaq1,nr1,ng1,nb1,nn1,ntwo1)
           call get_triangle(nworld,itri,
     x          tx2,ty2,tz2,tnx2,tny2,tnz2,
     x          tfr2,opaq2,nr2,ng2,nb2,nn2,ntwo2)
           call get_triangle(nworld,itri+1,
     x          tx3,ty3,tz3,tnx3,tny3,tnz3,
     x          tfr3,opaq3,nr3,ng3,nb3,nn3,ntwo3)
           call povwtr(tx1,ty1,tz1,
     x          tx2,ty2,tz2,
     x          tx3,ty3,tz3,
     x          tnx1,tny1,tnz1,
     x          tnx2,tny2,tnz2,
     x          tnx3,tny3,tnz3,nr1,ng1,nb1,opaq1)
         enddo

         do i=1,lamps
            call povwls(lampv(i,1),lampv(i,2),lampv(i,3),
     x           int(255*Idv(i,1)),int(255*Idv(i,2)),int(255*Idv(i,3)))
         enddo
         call gbkgrv(ir,ig,ib)
         call povwbg(ir,ig,ib)

         call get_hasframetext(nworld,iftext)
         if (iftext.ne.0) then
            call get_frametextxy(nworld,xmy,ymy)
            write(*,*) 'Position:',xmy,ymy
            call get_frametext(nworld,frametext)
            call get_frametext_size(frametext,xcoord*2,ycoord*2,tsize)
            call gztr(ztrans)
            call povwt((xmy-.5)*xcoord*2,-(ymy-.5)*ycoord*2,
     x           -ztrans,tsize,255,255,255,frametext)
         endif
         call povfin
      enddo
      return
      end

      subroutine get_frametext_size(frametext,xsize,ysize,tsize)
      implicit double precision (a-h,o-z)
      character*(*) frametext
      idfq=40
      il=islen(frametext)
      if (il.gt.40) idfq=il
      tsize=xsize/idfq
c      if (tsize.le.1) tsize=1.d0
      return
      end

