/* This is userinterface.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: userinterface.c 128 2013-12-18 07:03:36Z daniels $";

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include "Xco.h"

#include "userinterface.h"
#include "sockimport.h"
#include "periodic_table.h"
#include "ccinterface.h"
#include "xinterface.h"
#include "rotpanel.h"
#include "ymol.h"
#include "fstring.h"
#include "xinterface.h"
#include "misc.h"
#include "drawevents.h"
#include "labeldraw.h"
#include "bondrules.h"
#include "lights.h"
#include "importinterface.h"
#include "selectanimate.h"
#include "ppm.h"
#include "triangleworld.h"
#include "defaults.h"
#include "render_params.h"
#include "aboutymol.h"
#include "vmconsole.h"
#include "y4vm.h"
#include "ymolrc.h"
#include "showframeno.h"
#include "atomparams.h"
#include "filenamegood.h"
#include "register_update.h"
#include "postscript.h"
#include "frametext.h"
#include "dxexport.h"
#include "polygonrules.h"

XcoObject topobject;

static char untitledname[]="No File";
static char *current_file=NULL;
static int i_can_use_save=0;
static int i_need_to_save=0;

void set_need_to_save()
{
  i_need_to_save=1;
}

void set_can_use_save(int i)
{
  i_can_use_save=i;
}

void set_current_filename(char *name)
{
  char *tt;
  XTextProperty textproperty;
  if (current_file!=NULL)
    free(current_file);
  if (name!=NULL)
    {
      current_file=malloc((strlen(name)+1));
      strcpy(current_file,name);
      tt=malloc(strlen(name)+1+7);
      sprintf(tt,"Ymol - %s",name);
    }
  else
    {
      current_file=NULL;
      tt=malloc(5);
      strcpy(tt,"Ymol");
    }
  XStringListToTextProperty(&tt,1,&textproperty);
  XSetWMName(XcoGetDisplay(),XcoWindow(get_toplevel()),&textproperty);
  free(tt);
}

char *get_current_filename()
{
  if (current_file==NULL)
    return (untitledname);
  return current_file;
}


void quit_app()
{
  /* This should test the variable i_need_to_save and ask if
     user wishes to save the file */



  /*  printf("Quitting...\n"); */
  deinif_();
  exit(0);
}

/* Callbacks... */
void quit_callback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
      {
	quit_app();
      }
}


void cldta_()
{
  int i=0;
  set_can_use_save(0);
  set_current_filename(NULL);
  setany_(&i);
  wupd_();
  set_bkgr_pixmap();
  execute_update_functions();
}

int open_and_read_file(char *name)
{
  int rval=1;
  /* printf("I am told to open and read file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      int ok;
      i_can_use_save=0;
      set_current_filename(name);
      fload_file(name,&ok);
      if (!ok)
	{
	  cldta_();
	}
      else
	{
	  i_can_use_save=1;
	}
    }
  return (rval);
}

static int open_and_read_file_style(char *name)
{
  int rval=1;
  /* printf("I am told to open and read file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      int ok;
      fload_file_style(name,&ok);
      if (!ok)
	{
	  cldta_();
	}
      else
	{
	  mabr_();
	  /* Only recompute polygon rules *if* there are polygon rules */
	  if (get_number_of_polygon_rules())
	    mapr_();
	  wupd_();
	}
    }
  return (rval);
}

static int open_and_read_file_style2(char *name)
{
  int rval=1;
  /* printf("I am told to open and read file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      int ok;
      fload_file_style(name,&ok);
      if (!ok)
	{
	  cldta_();
	}
      else
	{
	  wupd_();
	}
    }
  return (rval);
}

int import_file(char *name)
{
  /* printf("I am told to import file '%s'\n",name); */
  if (strlen(name)==0)
     return 0;
  import_dialog(name);
  return 1;
}

int save_as_file(char *name)
{
  int rval=1;
  /* printf("I am told to save as file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+6);
      strcpy(myname,name);
      filenamegood(myname,".ymol",".ymol");
      /* test if file already exists... */

      /* ok to save */
      fsave_file(myname);
      set_current_filename(myname);
      free(myname);
      i_can_use_save=1;
    }
  return (rval);
}

static int save_as_style_file(char *name)
{
  int rval=1;
  /* printf("I am told to save as file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+6);
      strcpy(myname,name);
      filenamegood(myname,".ymol",".ymol");
      /* test if file already exists... */

      /* ok to save */
      fsave_style_file(myname);
      free(myname);
    }
  return (rval);
}

static void save_local_style_file()
{
  save_as_style_file("style.ymol");
}

static void save_global_style_file()
{
  char *home=getenv("HOME");
  char *gname;
  gname=malloc((strlen(home)+17+1));
  strcpy(gname,home);
  strcat(gname,"/.ymol/style.ymol");
  save_as_style_file(gname);
  free(gname);
}


static int save_orientation_file(char *name)
{
  int rval=1;
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+19);
      strcpy(myname,name);
      filenamegood(myname,".ymol_orientation",".ymol_orientation");
      /* test if file already exists... */

      /* ok to save */
      fsave_orientation_file(myname);
      free(myname);
    }
  return (rval);
}

static int load_orientation_file(char *name)
{
  int rval=1;
  if (strlen(name)==0)
    rval=0;
  else
    {
      int ok;
      fload_orientation_file(name,&ok);
      if (!ok)
	rval=0;
    }
  return (rval);
}

static void save_orientation()
{
  char *filters[2]={
    ".ymol_orientation",
    ""};
  XcoFileDialog("Save orientation as","Save",filters,2,save_orientation_file);
}

static void load_orientation()
{
  char *filters[2]={
    ".ymol_orientation",
    ""};
  XcoFileDialog("Load orientation from","Load",filters,2,load_orientation_file);
}
 
static int povsave(char *name)
{
  int rval=1;
  /* printf("I am told to save as file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+6);
      strcpy(myname,name);
      filenamegood(myname,".pov","");

      /* ok to save */
      povray_save(myname,0.);
      free(myname);
    }
  return (rval);
}


static int dxsave(char *name)
{
  int rval=1;
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+6);
      strcpy(myname,name);
      filenamegood(myname,".dx",".dx");

      /* ok to save */
      dx_save(myname);
      free(myname);
    }
  return (rval);
}


void ymol_save_ppm_image(char *filename)
{
  int oversample,ppm_xsize,ppm_ysize;
  uint32 *buffer=get_conv_buffer_ptr();
  get_displayed_image();
  govsmp_(&oversample);
  get_buffer_size(&ppm_xsize,&ppm_ysize);
  ppm_xsize/=oversample;
  ppm_ysize/=oversample;
  write_ppm(filename,ppm_xsize,ppm_ysize,buffer);
}

static uint32 *resize32(int from_x,int from_y,uint32 *from_buffer,int to_x,int to_y)
{
  uint32 *new_buffer=malloc(sizeof(uint32)*to_x*to_y);
  uint32 *new_ptr=new_buffer;
  int y,x;
  for (y=0; y<to_y; y++)
    {
      uint32 *y_pos_from=from_buffer+((y*from_y)/to_y)*from_x;
      for (x=0; x<to_x; x++)
	  *new_ptr++=*(y_pos_from+(x*from_x)/to_x);
    }
  return(new_buffer);
}

void ymol_load_ppm_image(char *filename)
{
  int oversample,ppm_xsize,ppm_ysize,bufx,bufy;
  uint32 *buffer,*newbuf,*newbuf2;
  set_can_use_save(0);
  set_current_filename(NULL);
  govsmp_(&oversample);
  get_buffer_size(&bufx,&bufy);
  bufx/=oversample;
  bufy/=oversample;
  newbuf=read_ppm(filename,&ppm_xsize,&ppm_ysize);
  set_draw_style(DRAW_STYLE_3D_SPHERES);
#ifdef USEOPENGL
  set_use_opengl(0);
#endif
  set_oversampling(1);
  set_global_oversampling(1);
  newbuf2=resize32(ppm_xsize,ppm_ysize,newbuf,bufx,bufy);
  free(newbuf);
  buffer=get_conv_buffer_ptr();
  memcpy(buffer,newbuf2,bufx*bufy*sizeof(uint32));
  flush_image();
  free(newbuf2);
  vmconsole_interrupt(0);
}

static int ppmsave(char *name)
{
  int rval=1;
  /* printf("I am told to save as file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+6);
      strcpy(myname,name);
      filenamegood(myname,".ppm",".ppm");
      /* test if file already exists... */
      
      /* ok to save */
      ymol_save_ppm_image(myname);
      free(myname);
    }
  return (rval);
}

static int pssave(char *name)
{
  int rval=1;
  /* printf("I am told to save as file '%s'\n",name); */
  if (strlen(name)==0)
    rval=0;
  else
    {
      /* Fix filename */
      char *myname=malloc(strlen(name)+6);
      strcpy(myname,name);
      filenamegood(myname,".eps",".eps");
      /* test if file already exists... */
      
      /* ok to save */
      ymol_save_ps_image(myname);
      free(myname);
    }
  return (rval);
}

static void save_as_ymol()
{
  char *filters[2]={
    ".ymol",
    ""};
  XcoFileDialog("Save as","Save",filters,2,save_as_file);
}

static void save_as_povray()
{
  char *filters[2]={
    ".pov",
    ""};
  XcoFileDialog("Save POVRAY scene","Save",filters,2,povsave);
}

static void save_as_dx()
{
  char *filters[2]={
    ".dx",
    ""};
  XcoFileDialog("Save as Data Explorer file","Save",filters,2,dxsave);
}

static void save_as_ppm()
{
  char *filters[2]={
    ".ppm",
    ""};
  XcoFileDialog("Save PPM image","Save",filters,2,ppmsave);
}

static void save_as_ps()
{
  char *filters[2]={
    ".eps",
    ""};
  XcoFileDialog("Save Postscript image","Save",filters,2,pssave);
}

static void save_ymol()
{
  if (i_can_use_save)
    {
      /* printf("I am saving %s\n",get_current_filename()); */
      fsave_file(get_current_filename());
    }
  else
    save_as_ymol();
}

void switch_mode()
{
#if 0
  set_draw_style(1-get_draw_style());
  uint32 *buf=get_buffer_ptr();
  int32 *zbuffer=get_zbuffer_ptr();
  int xsize,ysize;
  get_buffer_size(&xsize,&ysize);
  wupd_();
  /*  supd_((int*)buf,(int*) zbuffer,&xsize,&ysize); */
#endif
}

void main_app_close()
{
  /* printf("I did get the message about closing up...\n"); */
  quit_app();
}

static void (*callback_updatefunc)()=NULL;


int local_update_func()
{
#if 0
    static int numcalls=0;
    static int lasttime=0;
    struct timeval tv;
    struct timezone tz;
    gettimeofday(&tv,&tz);
    if (tv.tv_sec>lasttime)
    {
	printf("Calls/sec=%d\n",numcalls);
	numcalls=0;
	lasttime=tv.tv_sec;
    }
    numcalls++;
#endif
    /* printf("Workprocess\n"); */
    if (callback_updatefunc!=NULL)
	callback_updatefunc();
    sockimport_poll();
    usleep(10000);
    /*  active_timeout=0; */
    /* new_timeout(10); */
    return (0);
}

void set_updatefunc(void (*updatefunc)())
{
  callback_updatefunc=updatefunc;
}

int process_events()
{
  XcoAddWorkProc(local_update_func);
  XcoProcessEvents();
  return(0);
}

void f_updatefunc()
{
  uint32 *buf;
  int32 *zbuffer;
  int anyaction;
  /* This function calls the fortran update routine */
  int xsize,ysize;
  get_buffer_size(&xsize,&ysize);
  /* test that the drawing box did not change size. */
  test_draw_window_size(&xsize,&ysize);

  buf=get_buffer_ptr();
  zbuffer=get_zbuffer_ptr();
  pact_((int*)buf,(int*) zbuffer,&xsize,&ysize,&anyaction);
  update_showframe();
  anim_hook();
}

/* Max number of menus to handle */
#define MAXNMENUS 100
/* Number of predefined menus */
#define NMENUS 13

#define TOOLMENU 5

static int nmenus=NMENUS;

static XcoMenu mymenuid[MAXNMENUS];

typedef struct toolmenu
{
  int n;
  char *name;
  char **names;
  XcoMenu id;
  unsigned int *address;
  struct toolmenu *next;
} toolmenu;

static toolmenu *toolhook=NULL;
static int ntools=0;

void AddToolMenu(char *name,char **names,int n,unsigned int *address)
{
  int i;
  char **toolnames;
  toolmenu *new=malloc(sizeof(toolmenu));
  toolmenu *ptr;
  new->n=n;
  new->name=malloc(strlen(name)+1);
#if 0
  printf("Adding to toolmenu %s: %d items.\n",name,n);
#endif
  strcpy(new->name,name);
  new->names=malloc(sizeof(char*)*n);
  new->address=malloc(sizeof(unsigned int*)*n);
  for (i=0; i<n; i++)
    {
#if 0
      printf("Adding to toolmenu %s: %s.\n",name,names[i]);
#endif
      new->names[i]=malloc(strlen(names[i])+1);
      strcpy(new->names[i],names[i]);
      new->address[i]=address[i];
    }
  new->next=toolhook;
  toolhook=new;
  ntools++;
  toolnames=malloc(sizeof(char*)*ntools);
  ptr=toolhook;
#if 0
  printf("Hoho\n");
#endif
  i=0;
  while (ptr!=NULL)
    {
      toolnames[i]=malloc(strlen(ptr->name)+1);
      strcpy(toolnames[i],ptr->name);
      i++;
      ptr=ptr->next;
    }
  XcoChangeMenu(mymenuid[TOOLMENU],MENU_TOPLEVEL,0,toolnames,i);
  new->id=XcoCreateMenu(mymenuid[TOOLMENU],ntools-1,names,n);
  ptr=toolhook;
  i=0;
  while (ptr!=NULL)
    {
      XcoAttachSubMenu(mymenuid[TOOLMENU],i,ptr->id);
      free(toolnames[i++]);
      ptr=ptr->next;
    }
}

void RemoveToolMenu()
{
  char *toolnames[1]=
  {
    ""
  };
  toolmenu *ptr=toolhook,*tmp;
  while(ptr!=NULL)
    {
      int i;
      tmp=ptr;
      ptr=ptr->next;
      free(tmp->name);
      for(i=0; i<tmp->n;i++)
	free(tmp->names[i]);
      free(tmp->address);
      free(tmp->names);
      free(tmp);
    }
  toolhook=NULL;
  ntools=0;
  XcoChangeMenu(mymenuid[TOOLMENU],MENU_TOPLEVEL,0,toolnames,1);
}

XcoMenu mymenuid_get(int i)
{
  return mymenuid[i];
}

int n_mymenuid_get()
{
  return (nmenus);
}

static void myfopen()
{
  char *filters[2]={
    ".ymol",
    ""};
  XcoFileDialog("Open file","Open",filters,2,open_and_read_file);
}

static void mysopen()
{
  char *filters[2]={
    ".ymol",
    ""};
  XcoFileDialog("Get style from file","Get style",filters,2,open_and_read_file_style);
}

static void mysopen2()
{
  char *filters[2]={
    ".ymol",
    ""};
  XcoFileDialog("Get style from file (without bonds)","Get style",filters,2,open_and_read_file_style2);
}

void mymenucallback(int menu,int id,int i)
{
  /* printf("Selected:%d,%d,%d\n",menu,id,i); */
  if (id==mymenuid[0])
    {
      /* filemenu */
      switch(i)
	{
	case 0:
	  myfopen();
	  break;
	case 1:
	  {
	    char *filters[5]={
	      ".mol",
	      ".out",
	      ".xyz",
	      ".dat",
	      ""};
	    XcoFileDialog("Import file","Import",filters,5,import_file);
	  }
	  break;
	case 2:
	  save_ymol();
	  break;
	case 3:
	  save_as_ymol();
	  break;
	case 4:
	  save_local_style_file();
	  break;
	case 5:
	  save_global_style_file();
	  break;
	case 6:
	  load_orientation();
	  break;
	case 7:
	  save_orientation();
	  break;
	case 8:
	  cldta_();
	  break;
	case 9:
	  quit_app();
	  break;
	}
    }
  else if (id==mymenuid[12])
    {
      switch(i)
	{
	case 0:
	  myfopen();
	  break;
	case 1:
	  mysopen();
	  break;
	case 2:
	  mysopen2();
	  break;
	}
    }
  else if (id==mymenuid[1])
    {
      /* editmenu */
      switch (i)
      {
	  case 0:
	      bond_rules();
	      break;
	  case 1:
	      edit_rendering_parameters();
	      break;
	  case 2:
	      open_periodic_table("Edit atom properties",p_atomparams,0,NULL,0);
	      break;
	  case 3:
	      add_change_frametext(0.5,0.25);
	      break;
	  case 4:
	      edit_lights();
	      break;
	  case 5:
	      polygon_rules();
	      break;
      }
    }
  else if (id==mymenuid[2])
    {
      int z;
      /* view menu */
      switch(i)
	{
	case 0:
	  set_draw_style(DRAW_STYLE_WIREFRAME);
	  set_oversampling(1);
	  sterei_();
	  wupd_();
	  for (z=0; z<=2; z++)
	    if (0==z)
	      XcoSetMenuItemActivated(mymenuid[10],z,1);
	    else
	      XcoSetMenuItemActivated(mymenuid[10],z,0);
	  break;
	case 1:
	  open_rot_popup();
	  break;
	case 2:
	  open_showframe();
	  break;
	case 3:
	  z=1-XcoGetMenuItemActivated(id,i);
	  XcoSetMenuItemActivated(id,i,z);
	  dlbl_(&z);
	  fupd_();
	  break;
	case 4:
	  z=1-XcoGetMenuItemActivated(id,i);
	  XcoSetMenuItemActivated(id,i,z);
	  set_perspective(z);
	  fupd_();
	  break;
	case 5:
	  z=1-XcoGetMenuItemActivated(id,i);
	  XcoSetMenuItemActivated(id,i,z);
	  setste_(&z);
	  fupd_();
	  break;
	case 6:
	  z=1-XcoGetMenuItemActivated(id,i);
	  XcoSetMenuItemActivated(id,i,z);
	  sttriz_(&z);
	  wupd_();
	  break;
	}
    }
  else if (id==mymenuid[3])
    {
      /* options menu */
      switch(i)
	{
	case 0:

	  break;
	}
    }
  else if (id==mymenuid[4])
    {
      /* y4 menu */
      switch(i)
	{
	case 0:
	  open_vmconsole();
	  break;
	case 1:
	  vm_stop();
	  break;
	case 2:
	  vmconsoleinit();
	  save_vm_state();
	  load_ymolrc();
	  vm_invalidate();
	  break;
	}
    }
  else if (id==mymenuid[5])
    {
      /* Tools menu */
    }
  else if (id==mymenuid[6])
    {
      /* help menu */
      switch(i)
	{
	case 0:
	  show_about_ymol_message();
	  break;
	}
    }
  else if (id==mymenuid[7])
    {
      /* save as menu */
      switch(i)
	{
	case 0:
	  save_as_ymol();
	  break;
	case 1:
	  save_as_ppm();
	  break;
	case 2:
	  save_as_ps();
	  break;
	case 3:
	  save_as_povray();
	  break;
	case 4:
	  save_as_dx();
	  break;
	}
    }
  else if (id==mymenuid[8])
    {
      /* graphic options menu */
      switch(i)
	{
	case 0:
	  {
#if 0
	    int modenow=XcoGetMenuItemActivated(id,i);
	    switch(modenow)
	      {
	      case 0:
		set_draw_style(1);
		set_oversampling(get_global_oversampling());
		wupd_();
		XcoSetMenuItemActivated(id,i,1);
		break;
	      case 1:
		set_draw_style(0);
		set_oversampling(1);
		wupd_();
		XcoSetMenuItemActivated(id,i,0);
		break;
	      }
#endif
	  }
	  break;
	}
    }
  else if (id==mymenuid[9])
    {
      /* 3d options menu */
      switch(i)
	{
	case 0:
	  {
#ifdef USEOPENGL
	    int Icanuseopengl=1;
	    if (!QueryOpenGLSupport())
	      Icanuseopengl=0;
#else
	    int Icanuseopengl=0;
#endif
	    if (Icanuseopengl)
	      {
#ifdef USEOPENGL
		{
		    if ((!get_use_opengl()) || (get_3d_mode()!=MODE_STYLE_OPENGL) || (get_draw_style()!=DRAW_STYLE_3D_SPHERES))
		    {
		      int z;
		      set_draw_style(DRAW_STYLE_3D_SPHERES);
		      sterei_();
		      set_oversampling(1);
		      set_use_opengl(1);
		      set_3d_mode(MODE_STYLE_OPENGL);
		      set_fast_emulation(0);
		      wupd_();
		      for (z=0; z<=2; z++)
			if (i==z)
			  XcoSetMenuItemActivated(mymenuid[9],z,1);
			else
			  XcoSetMenuItemActivated(mymenuid[9],z,0);
		      for (z=0; z<=2; z++)
			  XcoSetMenuItemActivated(mymenuid[11],z,0);
		      XcoSetMenuItemActivated(mymenuid[11],2,1);

		    }
		}
#endif
	      }
	    else
	      {
		printf("OpenGL not supported\n");
	      }
	  }
	  break;
	case 1:
	  {
	    int z;
	    set_3d_mode(MODE_STYLE_NATIVE);
	    set_draw_style(DRAW_STYLE_3D_SPHERES);
	    sterei_();
	    set_oversampling(get_global_oversampling());
#ifdef USEOPENGL
	    set_use_opengl(0);
#endif	  
	    set_fast_emulation(1);
	    wupd_();
	    for (z=0; z<=2; z++)
	      if (i==z)
		XcoSetMenuItemActivated(mymenuid[9],z,1);
	      else
		XcoSetMenuItemActivated(mymenuid[9],z,0);
	    for (z=0; z<=2; z++)
	      XcoSetMenuItemActivated(mymenuid[11],z,0);
	    XcoSetMenuItemActivated(mymenuid[11],2,1);
	  }
	  break;
	case 2:
	  {
	    int z;
#ifdef USEOPENGL
	    set_use_opengl(0);
#endif
	    set_3d_mode(MODE_STYLE_POVRAY);
	    set_draw_style(DRAW_STYLE_3D_SPHERES);
	    sterei_();
	    set_oversampling(get_global_oversampling());
	    wupd_();
	    for (z=0; z<=2; z++)
	      if (i==z)
		XcoSetMenuItemActivated(mymenuid[9],z,1);
	      else
		XcoSetMenuItemActivated(mymenuid[9],z,0);
	    for (z=0; z<=2; z++)
		XcoSetMenuItemActivated(mymenuid[11],z,0);
	    XcoSetMenuItemActivated(mymenuid[11],2,1);
	  }
	break;
	}
    }
  else if (id==mymenuid[10])
    {
      /* doublebuffering menu */
      switch(i)
	{
	case 0:
	  {
	    int z;
#ifdef DOUBLEBUFFER
	    set_doublebuffer_usage(0);
#endif
#ifdef MULTIBUFFER
	    set_multibuffer_usage(0);
#endif
	    for (z=0; z<=2; z++)
	      if (i==z)
		XcoSetMenuItemActivated(mymenuid[10],z,1);
	      else
		XcoSetMenuItemActivated(mymenuid[10],z,0);
	  }
	  break;
	case 1:
	  {
	    int z;
#ifdef MULTIBUFFER
	    int Icanuseit=1;
	    if (!Iquery_mbuf_support())
	      Icanuseit=0;
#else
	    int Icanuseit=0;
#endif
	    if (Icanuseit)
	      {
#ifdef MULTIBUFFER
		set_multibuffer_usage(1);
#endif
		for (z=0; z<=2; z++)
		  if (i==z)
		    XcoSetMenuItemActivated(mymenuid[10],z,1);
		  else
		    XcoSetMenuItemActivated(mymenuid[10],z,0);
	      }
	    else
	      {
		printf("Multibuffer not supported\n");
	      }
	  }
	  break;
	case 2:
	  {
	    int z;
#ifdef DOUBLEBUFFER
	    int Icanuseit=1;
	    if (!Iquery_dbe_support())
	      Icanuseit=0;
#else
	    int Icanuseit=0;
#endif
	    if (Icanuseit)
	      {
#ifdef DOUBLEBUFFER
		set_doublebuffer_usage(1);
#endif
		for (z=0; z<=2; z++)
		  if (i==z)
		    XcoSetMenuItemActivated(mymenuid[10],z,1);
		  else
		    XcoSetMenuItemActivated(mymenuid[10],z,0);
	      }
	    else
	      {
		printf("Doublebuffer not supported\n");
	      }
	  }
	  break;
	}
    }
  else if (id==mymenuid[11])
    {
      int z;
      /* view menu */
      switch(i)
	{
	case 0:
	  set_draw_style(DRAW_STYLE_WIREFRAME);
	  sterei_();
	  set_oversampling(1);
	  wupd_();
	  break;
	case 1:
	  set_draw_style(DRAW_STYLE_2D_CIRCLES);
	  sterei_();
	  set_oversampling(1);
	  wupd_();
	  break;
	case 2:
	  set_draw_style(DRAW_STYLE_3D_SPHERES);
	  sterei_();
#ifdef USEOPENGL
	  if (!get_use_opengl())
#endif
	    set_oversampling(get_global_oversampling());
#ifdef USEOPENGL
	  else
	    set_oversampling(1);
#endif
	  wupd_();
	  break;
	}
      for (z=0; z<=2; z++)
	if (i==z)
	  XcoSetMenuItemActivated(id,z,1);
	else
	  XcoSetMenuItemActivated(id,z,0);
    }
  else
    {
      toolmenu *ptr=toolhook;
      while (ptr!=NULL)
	{
	  if (ptr->id==id)
	    vmconsole_call(ptr->address[i]," ");
	  ptr=ptr->next;
	}
    }
}

void update_em()
{
  int i,z;
  /* Go through the menu options and set everything to be ok */
  i=get_draw_style();
  switch(i)
    {
    case DRAW_STYLE_WIREFRAME:
      i=0;
      break;
    case DRAW_STYLE_2D_CIRCLES:
      i=1;
      break;
    case DRAW_STYLE_3D_SPHERES:
      i=2;
      break;
    }
  for (z=0; z<=2; z++)
    if (i==z)
      XcoSetMenuItemActivated(mymenuid[11],z,1);
    else
      XcoSetMenuItemActivated(mymenuid[11],z,0);
  switch(get_3d_mode())
    {
    case MODE_STYLE_OPENGL:
      i=0;
      break;
    case MODE_STYLE_NATIVE:
      i=1;
      break;
    case MODE_STYLE_POVRAY:
      i=2;
      break;
    }

#ifdef USEOPENGL
  if(get_use_opengl())
    i=0;
#endif
  for (z=0; z<=2; z++)
    if (i==z)
      XcoSetMenuItemActivated(mymenuid[9],z,1);
    else
      XcoSetMenuItemActivated(mymenuid[9],z,0);
  dlqry_(&i);
  XcoSetMenuItemActivated(mymenuid[2],3,i);
  XcoSetMenuItemActivated(mymenuid[2],4,get_perspective());
  steqry_(&i);
  XcoSetMenuItemActivated(mymenuid[2],5,i);
  trzqry_(&i);
  XcoSetMenuItemActivated(mymenuid[2],6,i);
}

void create_menus(XcoObject parent,int width)
{
  int Icanuseopengl;
  char *filemenutext[10]=
  {
    "Open",
    "Import",
    "Save",
    "Save as",
    "Save style",
    "Save global style",
    "Load orientation",
    "Save orientation",
    "Close",
    "Quit"
  };

  char *openmenutext[3]=
  {
    "Ymol file",
    "Style from ymol file (with rules)",
    "Style from ymol file (without rules)"
  };

  char *editmenutext[6]=
  {
    "Bond rules",
    "Rendering parameters",
    "Default atom properties",
    "Frametext",
    "Lights",
    "Polygon rules",
  };


  char *viewmenutext[7]=
  {
    "Style",
    "Control panel",
    "Frame number",
    "Labels",
    "Perspective",
    "Stereographic",
    "Triangelize"
  };

  char *viewmodetext[3]=
  {
    "Wireframe",
    "Circles and polygons",
    "Shaded spheres and cylinders"
  };

  char *optionsmenutext[1]=
  {
    "Graphics"
  };

  char *graphicoptiontext[2]=
  {
    "Shading",
    "Doublebuffering"
  };

  char *helpmenutext[1]=
  {
    "About Ymol"
  };

  char *dimdisplaytext[3]=
  {
    "Use OpenGL",
    "Use native software",
    "Use POVRAY"
  };

  char *dbuftext[3]=
  {
    "Use emulation (XCopyArea)",
    "Use multibuffering (Xmbuf)",
    "Use doublebuffering (Xdbe)"
  };

  char *moresavetext[5]=
  {
    "Ymol native",
    "PPM image",
    "Postscript",
    "POVRAY scene",
    "Data Explorer file"
  };

  char *y4text[3]=
  {
    "Y4 Console",
    "Stop VM",
    "Reset VM"
  };

  char *tooltext[1]=
  {
    ""
  };

  char *menubarnames[7]=
  {
    "File",
    "Edit",
    "View",
    "Options",
    "Y4",
    "Tools",
    "Help"
  };

#if 0
  char *testtoolnames[3]=
  {
    "Create",
    "Save",
    "Stop"
  };

  unsigned int testtooladdresses[3]={ 1,2,3 };
#endif

  register_update_function(update_em);

  /* Toplevels must be first in this array if it is to be passed to
     create_menubar */
  mymenuid[0]=XcoCreateMenu(MENU_TOPLEVEL,0,filemenutext,10);
  mymenuid[1]=XcoCreateMenu(MENU_TOPLEVEL,0,editmenutext,6);
  mymenuid[2]=XcoCreateMenu(MENU_TOPLEVEL,0,viewmenutext,7);
  mymenuid[3]=XcoCreateMenu(MENU_TOPLEVEL,0,optionsmenutext,1);
  mymenuid[4]=XcoCreateMenu(MENU_TOPLEVEL,0,y4text,3);
  mymenuid[5]=XcoCreateMenu(MENU_TOPLEVEL,0,tooltext,1);
  mymenuid[6]=XcoCreateMenu(MENU_TOPLEVEL,0,helpmenutext,1);
  mymenuid[7]=XcoCreateMenu(mymenuid[0],3,moresavetext,5);
  mymenuid[8]=XcoCreateMenu(mymenuid[3],0,graphicoptiontext,2);
  mymenuid[9]=XcoCreateMenu(mymenuid[8],0,dimdisplaytext,3);
  mymenuid[10]=XcoCreateMenu(mymenuid[8],1,dbuftext,3);
  mymenuid[11]=XcoCreateMenu(mymenuid[2],0,viewmodetext,3);
  mymenuid[12]=XcoCreateMenu(mymenuid[0],0,openmenutext,3);


  XcoSetMenuItemToggleable(mymenuid[2],3,1,0);
  XcoSetMenuItemToggleable(mymenuid[11],0,1,0);
  XcoSetMenuItemToggleable(mymenuid[11],1,1,1);
  XcoSetMenuItemToggleable(mymenuid[11],2,1,0);

  /* XcoSetMenuItemToggleable(mymenuid[6],0,1,0); */
  XcoSetMenuItemToggleable(mymenuid[2],4,1,1);
  XcoSetMenuItemToggleable(mymenuid[2],5,1,0);
  XcoSetMenuItemToggleable(mymenuid[2],6,1,0);

  XcoSetMenuItemToggleable(mymenuid[9],0,1,0);
  XcoSetMenuItemToggleable(mymenuid[9],1,1,0);
  XcoSetMenuItemToggleable(mymenuid[9],2,1,0);
  XcoSetMenuItemToggleable(mymenuid[10],0,1,1);
  XcoSetMenuItemToggleable(mymenuid[10],1,1,0);
  XcoSetMenuItemToggleable(mymenuid[10],2,1,0);


#ifdef USEOPENGL
  Icanuseopengl=1;
  if (!QueryOpenGLSupport())
    Icanuseopengl=0;
#else
  Icanuseopengl=0;
#endif

  if (Icanuseopengl)
    XcoSetMenuItemActivated(mymenuid[9],0,1);
  else
    XcoSetMenuItemActivated(mymenuid[9],1,1);

  XcoCreateMenubar(parent,0,0,width,7,menubarnames,mymenuid,mymenucallback,1);
#if 0
  AddToolMenu("Animated GIF",testtoolnames,3,testtooladdresses);
  AddToolMenu("MPEG",testtoolnames,3,testtooladdresses);
#endif
}

int init_userinterface(int *argc,char ***argv)
{

  /* initialize drawing window */
  if (init_animation_window(argc,argv))
    {
      return (1);
    }

  XcoAddCallback(topobject,quit_callback);
  

#if 0
  /* test icon. if we know about the default visual we should prepare
   beautiful color icons. otherwise we'll use a monochrome one. */
  Pixmap icon_pixmap=
    XCreatePixmap(XtDisplay(topwidget2),
		  XtWindow(topwidget2),64,64,
		  DefaultDepth(XtDisplay(topwidget2),
			       DefaultScreen(XtDisplay(topwidget2))));
  XSetForeground(XtDisplay(topwidget2),
		 DefaultGC(XtDisplay(topwidget2),
			   DefaultScreen(XtDisplay(topwidget2))),
		 WhitePixel(XtDisplay(topwidget2),
			    DefaultScreen(XtDisplay(topwidget2))));
  XFillRectangle(XtDisplay(topwidget2),
		 icon_pixmap,
		 DefaultGC(XtDisplay(topwidget2),
			   DefaultScreen(XtDisplay(topwidget2))),0,0,64,64);

  XtVaSetValues(topwidget2,XtNiconPixmap,icon_pixmap,NULL);
#endif
  set_updatefunc(f_updatefunc);
  /* load_the_font(); */

  return(0);

}

XcoObject get_toplevel()
{
  return(topobject);
}

/*
void realize_toplevel()
{
  XtRealizeWidget(top);
}
*/
