#include "Xco.h"
#include "xinterface.h"
#include "triangleworld.h"
#include <math.h>

#ifndef PI
#define PI 3.1415926
#endif

#define IMAX 100
#define JMAX 40
#define JPART 0.3
#define JXFACT 5
#define JYFACT 5
#define JZFACT 2
#define JXFACT2 3
#define JYFACT2 7
#define JZFACT2 5
#define IPART 1.9
#define PHASE2 (PI*0.5)

#define R11 255
#define R12 0
#define G11 0
#define G12 0
#define B11 0
#define B12 255

#define R21 0
#define R22 255
#define G21 255
#define G22 255
#define B21 0
#define B22 255

#define XHALF (xsize/2)
#define YHALF (ysize/2)
#define XHALF2 (XHALF-130)
#define YHALF2 (YHALF-130)

void test_triangles(unsigned int *buf,int *zbuf,int xsize,int ysize)
{
#if 1
  lamp l;
  int rgb0[3]={255,0,0};
  int rgb1[3]={0,0,255};
  int rgb2[3]={0,255,0};
  double rsv0=0.7;
  double rsv1=0.7;
  int i;

  set_draw_style(1);
  set_bglight(50,50,50);
  new_lamps(2);

  l.x=0;
  l.y=0;
  l.z=1;
  l.r=128;
  l.g=128;
  l.b=128;
  add_lamp(l);
  l.x=0.5774;
  l.y=0.5774;
  l.z=0.5774;
  l.r=128;
  l.g=128;
  l.b=128;
  add_lamp(l);
  for (i=0; i<IMAX; i++)
    {
      int j;
      int start=0,end=ysize-1;
      clear_buffers(0);
      new_triangles();
      for (j=0; j<JMAX; j++)
	{

	  int x1=XHALF+XHALF2*sin(PI*2*((JXFACT*((JPART*j))/JMAX)+IPART*i/IMAX));
	  int y1=YHALF+YHALF2*cos(PI*2*((JYFACT*((JPART*j))/JMAX)+IPART*i/IMAX));
	  int z1=YHALF*sin(PI*2*((JZFACT*((JPART*j))/JMAX)+IPART*i/IMAX));
	  int x2=XHALF+XHALF2*sin(PI*2*((JXFACT*((JPART*(j+1)))/JMAX)+IPART*i/IMAX));
	  int y2=YHALF+YHALF2*cos(PI*2*((JYFACT*((JPART*(j+1)))/JMAX)+IPART*i/IMAX));
	  int z2=YHALF*sin(PI*2*((JZFACT*((JPART*(j+1)))/JMAX)+IPART*i/IMAX));
	  rgb1[0]=R11+(R12-R11)*j/JMAX;
	  rgb2[0]=R11+(R12-R11)*(j+1)/JMAX;
	  rgb1[1]=G11+(G12-G11)*j/JMAX;
	  rgb2[1]=G11+(G12-G11)*(j+1)/JMAX;
	  rgb1[2]=B11+(B12-B11)*j/JMAX;
	  rgb2[2]=B11+(B12-B11)*(j+1)/JMAX;

#if 0
	  add_triangle_cylinder(x1,y1,z1,15,
				x2,y2,z2,15,
				rgb1,rsv0,100,
				rgb2,rsv0,100,
				16,xsize,ysize,0);
#endif
	  add_triangle_sphere(x1,y1,z1,15,rgb1,rsv0,100,16,16,xsize,ysize,0);

	  x1=XHALF+XHALF2*sin(PHASE2+PI*2*((JXFACT2*((JPART*j))/JMAX)+IPART*i/IMAX));
	  y1=YHALF+YHALF2*cos(PHASE2+PI*2*((JYFACT2*((JPART*j))/JMAX)+IPART*i/IMAX));
	  z1=YHALF*sin(PHASE2+PI*2*((JZFACT2*((JPART*j))/JMAX)+IPART*i/IMAX));
	  x2=XHALF+XHALF2*sin(PHASE2+PI*2*((JXFACT2*((JPART*(j+1)))/JMAX)+IPART*i/IMAX));
	  y2=YHALF+YHALF2*cos(PHASE2+PI*2*((JYFACT2*((JPART*(j+1)))/JMAX)+IPART*i/IMAX));
	  z2=YHALF*sin(PHASE2+PI*2*((JZFACT2*((JPART*(j+1)))/JMAX)+IPART*i/IMAX));
	  rgb1[0]=R21+(R22-R21)*j/JMAX;
	  rgb2[0]=R21+(R22-R21)*(j+1)/JMAX;
	  rgb1[1]=G21+(G22-G21)*j/JMAX;
	  rgb2[1]=G21+(G22-G21)*(j+1)/JMAX;
	  rgb1[2]=B21+(B22-B21)*j/JMAX;
	  rgb2[2]=B21+(B22-B21)*(j+1)/JMAX;
#if 1
	  add_triangle_cylinder(x1,y1,z1,10,
				x2,y2,z2,10,
				rgb1,rsv1,40,
				rgb2,rsv1,40,
				16,xsize,ysize,0);
#endif
#if 0
	  add_triangle_sphere(x1,y1,z1,15,rgb1,rsv0,100,16,16,xsize,ysize,0);
#endif
	}


      draw_triangles(buf,zbuf,xsize,ysize,0,ysize);

      doaa_(&start,&end);
      flush_image();
    }


#endif
}



