/* This is trimoljoin.c
   A utility part of the Ymol program. */

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
  int timesteps,t;
  char cline[10000];
  FILE *trifile,*molfile,*joinfile;
  if (argc!=4)
    {
      printf("three parameters are needed!\n");
      printf("usage:\ntrimoljoin trifile molfile joinfile\n");
      exit(1);
    }
  trifile=fopen(argv[1],"r");
  molfile=fopen(argv[2],"r");
  joinfile=fopen(argv[3],"w");
  fscanf(trifile,"%d",&timesteps);
  fscanf(molfile,"%d",&t);
  if (t!=timesteps)
    {
      printf("Mismatch in number of timesteps for trifile and molfile\n");
      exit(1);
    }
  fprintf(joinfile,"%d\n",timesteps);
  for (t=0; t<timesteps; t++)
    {
      int i;
      int natoms,ntriangles;
      fscanf(trifile,"%d",&ntriangles); fgets(cline,10000,trifile);
      fscanf(molfile,"%d",&natoms); fgets(cline,10000,molfile);
      fprintf(joinfile,"%d %d\n",natoms,ntriangles);
      for (i=0; i<natoms; i++)
	{
	  fgets(cline,10000,molfile);
	  fprintf(joinfile,"%s",cline);
	}
      for (i=0; i<ntriangles*3; i++)
	{
	  fgets(cline,10000,trifile);
	  fprintf(joinfile,"%s",cline);
	}
    }
  fclose(trifile);
  fclose(molfile);
  fclose(joinfile);
}
