/* This is triangleworld.h
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#ifndef __triangleworld__
#define __triangleworld__

#define DIV255 0.0039215686

#define MODE_STYLE_OPENGL 0
#define MODE_STYLE_NATIVE 1
#define MODE_STYLE_POVRAY 2

typedef struct triangle_point
{
  /* short x,y,z; */           /* coordinates */
  float x,y,z;           /* coordinates */
  float nx,ny,nz;        /* normals */
  unsigned char r,g,b;   /* colors */
  float fr;              /* reflection coefficient */
  float opaq;            /* opacity */
  short n;               /* exponent of phong refl */
  short twosided;
  struct triangle_point *next_point;
} triangle_point ;

typedef struct triangle
{
    triangle_point *point[3];
    struct triangle *next_triangle;
} triangle ;

typedef struct sphere
{
  float x,y,z,rad;
  unsigned char r,g,b;
  float fr;
  short n;
  struct sphere *next_sphere;
} sphere;

typedef struct cylinder
{
  float x1,y1,z1,rad1,x2,y2,z2,rad2;
  unsigned char r1,g1,b1,r2,g2,b2;
  float fr1,fr2;
  short n1,n2;
  int quality;
  struct cylinder *next_cylinder;
} cylinder;

typedef struct
{
  double x,y,z;  /* direction */
  int r,g,b;   /* color */
} lamp;


void new_triangles();
void register_triangle_point(triangle_point *tp);
void register_triangle(triangle *t);
void register_sphere(sphere *t);
void register_cylinder(cylinder *t);
void draw_triangles(unsigned int *framebuffer,int *zbuffer,int xsize,int ysize,
		    int ybankstart,int ybankend);

void set_bglight(int r,int g,int b);
void new_lamps(int number);
void add_lamp(lamp l);
int get_nlamps();
lamp *get_lamp(int i);
void setck(double ck);
double getck();
void setZMIN(double x);
double getZMIN();
void setZMAX(double x);
double getZMAX();

void set_fast_emulation(int fast);
int get_perspective();
void set_perspective(int p);

void add_triangle_sphere(double x,double y,double z,double r,
			 int rgb[3],double rsv,int n,int quality,int quality2,int xsize,int ysize,int draw_using_opengl);

void add_triangle_cylinder(double x1,double y1,double z1,double r1,double x2,double y2,double z2,double r2,
			   int rgb1[3],double rsv1,int n1,
			   int rgb2[3],double rsv2,int n2,
			   int quality,int xsize,int ysize,int draw_using_opengl);

#ifdef USEOPENGL
void set_use_opengl(int i);
int get_use_opengl();
#endif
void set_3d_mode(int mode);
int get_3d_mode();


void create_rotation_matrix(double x1,double y1,double z1, /* v1 */
			    double x2,double y2,double z2, /* v2 */
			    double m[4][4]);
void multiply_vectord(double v[3],double m[4][4]);
#endif
