/* A program to test ymols interface to other programs */

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <math.h>

#define MYSIGNAL SIGUSR1

#ifndef PI
#define PI 3.14159265359
#endif

static double time=0.;

static void generate_new_config()
{
  int i,j,natoms=50,ndiff=5,iatom[5]={1,8,17,6,5};
  FILE *myfile;
  myfile=fopen("interface.mol","w");
  fprintf(myfile,"1\n"); /* One frame */
  fprintf(myfile,"%d\n",natoms*ndiff);
  for (j=0; j<ndiff; j++)
    for (i=0; i<natoms; i++)
      {
	double pos=2*PI*((double)(i)/(double)(natoms));
	double myx=(10+j)*sin(time*3+(2*j)+pos);
	double myy=(10+j)*cos(time*7-(2*j)+pos);
	double myz=(20+2*j)*cos(time*3+pos);
	fprintf(myfile," %d  %f  %f  %f\n",iatom[j],myx,myy,myz);
      }
  time+=0.01;
  fclose(myfile);
}

int main()
{
  FILE *myfile;
  unsigned long ymolpid;
  myfile=fopen("ymolpid","r");
  fscanf(myfile,"%lu",&ymolpid);
  fclose(myfile);
  while(1) /* Forever */
    {
      generate_new_config();
      kill((pid_t)ymolpid,MYSIGNAL);
      usleep(250000);
    }
}
