      /* This is tables.F
      A part of the Ymol program
      Copyright (C) 1997-1998 Daniel Spangberg
      */

#include "maxs.h"

c     these are just the defaults.
c     each file can contain more information about the atoms
      subroutine read_tables
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      double precision temp_rgb(MAX_COLOR_SCHEMES,3),
     x     temp_rsv(MAX_COLOR_SCHEMES)
      integer temp_n(MAX_COLOR_SCHEMES)
      do i=1,256
         atom_radius(i)=1.d0
         atom_weight(i)=1.d0
         atom_color(i)=1
      enddo

      do i=1,MAX_COLOR_SCHEMES
         used_scheme(i)=0
      enddo


#include "tabledata.F"

#if 0

      open(unit=1,file='colorschemes.tbl',form='formatted',status='old')
      read(1,*) nschemes
      do i=1,nschemes
         read(1,*) (rgb(i,j),j=1,3),rsv(i),nfactor(i)
         used_scheme(i)=1
      enddo
      close(1)

      open(unit=1,file='atomdata.tbl',form='formatted',status='old')
      read(1,*) natomtypes
      do i=1,natomtypes
         read(1,*) j,atom_radius(j),atom_weight(j),atom_color(j)
      enddo
      close(1)
#endif

c     Reorganize color info...
      do i=1,MAX_COLOR_SCHEMES
         temp_rgb(i,1)=rgb(i,1)
         temp_rgb(i,2)=rgb(i,2)
         temp_rgb(i,3)=rgb(i,3)
         temp_rsv(i)=rsv(i)
         temp_n(i)=nfactor(i)
      enddo
      do i=1,256
         rgb(i,1)=temp_rgb(atom_color(i),1)
         rgb(i,2)=temp_rgb(atom_color(i),2)
         rgb(i,3)=temp_rgb(atom_color(i),3)
         rsv(i)=temp_rsv(atom_color(i))
         nfactor(i)=temp_n(atom_color(i))
         atom_color(i)=i
      enddo

      return
      end

      subroutine qdargb(inr,ir,ig,ib)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      ir=rgb(inr,1)
      ig=rgb(inr,2)
      ib=rgb(inr,3)
      return
      end

      subroutine sdargb(inr,ir,ig,ib)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      rgb(inr,1)=ir
      rgb(inr,2)=ig
      rgb(inr,3)=ib
      return
      end

      subroutine qdarad(inr,xrad)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      xrad=atom_radius(inr)
      return
      end

      subroutine sdarad(inr,xrad)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      atom_radius(inr)=xrad
      return
      end

      subroutine qdarsv(inr,x)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      x=rsv(inr)
      return
      end

      subroutine sdarsv(inr,x)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      rsv(inr)=x
      return
      end

      subroutine qdanpo(inr,x)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      x=nfactor(inr)
      return
      end

      subroutine sdanpo(inr,x)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      nfactor(inr)=int(x)
      if (nfactor(inr).le.0) nfactor(inr)=1
      return
      end

      subroutine qdawgh(inr,x)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      x=atom_weight(inr)
      return
      end


      subroutine sdawgh(inr,x)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      atom_weight(inr)=x
      return
      end

