/* This is rotpanel.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: rotpanel.c 109 2012-01-23 17:32:00Z daniels $";

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>

#include "Xco.h"

#include "userinterface.h"
#include "rotpanel.h"
#include "ccinterface.h"
#include "xinterface.h"

#include "cimages/uparrow.cmg"
#include "cimages/downarrow.cmg"
#include "cimages/leftarrow.cmg"
#include "cimages/rightarrow.cmg"
#include "cimages/deczarrow.cmg"
#include "cimages/inczarrow.cmg"
#include "cimages/rplayarrow.cmg"
#include "cimages/stoparrow.cmg"
#include "cimages/mplayncarrow.cmg"
#include "cimages/zoominarrow.cmg"
#include "cimages/zoomoutarrow.cmg"
#include "cimages/playreversearrow.cmg"
#include "cimages/playreversencarrow.cmg"

#define ARROW_WIDTH 32
#define ARROW_HEIGHT 32
#define ARROW_SPACE 8
#define CPANEL_WIDTH (((5*ARROW_SPACE)+(4*ARROW_WIDTH))+20)
#define CPANEL_HEIGHT (((7*ARROW_SPACE)+(4*ARROW_HEIGHT))+20+20)

static Pixmap uparrow;
static Pixmap downarrow;
static Pixmap leftarrow;
static Pixmap rightarrow;
static Pixmap deczarrow;
static Pixmap inczarrow;
static Pixmap rplayarrow;
static Pixmap mplayarrow;
static Pixmap stoparrow;
static Pixmap mstoparrow;
static Pixmap mplayncarrow;
static Pixmap zoominarrow;
static Pixmap zoomoutarrow;
static Pixmap playreversearrow;
static Pixmap playreversencarrow;
static int pixmaps_declared=0;

static XcoObject rot_popup;
static XcoObject upW;
static XcoObject downW;
static XcoObject leftW;
static XcoObject rightW;
static XcoObject deczW;
static XcoObject inczW;
static XcoObject rplayW;
static XcoObject mplayW;
static XcoObject mplayncW;
static XcoObject zoominW;
static XcoObject zoomoutW;
static XcoObject playreverseW;
static XcoObject playreversencW;
static XcoObject decorbox1,decorbox2;
static XcoObject looptoggle;

static int rot_open=0;

static void rotpbackground(XcoObject obj,Pixmap pix)
{
  XcoSetBackgroundPixmap(obj,pix,True);
}

void rot_close()
{
  rot_open=0;
  XcoDeleteObject(rot_popup);
}

void rot_delete(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      /* close rotate panel */
      rot_close();
    }
}

void rotpanel_up_button()
{
  int rx=-1;
  rotx_(&rx);
}
void rotpanel_down_button()
{
  int rx=1;
  rotx_(&rx);
}
void rotpanel_left_button()
{
  int rx=-1;
  roty_(&rx);
}
void rotpanel_right_button()
{
  int rx=1;
  roty_(&rx);
}
void rotpanel_zin_button()
{
      int rx=-1;
      zinout_(&rx);
}
void rotpanel_zout_button()
{
      int rx=1;
      zinout_(&rx);
}
void up_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_up_button();
}


void down_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_down_button();
}
void left_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_left_button();
}
void right_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_right_button();
}
void decz_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int rx=-1;
      rotz_(&rx);
    }
}
void incz_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int rx=1;
      rotz_(&rx);
    }
}
void zoomin_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int rx=1;
      zinout_(&rx);
    }
}
void zoomout_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int rx=-1;
      zinout_(&rx);
    }
}

static int current_rplay=0;
void rotpanel_rplay_button()
{
  int rx;
  current_rplay=1-current_rplay;
  rx=current_rplay;
  cont_(&rx);
  if (rot_open)
    {
      if (current_rplay)
	rotpbackground(rplayW,stoparrow);
      else
	rotpbackground(rplayW,rplayarrow);
    }
}

void rplay_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_rplay_button();
}

static int current_mplay=0;
void rotpanel_mplay_button()
{
  int rx,rxc;
  if (current_mplay==0)
    current_mplay=1;
  else
    current_mplay=0;
 
  rx=current_mplay;
  rxc=1;
  mplay_(&rx,&rxc);
  if (rot_open)
    {
      if (current_mplay)
	{
	  XcoSetBackgroundPixmap(mplayW,mstoparrow,True);
	  XcoSetBackgroundPixmap(playreverseW,mstoparrow,True);
	}
      else
	{
	  XcoSetBackgroundPixmap(mplayW,mplayarrow,True);
	  XcoSetBackgroundPixmap(playreverseW,playreversearrow,True);
	}
    }
}

void mplay_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_mplay_button();
}

void rotpanel_mplaync_button()
{
  int rx=1;
  int rxc=0;
  current_mplay=0;
  mplay_(&rx,&rxc);
  if (rot_open)
    {
      XcoSetBackgroundPixmap(mplayW,mplayarrow,True);
      XcoSetBackgroundPixmap(playreverseW,playreversearrow,True);
    }
}

void mplaync_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_mplaync_button();
}

void looptoggle_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
  {
      int loops=XcoGetToggleSelected(looptoggle);
      setlop_(&loops);
  }
}


void rotpanel_playreverse_button()
{
  int rx,rxc;
  if (current_mplay==0)
    current_mplay=-1;
  else
    current_mplay=0;
  rx=current_mplay;
  rxc=1;
  mplay_(&rx,&rxc);
  if (rot_open)
    {
      if (current_mplay)
	{
	  XcoSetBackgroundPixmap(mplayW,mstoparrow,True);
	  XcoSetBackgroundPixmap(playreverseW,mstoparrow,True);
	}
      else
	{
	  XcoSetBackgroundPixmap(mplayW,mplayarrow,True);
	  XcoSetBackgroundPixmap(playreverseW,playreversearrow,True);
	}
    }
}

void playreverse_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_playreverse_button();
}

void rotpanel_playreversenc_button()
{
  int rx=-1;
  int rxc=0;
  current_mplay=0;
  mplay_(&rx,&rxc);
  if (rot_open)
    {
      XcoSetBackgroundPixmap(mplayW,mplayarrow,True);
      XcoSetBackgroundPixmap(playreverseW,playreversearrow,True);
    }
}


void playreversenc_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    rotpanel_playreversenc_button();
}


void rotpanel_set_movieplay(int i)
{
  if (i==0)
    {
      if (current_mplay)
	rotpanel_mplay_button();
    }
  else if (i==-1)
    {
      if (current_mplay==0)
	rotpanel_playreverse_button();
      else if (current_mplay)
	{
	  rotpanel_playreverse_button(); /* Stops movie */
	  rotpanel_playreverse_button(); /* Starts movie */
	}
    }
  else if (i==1)
    {
      if (current_mplay==0)
	rotpanel_mplay_button();
      else if (current_mplay)
	{
	  rotpanel_mplay_button(); /* Stops movie */
	  rotpanel_mplay_button(); /* Starts movie */
	}
    }
}

void rotpanel_one_frame_forward()
{
  rotpanel_mplaync_button();
}

void rotpanel_one_frame_backward()
{
  rotpanel_playreversenc_button();
}


void open_rot_popup()
{
  if (!rot_open)
    {
      int prevloop;
      XcoObject maindecor;
      rot_popup=XcoCreateNamedWindow(0,0,CPANEL_WIDTH,CPANEL_HEIGHT,DEFAULT_BACKGROUND,1,-1,"Control Panel");
      XcoAddCallback(rot_popup,rot_delete);
      maindecor=XcoCreateBox3D(rot_popup,5,5,CPANEL_WIDTH-10,CPANEL_HEIGHT-10,2,1);
      decorbox1=XcoCreateBox3D(maindecor,5+ARROW_WIDTH/2,5,CPANEL_WIDTH-20-ARROW_WIDTH-ARROW_SPACE,ARROW_SPACE*4+ARROW_HEIGHT*3,2,1);
      decorbox2=XcoCreateBox3D(maindecor,5,ARROW_SPACE*5+ARROW_HEIGHT*3+10,CPANEL_WIDTH-20,ARROW_HEIGHT+10,2,1);
      upW=XcoCreateCommand(decorbox1,
			   ARROW_SPACE*2+ARROW_WIDTH,
			   ARROW_SPACE,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(upW,up_callback);
      downW=XcoCreateCommand(decorbox1,ARROW_SPACE*2+ARROW_WIDTH,
			     ARROW_SPACE*3+ARROW_HEIGHT*2,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(downW,down_callback);
      leftW=XcoCreateCommand(decorbox1,ARROW_SPACE,
			     ARROW_SPACE*2+ARROW_HEIGHT,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(leftW,left_callback);
      rightW=XcoCreateCommand(decorbox1,ARROW_SPACE*3+ARROW_WIDTH*2,
			     ARROW_SPACE*2+ARROW_HEIGHT,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(rightW,right_callback);
      deczW=XcoCreateCommand(decorbox1,ARROW_SPACE,
			     ARROW_SPACE,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(deczW,incz_callback);
      inczW=XcoCreateCommand(decorbox1,ARROW_SPACE,
			     ARROW_SPACE*3+ARROW_HEIGHT*2,
			     "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(inczW,decz_callback);
      zoominW=XcoCreateCommand(decorbox1,ARROW_SPACE*3+ARROW_WIDTH*2,
			     ARROW_SPACE*3+ARROW_HEIGHT*2,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(zoominW,zoomin_callback);
      zoomoutW=XcoCreateCommand(decorbox1,ARROW_SPACE*3+ARROW_WIDTH*2,
			     ARROW_SPACE,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(zoomoutW,zoomout_callback);
      rplayW=XcoCreateCommand(decorbox1,ARROW_SPACE*2+ARROW_WIDTH,
			     ARROW_SPACE*2+ARROW_HEIGHT,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(rplayW,rplay_callback);
      mplayW=XcoCreateCommand(decorbox2,ARROW_SPACE*3+ARROW_WIDTH*2,
			     5,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(mplayW,mplay_callback);
      mplayncW=XcoCreateCommand(decorbox2,ARROW_SPACE*4+ARROW_WIDTH*3,
			     5,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(mplayncW,mplaync_callback);
      playreverseW=XcoCreateCommand(decorbox2,ARROW_SPACE*2+ARROW_WIDTH,
			     5,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(playreverseW,playreverse_callback);
      playreversencW=XcoCreateCommand(decorbox2,ARROW_SPACE,
			     5,
			   "",ARROW_WIDTH,ARROW_HEIGHT);
      XcoAddCallback(playreversencW,playreversenc_callback);

      getlop_(&prevloop);
      looptoggle=XcoCreateToggle(maindecor,
				 4,CPANEL_HEIGHT-30,
				 10,10,
				 PIXEL(255,0,0),
				 1,prevloop);
      
      XcoAddCallback(looptoggle,looptoggle_callback);

      XcoCreateLabel(maindecor,4+4+10,CPANEL_HEIGHT-30,
		     "loop",0,0);
      

      if (!pixmaps_declared)
	{
	  uparrow=XcoCreatePixmapFromCimage(upW,uparrow_cimage,uparrow_width,uparrow_height);
	  downarrow=XcoCreatePixmapFromCimage(downW,downarrow_cimage,downarrow_width,downarrow_height);
	  leftarrow=XcoCreatePixmapFromCimage(leftW,leftarrow_cimage,leftarrow_width,leftarrow_height);
	  rightarrow=XcoCreatePixmapFromCimage(rightW,rightarrow_cimage,rightarrow_width,rightarrow_height);
	  deczarrow=XcoCreatePixmapFromCimage(deczW,deczarrow_cimage,deczarrow_width,deczarrow_height);
	  inczarrow=XcoCreatePixmapFromCimage(inczW,inczarrow_cimage,inczarrow_width,inczarrow_height);
	  zoominarrow=XcoCreatePixmapFromCimage(zoominW,zoominarrow_cimage,zoominarrow_width,zoominarrow_height);
	  zoomoutarrow=XcoCreatePixmapFromCimage(zoomoutW,zoomoutarrow_cimage,zoomoutarrow_width,zoomoutarrow_height);
	  rplayarrow=XcoCreatePixmapFromCimage(rplayW,rplayarrow_cimage,rplayarrow_width,rplayarrow_height);
	  stoparrow=XcoCreatePixmapFromCimage(rplayW,stoparrow_cimage,stoparrow_width,stoparrow_height);
	  mplayarrow=XcoCreatePixmapFromCimage(mplayW,rplayarrow_cimage,rplayarrow_width,rplayarrow_height);
	  mstoparrow=XcoCreatePixmapFromCimage(mplayW,stoparrow_cimage,stoparrow_width,stoparrow_height);
	  mplayncarrow=XcoCreatePixmapFromCimage(mplayncW,mplayncarrow_cimage,mplayncarrow_width,mplayncarrow_height);
	  playreversearrow=XcoCreatePixmapFromCimage(playreverseW,playreversearrow_cimage,playreversearrow_width,playreversearrow_height);
	  playreversencarrow=XcoCreatePixmapFromCimage(playreversencW,playreversencarrow_cimage,playreversencarrow_width,playreversencarrow_height);
	  pixmaps_declared=1;
	}
      
      rotpbackground(upW,uparrow);
      rotpbackground(downW,downarrow);
      rotpbackground(leftW,leftarrow);
      rotpbackground(rightW,rightarrow);
      rotpbackground(deczW,deczarrow);
      rotpbackground(inczW,inczarrow);
      rotpbackground(zoominW,zoominarrow);
      rotpbackground(zoomoutW,zoomoutarrow);
      rotpbackground(rplayW,rplayarrow);
      rotpbackground(mplayW,mplayarrow);
      rotpbackground(mplayncW,mplayncarrow);
      rotpbackground(playreverseW,playreversearrow);
      rotpbackground(playreversencW,playreversencarrow);

      XcoSetResizeMethod(upW,XcoUpLeft);
      XcoSetResizeMethod(downW,XcoUpLeft);
      XcoSetResizeMethod(leftW,XcoUpLeft);
      XcoSetResizeMethod(rightW,XcoUpLeft);
      XcoSetResizeMethod(deczW,XcoUpLeft);
      XcoSetResizeMethod(inczW,XcoUpLeft);
      XcoSetResizeMethod(zoominW,XcoUpLeft);
      XcoSetResizeMethod(zoomoutW,XcoUpLeft);
      XcoSetResizeMethod(rplayW,XcoUpLeft);
      XcoSetResizeMethod(mplayW,XcoUpLeft);
      XcoSetResizeMethod(mplayncW,XcoUpLeft);
      XcoSetResizeMethod(playreverseW,XcoUpLeft);
      XcoSetResizeMethod(playreversencW,XcoUpLeft);
      
      rot_open=1;

    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(rot_popup));
    }
}
