/* This is povraywrite.h
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#ifndef __povraywrite__
#define __povraywrite__

#define FIRST_PASS 0
#define SECOND_PASS 1

void povray_init_scene(char *filenamebase,int pass,double xc,double yc,double zc, double cshift);
void povray_write_bond(float x1,float y1,float z1,
		float x2,float y2,float z2,
		float radius,int r,int g,int b);
void povray_write_atom(float x1,float y1,float z1,
		float radius,int r,int g,int b);
void povray_write_triangle(float x1,float y1,float z1,
			   float x2,float y2,float z2,
			   float x3,float y3,float z3,
			   float nx1,float ny1,float nz1,
			   float nx2,float ny2,float nz2,
			   float nx3,float ny3,float nz3,
			   int r,int g,int b,float opacity);
void povray_write_text(float x1,float y1,float z1,float radius,int r,int g,int b,char *text);
void povray_write_light_source(float x1,float y1,float z1,
			       int r,int g,int b);
void povray_write_background_light(int r,int g,int b);
void povray_finish_scene();
void set_writeinc(int p);
void set_writeinc2(int p);

#endif
