#include <stdio.h> /* Needed for file operations */
#include <sys/types.h> /* Needed for pid_t etc */
#include <signal.h> /* Needed to send signals */
#include <unistd.h> /* Needed by sleep in this example program */
#include <math.h> /* Needed by this example program */

#define MYSIGNAL SIGUSR1 /* We will use this signal */

int main()
{
  FILE *myfile;
  unsigned long ymolpid;
  double time=0.; /* For this example program */
  myfile=fopen("ymolpid","r");
  fscanf(myfile,"%lu",&ymolpid);
  fclose(myfile);
  while(1) /* Forever */
    {

      int i;
      /* The filename can be changed in mdinterface.y4 */
      FILE *conffile=fopen("interface.mol","w");
      fprintf(conffile,"1\n"); /* One frame */
      fprintf(conffile,"8\n"); /* Eight atoms */
      for (i=0; i<8; i++)
	{
	  double x,y,z;
	  x=cos(2*3.14*i/8.+time);
	  y=sin(2*3.14*i/8.+time);
	  z=0.;
	  /* Write atom number and x, y and z coordinates to file */
	  fprintf(conffile,"1 %f %f %f\n",x,y,z);
	}
      fclose(conffile);
      time+=0.1;


      kill((pid_t)ymolpid,MYSIGNAL);
      /* We need to sleep for a while,
         so Ymol doesn't choke on too much
         input data */
      sleep(1);
    }
}

