/* This is importinterface.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */


static char rcsid[]="$Id: importinterface.c 109 2012-01-23 17:32:00Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Xco.h"
#include "fstring.h"
#include "ccinterface.h"
#include "userinterface.h"

static int import_dialog_open=0;
static char *ifilename;
static XcoObject import_options,decorbox;
static int mainstyle,substyle;

static void close_import_dialog()
{
  XcoDeleteObject(import_options);
  free( ifilename);
  import_dialog_open=0;
}

static XcoObject mainplist,subplist,subobjects,icrystal_toggle,iframetext_toggle,
  ibondrules_toggle,itriangles_toggle,iexplicitbonds_toggle,ilabel_toggle;


static void save_import_options();
static void setup_the_options();

void really_import_file()
{
    int nr;
    double value;

    /* simple import */
    nr=1;
    value=mainstyle;
    fiflag_(&nr,&value);
    nr=2;
    value=substyle;
    fiflag_(&nr,&value);

    /* fuzzmove=0.8 (not used by input format 2) */
    nr=3;
    value=0.8;
    fiflag_(&nr,&value);
    if (mainstyle==1)
    {
	nr=4;
	value=XcoGetToggleSelected(icrystal_toggle);
	fiflag_(&nr,&value);
	  
	nr=5;
	value=XcoGetToggleSelected(iframetext_toggle);
	fiflag_(&nr,&value);

	nr=6;
	value=XcoGetToggleSelected(ibondrules_toggle);
	fiflag_(&nr,&value);

	nr=7;
	value=XcoGetToggleSelected(itriangles_toggle);
	fiflag_(&nr,&value);

	nr=8;
	value=XcoGetToggleSelected(iexplicitbonds_toggle);
	fiflag_(&nr,&value);

	nr=9;
	value=XcoGetToggleSelected(ilabel_toggle);
	fiflag_(&nr,&value);
    }

    set_can_use_save(0);
    set_need_to_save();
    set_current_filename(ifilename);
    fimport_file(ifilename);

    close_import_dialog();
}

static void do_import_file(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      save_import_options();

      really_import_file();
    }
}

static void import_delete(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    close_import_dialog();
}

#if 0
void togglelist_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int i;
      int this_toggle=0;
      while ((toggles[this_toggle]!=id) && (this_toggle<N_TOGGLES))
	this_toggle++;
      if (toggles[this_toggle]==id)
	for (i=0; i<N_TOGGLES; i++)
	  XcoSetToggleSelected(toggles[i],(i==this_toggle));
    }
}
#endif

static void sublist_callback(XcoObject id,XEvent event)
{
  int action=XcoGetPulldownListStatus(id);
  if (action!=-1)
    {
      substyle=action;
    }  
}

static void mainlist_callback(XcoObject id,XEvent event)
{
  int action=XcoGetPulldownListStatus(id);
  if (action!=-1)
    {
      /* Style = action+1 */
      mainstyle=action+1;
      setup_the_options();
    }
}

#define IMPORT_WIDTH 200
#define IMPORT_HEIGHT 305

static char *mainnames[5]=
{
  "Simple x y z",
  "Gaussian 90/92/94/98",
  "Simple triangles",
  "Gamess",
  "MDSuS",
};

static char *subsimplenames[7]=
{
  "Z x y z",
  "x y z Z",
  "id Z x y z",
  "label x y z Z",
  "R W id Z x y z",
  "r g b R W id Z x y z",
  "Z x y z (mol logo)"
};

static char *subgaussiannames[3]=
{
  "Z-matrix",
  "Input orientation",
  "* orientation (g98)"
};

static char *subtrianglenames[1]=
{
  "x y z nx ny nz r g b rsv n"
};

static char *subgamessnames[2]=
{
  "COORDINATES OF ALL...",
  "COORDINATES OF SYM..."
};

static char *submdsusnames[1]=
{
  "Output format 5",
};


static void setup_the_options()
{
    XcoDeleteObject(subobjects);
    subobjects=XcoCreateHole(decorbox,10,80,IMPORT_WIDTH-25,IMPORT_HEIGHT-130);      
    switch(mainstyle)
    {
	case 1:
	    subplist=XcoCreatePulldownList(subobjects,0,0,subsimplenames,7,substyle,0,0);
	    XcoAddCallback(subplist,sublist_callback);
	    icrystal_toggle=XcoCreateToggle(subobjects,5,25,10,10,PIXEL(255,0,0),1,0);
	    XcoCreateLabel(subobjects,25,25,"Read crystal coordinates",0,0);
	    iframetext_toggle=XcoCreateToggle(subobjects,5,50,10,10,PIXEL(255,0,0),1,0);
	    ibondrules_toggle=XcoCreateToggle(subobjects,5,75,10,10,PIXEL(255,0,0),1,0);
	    XcoCreateLabel(subobjects,25,75,"No bondrules",0,0);
	    XcoCreateLabel(subobjects,25,50,"Read frametext",0,0);
	    itriangles_toggle=XcoCreateToggle(subobjects,5,100,10,10,PIXEL(255,0,0),1,0);
	    XcoCreateLabel(subobjects,25,100,"Read triangles",0,0);
	    iexplicitbonds_toggle=XcoCreateToggle(subobjects,5,125,10,10,PIXEL(255,0,0),1,0);
	    XcoCreateLabel(subobjects,25,125,"Explicit bonds",0,0);
	    ilabel_toggle=XcoCreateToggle(subobjects,5,150,10,10,PIXEL(255,0,0),1,0);
	    XcoCreateLabel(subobjects,25,150,"Read label",0,0);


	    break;
	case 2:
	    subplist=XcoCreatePulldownList(subobjects,0,0,subgaussiannames,3,substyle,0,0);
	    XcoAddCallback(subplist,sublist_callback);
	    break;
	case 3:
	    subplist=XcoCreatePulldownList(subobjects,0,0,subtrianglenames,1,substyle,0,0);
	    XcoAddCallback(subplist,sublist_callback);
	    break;
	case 4:
	    subplist=XcoCreatePulldownList(subobjects,0,0,subgamessnames,2,substyle,0,0);
	    XcoAddCallback(subplist,sublist_callback);
	    break;
	case 5:
	    subplist=XcoCreatePulldownList(subobjects,0,0,submdsusnames,1,substyle,0,0);
	    XcoAddCallback(subplist,sublist_callback);
	    break;
    }
}

#define IMPORT_OPTIONS_VERSION 1

static void save_import_options()
{
    FILE *f=fopen("ymol_import_options","w");
    fprintf(f,"%d\n",IMPORT_OPTIONS_VERSION);
    fprintf(f,"%d %d\n",mainstyle,substyle);
    if (mainstyle==1)
    {
	fprintf(f,"%d\n",XcoGetToggleSelected(icrystal_toggle));
	fprintf(f,"%d\n",XcoGetToggleSelected(iframetext_toggle));
	fprintf(f,"%d\n",XcoGetToggleSelected(ibondrules_toggle));
	fprintf(f,"%d\n",XcoGetToggleSelected(itriangles_toggle));
	fprintf(f,"%d\n",XcoGetToggleSelected(iexplicitbonds_toggle));
	fprintf(f,"%d\n",XcoGetToggleSelected(ilabel_toggle));
    }
    fclose(f);
}

static void load_import_options()
{
    FILE *f=fopen("ymol_import_options","r");
    if (f)
    {
	int version;
	fscanf(f,"%d",&version);
	if (version==IMPORT_OPTIONS_VERSION)
	{
	    fscanf(f,"%d %d",&mainstyle,&substyle);
	}
	setup_the_options();
	if (mainstyle==1)
	{
	    int value;
	    fscanf(f,"%d",&value);
	    XcoSetToggleSelected(icrystal_toggle,value);
	    fscanf(f,"%d",&value);
	    XcoSetToggleSelected(iframetext_toggle,value);
	    fscanf(f,"%d",&value);
	    XcoSetToggleSelected(ibondrules_toggle,value);
	    fscanf(f,"%d",&value);
	    XcoSetToggleSelected(itriangles_toggle,value);
	    fscanf(f,"%d",&value);
	    XcoSetToggleSelected(iexplicitbonds_toggle,value);
	    fscanf(f,"%d",&value);
	    XcoSetToggleSelected(ilabel_toggle,value);
	}
	fclose(f);
    }
    else
	setup_the_options();
}

void import_dialog(char *filename)
{
  if (!import_dialog_open)
    {
      int i;
      XcoObject ok,titlelabel,hole0,label0,hole1,label1,hole2,label2,hole3,label3;
      const unsigned int redpixel=PIXEL(255,0,0);
      ifilename=malloc((strlen(filename)+1));
      strcpy(ifilename,filename);
      import_options=XcoCreateNamedWindow(0,0,IMPORT_WIDTH,IMPORT_HEIGHT,DEFAULT_BACKGROUND,1,-1,"Import options");
      XcoAddCallback(import_options,import_delete);
      ok=XcoCreateCommand(import_options,10,IMPORT_HEIGHT-30,"Import",0,0);
      XcoAddCallback(ok,do_import_file);
      decorbox=XcoCreateBox3D(import_options,5,5,IMPORT_WIDTH-10,IMPORT_HEIGHT-45,2,1);
      titlelabel=XcoCreateLabel(decorbox,10,10,"Input format",0,0);
      mainplist=XcoCreatePulldownList(decorbox,10,30,mainnames,5,0,0,0);
      XcoAddCallback(mainplist,mainlist_callback);
      XcoCreateLabel(decorbox,10,60,"Substyle",0,0);
      subobjects=XcoCreateHole(decorbox,10,80,IMPORT_WIDTH-25,IMPORT_HEIGHT-130);


      mainstyle=1;
      substyle=0;

      load_import_options();

      import_dialog_open=1;
    }
}
