      /* This is import.F
      A part of the Ymol program
      Copyright (C) 1997-2001 Daniel Spangberg
      */

#include "maxs.h"
#include "defaults.h"

      subroutine simplefimp(filename,ok)
      implicit double precision (a-h,o-z)
#include "import.commonblock"
#include "world.commonblock"
      character*(*) filename
      character*120 tempdirname
      integer ok
      itype=nint(flagvalue(1))
      ok=0
      if (itype.eq.1) then
         isubtype=nint(flagvalue(2))
         icrystal=nint(flagvalue(4))
         icrystalnofrac=0

         call simple_import(filename,isubtype,
     x        flagvalue(3),nint(flagvalue(5)),nint(flagvalue(7)),
     x        nint(flagvalue(8)),nint(flagvalue(9)),ok)
      else if (itype.eq.2) then
         isubtype=nint(flagvalue(2))
         icrystal=0
         call gaussian_import(filename,isubtype,ok)
      else if (itype.eq.3) then
         isubtype=nint(flagvalue(2))
         icrystal=0
         call triangle_import(filename,isubtype,ok)
      else if (itype.eq.4) then
         isubtype=nint(flagvalue(2))
         icrystal=0
         call gamess_import(filename,isubtype,ok)
      else if (itype.eq.5) then
         isubtype=nint(flagvalue(2))
         icrystal=0
         call mdsus_import(filename,isubtype,ok)
      else
         call errmsg('Unknown import type')
         call upderr
      endif
      if (ok.eq.0) then
         call cldta
       else
         if (icrystal.eq.1) then
C     if it is a crystal set mass centrum to the middle of the box
           mass_x=0.5d0
           mass_y=0.5d0
           mass_z=0.5d0
           call mymatmul(xcrystal,mass_x,mass_y,mass_z)
         endif
      endif

      return
      end

      subroutine fimp(filename)
      implicit double precision (a-h,o-z)
      character*(*) filename
      character*(1000) globalstylefile
      integer ok
      logical styleexist
      logical globalstyleexist
#include "import.commonblock"
#include "bondrule.commonblock"
#include "world.commonblock"
      inquire(file='style.ymol',exist=styleexist)
      call ggstf(globalstylefile)
      inquire(file=globalstylefile,exist=globalstyleexist)
c     Default atom parameters
      call read_tables
c     Default bond rules
      call sdefbr
      call init_t_matrix
c     Some other default parameters:
      call sufog(0)
      call sfogp(5.d0)
      call sfogp2(0.4d0)
      call sfade(255)
      call dsset(DRAW_STYLE_2D_CIRCLES)
      call sbkgrc(255*(1+256+65536))
      call dlbl(0)
      call sframe(1)
      iforcetriangles=0
      itriqual=10
      ishowprogress=1
      call simplefimp(filename,ok)
      ishowprogress=0
      if (ok.eq.1) then
         call setany(1)
         if (styleexist) then
           call floads('style.ymol',ok)
         else
           if (globalstyleexist) then
             call floads(globalstylefile,ok)
           endif
         endif
         if (ok.eq.1) then
           if (nint(flagvalue(1)).ne.3) then
             if ((nint(flagvalue(6)).eq.0).and.
     x            (nint(flagvalue(8)).eq.0)) then
c     Apply bond rules
               ishowprogress=1
               call mabr
               ishowprogress=0
               ishowprogress=1
C     If we read triangles we cannot do polyhedral rules!
               if (nint(flagvalue(7)).eq.0) then
                  call mapr
               endif
               ishowprogress=0
             else
               nbondrules=0            
             endif
           else
             nbondrules=0
           endif
         endif
         call wupd
       endif
       call execute_update_functions
      return
      end

      subroutine sfimp(filename)
      implicit double precision (a-h,o-z)
      character*(*) filename
      integer ok
#include "import.commonblock"
      ishowprogress=0
      call simplefimp(filename,ok)
      call setany(1)
      return
      end

      subroutine sdefbr
      implicit double precision (a-h,o-z)
#include "bondrule.commonblock"
c     default bondrules
      nbondrules=2
      ndonors(1)=0
      nacceptors(1)=0
      fuzzfactor(1)=0.3d0
      colors(1)=65536*BOND_DEFAULT_R+
     x     256*BOND_DEFAULT_G+BOND_DEFAULT_B
      bondrulename(1)='Covalent bond'
      bondrulen(1)=20
      bondrulenslice(1)=1
      bondrulersv(1)=0.75
      bondrulewidth(1)=0.1
      vdwsub(1)=1
      ndonors(2)=1
      nacceptors(2)=3
      donors(2,1)=1
      acceptors(2,1)=7
      acceptors(2,2)=8
      acceptors(2,3)=9
      fuzzfactor(2)=0.8d0
      colors(2)=65536*250+256*250+1*10
      bondrulename(2)='Hydrogen bond'
      bondrulen(2)=20
      bondrulenslice(2)=0
      bondrulersv(2)=0.75
      bondrulewidth(2)=0.05
      vdwsub(2)=1
      return
      end


      subroutine fiflag(nr,value)
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      flagvalue(nr)=value
      return
      end

      subroutine mdsus_import(filename,substyle,ok)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
#include "import.commonblock"
#include "world.commonblock"
      character*(*) filename
      character*FMAXCHARSPERLABEL lbl
      integer atoms,bonds
      integer object,substyle,ok
      integer ntypes(1000)
      double precision h(3,3)
      if (ishowprogress.eq.1) object=ixcopw('Importing...')
      ok=1
c     compute mass centrum and bounds
c     store all data in temporary file
      bound_xmin=HUGE_FACTOR
      bound_ymin=HUGE_FACTOR
      bound_zmin=HUGE_FACTOR
      bound_xmax=-HUGE_FACTOR
      bound_ymax=-HUGE_FACTOR
      bound_zmax=-HUGE_FACTOR

      icurrentatomid=0

C     always one frame
      nframes=1 
      nworld=nframes+1
      call initialize_memory(nframes)

      iflen=LEN(filename)
      open(unit=1,file=filename(1:iflen),status='old',
     x     form='formatted',err=112)

      read(1,*,err=112,end=112) nc,ns

      if (.not.((ns.eq.0).or.(nc.eq.ns))) goto 112

      read(1,*,err=112,end=112) (ntypes(i),i=1,nc)

      do i=1,3
        read(1,*,err=112,end=112) (h(j,i),j=1,3)
      enddo

      natomsx=0
      do i=1,nc
        natomsx=natomsx+ntypes(i)
      enddo

      natomsinframe=natomsx
      if (nc.eq.ns) natomsinframe=natomsinframe*2
      
      xframepart=1.d0/dble(nframes)
      iframe=0

      av_x=0
      av_y=0
      av_z=0
      
      xlocal=0
      ylocal=0
      zlocal=0
      weight=0

      iframe=iframe+1
      call initialize_frame(iframe,natomsinframe,0,0)
      do iatom=1,natomsinframe
        read(1,*,err=112,end=112) inr,xtmp,ytmp,ztmp,q

C     multiply by H matrix
        x=h(1,1)*xtmp+h(2,1)*ytmp+h(3,1)*ztmp
        y=h(1,2)*xtmp+h(2,2)*ytmp+h(3,2)*ztmp
        z=h(1,3)*xtmp+h(2,3)*ytmp+h(3,3)*ztmp

        if (iatom.gt.natomsx) then
C     shell
          call get_atomxyz(iframe,iatom-1-natomsx,xtmp,ytmp,ztmp)
          x=x+xtmp
          y=y+ytmp
          z=z+ztmp
        endif

        icurrentatomid=iatom
        call set_atomxyz(iframe,iatom-1,x,y,z)
        call set_atomscalerad(iframe,iatom-1,1.d0)
        call set_atomnr(iframe,iatom-1,inr)
        call set_atomid(iframe,iatom-1,icurrentatomid)
        if (x.lt.bound_xmin) bound_xmin=x
        if (y.lt.bound_ymin) bound_ymin=y
        if (z.lt.bound_zmin) bound_zmin=z
        if (x.gt.bound_xmax) bound_xmax=x
        if (y.gt.bound_ymax) bound_ymax=y
        if (z.gt.bound_zmax) bound_zmax=z
        w=atom_weight(inr)
        xlocal=xlocal+x*w
        ylocal=ylocal+y*w
        zlocal=zlocal+z*w
        weight=weight+w
        call set_defradweight(iframe,iatom-1,1)
        call set_defcol(iframe,iatom-1,1)
        call set_atomdrawstyle(iframe,iatom-1,1)
        call set_deflabel(iframe,iatom-1,1)
        write(lbl,'(f5.2)') q
        call set_atomlabel(iframe,iatom-1,lbl)
        call set_atomhasmessage(iframe,iatom-1,0)
      enddo
      call set_hasframetext(iframe,0)
      av_x=av_x+xlocal/weight
      av_y=av_y+ylocal/weight
      av_z=av_z+zlocal/weight

      mass_x=av_x/dble(nframes)
      mass_y=av_y/dble(nframes)
      mass_z=av_z/dble(nframes)
      
      bound_xmin=bound_xmin-mass_x
      bound_ymin=bound_ymin-mass_y
      bound_zmin=bound_zmin-mass_z
      bound_xmax=bound_xmax-mass_x
      bound_ymax=bound_ymax-mass_y
      bound_zmax=bound_zmax-mass_z
      bound=dabs(bound_xmin)
      if (dabs(bound_ymin).gt.bound) bound=dabs(bound_ymin)
      if (dabs(bound_zmin).gt.bound) bound=dabs(bound_zmin)
      if (dabs(bound_xmax).gt.bound) bound=dabs(bound_xmax)
      if (dabs(bound_ymax).gt.bound) bound=dabs(bound_ymax)
      if (dabs(bound_zmax).gt.bound) bound=dabs(bound_zmax)
      call def_unit(bound+0.5d0)

      nmessages=0
      goto 115
 112  continue
      call errmsg('Unable to import file.')
      call upderr
      ok=0
 115  continue
      close(1)
      if (ishowprogress.eq.1) call xcodel(object)
c     This is necessary to make routines that check the nworld buffer work,
c     if they try to access it between the exit of this routnine, and before
c     the start of the next build_world call
      call get_frame_is_initialized(nworld,no)
      if (no.eq.1) then
         call deinitialize_frame(nworld)
      endif
      return
      end

      subroutine gatwgh(nr,w)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
      w=atom_weight(nr)
      return
      end

      subroutine smxyz(x,y,z)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      mass_x=x
      mass_y=y
      mass_z=z
      return
      end

      subroutine sbound(x)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
      bound=x
      return
      end
    

      subroutine simple_import(filename,substyle,
     x     fuzzmove,itextread,itriangles,iexpbond,ilblread,ok)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
#include "import.commonblock"
#include "world.commonblock"
      character*(*) filename
      character*80 tempfile
      double precision fuzzmove
      integer atoms,bonds
      integer object,substyle,ok
      character*FMAXCHARSPERLABEL lbl
      character*FMAXCHARSINFRAMETEXT myframetext
      character*1000 tmpline

      if (ishowprogress.eq.1) object=ixcopw('Importing...')
      ok=1


c     compute mass centrum and bounds
c     store all data in temporary file
      bound_xmin=HUGE_FACTOR
      bound_ymin=HUGE_FACTOR
      bound_zmin=HUGE_FACTOR
      bound_xmax=-HUGE_FACTOR
      bound_ymax=-HUGE_FACTOR
      bound_zmax=-HUGE_FACTOR

      av_x=0
      av_y=0
      av_z=0

      icurrentatomid=0

      iflen=LEN(filename)
      open(unit=1,file=filename(1:iflen),status='old',
     x     form='formatted',err=112)
      read(1,*,err=112,end=112) nframes
      nworld=nframes+1
      call initialize_memory(nframes)
      notheratoms=0
      xframepart=1.d0/dble(nframes)
      do iframe=1,nframes
         xlocal=0
         ylocal=0
         zlocal=0
         weight=0
         if (ishowprogress.eq.1) then
            x_handle=dble(iframe-1)*xframepart
            call xcopws(object,x_handle)
         endif
         nbuffer=MOD(iframe,2)+1
         notherbuffer=3-nbuffer
         if (itextread.ne.0) then
            read(1,'(a)',err=112,end=112) myframetext
            call fscs(myframetext)
         endif
         if (icrystal.ne.0) then
           read (1,'(a)',err=112,end=112) tmpline
            read(tmpline,*,err=1234,end=1234) xcrystal(1),xcrystal(2),
     x          xcrystal(3),xcrystal(4),xcrystal(5),
     x          xcrystal(6),xcrystal(7),xcrystal(8),
     x          xcrystal(9)
            icrystalnofrac=1
c            write (*,*) 'imported a file where icrystal=',icrystal
            goto 1235
 1234      continue
            read(tmpline,*,err=112,end=112) a_crystal,
     x          b_crystal,c_crystal,
     x           alpha_crystal,beta_crystal,gamma_crystal
            call compute_crystal_matrix
 1235       continue
         endif
         if (iexpbond.ne.0) then
            if (itriangles.ne.0) then
               read(1,*,err=112,end=112) natoms,
     x              nexpbond,ntriangles
            else
               read(1,*,err=112,end=112) natoms,nexpbond
               ntriangles=0
            endif
         else
            if (itriangles.ne.0) then
               read(1,*,err=112,end=112) natoms,ntriangles
c               write(*,*)'imp. natoms=',natoms,' ntriangles=',ntriangles
            else
               read(1,*,err=112,end=112) natoms
               ntriangles=0
            endif
            nexpbond=0
         endif
         if (nbuffer.eq.1) then
            nbufferid=0
            notherbufferid=nworld
         else
            nbufferid=nworld
            notherbufferid=0
         endif
         call initialize_frame(nbufferid,natoms,nexpbond,
     x        ntriangles*3)
         if (icrystal.ne.0) then
            call initialize_frame(iframe,natoms+8,nexpbond,
     x           ntriangles*3)
         else
            call initialize_frame(iframe,natoms,nexpbond,
     x           ntriangles*3)
         endif
         if (itextread.ne.0) then
            call set_hasframetext(iframe,1)
            call set_frametextxy(iframe,0.5d0,0.1d0)
            call set_frametext(iframe,myframetext)
         else
            call set_hasframetext(iframe,0)
         endif
c     read atom
         do iatom=1,natoms
            if ((substyle.eq.0).or.(substyle.eq.6)) then
               if (ilblread.ne.0) then
                  read(1,*,err=112,end=112) lbl,nnr,xc,yc,zc
               else
                  read(1,*,err=112,end=112) nnr,xc,yc,zc
               endif
            else if (substyle.eq.1) then
               if (ilblread.ne.0) then
                  read(1,*,err=112,end=112) lbl,xc,yc,zc,nnr
               else
                  read(1,*,err=112,end=112) xc,yc,zc,nnr
               endif
            else if (substyle.eq.2) then
               if (ilblread.ne.0) then
                  read(1,*,err=112,end=112) lbl,icurrentatomid,nnr,xc,yc
     x                ,zc
               else
                  read(1,*,err=112,end=112) icurrentatomid,nnr,xc,yc,zc
               endif
            else if (substyle.eq.3) then
               read(1,*,err=112,end=112) lbl,xc,yc,zc,nnr
            else if (substyle.eq.4) then
               if (ilblread.ne.0) then
                  read(1,*,err=112,end=112) lbl,radmy,weightmy,
     x                 icurrentatomid,nnr,xc,yc,zc
               else
                  read(1,*,err=112,end=112) radmy,weightmy,
     x                 icurrentatomid,nnr,xc,yc,zc
               endif
            else if (substyle.eq.5) then
               if (ilblread.ne.0) then
                  read(1,*,err=112,end=112) lbl,red,green,blue,
     x                 radmy,weightmy,
     x                 icurrentatomid,nnr,xc,yc,zc
               else
                  read(1,*,err=112,end=112) red,green,blue,
     x                 radmy,weightmy,
     x                 icurrentatomid,nnr,xc,yc,zc
               endif
            endif
            if ((nnr.lt.1).or.(nnr.gt.256)) then
               call errmsg(
     x 'Fatal: Atoms can not have a Z less than 1 or larger than 256')
               goto 112
            endif
            if (icrystal.ne.0) then
c               write(*,*) 'before:',xc,yc,zc
              if (icrystalnofrac.eq.0) call crystal_atom_pos(xc,yc,zc)
c               write(*,*) 'after:',xc,yc,zc
            endif
            if ((substyle.eq.2).or.(substyle.eq.4).or.(substyle.eq.5)
     x           .or.(iframe.eq.1)) then
               call set_atomxyz(nbufferid,iatom-1,xc,yc,zc)
               call set_atomscalerad(nbufferid,iatom-1,1.d0)
               call set_atomnr(nbufferid,iatom-1,nnr)
               call set_atomid(nbufferid,iatom-1,icurrentatomid)
c     Check ID so it is not duplicate
               if ((substyle.eq.2).or.(substyle.eq.4).or.
     x              (substyle.eq.5)) then
                  if (iatom.ne.1) then
                     do jtest=1,iatom-1
                        call get_atomid(nbufferid,jtest-1,itmp)
                        if (icurrentatomid.eq.
     x                       itmp) then
                           call errmsg(
     x 'Warning: Duplicate atom identification number.')

                        endif
                     enddo
                  endif
               else
                  icurrentatomid=icurrentatomid+1
               endif
            else
c     identify atom
c     This algorithm is too simple.
               jatom=1
 20            continue
               if (jatom.gt.notheratoms) goto 10
               call get_atomnr(notherbufferid,jatom-1,nnr2)
               if (nnr.eq.nnr2) then
                  call get_atomxyz(notherbufferid,jatom-1,xc2,yc2,zc2)
                  xd=xc-xc2
                  yd=yc-yc2
                  zd=zc-zc2
                  dist=sqrt(xd*xd+yd*yd+zd*zd)
                  if (dist.lt.fuzzmove) then
                     call get_atomid(notherbufferid,jatom-1,idatomid)
                     goto 10
                  endif
               endif
               jatom=jatom+1
               goto 20
 10            continue
               if (jatom.gt.notheratoms) then
c     was not identified
                  idatomid=icurrentatomid
                  icurrentatomid=icurrentatomid+1
               endif
               call set_atomxyz(nbufferid,iatom-1,xc,yc,zc)
               call set_atomscalerad(nbufferid,iatom-1,1.d0)
               call set_atomnr(nbufferid,iatom-1,nnr)
               call set_atomid(nbufferid,iatom-1,idatomid)
            endif
c     write coordinates etc. the last three ones mean:
c     default radius/weight
c     default color
c     drawtype=ball and stick
            call get_atomid(nbufferid,iatom-1,i1)
            call get_atomnr(nbufferid,iatom-1,inr)
            call get_atomxyz(nbufferid,iatom-1,x,y,z)
            if (x.lt.bound_xmin) bound_xmin=x
            if (y.lt.bound_ymin) bound_ymin=y
            if (z.lt.bound_zmin) bound_zmin=z
            if (x.gt.bound_xmax) bound_xmax=x
            if (y.gt.bound_ymax) bound_ymax=y
            if (z.gt.bound_zmax) bound_zmax=z
            w=atom_weight(inr)
            xlocal=xlocal+x*w
            ylocal=ylocal+y*w
            zlocal=zlocal+z*w
            weight=weight+w
            call set_atomid(iframe,iatom-1,i1)
            call set_atomnr(iframe,iatom-1,inr)
            call set_atomxyz(iframe,iatom-1,x,y,z)
            call set_atomscalerad(iframe,iatom-1,1.d0)
            if ((substyle.eq.4).or.(substyle.eq.5)) then
               call set_defradweight(iframe,iatom-1,0)
               call set_atomrad(iframe,iatom-1,radmy)
               call set_atomweight(iframe,iatom-1,weightmy)
               if (substyle.eq.5) then
                  call set_defcol(iframe,iatom-1,0)
                  call set_atomr(iframe,iatom-1,nint(255*red))
                  call set_atomg(iframe,iatom-1,nint(255*green))
                  call set_atomb(iframe,iatom-1,nint(255*blue))
                  call set_atomn(iframe,iatom-1,20)
                  call set_atomrsv(iframe,iatom-1,0.7d0)
               else
                  call set_defcol(iframe,iatom-1,1)
               endif
            else
               call set_defradweight(iframe,iatom-1,1)
               call set_defcol(iframe,iatom-1,1)
            endif
            call set_atomdrawstyle(iframe,iatom-1,1)
            if ((ilblread.ne.0).or.(substyle.eq.3)) then
               call set_deflabel(iframe,iatom-1,1)
            else
               call set_deflabel(iframe,iatom-1,0)
               lbl='  '
            endif
            call set_atomlabel(iframe,iatom-1,lbl)
            call set_atomhasmessage(iframe,iatom-1,0)
         enddo
         if (iexpbond.ne.0) then
            do ieb=1,nexpbond
               call set_drawbond(iframe,ieb-1,1)
               read(1,*,err=112,end=112) int1,int2,
     x              red,green,blue,xrsv,n,xra
c     find int3 and int4
               call get_atomid(iframe,int1-1,int3)
               call get_atomid(iframe,int2-1,int4)
               call set_bondp(iframe,ieb-1,int1,int2,int3,int4)
               call set_bond1(iframe,ieb-1,int1)
               call set_bond2(iframe,ieb-1,int2)
               call set_defbcol(iframe,ieb-1,0)
               call set_bondr1(iframe,ieb-1,nint(red*255))
               call set_bondg1(iframe,ieb-1,nint(green*255))
               call set_bondb1(iframe,ieb-1,nint(blue*255))
               call set_bondrsv1(iframe,ieb-1,xrsv)
               call set_bondn1(iframe,ieb-1,n)
               nslice=0
               call set_bondnslice(iframe,ieb-1,nslice)
               call set_bondrad1(iframe,ieb-1,xra)
            enddo
         endif
         if (itriangles.ne.0) then
c            write(*,*) 'reading triangles: ',ntriangles
            do it=1,ntriangles*3
               read(1,*,err=112,end=112) x,y,z,tnx,tny,tnz,
     x              nr,ng,nb,rsv1,nn,opaq,ntwo
               call set_triangle(iframe,it-1,x,y,z,tnx,tny,tnz,
     x              rsv1,opaq,nr,ng,nb,nn,ntwo)
               
               if (x.lt.bound_xmin) bound_xmin=x
               if (y.lt.bound_ymin) bound_ymin=y
               if (z.lt.bound_zmin) bound_zmin=z
               if (x.gt.bound_xmax) bound_xmax=x
               if (y.gt.bound_ymax) bound_ymax=y
               if (z.gt.bound_zmax) bound_zmax=z
               
               xlocal=xlocal+x*.1
               ylocal=ylocal+y*.1
               zlocal=zlocal+z*.1
               weight=weight+.1
            enddo
         endif
         if (icrystal.ne.0) then
            iatom=natoms
            do ih=0,1
               do ik=0,1
                  do il=0,1
                     x=dble(ih)
                     y=dble(ik)
                     z=dble(il)
                     call crystal_atom_pos(x,y,z)
                     iatom=iatom+1
                     if (x.lt.bound_xmin) bound_xmin=x
                     if (y.lt.bound_ymin) bound_ymin=y
                     if (z.lt.bound_zmin) bound_zmin=z
                     if (x.gt.bound_xmax) bound_xmax=x
                     if (y.gt.bound_ymax) bound_ymax=y
                     if (z.gt.bound_zmax) bound_zmax=z
                     call set_atomid(iframe,iatom-1,
     x                    iatom-natoms+1000000000)
c     Special id 256:
                     call set_atomnr(iframe,iatom-1,256)
                     call set_atomxyz(iframe,iatom-1,x,y,z)
                     call set_atomscalerad(iframe,iatom-1,1.d0)
                     call set_defradweight(iframe,iatom-1,0)
                     call set_atomrad(iframe,iatom-1,0.d0)
                     call set_atomweight(iframe,iatom-1,0.d0)
                     call set_defcol(iframe,iatom-1,1)
                     call set_atomdrawstyle(iframe,iatom-1,1)
                     call set_deflabel(iframe,iatom-1,0)
                     lbl='  '
                     call set_atomlabel(iframe,iatom-1,lbl)
                     call set_atomhasmessage(iframe,iatom-1,0)
                  enddo
               enddo
            enddo
            call set_crystal_matrix(iframe,xcrystal)
         endif
         notheratoms=natoms
         av_x=av_x+xlocal/weight
         av_y=av_y+ylocal/weight
         av_z=av_z+zlocal/weight
      enddo
      mass_x=av_x/dble(nframes)
      mass_y=av_y/dble(nframes)
      mass_z=av_z/dble(nframes)
      
      bound_xmin=bound_xmin-mass_x
      bound_ymin=bound_ymin-mass_y
      bound_zmin=bound_zmin-mass_z
      bound_xmax=bound_xmax-mass_x
      bound_ymax=bound_ymax-mass_y
      bound_zmax=bound_zmax-mass_z
      bound=dabs(bound_xmin)
      if (dabs(bound_ymin).gt.bound) bound=dabs(bound_ymin)
      if (dabs(bound_zmin).gt.bound) bound=dabs(bound_zmin)
      if (dabs(bound_xmax).gt.bound) bound=dabs(bound_xmax)
      if (dabs(bound_ymax).gt.bound) bound=dabs(bound_ymax)
      if (dabs(bound_zmax).gt.bound) bound=dabs(bound_zmax)
      call def_unit(bound+0.5d0)

      nmessages=0
      goto 115
 112  continue
      call errmsg('Unable to import file.')
      call upderr
      ok=0
 115  continue
      close(1)
      if (ok.eq.1) then
         if (substyle.eq.6) then
            call hueize_atoms
         endif
      endif
      if (ishowprogress.eq.1) call xcodel(object)
c     This is necessary to make routines that check the nworld buffer work,
c     if they try to access it between the exit of this routnine, and before
c     the start of the next build_world call
      call get_frame_is_initialized(nworld,no)
      if (no.eq.1) then
         call deinitialize_frame(nworld)
      endif
      return
      end

      subroutine hueize_atoms
      implicit double precision (a-h,o-z)
#include "bondrule.commonblock"
      min=10
      max=20
      md=max-min
      nbondrules=0
      ifromr=512
      ifromg=0
      ifromb=0
      itor=0
      itog=255
      itob=0
      ito2r=0
      ito2g=0
      ito2b=255
      ihalf=(min+max)/2
      do i=min,max
c         ir=127+128*(sin(3.14159*2*(((i-min)+0)/dble(md))))
c         ig=127+128*(sin(3.14159*2*(((i-min)+md/3)/dble(md))))
c         ib=127+128*(sin(3.14159*2*(((i-min)+(2*md)/3)/dble(md))))
         if (i.lt.ihalf) then
            ir=2*(itor*(i-min)+ifromr*(ihalf-i))/md
            ig=2*(itog*(i-min)+ifromg*(ihalf-i))/md
            ib=2*(itob*(i-min)+ifromb*(ihalf-i))/md
         else
            ir=2*(ito2r*(i-ihalf)+itor*(max-i))/md
            ig=2*(ito2g*(i-ihalf)+itog*(max-i))/md
            ib=2*(ito2b*(i-ihalf)+itob*(max-i))/md
         endif
#if 1
c     Intensity correct
         ins=ir+ig+ib
         myins=600
         ir=ir*myins/ins
         ig=ig*myins/ins
         ib=ib*myins/ins
#endif
         if (ir.gt.255) ir=255
         if (ig.gt.255) ig=255
         if (ib.gt.255) ib=255
         if (ir.lt.0) ir=0
         if (ig.lt.0) ig=0
         if (ib.lt.0) ib=0

         call sdarad(i,0.05d0)
         call sdargb(i,ir,ig,ib)
         nbondrules=nbondrules+1
         ndonors(nbondrules)=1
         nacceptors(nbondrules)=1
c     Distance in one dimension is 0.1 Bohr == 0.05291 Angstroms =>
c     Factor to correct for just a bit more than one dimension
         ffaca=0.25d0
         ffac=2.d0
         fuzzfactor(nbondrules)=ffaca*ffac
         colors(nbondrules)=65536*ib+256*ig+1*ir
         bondrulename(nbondrules)='Field'
         bondrulen(nbondrules)=20
         bondrulersv(nbondrules)=0.75
         bondrulewidth(nbondrules)=0.005
         vdwsub(nbondrules)=0
         donors(nbondrules,1)=i
         acceptors(nbondrules,1)=i
      enddo
      return
      end

      subroutine triangle_import(filename,isubstyle,ok)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
#include "import.commonblock"
#include "world.commonblock"
      character*(*) filename
      integer ok,object
      ok=1
      if (ishowprogress.eq.1) object=ixcopw('Importing...')

c     compute mass centrum and bounds
c     store all data in temporary file
      bound_xmin=HUGE_FACTOR
      bound_ymin=HUGE_FACTOR
      bound_zmin=HUGE_FACTOR
      bound_xmax=-HUGE_FACTOR
      bound_ymax=-HUGE_FACTOR
      bound_zmax=-HUGE_FACTOR

      av_x=0
      av_y=0
      av_z=0

      iflen=LEN(filename)
      open(unit=1,file=filename(1:iflen),status='old',
     x     form='formatted',err=112)

      read(1,*,err=112,end=112) nframes
      nworld=nframes+1
      call initialize_memory(nframes)
      xframepart=1.0/dble(nframes)
      do iframe=1,nframes
         xlocal=0
         ylocal=0
         zlocal=0
         weight=0
         if (ishowprogress.eq.1) then
            x_handle=dble(iframe-1)*xframepart
            call xcopws(object,x_handle)
         endif
         read(1,*,err=112,end=112) ntriangles
         call initialize_frame(iframe,0,0,ntriangles*3)
         do it=1,ntriangles*3
            read(1,*,err=112,end=112) x,y,z,tnx,tny,tnz,
     x           nr,ng,nb,rsv1,nn,opaq,ntwo
            call set_triangle(iframe,it-1,x,y,z,tnx,tny,tnz,
     x           rsv1,opaq,nr,ng,nb,nn,ntwo)

            if (x.lt.bound_xmin) bound_xmin=x
            if (y.lt.bound_ymin) bound_ymin=y
            if (z.lt.bound_zmin) bound_zmin=z
            if (x.gt.bound_xmax) bound_xmax=x
            if (y.gt.bound_ymax) bound_ymax=y
            if (z.gt.bound_zmax) bound_zmax=z

            xlocal=xlocal+x
            ylocal=ylocal+y
            zlocal=zlocal+z
         enddo
         if (ntriangles.gt.0) then
            av_x=av_x+xlocal/dble(ntriangles*3)
            av_y=av_y+ylocal/dble(ntriangles*3)
            av_z=av_z+zlocal/dble(ntriangles*3)
         endif
      enddo
      mass_x=av_x/dble(nframes)
      mass_y=av_y/dble(nframes)
      mass_z=av_z/dble(nframes)

      bound_xmin=bound_xmin-mass_x
      bound_ymin=bound_ymin-mass_y
      bound_zmin=bound_zmin-mass_z
      bound_xmax=bound_xmax-mass_x
      bound_ymax=bound_ymax-mass_y
      bound_zmax=bound_zmax-mass_z
      bound=dabs(bound_xmin)
      if (dabs(bound_ymin).gt.bound) bound=dabs(bound_ymin)
      if (dabs(bound_zmin).gt.bound) bound=dabs(bound_zmin)
      if (dabs(bound_xmax).gt.bound) bound=dabs(bound_xmax)
      if (dabs(bound_ymax).gt.bound) bound=dabs(bound_ymax)
      if (dabs(bound_zmax).gt.bound) bound=dabs(bound_zmax)
      call def_unit(bound+0.5d0)

      goto 115
 112  continue
      call errmsg('Unable to import file.')
      call upderr
      ok=0
 115  continue
      close(1)
      if (ishowprogress.eq.1) call xcodel(object)
      call get_frame_is_initialized(nworld,no)
      if (no.eq.1) then
         call deinitialize_frame(nworld)
      endif
      return
      end


      subroutine gaussian_import(filename,substyle,ok)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
#include "import.commonblock"
#include "world.commonblock"
      character*(*) filename
      character*80 templine
      double precision fuzzmove
      integer atoms,bonds
      integer object,substyle,ok
      character*FMAXCHARSPERLABEL lbl
      integer natomsinframe(10000)
      if (ishowprogress.eq.1) object=ixcopw('Importing...')
      ok=1

c     compute mass centrum and bounds
c     store all data in temporary file
      bound_xmin=HUGE_FACTOR
      bound_ymin=HUGE_FACTOR
      bound_zmin=HUGE_FACTOR
      bound_xmax=-HUGE_FACTOR
      bound_ymax=-HUGE_FACTOR
      bound_zmax=-HUGE_FACTOR

      icurrentatomid=0

      iflen=LEN(filename)
      open(unit=1,file=filename(1:iflen),status='old',
     x     form='formatted',err=112)
c     Find number of frames...
      nframes=0
 1000 continue
      read(1,'(a80)',err=112,end=1112) templine
      if (substyle.eq.0) then
        if (index(templine,'Z-Matrix orientation').ne.0) then
          goto 1414
        endif
      else if (substyle.eq.1) then
        if (index(templine,'Input orientation').ne.0) then
         goto 1414
        endif
      else
        if (index(templine,'Input orientation').ne.0) goto 1414
        if (index(templine,'Z-Matrix orientation').ne.0) goto 1414
        if (index(templine,'Standard orientation').ne.0) goto 1414
      endif
      goto 1313
 1414 continue
         nframes=nframes+1
c     Skip junk lines...
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
c     Find number of atoms in this frame...
         natomsinframe(nframes)=0
 1010    continue
         read(1,*,err=1212,end=112) ix,ixn,xi,xi,xi
#if 1
         if (ixn.ge.1)
     x        natomsinframe(nframes)=natomsinframe(nframes)+1
#endif
#if 0
         natomsinframe(nframes)=natomsinframe(nframes)+1
#endif
         goto 1010
 1212    continue
 1313 continue     
      goto 1000
 1112 continue
      rewind 1
      nworld=nframes+1
      call initialize_memory(nframes)
      xframepart=1.d0/dble(nframes)
      iframe=0

      av_x=0
      av_y=0
      av_z=0
      
 2000 continue
      xlocal=0
      ylocal=0
      zlocal=0
      weight=0

      read(1,'(a80)',err=112,end=2112) templine
      if (substyle.eq.0) then
         ii=index(templine,'Z-Matrix orientation')
      else if (substyle.eq.1) then
         ii=index(templine,'Input orientation')
      else
         ii=index(templine,'Input orientation')
         if (ii.eq.0) ii=index(templine,'Z-Matrix orientation')
         if (ii.eq.0) ii=index(templine,'Standard orientation')
      endif
      if (ii.ne.0) then
         iframe=iframe+1
c     Skip junk lines...
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
c     Read atoms in this frame...
         call initialize_frame(iframe,natomsinframe(iframe),0,0)
         iatom=1
 2010    continue
         if (substyle.eq.2) then
            read(1,*,err=2212,end=112) icurrentatomid,inr,ijunk,x,y,z
         else
            read(1,*,err=2212,end=112) icurrentatomid,inr,x,y,z
         endif
         if (inr.ge.1) then
            call set_atomxyz(iframe,iatom-1,x,y,z)
            call set_atomscalerad(iframe,iatom-1,1.d0)
            call set_atomnr(iframe,iatom-1,inr)
            call set_atomid(iframe,iatom-1,icurrentatomid)
            if (x.lt.bound_xmin) bound_xmin=x
            if (y.lt.bound_ymin) bound_ymin=y
            if (z.lt.bound_zmin) bound_zmin=z
            if (x.gt.bound_xmax) bound_xmax=x
            if (y.gt.bound_ymax) bound_ymax=y
            if (z.gt.bound_zmax) bound_zmax=z
            w=atom_weight(inr)
            xlocal=xlocal+x*w
            ylocal=ylocal+y*w
            zlocal=zlocal+z*w
c            write(*,*) 'In for a laugh:',w
            weight=weight+w
            call set_defradweight(iframe,iatom-1,1)
            call set_defcol(iframe,iatom-1,1)
            call set_atomdrawstyle(iframe,iatom-1,1)
            call set_deflabel(iframe,iatom-1,0)
            lbl='  '
            call set_atomlabel(iframe,iatom-1,lbl)
            call set_atomhasmessage(iframe,iatom-1,0)
            iatom=iatom+1
         endif
         goto 2010
 2212    continue
         call set_hasframetext(iframe,0)
c         write(*,*) 'Hahahahehaa:',weight
         av_x=av_x+xlocal/weight
         av_y=av_y+ylocal/weight
         av_z=av_z+zlocal/weight
      endif
      goto 2000
 2112 continue
      mass_x=av_x/dble(nframes)
      mass_y=av_y/dble(nframes)
      mass_z=av_z/dble(nframes)
      
      bound_xmin=bound_xmin-mass_x
      bound_ymin=bound_ymin-mass_y
      bound_zmin=bound_zmin-mass_z
      bound_xmax=bound_xmax-mass_x
      bound_ymax=bound_ymax-mass_y
      bound_zmax=bound_zmax-mass_z
      bound=dabs(bound_xmin)
      if (dabs(bound_ymin).gt.bound) bound=dabs(bound_ymin)
      if (dabs(bound_zmin).gt.bound) bound=dabs(bound_zmin)
      if (dabs(bound_xmax).gt.bound) bound=dabs(bound_xmax)
      if (dabs(bound_ymax).gt.bound) bound=dabs(bound_ymax)
      if (dabs(bound_zmax).gt.bound) bound=dabs(bound_zmax)
      call def_unit(bound+0.5d0)

      nmessages=0
      goto 115
 112  continue
      call errmsg('Unable to import file.')
      call upderr
      ok=0
 115  continue
      close(1)
      if (ishowprogress.eq.1) call xcodel(object)
c     This is necessary to make routines that check the nworld buffer work,
c     if they try to access it between the exit of this routnine, and before
c     the start of the next build_world call
      call get_frame_is_initialized(nworld,no)
      if (no.eq.1) then
         call deinitialize_frame(nworld)
      endif
      return
      end


C     gamess_import is derived from gaussian_import Jan 19, 2001
      subroutine gamess_import(filename,substyle,ok)
      implicit double precision (a-h,o-z)
#include "table.commonblock"
#include "import.commonblock"
#include "world.commonblock"
      character*(*) filename
      character*80 templine
      double precision fuzzmove
      integer atoms,bonds
      integer object,substyle,ok
      character*FMAXCHARSPERLABEL lbl
      integer natomsinframe(10000)
      if (ishowprogress.eq.1) object=ixcopw('Importing...')
      ok=1

c     compute mass centrum and bounds
c     store all data in temporary file
      bound_xmin=HUGE_FACTOR
      bound_ymin=HUGE_FACTOR
      bound_zmin=HUGE_FACTOR
      bound_xmax=-HUGE_FACTOR
      bound_ymax=-HUGE_FACTOR
      bound_zmax=-HUGE_FACTOR

      icurrentatomid=0

      iflen=LEN(filename)
      open(unit=1,file=filename(1:iflen),status='old',
     x     form='formatted',err=112)
c     Find number of frames...
      nframes=0
 1000 continue
      read(1,'(a80)',err=112,end=1112) templine
      if (substyle.eq.0) then
         if (index(templine,'COORDINATES OF ALL ATOMS ARE').ne.0)
     x    goto 1414
      else
         if (index(templine,'COORDINATES OF SYMMETRY UNIQUE ATOMS')
     x        .ne.0) goto 1414
      endif
      goto 1000
 1414 continue
      nframes=nframes+1
c     Skip junk lines...
      read(1,'(a80)',err=112,end=112) templine
      read(1,'(a80)',err=112,end=112) templine
c     Find number of atoms in this frame...
      natomsinframe(nframes)=0
 1010 continue
      read(1,'(a80)',err=112,end=112) templine
      if (substyle.eq.0) then
         if (templine(1:20).ne.'                    ') then
            natomsinframe(nframes)=natomsinframe(nframes)+1
            goto 1010
         endif
      else
         if ((index(templine,'---').eq.0).and.
     x        (index(templine,'$').eq.0)) then
            natomsinframe(nframes)=natomsinframe(nframes)+1
            goto 1010
         endif
      endif
      goto 1000
 1112 continue
      rewind 1
      nworld=nframes+1
      call initialize_memory(nframes)
      xframepart=1.d0/dble(nframes)
      iframe=0

      av_x=0
      av_y=0
      av_z=0
      
 2000 continue
      xlocal=0
      ylocal=0
      zlocal=0
      weight=0

      read(1,'(a80)',err=112,end=2112) templine
      if (substyle.eq.0) then
         ii=index(templine,'COORDINATES OF ALL ATOMS ARE')
      else
         ii=index(templine,'COORDINATES OF SYMMETRY UNIQUE ATOMS')
      endif
      if (ii.ne.0) then
         iframe=iframe+1
c     Skip junk lines...
         read(1,'(a80)',err=112,end=112) templine
         read(1,'(a80)',err=112,end=112) templine
c     Read atoms in this frame...
         call initialize_frame(iframe,natomsinframe(iframe),0,0)
         do iatom=1,natomsinframe(iframe)
            read(1,'(a80)',err=112,end=112) templine
C     Go past the label.
            ilinestart=1
 4010       continue
            if (templine(ilinestart:ilinestart).eq.' ') then
               ilinestart=ilinestart+1
               goto 4010
            endif
 4020       continue
            if (templine(ilinestart:ilinestart).ne.' ') then
               ilinestart=ilinestart+1
               goto 4020
            endif
C     Now we know where to start!
            read(templine(ilinestart:80),*) dnr,x,y,z
            icurrentatomid=iatom
            inr=nint(dnr)
            if (inr.ge.1) then
               call set_atomxyz(iframe,iatom-1,x,y,z)
            call set_atomscalerad(iframe,iatom-1,1.d0)
               call set_atomnr(iframe,iatom-1,inr)
               call set_atomid(iframe,iatom-1,icurrentatomid)
               if (x.lt.bound_xmin) bound_xmin=x
               if (y.lt.bound_ymin) bound_ymin=y
               if (z.lt.bound_zmin) bound_zmin=z
               if (x.gt.bound_xmax) bound_xmax=x
               if (y.gt.bound_ymax) bound_ymax=y
               if (z.gt.bound_zmax) bound_zmax=z
               w=atom_weight(inr)
               xlocal=xlocal+x*w
               ylocal=ylocal+y*w
               zlocal=zlocal+z*w
               weight=weight+w
               call set_defradweight(iframe,iatom-1,1)
               call set_defcol(iframe,iatom-1,1)
               call set_atomdrawstyle(iframe,iatom-1,1)
               call set_deflabel(iframe,iatom-1,0)
               lbl=templine(1:ilinestart)
               call set_atomlabel(iframe,iatom-1,lbl)
               call set_atomhasmessage(iframe,iatom-1,0)
            endif
         enddo
         call set_hasframetext(iframe,0)
         av_x=av_x+xlocal/weight
         av_y=av_y+ylocal/weight
         av_z=av_z+zlocal/weight
      endif
      goto 2000
 2112 continue
      mass_x=av_x/dble(nframes)
      mass_y=av_y/dble(nframes)
      mass_z=av_z/dble(nframes)
      
      bound_xmin=bound_xmin-mass_x
      bound_ymin=bound_ymin-mass_y
      bound_zmin=bound_zmin-mass_z
      bound_xmax=bound_xmax-mass_x
      bound_ymax=bound_ymax-mass_y
      bound_zmax=bound_zmax-mass_z
      bound=dabs(bound_xmin)
      if (dabs(bound_ymin).gt.bound) bound=dabs(bound_ymin)
      if (dabs(bound_zmin).gt.bound) bound=dabs(bound_zmin)
      if (dabs(bound_xmax).gt.bound) bound=dabs(bound_xmax)
      if (dabs(bound_ymax).gt.bound) bound=dabs(bound_ymax)
      if (dabs(bound_zmax).gt.bound) bound=dabs(bound_zmax)
      call def_unit(bound+0.5d0)

      nmessages=0
      goto 115
 112  continue
      call errmsg('Unable to import file.')
      call upderr
      ok=0
 115  continue
      close(1)
      if (ishowprogress.eq.1) call xcodel(object)
c     This is necessary to make routines that check the nworld buffer work,
c     if they try to access it between the exit of this routnine, and before
c     the start of the next build_world call
      call get_frame_is_initialized(nworld,no)
      if (no.eq.1) then
         call deinitialize_frame(nworld)
      endif
      return
      end
