/* This is frametext.c
   A part of the Ymol program
   Copyright (C) 1997-1999 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>

#include "Xco.h"

#include "register_update.h"
#include "ccinterface.h"
#include "worldmemory.h"
#include "maxs.h"

#define WINDOW_WIDTH 700
#define WINDOW_HEIGHT 140

static int frame_open=0;
static int this_frame,numframes;
static int virgin=1;
static XcoObject fwindow,plist,fdialog;
static double placepos_x,placepos_y;
static int pliststatus;

static void f_delete_window(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      XcoDeleteObject(fwindow);
      frame_open=0;
    }
}

static void plist_change(XcoObject id,XEvent dummy)
{
  int action=XcoGetPulldownListStatus(id);
  if (action!=-1)
    {
      pliststatus=action;
    }
}

static void apply_changes(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int from,to,iframe;
      char props[MAXCHARSINFRAMETEXT+1];
      gframe_(&this_frame,&numframes);
      switch(pliststatus)
	{
        case -1: /* This means no change. */
	case 0:
	  from=this_frame;
	  to=this_frame;
	  break;
	case 1:
	  from=1;
	  to=numframes;
	  break;
	case 2:
	  from=1;
	  to=this_frame;
	  break;
	case 3:
	  from=this_frame;
	  to=numframes;
	  break;
        default:
          printf("Error in pulldown list: %d\n",pliststatus);
	}
      strcpy(props,XcoGetDialogValue(fdialog));
      for (iframe=from; iframe<=to; iframe++)
	{

	  int i=1;
#if defined(USCORE2)
	  set_frametext__(&iframe,props,strlen(props));
#else
	  set_frametext_(&iframe,props,strlen(props));
#endif

#if defined(USCORE2)
	  set_hasframetext__(&iframe,&i);
#else
	  set_hasframetext_(&iframe,&i);
#endif


#if defined(USCORE2)
	  set_frametextxy__(&iframe,&placepos_x,&placepos_y);
#else
	  set_frametextxy_(&iframe,&placepos_x,&placepos_y);
#endif
	}

      wupd_();

    }
}

static void update_em()
{
  if (frame_open)
    {
      XcoDeleteObject(fwindow);
      frame_open=0;
    }
}


void add_change_frametext(double x,double y)
{
  placepos_x=x;
  placepos_y=y;
  gframe_(&this_frame,&numframes);
  if (!frame_open)
    {
      int any;
      getany_(&any);
      if (any)
	{
	  int ypos;
	  XcoObject hole,hole2,label,acmd,decorbox;
	  char props[MAXCHARSINFRAMETEXT+1];
	  static char *ftext[4]=
	  {
	    "in this frame only",
	    "in all frames",
	    "in all frames before and including this frame",
	    "in all frames after and including this frame"
	  };

	  if (virgin)
	    {
	      register_update_function(update_em);
	      virgin=0;
	    }

	  fwindow=XcoCreateNamedDialogParent(-1,0,0,WINDOW_WIDTH,WINDOW_HEIGHT,"Add/Change frametext");
	  XcoAddCallback(fwindow,f_delete_window);

	  decorbox=XcoCreateBox3D(fwindow,5,5,WINDOW_WIDTH-10,WINDOW_HEIGHT-45,2,1);

	  hole=XcoCreateHole(decorbox,5,5,WINDOW_WIDTH-20,50);
	  hole2=XcoCreateHole(hole,0,0,WINDOW_WIDTH-20,50);
	  XcoSetResizeMethod(hole2,XcoUpResize);
	  label=XcoCreateLabel(hole2,0,0,"Frametext",0,0);
	  XcoSetResizeMethod(label,XcoUpLeft);
	  ypos=XcoGetObjectHeight(label);

#if defined(USCORE2)
	  get_frametext__(&this_frame,props,MAXCHARSINFRAMETEXT);
#else
	  get_frametext_(&this_frame,props,MAXCHARSINFRAMETEXT);
#endif
      
	  fdialog=XcoCreateDialog(hole2,0,
				  ypos,fwindow,props,80,650,0);

	  hole=XcoCreateHole(decorbox,5,55,WINDOW_WIDTH-20,20);

	  plist=XcoCreatePulldownList(hole,0,0,ftext,4,0,300,20);
	  pliststatus=0;
	  XcoAddCallback(plist,plist_change);

	  XcoSetResizeMethod(plist,XcoUpResize);
	  acmd=XcoCreateCommand(fwindow,10,WINDOW_HEIGHT-30,"Apply",0,0);
	  XcoAddCallback(acmd,apply_changes);


	  frame_open=1;
	}
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(fwindow));
    }

}
