/* This is fortraninterface.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: fortraninterface.c 86 2007-10-16 19:52:55Z daniels $";


/* This file contains routines that are useful in the fortran part of the
   program */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <Xco.h>
#include "xinterface.h"
#include "userinterface.h"
#include "draw_primitives.h"
#include "ppm.h"
#include "fstring.h"
#include "ccinterface.h"
#include "triangleworld.h"
#include "selectanimate.h"
#include "render_params.h"
#include "vmconsole.h"

void vmint_(int *nr)
{
  vmconsole_interrupt(*nr);
}

void sflush_()
{
  flush_image();
}
#if 0
void setpnt_(const int *x, const int *y,
			const int *r, const int *g,const int *b)
{
  set_point(*x,*y,*r,*g,*b);
}
#endif
void sclear_(const int *icolor)
{
  clear_buffers(*icolor);
}

void wppm_()
{
  char *filename=getfstr();
  ymol_save_ppm_image(filename);
}

/* the rest is for pixmaps */

void dsset_(const int *i)
{
  set_draw_style(*i);
}

void dsget_(int *i)
{
  *i=get_draw_style();
}

void bgset_()
{
  set_bkgr_pixmap();
}

#ifdef USEOPENGL
void oglget_(int *i)
{
  *i=get_use_opengl();
}
#endif

void bset_(const int *i)
{
  set_active_pixmap(*i);
}

void bswap_()
{
  swap_pixmaps();
}

void frect_(const int *x,const int *y,
		       const int *width,const int *height,
		       const int *r,const int *g,const int *b)
{
  fill_rectangle(*x,*y,*width,*height,*r,*g,*b);
}

void rect_(const int *x,const int *y,
		       const int *width,const int *height,
		       const int *r,const int *g,const int *b)
{
  draw_rectangle(*x,*y,*width,*height,*r,*g,*b);
}

void arc_(const int *x,const int *y,
		     const int *width,const int *height,
		     const int *start_angle,const int *path_angle,
		     const int *r,const int *g,const int *b)
{
  draw_arc(*x,*y,*width,*height,*start_angle,*path_angle,*r,*g,*b);
}

void farc_(const int *x,const int *y,
		      const int *width,const int *height,
		      const int *start_angle,const int *path_angle,
		      const int *r,const int *g,const int *b)
{
  fill_arc(*x,*y,*width,*height,*start_angle,*path_angle,*r,*g,*b);
}

void fcirc_(const int *x,const int *y,
		       const int *radius,
		       const int *r,const int *g,const int *b)
{
  fill_arc(*x-*radius,*y-*radius,
	   2*(*radius),2*(*radius),0,360*64,*r,*g,*b);
}

void circ_(const int *x,const int *y,
		      const int *radius,
		      const int *r,const int *g,const int *b)
{
  draw_arc(*x-*radius,*y-*radius,
	   2*(*radius),2*(*radius),0,360*64,*r,*g,*b);
}

void line_(const int *x1,const int *y1,
		      const int *x2,const int *y2,
		      const int *r,const int *g,const int *b)
{
  draw_line(*x1,*y1,*x2,*y2,*r,*g,*b);
}

void point_(const int *x1,const int *y1,
		      const int *r,const int *g,const int *b)
{
  draw_point(*x1,*y1,*r,*g,*b);
}

void fpoly_(const int *xpoints,const int *ypoints,
		       const int *npoints,
		       const int *r,const int *g,const int *b)
{
  XPoint *points=malloc(sizeof( XPoint)*(*npoints));
  int i;
  for (i=1;i<=*npoints;i++)
    {
      points[i-1].x=xpoints[i-1];
      points[i-1].y=ypoints[i-1];
    }
  fill_polygon(points,*npoints,*r,*g,*b);
  free( points);
}

void poly_(const int *xpoints,const int *ypoints,
		      const int *npoints,
		      const int *r,const int *g,const int *b)
{
  XPoint *points=malloc(sizeof( XPoint)*(*npoints+1));
  int i;
  for (i=1;i<=*npoints;i++)
    {
      points[i-1].x=xpoints[i-1];
      points[i-1].y=ypoints[i-1];
    }
  points[*npoints].x=xpoints[0];
  points[*npoints].y=ypoints[0];
  draw_polygon(points,*npoints+1,*r,*g,*b);
  free( points);
}

void xflush_()
{
  XcoFlush();
}

void fflush_()
{
  fflush(NULL);
}

void xsync_()
{
  XSync(XcoGetDisplay(),False);
}

void xcodel_(XcoObject *id)
{
  XcoDeleteObject(*id);
}

void xcopws_(XcoObject *id,double *size)
{
  XcoSetProgressWindowHandleSize(*id,(float)(*size));
}

void tnew_()
{
  new_triangles();
}

void bglght_(int *r,int *g,int *b)
{
  set_bglight(*r,*g,*b);
}

void lnew_(int *n)
{
  new_lamps(*n);
}

void lmpadd_(double *x,double *y,double *z,
			int *r,int *g,int *b)
{
  lamp l;
  l.x=*x;
  l.y=*y;
  l.z=*z;
  l.r=*r;
  l.g=*g;
  l.b=*b;
  add_lamp(l);
}

void gtlmps_(int *n)
{
    *n=get_nlamps();
}

void lmpget_(int *i,double *x,double *y,double *z,
	    int *r,int *g,int *b)
{
    lamp *l=get_lamp(*i);
    *x=l->x;
    *y=l->y;
    *z=l->z;
    *r=l->r;
    *g=l->g;
    *b=l->b;
}

void tadsph_(double *x,double *y,double *z,double *r,int *rgb,double *rsv,
			int *n,int *quality,int *quality2,int *xsize,int *ysize)
{
  add_triangle_sphere(*x,*y,*z,*r,rgb,*rsv,*n,*quality,*quality2,*xsize,*ysize,0);
}

void tadtri_(double *x1,double *y1,double *z1,
	     double *nx1,double *ny1,double *nz1,
	     int *nr1,int *ng1,int *nb1,
	     double *rsv1,double *opaq1,int *n1,int *ntwo1,
	     double *x2,double *y2,double *z2,
	     double *nx2,double *ny2,double *nz2,
	     int *nr2,int *ng2,int *nb2,
	     double *rsv2,double *opaq2,int *n2,int *ntwo2,
	     double *x3,double *y3,double *z3,
	     double *nx3,double *ny3,double *nz3,
	     int *nr3,int *ng3,int *nb3,
	     double *rsv3,double *opaq3,int *n3,int *ntwo3)
{
  triangle_point *tp1=malloc(sizeof(triangle_point));
  triangle_point *tp2=malloc(sizeof(triangle_point));
  triangle_point *tp3=malloc(sizeof(triangle_point));
  triangle *t=malloc(sizeof(triangle));
  tp1->x=(float)*x1;
  tp1->y=(float)*y1;
  tp1->z=(float)*z1;
  tp1->nx=(float)*nx1;
  tp1->ny=(float)*ny1;
  tp1->nz=(float)*nz1;
  tp1->r=(unsigned char)*nr1;
  tp1->g=(unsigned char)*ng1;
  tp1->b=(unsigned char)*nb1;
  tp1->fr=(float)*rsv1;
  tp1->n=(short)*n1;
  tp1->twosided=(short)*ntwo1;
  tp1->opaq=(float)*opaq1;

  tp2->x=(float)*x2;
  tp2->y=(float)*y2;
  tp2->z=(float)*z2;
  tp2->nx=(float)*nx2;
  tp2->ny=(float)*ny2;
  tp2->nz=(float)*nz2;
  tp2->r=(unsigned char)*nr2;
  tp2->g=(unsigned char)*ng2;
  tp2->b=(unsigned char)*nb2;
  tp2->fr=(float)*rsv2;
  tp2->n=(short)*n2;
  tp2->twosided=(short)*ntwo1;
  tp2->opaq=(float)*opaq1;

  tp3->x=(float)*x3;
  tp3->y=(float)*y3;
  tp3->z=(float)*z3;
  tp3->nx=(float)*nx3;
  tp3->ny=(float)*ny3;
  tp3->nz=(float)*nz3;
  tp3->r=(unsigned char)*nr3;
  tp3->g=(unsigned char)*ng3;
  tp3->b=(unsigned char)*nb3;
  tp3->fr=(float)*rsv3;
  tp3->n=(short)*n3;
  tp3->twosided=(short)*ntwo1;
  tp3->opaq=(float)*opaq1;

  register_triangle_point(tp1);
  register_triangle_point(tp2);
  register_triangle_point(tp3);

  t->point[0]=tp1;
  t->point[1]=tp2;
  t->point[2]=tp3;

  register_triangle(t);
}

void tadcyl_(double *x1,double *y1,double *z1,double *r1, 
			double *x2,double *y2,double *z2,double *r2, 
			int *rgb1,double *rsv1,int *n1,
			int *rgb2,double *rsv2,int *n2,
			int *quality2,int *xsize,int *ysize)
{
  add_triangle_cylinder(*x1,*y1,*z1,*r1,
			*x2,*y2,*z2,*r2,
			rgb1,*rsv1,*n1,
			rgb2,*rsv2,*n2,
			*quality2,*xsize,*ysize,0);
}

void tdraw_(unsigned int *framebuffer,int *zbuffer,
		       int *xsize,int *ysize,int *ybankstart,int *ybankend)
{
  draw_triangles(framebuffer,zbuffer,*xsize,*ysize,*ybankstart,*ybankend);
}


void sanl_()
{
  new_list();
}

void saac_(int *x,int *y,int *r)
{
  add_anim_circle(*x,*y,*r);
}

void saal_(int *x,int *y,int *x2,int *y2)
{
  add_anim_line(*x,*y,*x2,*y2);
}

void sbkgrc_(int *color)
{
  set_bkgr_color(*color);
}

void gbkgrc_(int *color)
{
  *color=get_bkgr_color();
}

void gbkgrv_(int *r,int *g,int *b)
{
  get_bkgr_color_vector(r,g,b);
}

void sufog_(int *use_fogging)
{
  set_use_fogging(*use_fogging);
}

void gufog_(int *use_fogging)
{
  *use_fogging=get_use_fogging();
}

void sfogp_(double *fogging_prop)
{
  set_fogging_prop(*fogging_prop);
}

void gfogp_(double *fogging_prop)
{
  *fogging_prop=get_fogging_prop();
}

void sfogp2_(double *fogging_prop2)
{
  set_fogging_prop2(*fogging_prop2);
}

void gfogp2_(double *fogging_prop2)
{
  *fogging_prop2=get_fogging_prop2();
}

void gfade_(int *fading)
{
  *fading=get_fading();
}

void sfade_(int *fading)
{
  set_fading(*fading);
}

void glabcl_(double *x)
{
    get_label_color(x);
}

void glabzo_(double *x)
{
    get_label_z_offset(x);
}

void glabxy_(double *x)
{
    get_label_xy_offset(x);
}

void slabxy_(double *x)
{
    set_label_xy_offset(x);
}

void glabsc_(double *x)
{
    get_label_scale(x);
}

void slabcl_(double *x)
{
    set_label_color(x);
}

void slabzo_(double *x)
{
    set_label_z_offset(*x);
}

void slabsc_(double *x)
{
    set_label_scale(*x);
}

void gpersp_(int *p)
{
  *p=get_perspective();
}

void getzmn_(double *p)
{
    *p=getZMIN();
}

void setck_(double *p)
{
    setck(*p);
}

void setzmn_(double *p)
{
    setZMIN(*p);
}

void getzmx_(double *p)
{
    *p=getZMAX();
}

void setzmx_(double *p)
{
    setZMAX(*p);
}

void spersp_(int *p)
{
  set_perspective(*p);
}

void gtdsty_(int *p)
{
  *p=get_3d_mode();
}

void vmsncd_()
{
  vm_synced();
}

void gndots_(int *p)
{
    *p=get_ndots();
}

void sndots_(int *p)
{
    set_ndots(*p);
}

void gxfar_(double *p)
{
    *p=get_xhowfar();
}

void sxfar_(double *p)
{
    set_xhowfar(*p);
}

void crrtmt_(double *x1, double *y1, double *z1,
	     double *x2, double *y2, double *z2,
	     double *m)
{
  double mm[4][4];
  int i,j;
  create_rotation_matrix(*x1, *y1, *z1, *x2, *y2, *z2, mm);
  for (i=0; i<4; i++)
    for (j=0; j<4; j++)
      m[i*4+j]=mm[i][j];
}

void mmtvd_(double *x1, double *y1, double *z1,
	    double *m)
{
  double v[3];
  double mm[4][4];
  int i,j;
  for (i=0; i<4; i++)
    for (j=0; j<4; j++)
      mm[i][j]=m[i*4+j];
  v[0]=*x1;
  v[1]=*y1;
  v[2]=*z1;
  multiply_vectord(v,mm);
  *x1=v[0];
  *y1=v[1];
  *z1=v[2];
}

void stesmo_(int *i)
{
  set_stereo_mode(*i);
}

void stesbu_(int *i)
{
  set_stereo_buffer(*i);
}

void stecpy_()
{
  copy_stereo_buffer();
}

void steclr_(int *ir, int *ig, int *ib)
{
  clear_stereo_buffers(*ir,*ig,*ib);
}
