/* This is errorhandler.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: errorhandler.c 109 2012-01-23 17:32:00Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Xco.h>
#include "userinterface.h"
#include "errorhandler.h"

static int nerror=0;
static int error_open=0;
static XcoObject errorbox;
static XcoObject errorhole;
static XcoObject errorlist;

typedef struct mymessagelist
{
  char *message;
  struct mymessagelist *next;
} mymessagelist;

static mymessagelist *mylisthook=NULL;

static char **myxcolist=NULL;
static int myxcolistlen=0;

static void delete_xcolist()
{
  free(myxcolist);
  myxcolist=NULL;
  myxcolistlen=0;
}

static void create_xcolist()
{
  int i;
  mymessagelist *tmp=mylisthook;
  delete_xcolist();
  myxcolist=malloc(sizeof(char*)*nerror);

  for (i=0; i<nerror; i++)
    {
      myxcolist[i]=tmp->message;
      tmp=tmp->next;
    }
  myxcolistlen=nerror;
}

static void delete_list()
{
  mymessagelist *tmp=mylisthook;
  while (tmp!=NULL)
    {
      mymessagelist *tmp2=tmp;
      tmp=tmp->next;
      free(tmp2->message);
      free(tmp2);
    }
  delete_xcolist();
  mylisthook=NULL;
}

static void close_error_message()
{
  delete_list();
  XcoDeleteObject(errorbox);
  nerror=0;
  error_open=0;
}

static void cl_error(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    close_error_message();
}

static void close_button(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    close_error_message();
}

static char *last_message_test=NULL;
static int last_message_counter=0;

static int compare_messages(char *file,char *msg)
{
  int equal=0;
  char *message=malloc((strlen(file)+strlen(msg)+1));
  strcpy(message,file);
  strcat(message,msg);

  if (last_message_test!=NULL)
    {
      if (!strcmp(message,last_message_test))
	{
	  equal=1;
	  last_message_counter++;
	}
      else
	{
	  free(last_message_test);
	  last_message_test=malloc((strlen(message)+1));
	  strcpy(last_message_test,message);
	}
    }
  else
    {
      last_message_test=malloc((strlen(message)+1));
      strcpy(last_message_test,message);
      last_message_counter=1;
    }
  return(equal);
}


static void show_error_message_backend(char *message)
{
  /* We need to create a new holding place for the message
   We also have to add the messages using the idiot walk 
   (too keep them in order */
  char *new_message=malloc((strlen(message)+
					 strlen(get_current_filename())+1+17+10));
  mymessagelist *p=mylisthook,*p2=NULL;
  mymessagelist *new_listentry=malloc(sizeof(mymessagelist));

  while (p!=NULL)
    {
      p2=p;
      p=p->next;
    }
  nerror++;
  /* If this message is changed, be sure to change the amount of memory allocated
     above!!!! */
  sprintf(new_message,"Msg %d: file %s: %s",nerror,get_current_filename(),message);
  new_listentry->message=new_message;
  new_listentry->next=NULL;
  if (p2!=NULL)
    p2->next=new_listentry;
  else
    mylisthook=new_listentry;
  if (nerror<100)
    {
      if (nerror%5==0)
	update_error_message_box();
    }
  else
    if (nerror%1000==0)
      update_error_message_box();
}

void show_error_message(char *message)
{
  if (last_message_counter==0)
    {
      show_error_message_backend(message);
      /* Put message in queue */
      compare_messages(get_current_filename(),message);
    }
  else
    {
      if (!compare_messages(get_current_filename(),message))
	{
	  if (last_message_counter>1)
	    {
	      char mymsg[29+10];
	      sprintf(mymsg,"Last message repeated %d times",last_message_counter);
	      show_error_message_backend(mymsg);
	      show_error_message_backend(message);
	    }
	  else
	    {
	      show_error_message_backend(message);
	    }
	  last_message_counter=1;
	}
    }
}

static void clean_message_counter()
{
  if (last_message_counter>1)
    {
      char mymsg[29+10];
      sprintf(mymsg,"Last message repeated %d times",last_message_counter);
      show_error_message_backend(mymsg);
    }
  if (last_message_test!=NULL)
    free(last_message_test);
  last_message_test=NULL;
  last_message_counter=0;
}

void update_error_message_box()
{
  if (!error_open)
    {
      XcoObject c;
      errorbox=XcoCreateNamedWindow(0,0,600,300,DEFAULT_BACKGROUND,1,-1,"Messages");
      XcoAddCallback(errorbox,cl_error);
      errorhole=XcoCreateHole(errorbox,5,5,590,255);
      XcoSetResizeMethod(errorhole,XcoUpLeftDownRight);
      c=XcoCreateCommand(errorbox,20,270,"Close",0,0);
      XcoSetResizeMethod(c,XcoDownLeft);
      XcoAddCallback(c,close_button);
      clean_message_counter();
      create_xcolist();
      errorlist=XcoCreateList(errorhole,0,0,590,255,20,myxcolist,myxcolistlen);
      XcoSetResizeMethod(errorlist,XcoUpLeftDownRight);
      error_open=1;
    }
  else
    {
      create_xcolist();
      XcoSetListData(errorlist,myxcolist,myxcolistlen);
      XRaiseWindow(XcoGetDisplay(),XcoWindow(errorbox));
    }
}
