/* This is dxexport.c
   A part of the Ymol program
   Copyright (C) 1997-2002 Daniel Spangberg
   */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "dxexport.h"
#include "ccinterface.h"
#include "worldmemory.h"

void dx_save(char *filename)
{
    FILE *dxfile;
    int frame,nframes,natoms,nbonds,iatom,ibond;
#if 1
    gframe_(&frame,&nframes);
#else
    get_nframes(&frame);
    frame++;
#endif
    get_atoms(&frame,&natoms);
    get_bonds(&frame,&nbonds);
    if ((dxfile=fopen(filename,"w")))
    {
	fprintf(dxfile,"#Data explorer molecule. Generated by Ymol.\n");
	/* Radii */
	fprintf(dxfile,
		"#atom radii\n"
		"object 1 class array type float rank 0 items %d data follows\n",
		natoms);
	for (iatom=0; iatom<natoms; iatom++)
	{
	    int def;
	    double rad;
	    get_defradweight(&frame, &iatom, &def);
	    if (def)
	    {
		int anr;
		get_atomnr(&frame,&iatom,&anr);
		qdarad_(&anr,&rad); /* default atom radius. */
	    }
	    else
		get_atomrad(&frame,&iatom,&rad);
	    fprintf(dxfile,"%f\n",rad);
	}
        fprintf(dxfile,"attribute \"dep\" string \"positions\"\n");
	/* Positions */
	fprintf(dxfile,
		"#atom positions\n"
		"object 2 class array type float rank 1 shape 3 items %d data follows\n",
		natoms);
	for (iatom=0; iatom<natoms; iatom++)
	{
	    double x,y,z;
	    get_atomxyz(&frame,&iatom,&x,&y,&z);
	    fprintf(dxfile,"%f %f %f\n",x,y,z);
	}
        fprintf(dxfile,"attribute \"dep\" string \"positions\"\n");
	/* Connections */
	fprintf(dxfile,
		"#connections\n"
		"object 3 class array type int rank 1 shape 2 items %d data follows\n",
		nbonds);
	for (ibond=0; ibond<nbonds; ibond++)
	{
	    int bond1,bond2;
	    get_bond1(&frame,&ibond,&bond1);
	    get_bond2(&frame,&ibond,&bond2);
	    fprintf(dxfile,"%d %d\n",bond1-1,bond2-1);
	}
        fprintf(dxfile,
		"attribute \"element type\" string \"lines\"\n"
		"attribute \"ref\" string \"positions\"\n");
	fprintf(dxfile,
		"# the molecule\n"
		"object \"molecule\" class field\n"
		"component \"data\" value 1\n"
		"component \"positions\" value 2\n"
		"component \"connections\" value 3\n"
		"attribute \"name\" string \"molecule\"\n");
	fclose(dxfile);
    }
}
