/* This is drawevents.c
   A part of the Ymol program
   Copyright (C) 1997-1999 Daniel Spangberg
   */

static char rcsid[]="$Id: drawevents.c 135 2014-01-24 10:23:17Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>

#include "Xco.h"

#include "xinterface.h"
#include "userinterface.h"
#include "rotpanel.h"
#include "mouserotate.h"
#include "ccinterface.h"
#include "drawevents.h"
#include "fstring.h"
#include "atomprop.h"
#include "bondprop.h"
#include "triangleworld.h"
#include "povraywrite.h"
#include "measure.h"
#include "register_update.h"
#include "worldmemory.h"
#include "frametext.h"

static int mouseevent[5]=
{
    FN_ROTATE,FN_SELECT,FN_MENU,FN_ZIN,FN_ZOUT
};

void set_mouse_event(int button,int event)
{
  mouseevent[button]=event;
}

static int mymenu[20];

static int current_type;
static int current_object;
static int drawbox_x,drawbox_y;

static int do_export_selected_atoms(char *filename)
{
  int frame,nframes;
  int i,natoms,nshowatoms=0;
  if (strlen(filename)==0)
    return 0;

  gframe_(&frame,&nframes);
  getany_(&i);
  if (i)
    {
      int *idatoms;
      /* Count selected atoms */
      qna_(&natoms);
      for (i=1; i<=natoms; i++)
	{
	  int sel;
	  qasel_(&i,&sel);
	  if (sel)
	    nshowatoms++;
	}
      idatoms=malloc(sizeof(int)*nshowatoms);
      nshowatoms=0;
      for (i=1; i<=natoms; i++)
	{
	  int sel;
	  qasel_(&i,&sel);
	  if (sel)
	    {
	      idatoms[nshowatoms]=i;
	      aid_(&idatoms[nshowatoms],&idatoms[nshowatoms]);
	      nshowatoms++;
	    }
	}
      export_selected_atoms(1,nframes,idatoms,nshowatoms,filename);
      free(idatoms);
    }
  return 1;
}

static void delete_selected_atoms(int fromframe,int toframe)
{
  int i,natoms,ndelatoms=0;
  getany_(&i);
  if (i)
    {
      int *idatoms;
      /* Count selected atoms */
      qna_(&natoms);
      for (i=1; i<=natoms; i++)
	{
	  int sel;
	  qasel_(&i,&sel);
	  if (sel)
	    ndelatoms++;
	}
      idatoms=malloc(sizeof(int)*ndelatoms);
      ndelatoms=0;
      for (i=1; i<=natoms; i++)
	{
	  int sel;
	  qasel_(&i,&sel);
	  if (sel)
	    {
	      idatoms[ndelatoms]=i;
	      aid_(&idatoms[ndelatoms],&idatoms[ndelatoms]);
	      ndelatoms++;
	    }
	}
      for (i=fromframe; i<=toframe; i++)
	modify_delete_atoms(i,idatoms,ndelatoms);
      free(idatoms);
      wupd_();
    }
}

static void delete_selected_bonds(int fromframe,int toframe)
{
  int i,natoms,ndelatoms=0;
  getany_(&i);
  if (i)
    {
      int *idatoms1,*idatoms2;
      /* Count selected bonds */
      qnb_(&natoms);
      for (i=1; i<=natoms; i++)
	{
	  int sel;
	  qbsel_(&i,&sel);
	  if (sel)
	    ndelatoms++;
	}
      idatoms1=malloc(sizeof(int)*ndelatoms);
      idatoms2=malloc(sizeof(int)*ndelatoms);
      ndelatoms=0;
      for (i=1; i<=natoms; i++)
	{
	  int sel;
	  qbsel_(&i,&sel);
	  if (sel)
	    {
	      bnrs_(&i,&idatoms1[ndelatoms],&idatoms2[ndelatoms]);
	      aid_(&idatoms1[ndelatoms],&idatoms1[ndelatoms]);
	      aid_(&idatoms2[ndelatoms],&idatoms2[ndelatoms]);
	      ndelatoms++;
	    }
	}
      for (i=fromframe; i<=toframe; i++)
	modify_delete_bonds(i,idatoms1,idatoms2,ndelatoms);
      free(idatoms1);
      free(idatoms2);
      wupd_();
    }
}

void mod_frametextpos(int from,int to,double x,double y)
{
  int i;
  for (i=from; i<=to; i++)
    {
      int j=i;
#if defined(USCORE2)
      set_frametextxy__(&j,&x,&y);
#else
      set_frametextxy_(&j,&x,&y);
#endif
    }
  wupd_();
}

void rbcallback(int id,int i)
{
  if (id!=-1)
    {
      /* printf("Selected item:%d,%d\n",id,i); */
      int shiftmenu=0;
      if (current_type==0) /* bond */
	shiftmenu=1;
      else if (current_type==1) /* atom */
	shiftmenu=2;
      /* Handle remaining menu items. */
      /* Background selected */
      if (id==mymenu[0])
	{
	  /* base menu */
	  switch(i-shiftmenu)
	    {
	    case -2:
	      if (current_type==1)
		{
		  /* atom */
		  /* Delete atom */
		  {
		    int frame,nframes;
		    int delatom[1];
		    aid_(&current_object,&delatom[0]);
		    /* delatom[0]=current_object; */
		    /* printf("Deleting atom with id: %d\n",delatom[0]); */
		    gframe_(&frame,&nframes);
		    modify_delete_atoms(frame,delatom,1);
		    wupd_();
		  }
		}
	      break;
	    case -1:
	    if (current_type==0)
	      {
		/* bond */
		/* Delete bond */
		{
		  int frame,nframes;
		  int bnr1,bnr2;
		  gframe_(&frame,&nframes);
		  bnrs_(&current_object,&bnr1,&bnr2);
		  aid_(&bnr1,&bnr1);
		  aid_(&bnr2,&bnr2);
		  modify_delete_bonds(frame,&bnr1,&bnr2,1);
		  wupd_();
		}
	      }
	    else if (current_type==1)
	      {
		/* atom */
		/* Create bonds */
		{
		  int frame,nframes;
		  int delatom[1];
		  aid_(&current_object,&delatom[0]);
		  /* printf("Creating bonds to atom with id: %d\n",delatom[0]); */
		  gframe_(&frame,&nframes);
		  modify_create_bonds(frame,delatom[0]);
		  wupd_();
		}
	      }
	    break;
	    case 0:
	      /* Unselect all */
	      unsel_();
	      break;
	    case 1:
	      /* Select all */
	      allsel_();
	      break;
	    case 2:
	      /* Invert select */
	      invsel_();
	      break;
	    case 3:
	      {
		char *filters[1]={""};
		XcoFileDialog("Export selected atoms","Export",filters,1,do_export_selected_atoms);
	      }
	      break;
	    case 4:
	      /* Properties of selected atoms etc */
	      
	      break;
	    }
	}
      else if ((current_type==0) && (id==mymenu[1])) /* bond */
	{
	  int frame,nframes,start,end;
	  int bnr1,bnr2;
	  XcoObject progress;
	  gframe_(&frame,&nframes);
	  bnrs_(&current_object,&bnr1,&bnr2);
	  aid_(&bnr1,&bnr1);
	  aid_(&bnr2,&bnr2);
	  gframe_(&frame,&nframes);
	  if (i==0)
	    {
	      start=frame;
	      end=frame;
	    }
	  else if (i==1)
	    {
	      start=1;
	      end=nframes;
	    }
	  else if (i==2)
	    {
	      start=1;
	      end=frame;
	    }
	  else /* i==3 */
	    {
	      start=frame;
	      end=nframes;
	    }	      
	  progress=XcoCreateProgressWindow("Deleting bond...");
	  for (i=start; i<=end; i++)
	    {
	      XcoSetProgressWindowHandleSize(progress,((float)(i-start+1))/((float)(end-start+1)));
	      modify_delete_bonds(i,&bnr1,&bnr2,1);
	    }
	  XcoDeleteObject(progress);

	  wupd_();
	}
      else if ((current_type==1) && (id==mymenu[1])) /* atom */
	{
	  XcoObject progress;
	  int frame,nframes,start,end;
	  int delatom[1];
	  aid_(&current_object,&delatom[0]);
	  /* delatom[0]=current_object; */
	  /* printf("Deleting atom with id: %d\n",delatom[0]); */
	  gframe_(&frame,&nframes);
	  if (i==0)
	    {
	      start=frame;
	      end=frame;
	    }
	  else if (i==1)
	    {
	      start=1;
	      end=nframes;
	    }
	  else if (i==2)
	    {
	      start=1;
	      end=frame;
	    }
	  else /* i==3 */
	    {
	      start=frame;
	      end=nframes;
	    }
	      
	  progress=XcoCreateProgressWindow("Deleting atoms...");
	  for (i=start; i<=end; i++)
	    {
	      XcoSetProgressWindowHandleSize(progress,((float)(i-start+1))/((float)(end-start+1)));
	      modify_delete_atoms(i,delatom,1);
	    }
	  XcoDeleteObject(progress);

	  wupd_();
	  
	}
      else if ((current_type==1) && (id==mymenu[2])) /* atom */
	{
	  XcoObject progress;
	  int frame,nframes,start,end,k;
	  int delatom[1];
	  aid_(&current_object,&delatom[0]);
	  /* printf("Creating bonds to atom with id: %d\n",delatom[0]); */

	  gframe_(&frame,&nframes);
	  if (i==0)
	    {
	      start=frame;
	      end=frame;
	    }
	  else if (i==1)
	    {
	      start=1;
	      end=nframes;
	    }
	  else if (i==2)
	    {
	      start=1;
	      end=frame;
	    }
	  else /* i==3 */
	    {
	      start=frame;
	      end=nframes;
	    }
	  progress=XcoCreateProgressWindow("Creating bonds...");
	  for (k=start; k<=end; k++)
	    {
	      XcoSetProgressWindowHandleSize(progress,((float)(k-start+1))/((float)(end-start+1)));
	      modify_create_bonds(k,delatom[0]);
	    }
	  XcoDeleteObject(progress);
	  wupd_();
	}
      else if (id==mymenu[3])
	{
	  /* rendering menu */
	  switch(i)
	    {
	    case 0:
	      /* Properties of selected atoms */
	      {
		apropwindow();
	      }		  
	      break;
	    case 1:
	      /* Properties of selected bonds */
	      {
		bpropwindow();
	      }
	      break;
	    }
	}
      else if (id==mymenu[4])
	{
	  /* Convert to fixed point */
	  int rx,ry;
	  get_buffer_size(&rx,&ry);
	  rx=(drawbox_x*65536)/rx;
	  ry=(drawbox_y*65536)/ry;
	  switch(i)
	    {
	    case 0:
	      measure_distance(rx,ry);
	      break;
	    case 1:
	      measure_angle(rx,ry);
	      break;
	    case 2:
	      measure_dihedral(rx,ry);
	      break;
	    case 3:
	      measure_clear_all();
	      break;
	    }
	}
      else if (id==mymenu[5])
	{
	  switch(i)
	    {
	    case 0:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_atoms(frame,frame);
	      }
	      break;
	    case 1:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_bonds(frame,frame);
	      }
	      break;
	    }
	}
      else if (id==mymenu[6])
	{
	  switch(i)
	    {
	    case 0:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_atoms(frame,frame);
	      }
	      break;
	    case 1:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_atoms(1,nframes);
	      }
	      break;
	    case 2:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_atoms(1,frame);
	      }
	      break;
	    case 3:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_atoms(frame,nframes);
	      }
	      break;
	    }
	}
      else if (id==mymenu[7])
	{
	  switch(i)
	    {
	    case 0:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_bonds(frame,frame);
	      }
	      break;
	    case 1:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_bonds(1,nframes);
	      }
	      break;
	    case 2:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_bonds(1,frame);
	      }
	      break;
	    case 3:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		delete_selected_bonds(frame,nframes);
	      }
	      break;
	    }
	}
      else if (id==mymenu[8])
	{
	  int rx,ry;
	  double drx,dry;
	  get_buffer_size(&rx,&ry);
	  drx=(double)drawbox_x/(double)rx;
	  dry=(double)drawbox_y/(double)ry;
	  switch(i)
	    {
	    case 0:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		mod_frametextpos(frame,frame,drx,dry);		    
	      }
	      break;
	    case 1:
	      {
		add_change_frametext(drx,dry);
	      }
	    }
	}
      else if (id==mymenu[9])
	{
	  int rx,ry;
	  double drx,dry;
	  get_buffer_size(&rx,&ry);
	  drx=(double)drawbox_x/(double)rx;
	  dry=(double)drawbox_y/(double)ry;
	  switch(i)
	    {
	    case 0:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		mod_frametextpos(frame,frame,drx,dry);
	      }
	      break;
	    case 1:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		mod_frametextpos(1,nframes,drx,dry);
	      }
	      break;
	    case 2:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		mod_frametextpos(1,frame,drx,dry);
	      }
	      break;
	    case 3:
	      {
		int frame,nframes;
		gframe_(&frame,&nframes);
		mod_frametextpos(frame,nframes,drx,dry);
	      }
	      break;
	    }
	}
      else
	{
	  int nm=n_mymenuid_get();
	  int inm;
	  for (inm=0; inm<nm; inm++)
	    {
	      if (mymenuid_get(inm)==id)
		{
		  mymenucallback(0,id,i);
		  break;
		}
	    }
	}
    }
  XcoDeleteMenu(mymenu[0]);
}


void rbmenu(XcoObject id,int type,int object)
{
  Window root,child;
  int rx,ry,x1,y1;
  unsigned int mask;

  int shiftmenu=0;

  char *rbmenutext_bgr[16]=
    {
      "Unselect all",
      "Select all",
      "Invert selection",
      "Export selected atoms",
      "Delete selected",
      "Properties of selected",
      "Measure",
      "Frametext",
      "",
      "File",
      "Edit",
      "View",
      "Options",
      "Y4",
      "Tools",
      "Help"
    };

  char *rbmenutext_atom[18]=
    {
      "Delete atom",
      "Create bond(s) to selected specie(s)",
      "Unselect all",
      "Select all",
      "Invert selection",
      "Export selected atoms",
      "Delete selected",
      "Properties of selected",
      "Measure",
      "Frametext",
      "",
      "File",
      "Edit",
      "View",
      "Options",
      "Y4",
      "Tools",
      "Help"
    };

  char *rbmenutext_bond[17]=
    {
      "Delete bond",
      "Unselect all",
      "Select all",
      "Invert selection",
      "Export selected atoms",
      "Delete selected",
      "Properties of selected",
      "Measure",
      "Frametext",
      "",
      "File",
      "Edit",
      "View",
      "Options",
      "Y4",
      "Tools",
      "Help"
    };

  char *rbmenutext3[2]=
    {
      "atoms",
      "bonds"
    };

  char *ftext[4]=
    {
      "in this frame only",
      "in all frames",
      "in all frames before and including this frame",
      "in all frames after and including this frame"
    };

  char *measuretext[4]=
    {
      "distance",
      "angle",
      "dihedral angle",
      "clear all"
    };

  char *framet[2]=
    {
      "place here",
      "add/change"
    };

  current_type=type;
  current_object=object;

  if (type==0) /* bond */
    shiftmenu=1;
  else if (type==1) /* atom */
    shiftmenu=2;
  if (type==-1)
    mymenu[0]=XcoCreateMenu(MENU_TOPLEVEL,0,rbmenutext_bgr,16);
  else if (type==0) /* bond */
    {
      mymenu[0]=XcoCreateMenu(MENU_TOPLEVEL,0,rbmenutext_bond,17);
      mymenu[1]=XcoCreateMenu(mymenu[0],0,ftext,4);
    }
  else if (type==1) /* atom */
    {
      mymenu[0]=XcoCreateMenu(MENU_TOPLEVEL,0,rbmenutext_atom,18);
      mymenu[1]=XcoCreateMenu(mymenu[0],0,ftext,4);
      mymenu[2]=XcoCreateMenu(mymenu[0],1,ftext,4);
    }
  mymenu[3]=XcoCreateMenu(mymenu[0],5+shiftmenu,rbmenutext3,2);
  mymenu[4]=XcoCreateMenu(mymenu[0],6+shiftmenu,measuretext,4);
  mymenu[5]=XcoCreateMenu(mymenu[0],4+shiftmenu,rbmenutext3,2);
  mymenu[6]=XcoCreateMenu(mymenu[5],0+shiftmenu,ftext,4);
  mymenu[7]=XcoCreateMenu(mymenu[5],1+shiftmenu,ftext,4);
  mymenu[8]=XcoCreateMenu(mymenu[0],7+shiftmenu,framet,2);
  mymenu[9]=XcoCreateMenu(mymenu[7],0+shiftmenu,ftext,4);
  XcoAttachSubMenu(mymenu[0],9+shiftmenu,mymenuid_get(0));
  XcoAttachSubMenu(mymenu[0],10+shiftmenu,mymenuid_get(1));
  XcoAttachSubMenu(mymenu[0],11+shiftmenu,mymenuid_get(2));
  XcoAttachSubMenu(mymenu[0],12+shiftmenu,mymenuid_get(3));
  XcoAttachSubMenu(mymenu[0],13+shiftmenu,mymenuid_get(4));
  XcoAttachSubMenu(mymenu[0],14+shiftmenu,mymenuid_get(5));
  XcoAttachSubMenu(mymenu[0],15+shiftmenu,mymenuid_get(6));
  
  /* get exact x and y coordinates of mouse pointer. */
  XQueryPointer(XcoGetDisplay(),
		XcoWindow(get_drawbox()),
		&root,&child,&rx,&ry,&drawbox_x,&drawbox_y,&mask); 

  XcoOpenMenu(-1,mymenu[0],rx,ry,rbcallback,0);
}


static int mouse_xpress,mouse_ypress;
static int my_kind_of_press=0;
static int started_crystal_translate=0;
static double total_crystal_translate_x=0.;
static double total_crystal_translate_y=0.;
static double total_crystal_translate_z=0.;

static void local_crystal_translate(double xdiff, double ydiff, double zdiff)
{
  int frame,nframes;
  int oldpoly;
  int oldbond;
  int zero=0;
  gframe_(&frame,&nframes);
  total_crystal_translate_x+=xdiff;
  total_crystal_translate_y+=ydiff;
  total_crystal_translate_z+=zdiff;
  pctrf_(&frame,&xdiff,&ydiff,&zdiff);
  gnpr_(&oldpoly);
  gnbdr_(&oldbond);
  /* Remove all bond rules and triangles. */
  snpr_(&zero);
  snbdr_(&zero);
  /* Apply all bond rules and polygon rules (to remove the bond rules and polygon rules) */
  mabrf_(&frame);
  maprf_(&frame);
  wupd_();
  /* Restore number of bond rules and polygon rules. */
  snpr_(&oldpoly);
  snbdr_(&oldbond);
}

void event_draw_window(XcoObject dummy,XEvent event)
{
    int xb,yb,xsize,ysize,mevent=0;
    /* printf("Message to draw window: "); */
    /* printf("Type: %lu,Window:%lu:",(unsigned long)event.type,(unsigned long) event.xany.window); */
    /* remove_any_menu(); */
    switch(event.type)
    {
	case ButtonRelease:
	    if (my_kind_of_press)
	    {
		if ((event.xbutton.x==mouse_xpress) && (event.xbutton.y==mouse_ypress))
		{
		    /* printf("I will keep your menu\n"); */
		}
		else
		{
		    /* Don't keep menu */
		    XcoRemoveAnyMenu(-1,0);
		}
	    }
	    else
	    {
	    }
	    my_kind_of_press=0;

	    /* printf("Oh how nice! of you :-)\n"); */
	    break;
	case ButtonPress:
	    mevent=event.xbutton.button-1;
	    if (mevent<0)
		mevent=0;
	    if (mevent>4)
		mevent=4;
	    switch (mouseevent[mevent])
	    {
		case FN_ROTATE:
		    set_origin(event.xbutton.x,event.xbutton.y);
		    break;
		case FN_SELECT:
		{
		    int i;
		    xb=event.xbutton.x;
		    yb=event.xbutton.y;
		    set_origin(xb,yb);
		    get_buffer_size(&xsize,&ysize);
		    getany_(&i);
		    if (i)
			fsel_(&xb,&yb,&xsize,&ysize);
		}
		break;
		case FN_MENU:
		{
		    int type,object,i;
		    xb=event.xbutton.x;
		    yb=event.xbutton.y;
		    mouse_xpress=xb;
		    mouse_ypress=yb;
		    my_kind_of_press=1;
		    get_buffer_size(&xsize,&ysize);
		    getany_(&i);
		    if (i)
		    {
 		        int xsizecp=xsize;
			/* printf("I will look...\n");
			   fflush(stdout); */
			flook_(&xb,&yb,&xsizecp,&ysize,&type,&object);
			/* printf("I have stopped looking\n");
			   fflush(stdout); */
		    }
		    else
		    {
			type=-1;
		    }
		    rbmenu(get_drawbox(),type,object);
		}
		break;
	    case FN_ZIN:
	      {
		if (started_crystal_translate)
		  {
		    local_crystal_translate(0.,0.,-1.);
		  }
		else
		  {
		    if (event.xbutton.state & (Button1Mask|Button2Mask|Button3Mask))
		      {
			stainc_();
			wupd_();
		      }
		    else
		      rotpanel_zin_button();
		  }
	      }
	      break;
	    case FN_ZOUT:
	      {
		if (started_crystal_translate)
		  {
		    local_crystal_translate(0.,0.,1.);
		  }
		else
		  {
		    if (event.xbutton.state & (Button1Mask|Button2Mask|Button3Mask))
		      {
			stadec_();
			wupd_();
		      }
		    else
		      rotpanel_zout_button();
		  }
	      }
	      break;
	    }
	    break;
	case MotionNotify:
      
	    if (event.xmotion.state & Button1Mask)
		mevent=0;
	    if (event.xmotion.state & Button2Mask)
		mevent=1;
	    if (event.xmotion.state & Button3Mask)
		mevent=2;
	    if (started_crystal_translate)
	      {
		double xdiff, ydiff, zdiff;
		int xorig, yorig;
		gsorg_(&xorig,&yorig);
		xdiff=event.xmotion.x-xorig;
		ydiff=event.xmotion.y-yorig;
		if (xdiff>0)
		  xdiff=1.;
		else if (xdiff<0)
		  xdiff=-1.;
		if (ydiff>0)
		  ydiff=1.;
		else if (ydiff<0)
		  ydiff=-1.;
		zdiff=0.;
		local_crystal_translate(xdiff,ydiff,zdiff);
		set_origin(event.xmotion.x,event.xmotion.y);
	      }
	    else
	      {
		switch (mouseevent[mevent])
		  {
		  case FN_ROTATE:
		    rotate_to(event.xmotion.x,event.xmotion.y);
		    sematr_();
		    break;
		  case FN_SELECT:
		    translate_to(event.xmotion.x,event.xmotion.y);
		    stmatr_();
		    break;
		  }
	      }
	    break;
    case KeyRelease:
      {
	int length;
	char keyb_buffer[20];
	KeySym keysym;
	XComposeStatus composestatus;
	length=XLookupString(&event.xkey,keyb_buffer,1,
			     &keysym,&composestatus);
	keyb_buffer[length]='\0';
	    switch(keysym)
	    {
	    case XK_Shift_L:
	    case XK_Shift_R:
#if 0
	      printf("Shift is released.\n");
#endif
	      if (started_crystal_translate)
		{
		  int frame,nframes;
		  double crystal_translate_x;
		  double crystal_translate_y;
		  double crystal_translate_z;
		  gframe_(&frame,&nframes);
		  /* Translate the current frame back. */
		  crystal_translate_x=-total_crystal_translate_x;
		  crystal_translate_y=-total_crystal_translate_y;
		  crystal_translate_z=-total_crystal_translate_z;
		  pctrf_(&frame,&crystal_translate_x,&crystal_translate_y,&crystal_translate_z);
		  /* Translate all frames. */
		  pctr_(&total_crystal_translate_x,&total_crystal_translate_y,&total_crystal_translate_z);
		  /* Apply all bond rules and polygon rules. */
		  mabr_();
		  mapr_();
		  wupd_();
		  started_crystal_translate=0;
		}
	      break;
	    }	       
      }
      break;
	case KeyPress:
	{
	    int i;
	    int length;
	    char keyb_buffer[20];
	    KeySym keysym;
	    XComposeStatus composestatus;
	    length=XLookupString(&event.xkey,keyb_buffer,1,
				 &keysym,&composestatus);
	    keyb_buffer[length]='\0';
	    /* printf("KeyPress. key: '%s'\n",keyb_buffer); */

	    switch(keysym)
	    {
	    case XK_Shift_L:
	    case XK_Shift_R:
	      {
		int icrystal;
#if 0
		printf("Shift is pressed.\n");
#endif
		gicrys_(&icrystal);
		if (icrystal)
		  {
		    total_crystal_translate_x=0.;
		    total_crystal_translate_y=0.;
		    total_crystal_translate_z=0.;
		    started_crystal_translate=1;
#if 0
		    printf("Started crystal translate\n");
#endif
		  }
	      }
	      break;
		case XK_g:
		case XK_G:
#ifdef USEOPENGL
		    if (QueryOpenGLSupport())
		    {
			int useit;
			set_oversampling(1);
			useit=1-get_use_opengl();
			set_use_opengl(useit);
			if (useit)
			    set_fast_emulation(0);
			else
			    set_fast_emulation(1);
		    }
		fupd_();
#endif
		execute_update_functions();
		break;

#if 0
		case XK_o:
		case XK_O:
		    set_oversampling(2);
		    fupd_();
		    break;

		case XK_p:
		case XK_P:
		    i=1;
		    dppm_(&i);
		    break;
		case XK_w:
		case XK_W:
		    fsppm_();
		    break;
#endif
		case XK_t:
		case XK_T:
		    dlqry_(&i);
		    i=1-i;
		    dlbl_(&i);
		    fupd_();
		    execute_update_functions();
		    break;
		case XK_s:
		case XK_S:
		  tglste_();
		  wupd_();
		  execute_update_functions();
		  break;
		case XK_q:
		case XK_Q:
		    quit_app();
		    break;

		case XK_c:
		case XK_C:
		    open_rot_popup();
		    break;
	    case XK_Next:
	      if (started_crystal_translate)
		local_crystal_translate(0.,0.,1.);
	      break;
	    case XK_Prior:
	      if (started_crystal_translate)
		local_crystal_translate(0.,0.,-1.);
	      break;
		case XK_Left:
		  if (started_crystal_translate)
		    local_crystal_translate(-1.,0.,0.);
		  else
		    rotpanel_left_button();
		    break;
	        case XK_Right:
		  if (started_crystal_translate)
		    local_crystal_translate(1.,0.,0.);
		  else
		    rotpanel_right_button();
		  break;
		case XK_Up:
		  if (started_crystal_translate)
		    local_crystal_translate(0.,1.,0.);
		  else
		    rotpanel_up_button();
		  break;
		case XK_Down:
		  if (started_crystal_translate)
		    local_crystal_translate(0.,-1.,0.);
		  else
		    rotpanel_down_button();
		    break;
		case XK_space:
		    rotpanel_rplay_button();
		    break;

		case XK_m:
		case XK_M:
		    switch_mode();
		    break;
#ifdef DOUBLEBUFFER
		case XK_1:
		    switch_doublebuffer_usage();
		    execute_update_functions();
		    break;
#endif
#ifdef MULTIBUFFER
		case XK_2:
		    switch_multibuffer_usage();
		    execute_update_functions();
		    break;
#endif
	    }
	}


	break;
    }
}

