/* This is draw_primitives.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: draw_primitives.c 86 2007-10-16 19:52:55Z daniels $";

#include <stdio.h>
#include <X11/Xlib.h>
#include "Xco.h"
#include "xinterface.h"

/* All primitives will draw to the inactive pixmap */

void draw_rectangle(int x,int y,int width,int height,
		    int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XDrawRectangle(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
		 x,y,width,height);
}

void fill_rectangle(int x,int y,int width,int height,
		    int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XFillRectangle(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
		 x,y,width,height);
}

void draw_arc(int x,int y,int width,int height,
	      int start_angle,int path_angle,
	      int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XDrawArc(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
	   x,y,width,height,start_angle,path_angle);
}

void fill_arc(int x,int y,int width,int height,
	      int start_angle,int path_angle,
	      int r,int g,int b)
{
#if 0
  printf("FA: %d %d %d %d %d %d %d\n",x,y,width,height,r,g,b);
#endif
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XFillArc(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
	   x,y,width,height,start_angle,path_angle);
}

void draw_line(int x1,int y1,int x2,int y2,
	       int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XDrawLine(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
	    x1,y1,x2,y2);
}

void draw_point(int x,int y,
		int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XDrawPoint(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
	     x,y);
}

void draw_polygon(XPoint *points,int npoints, 
		  int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XDrawLines(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
	     points,npoints,CoordModeOrigin);
}

void fill_polygon(XPoint *points,int npoints, 
		  int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XFillPolygon(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),
	     points,npoints,Complex,CoordModeOrigin);
}

