/*
    A part of the ymol program.
    Copyright (C) 1997-1998 Daniel Spangberg
*/
    /* This file reads the atomdata.tbl and colorschemes.tbl and creates fortran code
 from the data */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main()
{
  FILE *myfile, *outfile;
  int nscheme;
  int i;
  int natoms;
  outfile=fopen("tabledata.F","w");
  myfile=fopen("colorschemes.tbl","r");

  fscanf(myfile,"%d",&nscheme);

  for (i=1; i<=nscheme; i++)
    {
      int r,g,b,n;
      double rsv;
      fscanf(myfile,"%d%d%d%lf%d",&r,&g,&b,&rsv,&n);
      fprintf(outfile,"      rgb(%d,%d)=%d\n",i,1,r);
      fprintf(outfile,"      rgb(%d,%d)=%d\n",i,2,g);
      fprintf(outfile,"      rgb(%d,%d)=%d\n",i,3,b);
      fprintf(outfile,"      rsv(%d)=%fd0\n",i,rsv);
      fprintf(outfile,"      nfactor(%d)=%d\n",i,n);
    }
  fclose(myfile);
  myfile=fopen("atomdata.tbl","r");

  fscanf(myfile,"%d",&natoms);
  for (i=1; i<=natoms; i++)
    {
      int n,col;
      double rad,weight;
      fscanf(myfile,"%d%lf%lf%d",&n,&rad,&weight,&col);
      fprintf(outfile,"      atom_radius(%d)=%fd0\n",n,rad);
      fprintf(outfile,"      atom_weight(%d)=%fd0\n",n,weight);
      fprintf(outfile,"      atom_color(%d)=%d\n",n,col);
    }

  fclose(myfile);
  fclose(outfile);
  return 0;
}
