#include <stdio.h>
#include <math.h>


#define FRAMES 30

#define XRES 25
#define YRES 25

#define MAXX 5*3.14159
#define MAXY 5*3.14159

#define FREVOL 2*3.14159


#define ZMUL 4

#define RCOL(a,b) ((int)(((mat[a][b]/ZMUL+1)*0.5)*255))
#define GCOL(a,b) 100
#define BCOL(a,b) ((int)(255-(((mat[a][b]/ZMUL+1)*0.5)*255)))

#define RSV 0.7
#define NREFL 20

#if 0
#define OPAQ(a) (a/(MAXX)+0.5)
#endif

#define OPAQ(a) (0.5)

#define TWOS 1

#define NMAC(myx0,myy0,myx1,myy1) \
 ix0=myx0; \
 iy0=myy0; \
 ix1=myx1; \
 iy1=myy1; \
 if (ix0<0) \
  ix0=0; \
 if (iy0<0) \
  iy0=0; \
 if (ix1>(XRES-1)) \
  ix1=XRES-1; \
 if (iy1>(YRES-1)) \
  iy1=YRES-1; \
 nx=(nmat[ix0][iy0][0][0]+ \
     nmat[ix0][iy0][1][0]+ \
     nmat[ix0][iy1][0][0]+ \
     nmat[ix0][iy1][1][0]+ \
     nmat[ix1][iy0][0][0]+ \
     nmat[ix1][iy0][1][0]+ \
     nmat[ix1][iy1][0][0]+ \
     nmat[ix1][iy1][1][0])*0.125; \
 ny=(nmat[ix0][iy0][0][1]+ \
     nmat[ix0][iy0][1][1]+ \
     nmat[ix0][iy1][0][1]+ \
     nmat[ix0][iy1][1][1]+ \
     nmat[ix1][iy0][0][1]+ \
     nmat[ix1][iy0][1][1]+ \
     nmat[ix1][iy1][0][1]+ \
     nmat[ix1][iy1][1][1])*0.125; \
 nz=(nmat[ix0][iy0][0][2]+ \
     nmat[ix0][iy0][1][2]+ \
     nmat[ix0][iy1][0][2]+ \
     nmat[ix0][iy1][1][2]+ \
     nmat[ix1][iy0][0][2]+ \
     nmat[ix1][iy0][1][2]+ \
     nmat[ix1][iy1][0][2]+ \
     nmat[ix1][iy1][1][2])*0.125; \
 nl=sqrt(nx*nx+ny*ny+nz*nz); \
 nx/=nl; \
 ny/=nl; \
 nz/=nl;

int main()
{
  int ix,iy,frame;
  double x,y,z,x2,y2;
  double mat[XRES][YRES];
  double nmat[XRES][YRES][2][3];
  printf("%d\n",FRAMES);
  for (frame=0; frame<FRAMES; frame++)
    {
      printf("%d\n",(XRES-1)*(YRES-1)*2);
      for (ix=0; ix<XRES; ix++)
	for (iy=0; iy<YRES; iy++)
	  {
	    x=(double)(ix-XRES/2)*MAXX/XRES;
	    y=(double)(iy-YRES/2)*MAXY/YRES;
	    z=sin(x+FREVOL*frame/FRAMES)*cos(y+FREVOL*frame/FRAMES);
	    mat[ix][iy]=z*ZMUL;
	  }
      /* Compute normals */
      for (ix=0; ix<(XRES-1); ix++)
	for (iy=0; iy<(YRES-1); iy++)
	  {
	    double a,b,c,d,e,f,nx,ny,nz,nl;
	    x=(double)(ix-XRES/2)*MAXX/XRES;
	    y=(double)(iy-YRES/2)*MAXY/YRES;
	    x2=(double)(ix+1-XRES/2)*MAXX/XRES;
	    y2=(double)(iy+1-YRES/2)*MAXY/YRES;
	    a=x-x;
	    b=y2-y;
	    c=mat[ix][iy+1]-mat[ix][iy];
	    d=x2-x;
	    e=y2-y;
	    f=mat[ix+1][iy+1]-mat[ix][iy];
	    nx=b*f-c*e;
	    ny=c*d-a*f;
	    nz=a*e-b*d;

	    nl=sqrt(nx*nx+ny*ny+nz*nz);
	    nx/=nl;
	    ny/=nl;
	    nz/=nl;

	    nmat[ix][iy][0][0]=nx;
	    nmat[ix][iy][0][1]=ny;
	    nmat[ix][iy][0][2]=nz;

	    a=x2-x;
	    b=y2-y;
	    c=mat[ix+1][iy+1]-mat[ix][iy];
	    d=x2-x;
	    e=y-y;
	    f=mat[ix+1][iy]-mat[ix][iy];
	    nx=b*f-c*e;
	    ny=c*d-a*f;
	    nz=a*e-b*d;

	    nl=sqrt(nx*nx+ny*ny+nz*nz);
	    nx/=nl;
	    ny/=nl;
	    nz/=nl;

	    nmat[ix][iy][1][0]=nx;
	    nmat[ix][iy][1][1]=ny;
	    nmat[ix][iy][1][2]=nz;
	  }

      /* Write the triangles to file... */
      for (ix=0; ix<(XRES-1); ix++)
	for (iy=0; iy<(YRES-1); iy++)
	  {
	    int ix0,iy0,ix1,iy1;
	    double a,b,c,d,e,f,nx,ny,nz,nl;
	    x=(double)(ix-XRES/2)*MAXX/XRES;
	    y=(double)(iy-YRES/2)*MAXY/YRES;
	    x2=(double)(ix+1-XRES/2)*MAXX/XRES;
	    y2=(double)(iy+1-YRES/2)*MAXY/YRES;

	    NMAC(ix-1,iy-1,ix,iy)
	    printf("%e %e %e %e %e %e %d %d %d %e %d %e %d\n",
		   x,y,mat[ix][iy],nx,ny,nz,
		   RCOL(ix,iy),GCOL(ix,iy),BCOL(ix,iy),RSV,NREFL,OPAQ(x),TWOS);

	    NMAC(ix-1,iy,ix,iy+1)
	    printf("%e %e %e %e %e %e %d %d %d %e %d %e %d\n",
		   x,y2,mat[ix][iy+1],nx,ny,nz,
		   RCOL(ix,iy+1),GCOL(ix,iy+1),BCOL(ix,iy+1),RSV,NREFL,OPAQ(x),TWOS);

	    NMAC(ix,iy,ix+1,iy+1)
	    printf("%e %e %e %e %e %e %d %d %d %e %d %e %d\n",
		   x2,y2,mat[ix+1][iy+1],nx,ny,nz,
		   RCOL(ix+1,iy+1),GCOL(ix+1,iy+1),BCOL(ix+1,iy+1),RSV,NREFL,OPAQ(x),TWOS);
		   

	    NMAC(ix-1,iy-1,ix,iy)
	    printf("%e %e %e %e %e %e %d %d %d %e %d %e %d\n",
		   x,y,mat[ix][iy],nx,ny,nz,
		   RCOL(ix,iy),GCOL(ix,iy),BCOL(ix,iy),RSV,NREFL,OPAQ(x),TWOS);

	    NMAC(ix,iy-1,ix+1,iy)
	    printf("%e %e %e %e %e %e %d %d %d %e %d %e %d\n",
		   x2,y,mat[ix+1][iy],nx,ny,nz,
		   RCOL(ix+1,iy),GCOL(ix+1,iy),BCOL(ix+1,iy),RSV,NREFL,OPAQ(x),TWOS);

	    NMAC(ix,iy,ix+1,iy+1)
	    printf("%e %e %e %e %e %e %d %d %d %e %d %e %d\n",
		   x2,y2,mat[ix+1][iy+1],nx,ny,nz,
		   RCOL(ix+1,iy+1),GCOL(ix+1,iy+1),BCOL(ix+1,iy+1),RSV,NREFL,OPAQ(x),TWOS);
	  }

    }
  return 0;
}
