/* This is ccinterface.h
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

/* This file contains declarations for routines in the fortran part
   of this program */

#ifndef __ccinterface__
#define __ccinterface__

void rendfr_(int *buffer,int *zbuffer,int *x,int *y);
void initf_(int *buffer,int *zbuffer,int *x,int *y);
void reinif_(int *x,int *y);
void pact_(int *buffer,int *zbuffer,int *x,int *y,int *action);
void supd_(int *buffer,int *zbuffer,int *x,int *y);
void rotx_(int *rot);
void roty_(int *rot);
void rotz_(int *rot);
void zinout_(int *rot);
void cont_(int *rot);
void mplay_(int *play,int *continous);
void rspd_(double *speed);
void deinif_();
void fiflag_(int *nr,double *value);
void sdefbr_();
void wupd_();
void wupds_();
void fupd_();
void sylamp_();
void setany_(int *anything);
void getany_(int *anything);
void itmatr_();
void sematr_();
void stmatr_();
void se2mat_();
void se2mel_(int *i,double *x);
void fsorg_(int *x,int *y);
void gsorg_(int *x,int *y);
void fsto_(int *x,int *y);
void fstto_(int *x,int *y);
void dppm_(int *i);
void dlbl_(int *i);
void dlqry_(int *i);
void fsel_(int *x,int *y,int *xsize,int *ysize);
void flook_(int *x,int *y,int *xsize,int *ysize,int *type,int *object);
void fsppm_();
void unsel_();
void allsel_();
void invsel_();
void aid_(int *atomnr, int *atomid);
void bnrs_(int *bondnr, int *bondatomid1,int *bondatomid2);
void qna_(int *natoms);
void qnb_(int *nbonds);
void qasel_(int *i,int *sel);
void qbsel_(int *i,int *sel);
void qaxyz_(int *i,double *x,double *y,double *z);
void qaid_(int *i, int *id);
void qan_(int *i, int *n);
int qargb_(int *i);
int qbrgb_(int *i);
void gatwgh_(int *i, double *w);
void cldta_();
double qbrad_(int *i);
int qbrns_(int *i);
void qsfill_(int *i,int *sfill);
void pssave_(int *xsize,int *ysize);

int pcolor_(int *r,int *g,int *b,
		       double *rsv1,double *rsv2,double *rsv3,
		       int *n,
		       double *vecx,double *vecy,double *vecz);

void gframe_(int *frame,int *nframes);
int nbrule_();
int addbr_();
void delbr_(int *item);
void brup_(int *item);
void brdown_(int *item);


/* Functions for retreiving info. */
int ndon_(int *item);
int nacc_(int *item);
int donor_(int *item,int *i);
int accept_(int *item,int *i);
int col_(int *item);
double fuzzb_(int *item);
int brn_(int *item);
int brns_(int *item);
double brrsv_(int *item);
double brrad_(int *item);
int ivdw_(int *item);

/* Subroutines for setting info. */
void sndon_(int *item,int *ndon);
void snacc_(int *item,int *nacc);
void sdonor_(int *item,int *i,int *don);
void sacc_(int *item,int *i,int *acc);
void scol_(int *item, int *col);
void sfuzzb_(int *item, double *fuzzb);
void mabrf_(int *frame);
void mabr_();
void maprf_(int *frame);
void mapr_();
void mabrns_();
void maprns_();
void sbrn_(int *item, int *n);
void sbrns_(int *item, int *n);
void sbrrsv_(int *item, double *rsv);
void sbrrad_(int *item, double *rad);
void sivdw_(int *item,int *ivdw);

/* Oversampling */
void govsmp_(int *oversampling);
void sovsmp_(int *oversampling);

/* Movie looping */
void getlop_(int *looping);
void setlop_(int *looping);

/* Fogging */
void fog_(int *z,int *r,int *g,int *b,int *xsize,int *ysize,double *prop,double *prop2);
void fogfac_(int *z,int *xsize,int *ysize,double *prop, double *prop2,double *dv);

void gztr_(double *zt);

/* Default atom properties */
void qdargb_(int *nr,int *r,int *g,int *b);
void sdargb_(int *nr,int *r,int *g,int *b);
void qdarad_(int *nr,double *x);
void sdarad_(int *nr,double *x);
void qdawgh_(int *nr,double *x);
void sdawgh_(int *nr,double *x);
void qdarsv_(int *nr,double *x);
void sdarsv_(int *nr,double *x);
void qdanpo_(int *nr,double *x);
void sdanpo_(int *nr,double *x);

#ifdef USCORE2
void def_unit__(double *x);
#else
void def_unit_(double *x);
#endif

void sbound_(double *x);
void smxyz_(double *x, double *y, double *z);
void tglste_();
void steini_();
void sterei_();
void stepar_(double *sa, double *ss, double *st);
void stepqy_(double *sa, double *ss, double *st);
void setste_(int *n);
void steqry_(int *n);
void sttriz_(int *n);
void trzqry_(int *n);
void stntrz_(int *n);
void tznqry_(int *n);
void stainc_();
void stadec_();
void gicrys_(int *ic);
void gnbdr_(int *n);
void snbdr_(int *n);
void gnpr_(int *n);
void snpr_(int *n);
void pctrf_(int *n,double *x, double *y, double *z);
void pctr_(double *x, double *y, double *z);
#endif
