      /* This is bondrulehandler.F
      A part of the Ymol program
      Copyright (C) 1997-1998  Daniel Spangberg
      */

#include "maxs.h"
#include "defaults.h"

      function nbrule()
      implicit double precision (a-h,o-z)
      integer nbrule
#include "bondrule.commonblock"
      nbrule=nbondrules
      return
      end

      function addbr()
      implicit double precision (a-h,o-z)
      integer addbr
#include "bondrule.commonblock"
      nbondrules=nbondrules+1
      ndonors(nbondrules)=0
      nacceptors(nbondrules)=0
      colors(nbondrules)=65536*BOND_DEFAULT_B+
     x     256*BOND_DEFAULT_G+
     x     BOND_DEFAULT_R
      bondrulen(nbondrules)=BOND_DEFAULT_N
      bondrulenslice(nbondrules)=BOND_DEFAULT_NSLICE
      bondrulersv(nbondrules)=BOND_DEFAULT_RSV
      bondrulewidth(nbondrules)=BOND_DEFAULT_RAD
      vdwsub(nbondrules)=1
      bondrulename(nbondrules)='New rule'
      fuzzfactor(nbondrules)=0.3d0
      addbr=nbondrules
      return
      end

      subroutine delbr(item)
      implicit double precision (a-h,o-z)
      integer item
#include "bondrule.commonblock"
      if (item.lt.nbondrules) then
         do i=item,nbondrules-1
            ndonors(i)=ndonors(i+1)
            if (ndonors(i).gt.0) then
               do j=1,ndonors(i)
                  donors(i,j)=donors(i+1,j)
               enddo
            endif
            nacceptors(i)=nacceptors(i+1)
            if (nacceptors(i).gt.0) then
               do j=1,nacceptors(i)
                  acceptors(i,j)=acceptors(i+1,j)
               enddo
            endif
            colors(i)=colors(i+1)
            bondrulename(i)=bondrulename(i+1)
            fuzzfactor(i)=fuzzfactor(i+1)
            bondrulen(i)=bondrulen(i+1)
            bondrulenslice(i)=bondrulenslice(i+1)
            bondrulersv(i)=bondrulersv(i+1)
            vdwsub(i)=vdwsub(i+1)
            bondrulewidth(i)=bondrulewidth(i+1)
         enddo
      endif
      nbondrules=nbondrules-1
c      write(*,*) 'nbondrules=',nbondrules
      return
      end

      subroutine brup(item)
      implicit double precision (a-h,o-z)
      integer item
      character*64 bname
#include "bondrule.commonblock"
      if (item.ne.1) then
         i=ndonors(item)
         ndonors(item)=ndonors(item-1)
         ndonors(item-1)=i
         do j=1,10
            i=donors(item,j)
            donors(item,j)=donors(item-1,j)
            donors(item-1,j)=i
         enddo
         i=nacceptors(item)
         nacceptors(item)=nacceptors(item-1)
         nacceptors(item-1)=i
         do j=1,10
            i=acceptors(item,j)
            acceptors(item,j)=acceptors(item-1,j)
            acceptors(item-1,j)=i
         enddo
         i=colors(item)
         colors(item)=colors(item-1)
         colors(item-1)=i
         bname=bondrulename(item)
         bondrulename(item)=bondrulename(item-1)
         bondrulename(item-1)=bname
         x=fuzzfactor(item)
         fuzzfactor(item)=fuzzfactor(item-1)
         fuzzfactor(item-1)=x
         i=bondrulen(item)
         bondrulen(item)=bondrulen(item-1)
         bondrulen(item-1)=i
         i=bondrulenslice(item)
         bondrulenslice(item)=bondrulenslice(item-1)
         bondrulenslice(item-1)=i
         x=bondrulersv(item)
         bondrulersv(item)=bondrulersv(item-1)
         bondrulersv(item-1)=x
         x=bondrulewidth(item)
         bondrulewidth(item)=bondrulewidth(item-1)
         bondrulewidth(item-1)=x
         i=vdwsub(item)
         vdwsub(item)=vdwsub(item-1)
         vdwsub(item-1)=i
      endif
      return
      end

      subroutine brdown(item)
      implicit double precision (a-h,o-z)
      integer item
      character*64 bname
#include "bondrule.commonblock"
      if (item.ne.nbondrules) then
         i=ndonors(item)
         ndonors(item)=ndonors(item+1)
         ndonors(item+1)=i
         do j=1,10
            i=donors(item,j)
            donors(item,j)=donors(item+1,j)
            donors(item+1,j)=i
         enddo
         i=nacceptors(item)
         nacceptors(item)=nacceptors(item+1)
         nacceptors(item+1)=i
         do j=1,10
            i=acceptors(item,j)
            acceptors(item,j)=acceptors(item+1,j)
            acceptors(item+1,j)=i
         enddo
         i=colors(item)
         colors(item)=colors(item+1)
         colors(item+1)=i
         bname=bondrulename(item)
         bondrulename(item)=bondrulename(item+1)
         bondrulename(item+1)=bname
         x=fuzzfactor(item)
         fuzzfactor(item)=fuzzfactor(item+1)
         fuzzfactor(item+1)=x
         i=bondrulen(item)
         bondrulen(item)=bondrulen(item+1)
         bondrulen(item+1)=i
         i=bondrulenslice(item)
         bondrulenslice(item)=bondrulenslice(item+1)
         bondrulenslice(item+1)=i
         x=bondrulersv(item)
         bondrulersv(item)=bondrulersv(item+1)
         bondrulersv(item+1)=x
         x=bondrulewidth(item)
         bondrulewidth(item)=bondrulewidth(item+1)
         bondrulewidth(item+1)=x
         i=vdwsub(item)
         vdwsub(item)=vdwsub(item+1)
         vdwsub(item+1)=i
      endif
      return
      end


      function ndon(item)
      implicit double precision (a-h,o-z)
      integer ndon
#include "bondrule.commonblock"
      ndon=ndonors(item)
      return
      end

      function nacc(item)
      implicit double precision (a-h,o-z)
      integer nacc
#include "bondrule.commonblock"
      nacc=nacceptors(item)
      return
      end

      function donor(item,i)
      implicit double precision (a-h,o-z)
      integer donor
#include "bondrule.commonblock"
      donor=donors(item,i)
      return
      end

      function accept(item,i)
      implicit double precision (a-h,o-z)
      integer accept
#include "bondrule.commonblock"
      accept=acceptors(item,i)
      return
      end

      function col(item)
      implicit double precision (a-h,o-z)
      integer col
#include "bondrule.commonblock"
      col=colors(item)
      return
      end

      function fuzzb(item)
      implicit double precision (a-h,o-z)
      double precision fuzzb
#include "bondrule.commonblock"
      fuzzb=fuzzfactor(item)
      return
      end

      subroutine bname(item,n)
      implicit double precision (a-h,o-z)
      character*64 n
#include "bondrule.commonblock"
      n=bondrulename(item)
      return
      end

      function brn(item)
      implicit double precision (a-h,o-z)
      integer brn
#include "bondrule.commonblock"
      brn=bondrulen(item)
      return
      end

      function brns(item)
      implicit double precision (a-h,o-z)
      integer brns
#include "bondrule.commonblock"
      brns=bondrulenslice(item)
      return
      end

      function brrsv(item)
      implicit double precision (a-h,o-z)
      double precision brrsv
#include "bondrule.commonblock"
      brrsv=bondrulersv(item)
      return
      end

      function brrad(item)
      implicit double precision (a-h,o-z)
      double precision brrad
#include "bondrule.commonblock"
      brrad=bondrulewidth(item)
      return
      end

      function ivdw(item)
      implicit double precision (a-h,o-z)
#include "bondrule.commonblock"
      ivdw=vdwsub(item)
      return
      end

      subroutine sndon(item,ndon)
      implicit double precision (a-h,o-z)
      integer ndon
#include "bondrule.commonblock"
      ndonors(item)=ndon
      return
      end

      subroutine snacc(item,nacc)
      implicit double precision (a-h,o-z)
      integer nacc
#include "bondrule.commonblock"
      nacceptors(item)=nacc
      return
      end

      subroutine sdonor(item,i,donor)
      implicit double precision (a-h,o-z)
      integer donor
#include "bondrule.commonblock"
      donors(item,i)=donor
      return
      end

      subroutine sacc(item,i,accept)
      implicit double precision (a-h,o-z)
      integer accept
#include "bondrule.commonblock"
      acceptors(item,i)=accept
      return
      end

      subroutine scol(item,col)
      implicit double precision (a-h,o-z)
      integer col
#include "bondrule.commonblock"
      colors(item)=col
      return
      end

      subroutine sfuzzb(item,fuzzb)
      implicit double precision (a-h,o-z)
      double precision fuzzb
#include "bondrule.commonblock"
      fuzzfactor(item)=fuzzb
      return
      end

      subroutine sbname(item,n)
      implicit double precision (a-h,o-z)
      character*64 n
#include "bondrule.commonblock"
      bondrulename(item)=n
      return
      end

      subroutine sbrn(item,n)
      implicit double precision (a-h,o-z)
      integer n
#include "bondrule.commonblock"
      bondrulen(item)=n
      return
      end

      subroutine sbrns(item,n)
      implicit double precision (a-h,o-z)
      integer n
#include "bondrule.commonblock"
      bondrulenslice(item)=n
      return
      end

      subroutine sbrrsv(item,rsv)
      implicit double precision (a-h,o-z)
      double precision rsv
#include "bondrule.commonblock"
      bondrulersv(item)=rsv
      return
      end

      subroutine sbrrad(item,rad)
      implicit double precision (a-h,o-z)
      double precision rad
#include "bondrule.commonblock"
      bondrulewidth(item)=rad
      return
      end

      subroutine sivdw(item,ivdw)
      implicit double precision (a-h,o-z)
#include "bondrule.commonblock"
      vdwsub(item)=ivdw
      return
      end


