/* This is bondprop.cc
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include "Xco.h"


#include "ccinterface.h"
#include "fstring.h"
#include "register_update.h"

static int open_bondprop=0;
static XcoObject bwindow;
static int browse_pixel;
static XcoObject colorhole;
static int open_bcolor=0;
static XcoObject colsel;
static XcoObject braddialog;
static int virgin=1;
static XcoObject slicetoggle;

static void apply_bondprop(int from_frame,int to_frame)
{
  XcoObject progress;
  double rad=strtod(XcoGetDialogValue(braddialog),NULL);

  int nbonds;


  int nselbonds=0;
  int i;
  int *bnr1,*bnr2;
  int nsb;
  int color_r,color_g,color_b;
  int frame;
  int islice;

  qnb_(&nbonds);

  for (i=0; i<nbonds; i++)
    {
      int j=i+1;
      int sel;
      qbsel_(&j,&sel);
      if (sel)
	nselbonds++;
    }
  bnr1=malloc(sizeof( int)*(nselbonds));
  bnr2=malloc(sizeof( int)*(nselbonds));
  nsb=0;
  for (i=0; i<nbonds; i++)
    {
      int j=i+1;
      int sel;
      qbsel_(&j,&sel);
      if (sel)
	{
	  bnrs_(&j,&bnr1[nsb],&bnr2[nsb]);
	  aid_(&bnr1[nsb],&bnr1[nsb]);
	  aid_(&bnr2[nsb],&bnr2[nsb]);
	  nsb++;
	}
    }


  islice=XcoGetToggleSelected(slicetoggle);
  color_r=R_OF_PIXEL(browse_pixel);
  color_g=G_OF_PIXEL(browse_pixel);
  color_b=B_OF_PIXEL(browse_pixel);
  progress=XcoCreateProgressWindow("Modifying bond properties...");  
  for (frame=from_frame; frame<=to_frame; frame++)
    {
      XcoSetProgressWindowHandleSize(progress,((float)(frame-from_frame+1))/((float)(to_frame-from_frame+1)));
      modify_bond_properties(frame,bnr1,bnr2,nselbonds,
			     color_r,color_g,color_b,
			     rad,islice);
    }
  XcoDeleteObject(progress);
  free( bnr1);
  free( bnr2);
  wupd_();
}

static void apclose()
{
  XcoDeleteObject(bwindow);
  open_bondprop=0;
  if (open_bcolor)
    {
      XcoDeleteObject(colsel);
      open_bcolor=0;
    }
}


static void adelete(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      apclose();
    }
}

static void set_colorpixmap(unsigned int pixel)
{
  unsigned int image[16];
  int i;
  Pixmap colorpixmap;
  browse_pixel=pixel;

  for (i=0; i<16; i++)
    image[i]=pixel;
  colorpixmap=XcoCreatePixmapFromImage(colorhole,image,4,4);
  XcoSetBackgroundPixmap(colorhole,colorpixmap,True);
  XFreePixmap(XcoGetDisplay(),colorpixmap);
}


static void use_color(int r,int g,int b,int ok)
{
  if (open_bondprop)
    if (ok)
      {
	set_colorpixmap(PIXEL(r,g,b));
      }
}


static void dcolsel(XcoObject dummy,XEvent event)
{
  if (event.type==DestroyNotify)
    {
      printf("The color selector object was destroyed\n");
      open_bcolor=0;
    }
}

static void browse_colors(XcoObject dummy,XEvent event)
{
  if (open_bondprop)
    {
      if (event.type==ButtonPress)
	{
	  if (!open_bcolor)
	    {
	      colsel=XcoColorselector(R_OF_PIXEL(browse_pixel),
				      G_OF_PIXEL(browse_pixel),
				      B_OF_PIXEL(browse_pixel),
				      use_color);
	      XcoAddCallback(colsel,dcolsel);
	      open_bcolor=1;
	    }
	}
    }
}

static void apply_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int frame,nframes;
      gframe_(&frame,&nframes);
      apply_bondprop(frame,frame);
    }
}

static void applyall_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int frame,nframes;
      gframe_(&frame,&nframes);
      apply_bondprop(1,nframes);
    }
}

static void virginize()
{
  if (open_bondprop)
    apclose();
}

void bpropwindow()
{
  if (!open_bondprop)
    {
      XcoObject bcmd,colorbox,apply,lbl;
      double brad=0;
      int icol=0;
      int islice=0;
      int nbonds;
      int sel;
      int i;
      char rads[4];
      getany_(&i);
      if (i)
	{
	  if (virgin)
	    {
	      register_update_function(virginize);
	      virgin=0;
	    }

	  bwindow=XcoCreateNamedDialogParent(-1,0,0,300,320,"Properties of selected bonds");

	  XcoAddCallback(bwindow,adelete);

	  bcmd=XcoCreateCommand(bwindow,80,10,"Browse",0,0);
	  colorbox=XcoCreateBox3D(bwindow,20,10,50,XcoGetObjectHeight(bcmd),0,1);
	  colorhole=XcoCreateHole(colorbox,2,2,46,XcoGetObjectHeight(bcmd)-4);
	  XcoAddCallback(bcmd,browse_colors);
	  XcoSetResizeMethod(colorbox,XcoUpLeftDownRight);
	  XcoSetResizeMethod(colorhole,XcoUpLeftDownRight);
	  XcoSetResizeMethod(bcmd,XcoUpRight);


	  qnb_(&nbonds);
	  for (i=0; i<nbonds; i++)
	    {
	      int j=i+1;
	      qbsel_(&j,&sel);
	      if (sel)
		{
		  brad=qbrad_(&j);
		  icol=qbrgb_(&j);
		  islice=qbrns_(&j);
		  break;
		}
	    }
	  if (sel)
	    set_colorpixmap(icol);
	  else
	    set_colorpixmap(0);

	  lbl=XcoCreateLabel(bwindow,20,50,"Radius:",0,0);

	  sprintf(rads,"%4.2f",brad);
	  braddialog=XcoCreateDialog(bwindow,30+XcoGetObjectWidth(lbl),50,bwindow,rads,4,80,0);

	  lbl=XcoCreateLabel(bwindow,20,200,"Slice bond:",0,0);

	  slicetoggle=XcoCreateToggle(bwindow,30+XcoGetObjectWidth(lbl),200,10,10,PIXEL(255,0,0),1,islice);

	  apply=XcoCreateCommand(bwindow,20,220,"Apply",0,0);
	  XcoAddCallback(apply,apply_callback);
	  apply=XcoCreateCommand(bwindow,25+XcoGetObjectWidth(apply),220,"Apply to all frames",0,0);
	  XcoAddCallback(apply,applyall_callback);
	  open_bondprop=1;
	}
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(bwindow));
    }
}


