#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "Xco.h"

XcoMenu menu,menu2,menu3,menu4;


static uint16 byteswap16(uint16 word)
{
  return (((word&0xff00)>>8)|((word&0xff)<<8));
}



void menucallback(int id,int i)
{
  printf("Called menu: %d, %d\n",id,i);
}

void menubarcallback(int menubar,int id,int pos)
{
  printf("Called menu: %d, %d, %d\n",menubar,id,pos);
  if (id==menu4)
    {
      int p=XcoGetMenuItemActivated(menu4,pos);
      printf("Switching:%d\n",p);
      XcoSetMenuItemActivated(menu4,pos,1-p);
    }
}

void button_callback(XcoObject id,XEvent event)
{
  int x,y;
  int rx,ry;
  Window wr,wc;
  unsigned int mask;
  switch (event.type)
    {
    case ButtonPress:
      printf("My button pressed\n");
      XQueryPointer(XcoGetDisplay(),XcoWindow(id),&wr,&wc,&rx,&ry,&x,&y,&mask);
      XcoOpenMenu(-1,menu,rx-x,ry-y+15,menucallback,0);
      break;
    case ButtonRelease:
      printf("My button released\n");
      break;
    }
}

XcoObject win;
XcoObject win2;

void w_callback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      XcoDeleteObject(win);
      exit(0);
    }
}

void w2_callback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    XcoDeleteObject(win2);
}


void b2_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      XcoDeleteObject(win2);
    }
}


void button2_callback(XcoObject dummy ,XEvent event)
{
  if (event.type==ButtonPress)
    {
      XcoObject test,command,sbar;
      win2=XcoCreateWindow(0,0,320,200,DEFAULT_BACKGROUND,1,-1);
      XcoAddCallback(win2,w2_callback);
      XStoreName(XcoGetDisplay(),XcoWindow(win2),"Test2");
      test=XcoCreateCommand(win2,10,10,"",300,180);
      XcoSetResizeMethod(test,XcoDownResize);      
      command=XcoCreateCommand(test,10,10,"",100,100);
      XcoAddCallback(command,b2_callback);
      sbar=XcoCreateScrollbar(command,10,10,20,80,0.1,0.5,ScrollbarVert);

    }
}

#define MAX_CIRCLES 10000
#define TCOLOR ((50<<16)|(150<<8)|255)
static int circles=0;
static int circle_x[MAX_CIRCLES];
static int circle_y[MAX_CIRCLES];

void hole_callback(XcoObject id,XEvent event)
{
  switch(event.type)
    {
    case ButtonPress:
      circles++;
      circle_x[circles-1]=event.xbutton.x;
      circle_y[circles-1]=event.xbutton.y;
      XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,TCOLOR));
      XFillArc(XcoGetDisplay(),XcoWindow(id),XcoGC(id),
	       circle_x[circles-1]-5,circle_y[circles-1]-5,10,10,0,360*64);

      break;
    case MotionNotify:
      circles++;
      circle_x[circles-1]=event.xmotion.x;
      circle_y[circles-1]=event.xmotion.y;
      XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,TCOLOR));
      XFillArc(XcoGetDisplay(),XcoWindow(id),XcoGC(id),
	       circle_x[circles-1]-5,circle_y[circles-1]-5,10,10,0,360*64);


      break;
    case Expose:
      {
	int i;
	XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,TCOLOR));
	for (i=0;i<circles;i++)
	  {
	    XFillArc(XcoGetDisplay(),XcoWindow(id),XcoGC(id),
		     circle_x[i]-5,circle_y[i]-5,10,10,0,360*64);
	  }
      }
    break;
    }
}

void dialog_callback(XcoObject id,XEvent event)
{
  if (event.type==KeyPress)
    {
      int length;
      char keyb_buffer[20];
      KeySym keysym;
      XComposeStatus composestatus;
      length=XLookupString(&event.xkey,keyb_buffer,1,
			   &keysym,&composestatus);
      keyb_buffer[length]='\0';
      if (keysym==XK_Return)
	{
	  printf("Entered string: '%s'\n",XcoGetDialogValue(id));
	}
    }
}

void sbar_callback(XcoObject id,XEvent event)
{
  XcoScrollbarData data;
  if (XcoGetScrollbarStatus(id,&data))
    {
      switch (data.action)
	{
	case ScrollbarButtonUp:
	  XcoSetScrollbarHandlePos(id,data.handle_position-0.1);
	  break;	
	case ScrollbarButtonDown:
	  XcoSetScrollbarHandlePos(id,data.handle_position+0.1);
	  break;
	case ScrollbarHandle:
	  printf("Handle\n");
	  break;
	}
    }
}

void sbar2_callback(XcoObject id,XEvent event)
{
  XcoScrollbarData data;
  if (XcoGetScrollbarStatus(id,&data))
    {
      switch (data.action)
	{
	case ScrollbarButtonLeft:
	  XcoSetScrollbarHandlePos(id,data.handle_position-0.1);
	  break;	
	case ScrollbarButtonRight:
	  XcoSetScrollbarHandlePos(id,data.handle_position+0.1);
	  break;
	case ScrollbarHandle:
	  printf("Handle\n");
	  break;
	}
    }
}

int file_callback(char *filename)
{
  printf("Filedialog: %s\n",filename);
  return(0);
}

static XcoObject progresswindow;
static float hsize=0;
static float delta=0.0001;

int workprocess()
{
  hsize+=delta;
  if (hsize>=1.0)
    {  
      delta=-delta;
      hsize=1.0;
    }
  if (hsize<=0)
    {
      delta=-delta;
      hsize=0.0;
    }

  XcoSetProgressWindowHandleSize(progresswindow,hsize);

  return(0);
}



void cselcallback(int r,int g,int b,int ok)
{
  printf("Selected r=%d, g=%d, b=%d. Ok=%d\n",r,g,b,ok);
}






int main()
{
  int i;
  char *menutext[4]=
  {
    "Background color1",
    "Background color2",
    "",
    "Phong shading options"
  };

  char *menutext2[10]=
  {
    "Blaj1",
    "Blaj2",
    "Blaj3",
    "Blaj4",
    "Blaj5",
    "Blaj6",
    "Blaj7",
    "Blaj8",
    "Blaj9",
    "Mer blaj"
  };

  char *menutext3[2]=
  {
    "Blajx",
    "Mer blajx"
  };

  char *menutext4[12]=
  {
    "Blajx1",
    "Blajx2",
    "Blajx3",
    "Blajx4",
    "Blajx5",
    "Blajx6",
    "Blajx7",
    "Blajx8",
    "Blajx9",
    "Blajx10",
    "Blajx11",
    "Mer blajx"
  };
  char *filters[3]=
  {
    ".cc",
    ".h",
    ""
  };


  int k;
  XcoObject command,command2,box,hole,dialogparent,blajs,dialog,dialog2,sbar,sbar2,list,toggle,toggle2,plist,plist2;

  char *menubartext[4]=
  {
    "File",
    "Edit",
    "Options",
    "Help"
  };

  char *list_str[]={"**********hello1","world1",
		    "***************************************************hello2","world2",
		    "**********hello3","world3",
		    "**********hello4","world4",
		    "**********hello5","world5",
		    "**********hello6","world3",
		    "**********hello7","world4",
		    "**********hello8","world3",
		    "**********hello9","world4",
		    "**********hello0","world3",
		    "**********hello1","world4",
		    "**********hello2","world3",
		    "**********hello3","world4",
		    "**********hello4","world3",
		    "**********hello5","world4",
		    "**********hello6","world3",
		    "**********hello7","world4",
		    "**********hello8","world3",
		    "**********hello9","world4",
		    "**********hello0","world3",
		    "**********hello1","world4",
		    "**********hello2","world3",
		    "**********hello3","world4",
		    "**********hello4","world3",
		    "**********hello5","world4"};
  XFontStruct *myfont;
  XFontStruct *myfont2;
  XcoMenu menuid[4];
  uint16 before,after;

  XcoInit();
  win=XcoCreateWindow(0,0,640,480,DEFAULT_BACKGROUND,1,-1);
  XcoAddCallback(win,w_callback);
  XStoreName(XcoGetDisplay(),XcoWindow(win),"Test");

  myfont=XcoLoadFont("-*-times-*-r-*-*-12-*-*-*-*-*-*-*");
  XcoLabelFont(myfont);
  XcoCommandFont(myfont);
  XcoDialogFont(myfont);
  XcoListFont(myfont);
  myfont2=XcoLoadFont("-*-helvetica-*-r-*-*-12-*-*-*-*-*-*-*");
  XcoMenuFont(myfont2);
  XcoPulldownListFont(myfont2);


  command=XcoCreateCommand(win,10,50,"Press me!",0,0);
  XcoAddCallback(command,button_callback);

  command2=XcoCreateCommand(win,10,100,"Knapp 2",0,0);
  XcoAddCallback(command2,button2_callback);

  box=XcoCreateBox3D(win,200,30,400,300,0,1);
  hole=XcoCreateHole(box,2,2,396,296);
  XSelectInput(XcoGetDisplay(),XcoWindow(hole),
	       ExposureMask|ButtonPressMask|ButtonMotionMask);
  XcoAddCallback(hole,hole_callback);

  dialogparent=XcoCreateDialogParent(win,200,350,400,60);

  blajs=XcoCreateHole(dialogparent,0,0,400,60);
  dialog=XcoCreateDialog(blajs,
				   0,0,dialogparent,
				   "Test",32,400,0);

  XcoSetResizeMethod(dialog,XcoDownResize);
  XcoAddCallback(dialog,dialog_callback);



    dialog2=XcoCreateDialog(blajs,
				   0,30,dialogparent,
				   "Test2",32,400,0);
  XcoSetResizeMethod(dialog2,XcoDownResize);
  XcoAddCallback(dialog2,dialog_callback);

  sbar=XcoCreateScrollbar(win,
				    10,140,20,100,
				    0.5,0.,ScrollbarVert);
  XcoAddCallback(sbar,sbar_callback);

  sbar2=XcoCreateScrollbar(win,
				    10,250,100,20,
				    0.5,0.,ScrollbarHoriz);
  XcoAddCallback(sbar2,sbar2_callback);



  list=XcoCreateList(win,
			       10,300,100,100,20,
			       list_str,50);


  toggle=XcoCreateToggle(win,
			  20,420,11,11,
			  PIXEL(255,0,0),1,0);

  toggle2=XcoCreateToggle(win,
				    20,440,11,11,
				    PIXEL(255,0,0),1,0);


  

  menu=XcoCreateMenu(MENU_TOPLEVEL,0,menutext,4);
  menu2=XcoCreateMenu(menu,1,menutext2,10);
  menu3=XcoCreateMenu(menu2,0,menutext3,2);
  menu4=XcoCreateMenu(menu,0,menutext4,12);
  
  for (k=0; k<12; k++)
    XcoSetMenuItemToggleable(menu4,k,1,0);





  menuid[0]=menu;
  menuid[1]=menu2;
  menuid[2]=menu3;
  menuid[3]=menu4;


  XcoCreateMenubar(win,0,0,640,4,menubartext,menuid,menubarcallback,1);

  plist=XcoCreatePulldownList(win,200,450,menutext4,12,0,0,0);
  plist2=XcoCreatePulldownList(win,300,450,menutext2,10,4,0,0);

  XcoFileDialog("Hello","Yup",filters,3,file_callback);

  progresswindow=XcoCreateProgressWindow("Bouncing...");
  /* XcoAddWorkProc(workprocess); */

  XcoColorselector(253,0,0,cselcallback);


  before=0xAABB;
  after=byteswap16(before);
  printf("Before=%d, After=%d\n",before,after);

  XcoProcessEvents();
  return 0;
}







