/* This is triangle.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: triangle.c 2 2001-10-30 13:35:39Z daniels $";

#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"


typedef struct
{
  int pressed;
} triangledata;


void __expose_triangle(XcoObject id)
{
  XPoint my[4];
  my[0].x=__objects[id]->width/4;
  my[0].y=3*__objects[id]->height/4;
  my[1].x=__objects[id]->width/4;
  my[1].y=__objects[id]->height/4;
  my[2].x=3*__objects[id]->width/4;
  my[2].y=__objects[id]->height/2;
  if (((triangledata*)(__objects[id]->data))->pressed)
    XcoDrawPolyLine(id,my,3,PIXEL(0,0,0));
  else
    XcoDrawPolyLine(id,my,3,PIXEL(255,255,255));
  my[0].x=3*__objects[id]->width/4;
  my[0].y=__objects[id]->height/2;
  my[1].x=__objects[id]->width/4;
  my[1].y=3*__objects[id]->height/4;
  if (((triangledata*)(__objects[id]->data))->pressed)
    XcoDrawPolyLine(id,my,2,PIXEL(255,255,255));
  else
    XcoDrawPolyLine(id,my,2,PIXEL(0,0,0));
}

void __triangle_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_triangle(id);
      break;
    }
}


void XcoSetTriangleStatus(XcoObject id,int pressed)
{
  ((triangledata*)(__objects[id]->data))->pressed=pressed;
  __expose_triangle(id);
}



XcoObject XcoCreateTriangle(XcoObject parent,
			 int x,int y,int width,int height)
{
  triangledata *mydata;
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  __objects[myobject]->type=XcoTTriangle;
  mydata=malloc(sizeof( triangledata));
  mydata->pressed=0;
  __objects[myobject]->data=(void*) mydata;
  
  __expose_triangle(myobject);

  XcoAddCallback(myobject,__triangle_callback);

  return (myobject);
}

