/* This is scrollbar.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: scrollbar.c 4 2001-12-14 13:53:39Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "Xco.h"

typedef struct
{
  float handle_size;
  float handle_position;
  int button1_pressed;
  int button2_pressed;
  int _pos;
  int action;
  int type;
} scrollbardata;

void __expose_scrollbar_vert(XcoObject id)
{
  int buttonheight,scrollbarheight,handleheight,handleposition;
  XPoint my[3];
  buttonheight=__objects[id]->width;
  scrollbarheight=__objects[id]->height-2*buttonheight-6;
  handleheight=(int)(scrollbarheight*((scrollbardata*)(__objects[id]->data))->handle_size);
  handleposition=(int)(scrollbarheight*((scrollbardata*)(__objects[id]->data))->handle_position);
  
  if (handleposition>0)
    XcoFillBox(id,2,buttonheight+3,
	       __objects[id]->width-4,
	       handleposition,
	       __objects[id]->background);
  if ((scrollbarheight-handleposition-handleheight)>0)
    XcoFillBox(id,2,handleposition+buttonheight+3+handleheight,
	       __objects[id]->width-4,
	       scrollbarheight-handleposition-handleheight+1,
	       __objects[id]->background);


  XcoDrawInverted3DBox(id,0,buttonheight+1,
		       __objects[id]->width,
		       __objects[id]->height-2*buttonheight-2);

  XcoDraw3DBox(id,2,handleposition+buttonheight+3,
	       __objects[id]->width-4,
	       handleheight);

  if (handleheight>4)
    XcoFillBox(id,4,handleposition+buttonheight+5,
	       __objects[id]->width-8,
	       handleheight-4,__objects[id]->background);



  if (((scrollbardata*)(__objects[id]->data))->button1_pressed)
    XcoDrawInverted3DBox(id,0,0,__objects[id]->width,buttonheight);
  else
    XcoDraw3DBox(id,0,0,__objects[id]->width,buttonheight);

  if (((scrollbardata*)(__objects[id]->data))->button2_pressed)
    XcoDrawInverted3DBox(id,0,__objects[id]->height-buttonheight,
			 __objects[id]->width,buttonheight);
  else
    XcoDraw3DBox(id,0,__objects[id]->height-buttonheight,
		 __objects[id]->width,buttonheight);


  my[0].x=3*__objects[id]->width/4;
  my[0].y=__objects[id]->height-buttonheight+buttonheight/4;
  my[1].x=__objects[id]->width/2;
  my[1].y=__objects[id]->height-buttonheight+3*buttonheight/4;
  my[2].x=__objects[id]->width/4;
  my[2].y=__objects[id]->height-buttonheight+buttonheight/4;
  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,__objects[id]->foreground));
  XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,3,
	       Complex,CoordModeOrigin);

  my[0].x=3*__objects[id]->width/4;
  my[0].y=3*buttonheight/4;
  my[1].x=__objects[id]->width/2;
  my[1].y=buttonheight/4;
  my[2].x=__objects[id]->width/4;
  my[2].y=3*buttonheight/4;
  XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,3,
	       Complex,CoordModeOrigin);
}

void __expose_scrollbar_horiz(XcoObject id)
{
  int buttonwidth,scrollbarwidth,handlewidth,handleposition;
  XPoint my[3];
  buttonwidth=__objects[id]->height;
  scrollbarwidth=__objects[id]->width-2*buttonwidth-6;
  handlewidth=(int)(scrollbarwidth*((scrollbardata*)(__objects[id]->data))->handle_size);
  handleposition=(int)(scrollbarwidth*((scrollbardata*)(__objects[id]->data))->handle_position);
  
  if (handleposition>0)
    XcoFillBox(id,buttonwidth+3,2,
	       handleposition,
	       __objects[id]->height-4,
	       __objects[id]->background);
  if ((scrollbarwidth-handleposition-handlewidth)>0)
    XcoFillBox(id,handleposition+buttonwidth+3+handlewidth,2,
	       scrollbarwidth-handleposition-handlewidth+1,
	       __objects[id]->height-4,	 
	       __objects[id]->background);


  XcoDrawInverted3DBox(id,buttonwidth+1,0,
		       __objects[id]->width-2*buttonwidth-2,
		       __objects[id]->height);

  XcoDraw3DBox(id,
	       handleposition+buttonwidth+3,
	       2,	       
	       handlewidth,
	       __objects[id]->height-4);

  if (handlewidth>4)
    XcoFillBox(id,
	       handleposition+buttonwidth+5,
	       4,
	       handlewidth-4,
	       __objects[id]->height-8,
	       __objects[id]->background);

  if (((scrollbardata*)(__objects[id]->data))->button1_pressed)
    XcoDrawInverted3DBox(id,0,0,
			 buttonwidth,
			 __objects[id]->height);
  else
    XcoDraw3DBox(id,0,0,
		 buttonwidth,
		 __objects[id]->height);

  if (((scrollbardata*)(__objects[id]->data))->button2_pressed)
    XcoDrawInverted3DBox(id,
			 __objects[id]->width-buttonwidth,
			 0,
			 buttonwidth,
			 __objects[id]->height);
  else
    XcoDraw3DBox(id,
		 __objects[id]->width-buttonwidth,
		 0,
		 buttonwidth,
		 __objects[id]->height);



  my[0].x=__objects[id]->width-buttonwidth+buttonwidth/4;
  my[0].y=3*__objects[id]->height/4;
  my[1].x=__objects[id]->width-buttonwidth+3*buttonwidth/4;
  my[1].y=__objects[id]->height/2;
  my[2].x=__objects[id]->width-buttonwidth+buttonwidth/4;
  my[2].y=__objects[id]->height/4;

  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,__objects[id]->foreground));
  XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,3,
	       Complex,CoordModeOrigin);

  my[0].x=3*buttonwidth/4;
  my[0].y=3*__objects[id]->height/4;
  my[1].x=buttonwidth/4;
  my[1].y=__objects[id]->height/2;
  my[2].x=3*buttonwidth/4;
  my[2].y=__objects[id]->height/4;
  XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,3,
	       Complex,CoordModeOrigin);

}


void __expose_scrollbar(XcoObject id)
{
  if (((scrollbardata*)(__objects[id]->data))->type==ScrollbarVert)
    __expose_scrollbar_vert(id);
  else
    __expose_scrollbar_horiz(id);
  XcoFlush();
}

int XcoGetScrollbarStatus(XcoObject id,XcoScrollbarData *data)
{
  data->action=((scrollbardata*)(__objects[id]->data))->action; 
  data->handle_position=((scrollbardata*)(__objects[id]->data))->handle_position;
  data->handle_size=((scrollbardata*)(__objects[id]->data))->handle_size;
  return ((scrollbardata*)(__objects[id]->data))->action; 
}

void XcoSetScrollbarHandlePos(XcoObject id,float handle_pos)
{
  if (handle_pos<0.)
    handle_pos=0.;
  if (handle_pos>(1.0-((scrollbardata*)(__objects[id]->data))->handle_size))
    handle_pos=1.0-((scrollbardata*)(__objects[id]->data))->handle_size;
  ((scrollbardata*)(__objects[id]->data))->handle_position=handle_pos;
  __expose_scrollbar(id);
}

void XcoSetScrollbarHandleSize(XcoObject id,float handle_size)
{
  if (handle_size<0.)
    handle_size=0.;
  if (handle_size>1.)
    handle_size=1.;
  ((scrollbardata*)(__objects[id]->data))->handle_size=handle_size;
  if (((scrollbardata*)(__objects[id]->data))->handle_position>(1.0-((scrollbardata*)(__objects[id]->data))->handle_size))
    ((scrollbardata*)(__objects[id]->data))->handle_position=1.0-((scrollbardata*)(__objects[id]->data))->handle_size;
  __expose_scrollbar(id);
}

static void place_dragbar(XcoObject id,XEvent event)
{
  int type,x,y;
  ((scrollbardata*)(__objects[id]->data))->action=ScrollbarNoAction;
  type=((scrollbardata*)(__objects[id]->data))->type;
  switch (event.type)
    {
    case ButtonPress:
      x=event.xbutton.x;
      y=event.xbutton.y;
      break;
    case MotionNotify:
      x=event.xmotion.x;
      y=event.xmotion.y;
      break;
    }
  if (type==ScrollbarVert)
    {
      int buttonheight=__objects[id]->width;
      int scrollbarheight=__objects[id]->height-2*buttonheight;
      if (scrollbarheight>0)
	{
	  ((scrollbardata*)(__objects[id]->data))->handle_position=
	    ((float)(y-buttonheight)/(float)(scrollbarheight))-((scrollbardata*)(__objects[id]->data))->handle_size*0.5;
	  if (((scrollbardata*)(__objects[id]->data))->handle_position<0.)
	    ((scrollbardata*)(__objects[id]->data))->handle_position=0.;
	  if (((scrollbardata*)(__objects[id]->data))->handle_position>
	      (1.0-((scrollbardata*)(__objects[id]->data))->handle_size))
	    ((scrollbardata*)(__objects[id]->data))->handle_position=
	      (1.0-((scrollbardata*)(__objects[id]->data))->handle_size);
	  ((scrollbardata*)(__objects[id]->data))->action=ScrollbarHandle;
	}
    }
  else
    {
      int buttonwidth=__objects[id]->height;
      int scrollbarwidth=__objects[id]->width-2*buttonwidth;
      if (scrollbarwidth>0)
	{
	  ((scrollbardata*)(__objects[id]->data))->handle_position=
	    ((float)(x-buttonwidth)/(float)(scrollbarwidth))-((scrollbardata*)(__objects[id]->data))->handle_size*0.5;
	  if (((scrollbardata*)(__objects[id]->data))->handle_position<0.)
	    ((scrollbardata*)(__objects[id]->data))->handle_position=0.;
	  if (((scrollbardata*)(__objects[id]->data))->handle_position>
	      (1.0-((scrollbardata*)(__objects[id]->data))->handle_size))
	    ((scrollbardata*)(__objects[id]->data))->handle_position=
	      (1.0-((scrollbardata*)(__objects[id]->data))->handle_size);
	  ((scrollbardata*)(__objects[id]->data))->action=ScrollbarHandle;
	}
    }
#if 0
  printf("Scrollbar: %e, %e, %e\n",
	 ((scrollbardata*)(__objects[id]->data))->handle_position,
	 ((scrollbardata*)(__objects[id]->data))->handle_size,
	 ((scrollbardata*)(__objects[id]->data))->handle_position+
	 ((scrollbardata*)(__objects[id]->data))->handle_size);
#endif
}

void __scrollbar_callback(XcoObject id,XEvent event)
{
  int type;
  ((scrollbardata*)(__objects[id]->data))->action=ScrollbarNoAction;
  type=((scrollbardata*)(__objects[id]->data))->type;
  switch (event.type)
    {
    case Expose:
      __expose_scrollbar(id);
      break;

    case ButtonPress:
      {
	/* Any button pressed?? */
	if (type==ScrollbarVert)
	  {
	    int buttonheight;
	    int y=event.xbutton.y;
	    ((scrollbardata*)(__objects[id]->data))->_pos=y;
	    buttonheight=__objects[id]->width;

	    if (y<buttonheight)
	      {
		((scrollbardata*)(__objects[id]->data))->button1_pressed=1;
		((scrollbardata*)(__objects[id]->data))->action=ScrollbarButtonUp;
	      }
	    else if (y>__objects[id]->height-buttonheight)
	      {
		((scrollbardata*)(__objects[id]->data))->button2_pressed=1;
		((scrollbardata*)(__objects[id]->data))->action=ScrollbarButtonDown;
	      }
	    else
	      {
		place_dragbar(id,event);
	      }
	  }
	else
	  {
	    int buttonwidth;
	    int x=event.xbutton.x;
	    ((scrollbardata*)(__objects[id]->data))->_pos=x;
	    buttonwidth=__objects[id]->height;

	    if (x<buttonwidth)
	      {
		((scrollbardata*)(__objects[id]->data))->button1_pressed=1;
		((scrollbardata*)(__objects[id]->data))->action=ScrollbarButtonUp;
	      }
	    else if (x>__objects[id]->width-buttonwidth)
	      {
		((scrollbardata*)(__objects[id]->data))->button2_pressed=1;
		((scrollbardata*)(__objects[id]->data))->action=ScrollbarButtonDown;
	      }
	    else
	      {
		place_dragbar(id,event);
	      }
	  }
	__expose_scrollbar(id);
      }
      break;
    case ButtonRelease:
      ((scrollbardata*)(__objects[id]->data))->button1_pressed=0;
      ((scrollbardata*)(__objects[id]->data))->button2_pressed=0;
      __expose_scrollbar(id);
      break;
    case MotionNotify:
      {
	  if (type==ScrollbarVert)
	  {
	      int y=event.xmotion.y;
	      int buttonheight=__objects[id]->width;
	      if ((y>=buttonheight) && (y<=__objects[id]->height-buttonheight))
		  place_dragbar(id,event);
	  }
	  else
	  {
	      int x=event.xmotion.x;
	      int buttonwidth=__objects[id]->height;
	      if ((x>=buttonwidth) && (x<=__objects[id]->width-buttonwidth))
		  place_dragbar(id,event);
	  }

	__expose_scrollbar(id);
#if 0
	if ((!((scrollbardata*)(__objects[id]->data))->button1_pressed) &&
	    (!((scrollbardata*)(__objects[id]->data))->button2_pressed))
	  {
	    if (type==ScrollbarVert)
	      {
		int y=event.xmotion.y;
		int buttonheight=__objects[id]->width;
		int scrollbarheight=__objects[id]->height-2*buttonheight;
		if (scrollbarheight>0)
		  {
		    int handleheight=(int)(scrollbarheight*((scrollbardata*)(__objects[id]->data))->handle_size);
		    int handleposition=(int)(scrollbarheight*((scrollbardata*)(__objects[id]->data))->handle_position);
		    /*
		    printf("y:%d, handleposition:%d, buttonheight:%d, handleheight:%d\n",
			   y,handleposition,buttonheight,handleheight);
			   */
		    if ((y>(handleposition+buttonheight+1))&&
			(y<(buttonheight+1+handleposition+handleheight)))
		      {
			int diff=y-((scrollbardata*)(__objects[id]->data))->_pos;
			/*			printf("Diff: %d\n",diff); */
			((scrollbardata*)(__objects[id]->data))->handle_position+=
			  (float)(diff)/(float)(scrollbarheight);
			if (((scrollbardata*)(__objects[id]->data))->handle_position<0.)
			  ((scrollbardata*)(__objects[id]->data))->handle_position=0.;
			if (((scrollbardata*)(__objects[id]->data))->handle_position>
			    (1.0-((scrollbardata*)(__objects[id]->data))->handle_size))
			  ((scrollbardata*)(__objects[id]->data))->handle_position=
			    (1.0-((scrollbardata*)(__objects[id]->data))->handle_size);
			/*			printf("Pos: %f\n",((scrollbardata*)(__objects[id]->data))->handle_position); */
			((scrollbardata*)(__objects[id]->data))->action=ScrollbarHandle;
		      }
		  }
		((scrollbardata*)(__objects[id]->data))->_pos=y;
	      }
	    else
	      {
		int x=event.xmotion.x;

		int buttonwidth=__objects[id]->height;
		int scrollbarwidth=__objects[id]->width-2*buttonwidth;
		if (scrollbarwidth>0)
		  {
		    int handlewidth=(int)(scrollbarwidth*((scrollbardata*)(__objects[id]->data))->handle_size);
		    int handleposition=(int)(scrollbarwidth*((scrollbardata*)(__objects[id]->data))->handle_position);
		    if ((x>(handleposition+buttonwidth+1))&&
			(x<(buttonwidth+1+handleposition+handlewidth)))
		      {
			int diff=x-((scrollbardata*)(__objects[id]->data))->_pos;
			((scrollbardata*)(__objects[id]->data))->handle_position+=
			  (float)(diff)/(float)(scrollbarwidth);
			if (((scrollbardata*)(__objects[id]->data))->handle_position<0.)
			  ((scrollbardata*)(__objects[id]->data))->handle_position=0.;
			if (((scrollbardata*)(__objects[id]->data))->handle_position>
			    (1.0-((scrollbardata*)(__objects[id]->data))->handle_size))
			  ((scrollbardata*)(__objects[id]->data))->handle_position=
			    (1.0-((scrollbardata*)(__objects[id]->data))->handle_size);
			/*			printf("Pos: %f\n",((scrollbardata*)(__objects[id]->data))->handle_position); */
			((scrollbardata*)(__objects[id]->data))->action=ScrollbarHandle;
		      }
		  }
		((scrollbardata*)(__objects[id]->data))->_pos=x;
	      }
	  }
    __expose_scrollbar(id);
#endif
      }
    break;

    }
}

XcoObject XcoCreateScrollbar(XcoObject parent,
			     int x,int y,int width,int height,
			     float handle_size,float handle_pos,int type)
{
  scrollbardata *myscrollbardata;
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);
  XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
	       ExposureMask|ButtonPressMask|ButtonReleaseMask|ButtonMotionMask);


  myscrollbardata=malloc(sizeof( scrollbardata));
  myscrollbardata->handle_size=handle_size;
  myscrollbardata->handle_position=handle_pos;
  myscrollbardata->button1_pressed=0;
  myscrollbardata->button2_pressed=0;
  myscrollbardata->action=ScrollbarNoAction;
  myscrollbardata->type=type;

  __objects[myobject]->data=(void*) myscrollbardata;
  __objects[myobject]->type=XcoTScrollbar;

  __expose_scrollbar(myobject);

  XcoAddCallback(myobject,__scrollbar_callback);

  return (myobject);
}

