/* This is process.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: process.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"


typedef struct __workprocess
{
  int (*wp)();
  struct __workprocess *next;
} workprocess ;

static workprocess *wpfirst=NULL;

void XcoAddWorkProc(int (*wp)())
{
  workprocess *nwp=malloc(sizeof( workprocess));
  nwp->wp=wp;
  nwp->next=wpfirst;
  wpfirst=nwp;
}

/* this function never returns */
void XcoProcessEvents()
{
  XEvent event;
  while (1)
    {
      if (wpfirst!=NULL)
	{
	  /* Execute all workprocesses. */
	  workprocess *step=wpfirst;
	  workprocess *previous=NULL;
	  while (step!=NULL)
	    {
	      if (step->wp())
		{
		  /* Remove this work process... */
		  if (previous==NULL)
		    {
		      wpfirst=step->next;
		      free(step);
		      step=wpfirst;
		    }
		  else
		    {
		      previous->next=step->next;
		      free(step);
		      step=previous->next;
		    }
		}
	      else
		{
		  previous=step;
		  step=step->next;
		}
	    }
	}
      if ((wpfirst==NULL) || (XPending(XcoGetDisplay())>0))
	{
	  while (XPending(XcoGetDisplay())>0)
	    {
	      Window w;
	      XcoObject id;
	      XNextEvent(XcoGetDisplay(),&event);
	      /* printf("Event!\n"); */
	      w=event.xany.window;
	      id=0;
	      while ((id<MAX_OBJECTS) && (((__used_objects[id]) && (__objects[id]->window!=w)) || (!__used_objects[id])))
		id++;
	      if ((id<MAX_OBJECTS) && (__used_objects[id]) && (__objects[id]->window==w))
		{
		  XcoExecuteCallbacks(id,event);
		}
	    }
	}
    }
}

/* this function returns */
void XcoPollEvents()
{
  XEvent event;
  if ((wpfirst==NULL) || (XPending(XcoGetDisplay())>0))
    {
      while (XPending(XcoGetDisplay())>0)
	{
	  Window w;
	  XcoObject id=0;
	  XNextEvent(XcoGetDisplay(),&event);
	  /* printf("Event!\n"); */
	  w=event.xany.window;

	  while ((id<MAX_OBJECTS) && (((__used_objects[id]) && (__objects[id]->window!=w)) || (!__used_objects[id])))
	    id++;
	  if ((id<MAX_OBJECTS) && (__used_objects[id]) && (__objects[id]->window==w))
	    {
	      XcoExecuteCallbacks(id,event);
	    }
	}
    }
}

/* this function returns after an event has been received */
void XcoWaitForEvents()
{
  XEvent event;
  if ((wpfirst==NULL) || (XPending(XcoGetDisplay())>0))
    {
      do
	{
	  Window w;
	  XcoObject id=0;
	  XNextEvent(XcoGetDisplay(),&event);
	  /* printf("Event!\n"); */
	  w=event.xany.window;

	  while ((id<MAX_OBJECTS) && (((__used_objects[id]) && (__objects[id]->window!=w)) || (!__used_objects[id])))
	    id++;
	  if ((id<MAX_OBJECTS) && (__used_objects[id]) && (__objects[id]->window==w))
	    {
	      XcoExecuteCallbacks(id,event);
	    }
	} while (XPending(XcoGetDisplay())>0);
    }
}

