/* This is primitives.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: primitives.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>

#include "Xco.h"

void XcoDrawPolyLineRGB(XcoObject id,XPoint *points,int npoints, 
		  int r,int g,int b)
{
  XSetForeground(XcoGetDisplay(),__objects[id]->gc,XcoGetPixel(0,0,r,g,b));
  XDrawLines(XcoGetDisplay(),__objects[id]->window,__objects[id]->gc,
	     points,npoints,CoordModeOrigin);
}

void XcoDrawPolyLine(XcoObject id,XPoint *points,int npoints, 
		  int pixel)
{
  XSetForeground(XcoGetDisplay(),__objects[id]->gc,XcoGetPixel32(0,0,pixel));
  XDrawLines(XcoGetDisplay(),__objects[id]->window,__objects[id]->gc,
	     points,npoints,CoordModeOrigin);
}

void XcoDraw3DBox(XcoObject id,int x,int y,int width,int height)
{
  XPoint mypoints[3];
  mypoints[0].x=x;
  mypoints[0].y=y+height-2;
  mypoints[1].x=x;
  mypoints[1].y=y;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y;
  XcoDrawPolyLineRGB(id,mypoints,3,255,255,255);
  mypoints[0].x=x+1;
  mypoints[0].y=y+height-2;
  mypoints[1].x=x+1;
  mypoints[1].y=y+1;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y+1;
  XcoDrawPolyLineRGB(id,mypoints,3,255,255,255);
  mypoints[0].x=x;
  mypoints[0].y=y+height-1;
  mypoints[1].x=x+width-1;
  mypoints[1].y=y+height-1;
  mypoints[2].x=x+width-1;
  mypoints[2].y=y;
  XcoDrawPolyLineRGB(id,mypoints,3,0,0,0);
  mypoints[0].x=x+1;
  mypoints[0].y=y+height-2;
  mypoints[1].x=x+width-2;
  mypoints[1].y=y+height-2;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y+1;
  XcoDrawPolyLineRGB(id,mypoints,3,0,0,0);
}

void XcoDrawDecoratedBox(XcoObject id,int x,int y,int width,int height)
{
  XPoint mypoints[5];
  mypoints[0].x=x;
  mypoints[0].y=y;
  mypoints[1].x=x+width-2;
  mypoints[1].y=y;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y+height-2;
  mypoints[3].x=x;
  mypoints[3].y=y+height-2;
  mypoints[4].x=x;
  mypoints[4].y=y;
  XcoDrawPolyLineRGB(id,mypoints,5,0,0,0);
  mypoints[0].x=x;
  mypoints[0].y=y+height-1;
  mypoints[1].x=x+width-1;
  mypoints[1].y=y+height-1;
  mypoints[2].x=x+width-1;
  mypoints[2].y=y;
  XcoDrawPolyLineRGB(id,mypoints,3,255,255,255);
  mypoints[0].x=x+1;
  mypoints[0].y=y+height-3;
  mypoints[1].x=x+1;
  mypoints[1].y=y+1;
  mypoints[2].x=x+width-3;
  mypoints[2].y=y+1;
  XcoDrawPolyLineRGB(id,mypoints,3,255,255,255);
}

void XcoDrawInverted3DBox(XcoObject id,int x,int y,int width,int height)
{
  XPoint mypoints[3];
  mypoints[0].x=x;
  mypoints[0].y=y+height-2;
  mypoints[1].x=x;
  mypoints[1].y=y;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y;
  XcoDrawPolyLineRGB(id,mypoints,3,0,0,0);
  mypoints[0].x=x+1;
  mypoints[0].y=y+height-2;
  mypoints[1].x=x+1;
  mypoints[1].y=y+1;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y+1;
  XcoDrawPolyLineRGB(id,mypoints,3,0,0,0);
  mypoints[0].x=x;
  mypoints[0].y=y+height-1;
  mypoints[1].x=x+width-1;
  mypoints[1].y=y+height-1;
  mypoints[2].x=x+width-1;
  mypoints[2].y=y;
  XcoDrawPolyLineRGB(id,mypoints,3,255,255,255);
  mypoints[0].x=x+1;
  mypoints[0].y=y+height-2;
  mypoints[1].x=x+width-2;
  mypoints[1].y=y+height-2;
  mypoints[2].x=x+width-2;
  mypoints[2].y=y+1;
  XcoDrawPolyLineRGB(id,mypoints,3,255,255,255);
}

void XcoFillBox(XcoObject id,int x,int y,int width,int height,int pixel)
{
  XSetForeground(XcoGetDisplay(),__objects[id]->gc,XcoGetPixel32(0,0,pixel));
  XFillRectangle(XcoGetDisplay(),__objects[id]->window,__objects[id]->gc,
		 x,y,width,height);
}


static int current_font_ascent;

XFontStruct *XcoLoadFont(char *name)
{
  return(XLoadQueryFont(XcoGetDisplay(),name));
}

int XcoTextWidth(XFontStruct *fstruct,char *str)
{
  return(XTextWidth(fstruct,str,strlen(str)));
}

int XcoTextHeight(XFontStruct *fstruct)
{
  return(fstruct->ascent+fstruct->descent);
}

void XcoUseFont(XcoObject id,XFontStruct *fstruct)
{
  XSetFont(XcoGetDisplay(),XcoGC(id),fstruct->fid);
  current_font_ascent=fstruct->ascent;
}

void XcoDrawFont(XcoObject id,int x,int y,char *str,int pixel)
{
  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,pixel));  
  XDrawString(XcoGetDisplay(),XcoWindow(id),XcoGC(id),x,y+current_font_ascent,str,strlen(str));
}

void XcoDrawImageFont(XcoObject id,int x,int y,char *str,int foregroundpixel,int backgroundpixel)
{
  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,foregroundpixel));  
  XSetBackground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,backgroundpixel));  
  XDrawImageString(XcoGetDisplay(),XcoWindow(id),XcoGC(id),x,y+current_font_ascent,str,strlen(str));
}

