/* This is list.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: list.c 8 2003-05-20 11:37:20Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "Xco.h"

static XFontStruct *listfont;

void XcoListFont(XFontStruct *fstruct)
{
  listfont=fstruct;
}

typedef struct
{
  char **str;
  int elements;
  int selected;  
  int listwidth;
  int textheight;
  int scrollbarsize;
  int first;
  int listxpos;
  XcoObject scrollbarvert;
  XcoObject scrollbarhoriz;
  XcoObject hole;
  XcoObject hole2;
  int status;
} listdata;

typedef struct
{
  XcoObject list;
} parentdata;

void __expose_list_hole(XcoObject id)
{
  int i;
  listdata *mylist=((listdata*)(__objects[id]->data));

  float handle_size=1.0;
  if (mylist->elements!=0)
    handle_size=(float)(__objects[id]->height-mylist->scrollbarsize)/
    (float)(mylist->textheight*mylist->elements);
  if (handle_size>1.0)
    handle_size=1.0;
  XcoSetScrollbarHandleSize(mylist->scrollbarvert,handle_size);

  handle_size=(float)(__objects[id]->width-mylist->scrollbarsize)/
    (float)(mylist->listwidth);
  if (handle_size>1.0)
    handle_size=1.0;
  XcoSetScrollbarHandleSize(mylist->scrollbarhoriz,handle_size);

  XcoUseFont(mylist->hole,listfont);
  i=0;
  if (mylist->elements>0)
    {
      for (i=mylist->first; i<mylist->elements; i++)
	{
	  int fpix=__objects[id]->foreground;
	  int bpix=__objects[id]->background;
	  int w;
	  if (i==mylist->selected)
	    {
	      int x=fpix;
	      fpix=bpix;
	      bpix=x;
	    }
	  if ((i-mylist->first)*mylist->textheight>__objects[mylist->hole]->height)
	    break;
	  w=XcoTextWidth(listfont,mylist->str[i]);

	  XcoDrawImageFont(mylist->hole,-mylist->listxpos,
			   (i-mylist->first)*mylist->textheight,
			   mylist->str[i],fpix,bpix);
	  if ((w-mylist->listxpos)<__objects[mylist->hole]->width)
	    XcoFillBox(mylist->hole,
		       w-mylist->listxpos,
		       (i-mylist->first)*mylist->textheight,
		       __objects[mylist->hole]->width-(w-mylist->listxpos),
		       mylist->textheight,
		       bpix);
	}
    }
  if ((i-mylist->first)*mylist->textheight<__objects[mylist->hole]->height)
    XcoFillBox(mylist->hole,0,(i-mylist->first)*mylist->textheight,
	       __objects[mylist->hole]->width,
	       __objects[mylist->hole]->height-(i-mylist->first)*mylist->textheight,
	       __objects[id]->background);
}

void __expose_list_hole2(XcoObject id)
{  
  XcoDrawInverted3DBox(id,0,0,
		       __objects[id]->width,
		       __objects[id]->height);
}


void __list_scrollbarhoriz_callback(XcoObject id,XEvent dummy)
{
  XcoScrollbarData data;
  if (XcoGetScrollbarStatus(id,&data))
    {
      XcoObject list_id=((parentdata*)(__objects[id]->parentdata))->list;
      listdata *mylist=((listdata*)(__objects[list_id]->data));
      switch (data.action)
	{
	case ScrollbarButtonLeft:
	  {
	    float handle_pos;
	    mylist->listxpos--;
	    if (mylist->listxpos<0)
	      mylist->listxpos=0;
	    handle_pos=(float)(mylist->listxpos)/(float)(mylist->listwidth);
	    XcoSetScrollbarHandlePos(id,handle_pos);
	  }
	  break;
	case ScrollbarButtonRight:
	  {
	    float handle_pos;
	    mylist->listxpos++;
	    if (mylist->listxpos>(4+mylist->listwidth-__objects[mylist->hole]->width))
	      mylist->listxpos--;
	    handle_pos=(float)(mylist->listxpos)/(float)(mylist->listwidth);
	    if (handle_pos>1.0)
	      handle_pos=1.0;
	    XcoSetScrollbarHandlePos(id,handle_pos);
	  }
	  break;	
	case ScrollbarHandle:
	  {
	    float handle_pos;
	    mylist->listxpos=(int)(data.handle_position*mylist->listwidth+0.5);
	    if (mylist->listxpos>(4+mylist->listwidth-__objects[mylist->hole]->width))
	      mylist->listxpos=4+mylist->listwidth-__objects[mylist->hole]->width;
	    if (mylist->listxpos<0)
	      mylist->listxpos=0;
	    handle_pos=(float)(mylist->listxpos)/(float)(mylist->listwidth);
	    if (handle_pos>1.0)
	      handle_pos=1.0;
	    XcoSetScrollbarHandlePos(id,handle_pos);
	  }
	  break;
	}
      __expose_list_hole(list_id);
    }
}

static void scrollbarbuttonup(listdata *mylist,XcoObject id)
{
    float handle_pos;
    mylist->first--;
    if (mylist->first<0)
	mylist->first=0;
    handle_pos=(float)(mylist->first)/(float)(mylist->elements);
    XcoSetScrollbarHandlePos(id,handle_pos);
}

static void scrollbarbuttondown(listdata *mylist,XcoObject id)
{
    int element_fit;
    float handle_pos;
    mylist->first++;
    element_fit=__objects[mylist->hole]->height/mylist->textheight;
    /* printf("element_fit:%d,first:%d\n",element_fit,mylist->first); */
    if (mylist->first>(mylist->elements-element_fit))
	mylist->first--;
    handle_pos=(float)(mylist->first)/(float)(mylist->elements);
    XcoSetScrollbarHandlePos(id,handle_pos);
}

void __list_scrollbarvert_callback(XcoObject id,XEvent dummy)
{
  XcoScrollbarData data;
  if (XcoGetScrollbarStatus(id,&data))
    {
      XcoObject list_id=((parentdata*)(__objects[id]->parentdata))->list;
      listdata *mylist=((listdata*)(__objects[list_id]->data));
      switch (data.action)
	{
	case ScrollbarButtonUp:
	    scrollbarbuttonup(mylist,id);
	  break;	
	case ScrollbarButtonDown:
	    scrollbarbuttondown(mylist,id);
	  break;
	case ScrollbarHandle:
	  {
	    int element_fit;
	    mylist->first=(int)(data.handle_position*mylist->elements+0.5);
	    element_fit=__objects[mylist->hole]->height/mylist->textheight;
	    /* printf("element_fit:%d,first:%d\n",element_fit,mylist->first); */
	    if (mylist->first<0)
	      mylist->first=0;
	    if (element_fit<=mylist->elements)
	      if (mylist->first>(mylist->elements-element_fit))
		mylist->first=mylist->elements-element_fit;
	  }
	  break;
	}
      __expose_list_hole(list_id);      
    }
}

void __list_hole_callback(XcoObject id,XEvent event)
{
  XcoObject list_id=((parentdata*)(__objects[id]->parentdata))->list;
  ((listdata*)(__objects[list_id]->data))->status=-1;
  switch (event.type)
    {
    case Expose:
      __expose_list_hole(list_id);
      break;
    case ButtonPress:
      {
	  listdata *mylist=((listdata*)(__objects[list_id]->data));
	  /* Maybe this is the scroll wheel? */
	  if (event.xbutton.button==4)
	      scrollbarbuttonup(mylist,mylist->scrollbarvert);
          else if (event.xbutton.button==5)
	      scrollbarbuttondown(mylist,mylist->scrollbarvert);
	  else if (event.xbutton.button==1)
	  {
	      /* Nope. Ordinary button */
	      int y=event.xbutton.y-2;
	      if ((y>=0) && (y<=__objects[id]->height))
	      {
		  int sel=y/mylist->textheight+mylist->first;
		  if (mylist->selected==sel)
		      mylist->selected=-1;
		  else
		      mylist->selected=sel;
		  if (mylist->selected>(mylist->elements-1))
		      mylist->selected=-1;
		  if (mylist->selected!=-1)
		      ((listdata*)(__objects[list_id]->data))->status=mylist->selected;
	      }
	  }
      }
      __expose_list_hole(list_id);
      break;
    }
  XcoExecuteCallbacks(list_id,event);
}

void __list_hole2_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_list_hole2(id);
      break;
    }
}

int XcoGetListStatus(XcoObject id)
{
  return(((listdata*)(__objects[id]->data))->status);
}

void XcoSetListStatus(XcoObject id, int select_item)
{
    XcoObject list_id=id;/* ((parentdata*)(__objects[id]->parentdata))->list; */
    listdata *mylist=((listdata*)(__objects[list_id]->data));
    mylist->selected=select_item;
    if (mylist->selected<0)
	mylist->selected=-1;
    else if (mylist->selected>(mylist->elements-1))
	mylist->selected=-1;
    if (mylist->selected!=-1)
	((listdata*)(__objects[list_id]->data))->status=mylist->selected;
  __expose_list_hole(id);    
}

void XcoSetListData(XcoObject id,char **str,int elements)
{
  int i;
  float handle_size;
  listdata *mylistdata=(listdata*)(__objects[id]->data);
  mylistdata->str=str;
  mylistdata->elements=elements;
  mylistdata->selected=-1;
  mylistdata->first=0;
  mylistdata->listxpos=0;
  mylistdata->status=-1;

  mylistdata->listwidth=1;
  if (elements>0)
    {
      mylistdata->listwidth=XcoTextWidth(listfont,str[0]);
      if (elements>1)
	for (i=2; i<elements; i++)
	  {
	    int w=XcoTextWidth(listfont,str[i-1]);
	    if (w>mylistdata->listwidth)
	      mylistdata->listwidth=w;
	  }
    }

  handle_size=1.0;
  if (elements!=0)
    handle_size=(float)(__objects[id]->height-mylistdata->scrollbarsize)/(float)(mylistdata->textheight*elements);
  if (handle_size>1.0)
    handle_size=1.0;
  XcoSetScrollbarHandleSize(mylistdata->scrollbarvert,handle_size);
  XcoSetScrollbarHandlePos(mylistdata->scrollbarvert,0);

  handle_size=(float)(__objects[id]->width-mylistdata->scrollbarsize)/(float)(mylistdata->listwidth);
  if (handle_size>1.0)
    handle_size=1.0;
  XcoSetScrollbarHandleSize(mylistdata->scrollbarhoriz,handle_size);
  XcoSetScrollbarHandlePos(mylistdata->scrollbarhoriz,0);

  __expose_list_hole(id);
}


XcoObject XcoCreateList(XcoObject parent,
			int x,int y,int width,int height,int scrollbarsize,
			char **str,int elements)
{
  parentdata *myparent1,*myparent2,*myparent3,*myparent4;
  int i;
  listdata *mylistdata;

  float handle_size;
  XcoObject temphole;

  XcoObject myobject=XcoCreateWindow(x,y,width,height,
#if 0
				     DEFAULT_BACKGROUND,
#else
				     PIXEL(255,255,255),
#endif
				     1,
				     parent);

  myparent1=malloc(sizeof(parentdata));
  myparent1->list=myobject;
  myparent2=malloc(sizeof(parentdata));
  myparent2->list=myobject;
  myparent3=malloc(sizeof(parentdata));
  myparent3->list=myobject;
  myparent4=malloc(sizeof(parentdata));
  myparent4->list=myobject;

  mylistdata=malloc(sizeof( listdata));
  mylistdata->str=str;
  mylistdata->elements=elements;
  mylistdata->selected=-1;
  mylistdata->first=0;
  mylistdata->listxpos=0;
  mylistdata->status=-1;

  mylistdata->textheight=XcoTextHeight(listfont);
  mylistdata->listwidth=1;
  if (elements>0)
    {
      mylistdata->listwidth=XcoTextWidth(listfont,str[0]);
      if (elements>1)
	for (i=2; i<elements; i++)
	  {
	    int w=XcoTextWidth(listfont,str[i-1]);
	    if (w>mylistdata->listwidth)
	      mylistdata->listwidth=w;
	  }
    }
  mylistdata->scrollbarsize=scrollbarsize;
  
  handle_size=1.0;
  if (elements!=0)
    handle_size=(float)(height-scrollbarsize)/(float)(mylistdata->textheight*elements);
  if (handle_size>1.0)
    handle_size=1.0;


  temphole=XcoCreateHole(myobject,width-scrollbarsize,0,scrollbarsize,height);
  XcoSetResizeMethod(temphole,XcoResizeRight);
  mylistdata->scrollbarvert=XcoCreateScrollbar(temphole,
					       0,0,
					       scrollbarsize,height-scrollbarsize,
					       handle_size,
					       0,ScrollbarVert);
  XcoSetResizeMethod(mylistdata->scrollbarvert,XcoUpLeftDownRight);
  XcoAddCallback(mylistdata->scrollbarvert,__list_scrollbarvert_callback);

  __objects[mylistdata->scrollbarvert]->parentdata=myparent1;

  handle_size=(float)(width-scrollbarsize)/(float)(mylistdata->listwidth);
  if (handle_size>1.0)
    handle_size=1.0;

  temphole=XcoCreateHole(myobject,0,height-scrollbarsize,width,scrollbarsize);
  XcoSetResizeMethod(temphole,XcoDownResize);
  mylistdata->scrollbarhoriz=XcoCreateScrollbar(temphole,
						0,0,
						width-scrollbarsize,scrollbarsize,
						handle_size,
						0,ScrollbarHoriz);
  XcoSetResizeMethod(mylistdata->scrollbarhoriz,XcoUpLeftDownRight);
  XcoAddCallback(mylistdata->scrollbarhoriz,__list_scrollbarhoriz_callback);

  __objects[mylistdata->scrollbarhoriz]->parentdata=myparent2;

  mylistdata->hole2=XcoCreateHole(myobject,0,0,width-scrollbarsize,height-scrollbarsize);
  XcoSetResizeMethod(mylistdata->hole2,XcoUpLeftDownRight);
  XcoAddCallback(mylistdata->hole2,__list_hole2_callback);
  __objects[mylistdata->hole2]->parentdata=myparent3;


  mylistdata->hole=XcoCreateHole(mylistdata->hole2,2,2,width-scrollbarsize-4,height-scrollbarsize-4);
  XcoSetResizeMethod(mylistdata->hole,XcoUpLeftDownRight);
  XSelectInput(XcoGetDisplay(),XcoWindow(mylistdata->hole),
	       ExposureMask|ButtonPressMask);

  XcoAddCallback(mylistdata->hole,__list_hole_callback);
  __objects[mylistdata->hole]->parentdata=myparent4;

  __objects[myobject]->data=(void*) mylistdata;
  __objects[myobject]->type=XcoTList;
  
  __expose_list_hole(myobject);

  return (myobject);
}

