/* This is init.c
   A part of the Xco library
   Copyright (C) 1997-2001 Daniel Spangberg
   */

#if 0
#define DEBUG_VISUAL
#endif

static char rcsid[]="$Id: init.c 19 2012-01-23 17:49:34Z daniels $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xco.h"

static char *applicationName=NULL;
static char *applicationClass=NULL;
static Display *display;
static int screen;
static Visual *visual;
static int depth;
static int true_color_screen;
static int default_visual;
static Colormap colormap;
static int colormapsize;
static int shared_colormap;
static int screen_width;
static int screen_height;

static unsigned int r_shift;
static unsigned int g_shift;
static unsigned int b_shift;
static unsigned int r_bits;
static unsigned int g_bits;
static unsigned int b_bits;
static unsigned int r_mask;
static unsigned int g_mask;
static unsigned int b_mask;

static unsigned int dither_rmask;
static unsigned int dither_gmask;
static unsigned int dither_bmask;
static unsigned int dither_radd;
static unsigned int dither_gadd;
static unsigned int dither_badd;

static unsigned int do_dither;

static unsigned int bytes_per_pixel;

static int pad;
static int padbyte;

static int border,bpad,bunit;
static int xbpp;

/* static int dither[16]={ 16,2,14,4,6,12,8,10,3,15,1,13,9,5,11,7 }; */
static int dither[16]={ 16,1,14,3,5,12,7,10,2,15,0,13,9,4,11,6 };

static int alloc_colortable[1024];
static int use_alloc_colortable;

static int dithertable_r[16*256];
static int dithertable_g[16*256];
static int dithertable_b[16*256];

static int endian;
static int require_byte_swap;

typedef union
{
  uint32 ltype;
  unsigned char stype[4]; 
} etest ;

static int endian_test()
{
  etest mytest;
  mytest.ltype=0x01020304;
  if (mytest.stype[0]==0x4)
    return 0;
  if (mytest.stype[0]==0x1)
    return 1;

  printf("Cannot determine endianess\n");
  printf("Result: %d,%d,%d,%d\n",mytest.stype[0],mytest.stype[1],mytest.stype[2],mytest.stype[3]);
  printf("Should be 1,2,3,4 for big endian machine and 4,3,2,1 for little endian machine\n");
  exit(1);
}

/* Routines for byte swapping. Overloading seemed fine here. :-( */
static  uint16 byteswap16(uint16 word)
{
  return (((word&0xff00)>>8)|((word&0xff)<<8));
}

static  uint32 byteswap32(uint32 longword)
{
  return (((longword&0xffL)<<24)|
	  ((longword&0xff00L)<<8)|
	  ((longword&0xff0000L)>>8)|
	  ((longword&0xff000000L)>>24));
}

void XcoSetApplicationName(char *name)
{
  applicationName=malloc(strlen(name)+1);
  strcpy(applicationName,name);
}

void XcoSetApplicationClass(char *name)
{
  applicationClass=malloc(strlen(name)+1);
  strcpy(applicationClass,name);
}

char *XcoGetApplicationName()
{
  return applicationName;
}

char *XcoGetApplicationClass()
{
  return applicationClass;
}


Display *XcoGetDisplay()
{
  return (display);
}

Colormap XcoGetColormap()
{
  return (colormap);
}

Visual *XcoGetVisual()
{
  return (visual);
}

int XcoGetScreen()
{
  return (screen);
}

int XcoGetScreenHeight()
{
    return (screen_height);
}

int XcoGetScreenWidth()
{
    return (screen_width);
}

int XcoGetDepth()
{
  return(depth);
}

int XcoGetBytesPerPixel()
{
  return (bytes_per_pixel);
}

int XcoGetPad()
{
  return pad;
}

int XcoGetPadByte()
{
  return padbyte;
}

int XcoGetNPad()
{
  /* Extra pad per scanline */
  return (XcoGetPad()/8-XcoGetBytesPerPixel());
}

int XcoDefaultVisualQuery()
{
  return (default_visual);
}

int XcoWParamsQuery()
{
  if (!default_visual)
    return 1;
  if (!true_color_screen)
    {
      if (!shared_colormap)
	return 1;
    }
  return 0;
}


void __XcoInitDitherBuffers()
{
  int pos,rgb,r,g,b,rmod,gmod,bmod,cdit,cdit2,cdit3;
  for (pos=0; pos<=15; pos++)
    for (rgb=0; rgb<=255; rgb++)
      {
	r=rgb;
	g=rgb;
	b=rgb;
	rmod=r & dither_rmask;
	(r_bits<4) ? 
	  (rmod>>=(4-r_bits))
	  :
	  (rmod<<=(r_bits-4));
	gmod=g & dither_gmask;
	(g_bits<4) ?
	  (gmod>>=(4-g_bits))
	  :
	  (gmod<<=(g_bits-4));
	bmod=b & dither_bmask;
	(b_bits<4) ?
	  (bmod>>=(4-b_bits))
	  :
	  (bmod<<=(b_bits-4));
	cdit=dither[pos];
#if 0
	cdit2=cdit+5;
	if (cdit2>16)
	  cdit2=cdit2-16;
	cdit3=cdit+11;
	if (cdit3>16)
	  cdit3=cdit3-16;
	
#else
	cdit2=cdit3=cdit;
#endif
	if (rmod>cdit)
	  r+=dither_radd;
	if (gmod>cdit2)
	  g+=dither_gadd;
	if (bmod>cdit3)
	  b+=dither_badd;

	if (r>255)
	  r=255;
	if (g>255)
	  g=255;
	if (b>255)
	  b=255;

	/* Map colors */

	r>>=(8-r_bits);
	g>>=(8-g_bits);
	b>>=(8-b_bits);
	dithertable_r[pos+(rgb<<4)]=r<<r_shift;
	dithertable_g[pos+(rgb<<4)]=g<<g_shift;
	dithertable_b[pos+(rgb<<4)]=b<<b_shift;
      }
}

static int default_background;
static int default_foreground;

int XcoGetDefaultBackground()
{
  return default_background;
}

int XcoGetDefaultForeground()
{
  return default_foreground;
}

void XcoSetDefaultBackground(int pixel)
{
  default_background=pixel;
}

void XcoSetDefaultForeground(int pixel)
{
  default_foreground=pixel;
}


static int (*do_visual_query)(Display *dpy,int screen, XVisualInfo *vis)=NULL;
static void (*do_visual_postprocess)(Display *dpy,int screen, XVisualInfo *vis)=NULL;

void XcoSetQueryVisual(int (*dvq)(Display *dpy,int screen, XVisualInfo *vis),
		       void (*dvpp)(Display *dpy,int screen, XVisualInfo *vis))
{
    do_visual_query=dvq;
    do_visual_postprocess=dvpp;
}

static XcoInitError_t XcoInitError;

XcoInitError_t XcoGetInitError()
{
    return XcoInitError;
}

int XcoInit()
{
  int color_screen;
  XVisualInfo tmp;
  int nmatch;
  XVisualInfo *myinfo;
  int *acceptvisual;
  int *old_acceptvisual;
  int i,naccept=0,old_naccept;
  int vinfon;
  int maxdepth;
  int depth24;
  XFontStruct *myfont;
  int iformats,nformats;
  XPixmapFormatValues *myformats;

  XcoInitError=XcoInitNoError;

  printf("This program uses Xco version %s.\n",PROGRAMVERSION);
  display=XOpenDisplay((char*) NULL);
  if (display==NULL)
    {
#if 0
      printf("Can't open display.\n");
#endif
      XcoInitError=XcoInitNoDisplay;
      return 1;
    }


  screen=DefaultScreen(display);
    
  screen_width=DisplayWidth(XcoGetDisplay(),XcoGetScreen());
  screen_height=DisplayHeight(XcoGetDisplay(),XcoGetScreen());

  bunit=BitmapUnit(display);
  /*  printf("Bitmap unit:%d\n",bunit); */

  bpad=BitmapPad(display);
  /* printf("Bitmap pad:%d\n",bpad); */

  border=ImageByteOrder(display);
  /* printf("Image byte order:%d\n",border); */

  if (border==0)
    printf("Server is a little endian machine\n");
  else
    printf("Server is a big endian machine\n");
  

  endian=endian_test();
  if (endian==0)
    printf("I (client) am a little endian machine\n");
  else
    printf("I (client) am a big endian machine\n");

  if (border!=endian)
    {
      printf("I must do byte swapping.\n");
      require_byte_swap=1;
    }
  else
    {
      printf("I won't do byte swapping.\n");
      require_byte_swap=0;
    }

  color_screen=1;
  true_color_screen=0;
  default_visual=1;
  shared_colormap=1;

  tmp.screen=screen;

  myinfo=XGetVisualInfo(display,VisualScreenMask,&tmp,&nmatch);

#ifdef DEBUG_VISUAL
  printf("Found %d visuals\n",nmatch);
#endif
  acceptvisual=malloc(sizeof(int)*nmatch);
  
  for (i=0; i<nmatch; i++)
    {
      if (myinfo[i].class==PseudoColor)
	{
	  if ((myinfo[i].depth<=8) && (myinfo[i].colormap_size<=256))
	    {
	      acceptvisual[i]=1;
	      naccept++;
	    }
	  else
	    acceptvisual[i]=0;	    
	}
      else if  (myinfo[i].class==TrueColor)
	{
	  acceptvisual[i]=1;
	  naccept++;
	}
      else
	acceptvisual[i]=0;
#ifdef DEBUG_VISUAL
      if (acceptvisual[i]==0)
	printf("Throwing away visual: %d\n",(int)myinfo[i].visualid);
      else
	printf("Accepting visual: %d\n",(int)myinfo[i].visualid);
#endif
    }
#ifdef DEBUG_VISUAL
  printf("%d visuals accepted after Xlib step\n",naccept);
#endif
  if (naccept==0)
    {
#if 0
      printf("No visuals usable by Xlib routines.\n");
#endif
      XcoInitError=XcoInitNoVisuals;
      return 1;
    }
  if (do_visual_query)
  {
      old_acceptvisual=malloc(sizeof(int)*naccept);
      old_naccept=0;
      
      for (i=0; i<nmatch; i++)
	  if (acceptvisual[i])
	      old_acceptvisual[old_naccept++]=i;
      naccept=0;
      
      for (i=0; i<nmatch; i++)
      {
	  if (acceptvisual[i])
	  {
	      acceptvisual[i]=do_visual_query(display,screen,&myinfo[i]);
	      if (acceptvisual[i])
		  naccept++;
	  }
      }
      if (naccept==0)
      {
#if 0
	  printf("Not supported because there are no visuals available that can\n"
		 "be used by both Other and Xlib routines.\n");
#endif
	  for (i=0; i<old_naccept; i++)
	      acceptvisual[old_acceptvisual[i]]=1;
      }
      free(old_acceptvisual);
      if (naccept==0)
      {
	  XcoInitError=XcoInitNoOtherVisuals;
	  return 1;
      }
  }
  /* Find highest depth and use it. If we have depth 24 we use and prefer that. */

  depth24=0;
  maxdepth=0;
  for (i=0; i<nmatch; i++)
    {
      if (acceptvisual[i])
	{
	  if (myinfo[i].depth>maxdepth)
	    maxdepth=myinfo[i].depth;
	  if (myinfo[i].depth==24)
	    depth24=1;
	}
    }
  
  if (depth24)
    maxdepth=24;

  default_visual=0;
  
  vinfon=0;
  /* Can we use default visual? */
  if (maxdepth==DefaultDepth(display,screen))
    {
      for (i=0; i<nmatch; i++)
	{
	  if (acceptvisual[i])
	    {
	      if (myinfo[i].visualid==XVisualIDFromVisual(DefaultVisual(display,screen)))
		{
		  /* ok */
		  default_visual=1;
		  vinfon=i;
		  break;
		}
	    }
	}
    }

  true_color_screen=0;
  color_screen=1;
  if (default_visual)
    {
      visual=DefaultVisual(display,screen);
      depth=DefaultDepth(display,screen);
    }
  else
    {
      depth=maxdepth;
      for (i=0; i<nmatch; i++)
	{
	  if (acceptvisual[i])
	    {
	      if (myinfo[i].depth==maxdepth)
		{
		  visual=myinfo[i].visual;
		  vinfon=i;
		  break;
		}
	    }
	}
    }
  if (visual->class==TrueColor)
    true_color_screen=1;

  if (do_visual_postprocess)
      do_visual_postprocess(display,screen,&myinfo[vinfon]);
  
  XFree(myinfo);
  free(acceptvisual);


  /*
  printf("Visual: %d\n",(int) XVisualIDFromVisual(visual));
  printf("Depth: %d\n",depth);
  printf("true_color_screen:%d\n",true_color_screen);
  printf("default_visual:%d\n",default_visual);
  printf("Bits per rgb:%d\n",visual->bits_per_rgb);
  */


  myformats=XListPixmapFormats(display,&nformats);
  /* printf("Supported pixmap formats: %d\n",nformats); */
  for (iformats=0; iformats<nformats; iformats++)
    {
      /* printf("Pixmap depth=%d, bpp=%d ",myformats[iformats].depth,myformats[iformats].bits_per_pixel); */
      if (myformats[iformats].depth==depth)
	{
	  /* printf("Using this one\n"); */
	  xbpp=myformats[iformats].bits_per_pixel;
	}
      /*
      else
	printf("\n"); */
    }
  XFree((char*)myformats);



  if (true_color_screen)
    {
      colormap=XCreateColormap(display,RootWindow(display,screen),
      	 		       visual,AllocNone);
      /*      XSetWindowColormap(display,window,colormap); */
      /* Find the correct mask values */
      use_alloc_colortable=0;
      r_mask=visual->red_mask;
      g_mask=visual->green_mask;
      b_mask=visual->blue_mask;
      if ((r_mask==0) || (g_mask==0) || (b_mask==0))
	{
#if 0
	  printf("Some of the mask values are zero.\n");
	  printf("I really need those values to be able to compute\n");
	  printf("how to compose the colors!\n");
#endif
	  XcoInitError=XcoInitBadMask;
	  return 1;
	}

      r_bits=0;
      g_bits=0;
      b_bits=0;
      r_shift=0;
      g_shift=0;
      b_shift=0;
      /* search for first red bit. */
      while (((1<<r_shift) & (r_mask))==0)
	r_shift++;
      /* how many bits are there? */
      while(((1<<(r_shift+r_bits)) & (r_mask))!=0)
	r_bits++;
      /* search for first green bit. */
      while (((1<<g_shift) & (g_mask))==0)
	g_shift++;
      /* how many bits are there? */
      while(((1<<(g_shift+g_bits)) & (g_mask))!=0)
	g_bits++;
      /* search for first blue bit. */
      while (((1<<b_shift) & (b_mask))==0)
	b_shift++;
      /* how many bits are there? */
      while(((1<<(b_shift+b_bits)) & (b_mask))!=0)
	b_bits++;

      /* Test that all is ok... */
      r_mask=((1<<r_bits)-1)<<r_shift;
      g_mask=((1<<g_bits)-1)<<g_shift;
      b_mask=((1<<b_bits)-1)<<b_shift;
      

      if ((r_mask!=visual->red_mask) ||
	  (g_mask!=visual->green_mask) ||
	  (b_mask!=visual->blue_mask))
	{
#if 0
	  printf("Unsupported rgb masks\n");
#endif
	  XcoInitError=XcoInitBadMask;
	  return 1;
	}
    }
  else
    {
      int colormap_depth;
      int colormaps;
      long unsigned int *color_cells;
      int ncells;
      int ncelldepth;
      int next_to_alloc;
      int i;
      int rc,r,gc,g,bc,b;
      XColor colorelement;
      int r_colors;
      int g_colors;
      int b_colors;

      /* Setup screen to resemble a true color screen and set the
       corresponding mask values */

      use_alloc_colortable=1;
      colormapsize=visual->map_entries;
      /* Here one can set the colormapsize to something else and test
	 very different colormap sizes.
	 */
      colormap_depth=-1;
      colormaps=colormapsize;
      while (colormaps>0)
	{
	  colormaps>>=1;
	  colormap_depth++;
	}

      if (colormap_depth>depth)
	{
#if 0
	  printf("The colormap contains more entries than the depth of the\n");
	  printf("screen. Quite odd...\n");
#endif
	  
	  XcoInitError=XcoInitBadColormap;
	  return 1;
	}


      color_cells=NULL;
      ncells=colormapsize;
      ncelldepth=colormap_depth;
      if ((shared_colormap)&&(default_visual))
	{
	  Colormap cmap;
	  int status;
	  /******************
	    If we have enough free color cells, it may be better *not*
	    to install an own colormap...
	    ******************/
	  color_cells=malloc(sizeof(long unsigned int)*colormapsize);
	  cmap=DefaultColormap(display,screen);
	  status=0;
	  while ((!status)&&(ncells>=8))
	    {
	      /*    printf("ncells: %d\n",ncells); */
	      status=XAllocColorCells(display,cmap,0,NULL,0,color_cells,ncells);
	      if (status==0)
		{
		  ncells>>=1;
		  ncelldepth--;
		}
	    }
	  if (ncells<8)
	    shared_colormap=0;
	}

      if (shared_colormap)
	{
	  colormap=DefaultColormap(display,screen);
	  colormapsize=ncells;
	  colormap_depth=ncelldepth;
	}
      else
	colormap=XCreateColormap(display,RootWindow(display,screen),
				 visual,AllocNone);
      
      r_bits=0;
      g_bits=0;
      b_bits=0;

      next_to_alloc=0;
      
      /* Leave some colors free... */
      /*      colormap_depth--; */
      if (colormap_depth>10)
	{
#if 0
	  printf("Too many colors.\n");
#endif
	  XcoInitError=XcoInitTooManyColors;
	  return 1;
	}
      
      for (i=1; i<=colormap_depth; i++)
	{
	  if (next_to_alloc==0)
	    g_bits++;
	  if (next_to_alloc==1)
	    r_bits++;
	  if (next_to_alloc==2)
	    b_bits++;
	  next_to_alloc++;
	  if (next_to_alloc>2)
	    next_to_alloc=0;
	}
      r_shift=0;
      g_shift=r_bits;
      b_shift=r_bits+g_bits;
      r_mask=((1<<r_bits)-1)<<r_shift;
      g_mask=((1<<g_bits)-1)<<g_shift;
      b_mask=((1<<b_bits)-1)<<b_shift;
      
      r_colors=(1<<r_bits)-1;
      g_colors=(1<<g_bits)-1;
      b_colors=(1<<b_bits)-1;
      for (rc=0; rc<=r_colors; rc++)
	{
	  /* Requires at least 32 bit ints and that no more than 15 planes
	     per color. Should be ok. */
	  for (gc=0; gc<=g_colors; gc++)
	    {
	      for (bc=0; bc<=b_colors; bc++)
		{

		  r=(rc*65535)/r_colors;
		  g=(gc*65535)/g_colors;
		  b=(bc*65535)/b_colors;
		  if (shared_colormap)
		    {
		      colorelement.pixel=color_cells[rc|(gc<<g_shift)|(bc<<b_shift)];
		      colorelement.red=r;
		      colorelement.green=g;
		      colorelement.blue=b;
		      colorelement.flags=DoRed|DoGreen|DoBlue;
		      XStoreColor(display,colormap,&colorelement);
		      alloc_colortable[rc|(gc<<g_shift)|(bc<<b_shift)]=color_cells[rc|(gc<<g_shift)|(bc<<b_shift)];
		    }
		  else
		    {
		      colorelement.red=r;
		      colorelement.green=g;
		      colorelement.blue=b;
		      colorelement.flags=DoRed|DoGreen|DoBlue;
		      XAllocColor(display,colormap,&colorelement);
		      alloc_colortable[rc|(gc<<g_shift)|(bc<<b_shift)]=colorelement.pixel;
		    }
		}
	    }
	}
    }
  printf("rgb:%d%d%d\n",r_bits,g_bits,b_bits);
  /*
  printf("r_bits:%d\n",r_bits);
  printf("g_bits:%d\n",g_bits);
  printf("b_bits:%d\n",b_bits);
  printf("r_mask:%d\n",r_mask);
  printf("g_mask:%d\n",g_mask);
  printf("b_mask:%d\n",b_mask);
  printf("r_shift:%d\n",r_shift);
  printf("g_shift:%d\n",g_shift);
  printf("b_shift:%d\n",b_shift);
  */
  if ((r_bits==0) || (g_bits==0) || (b_bits==0))
    {
#if 0
      printf("I need at least one bit per r,g and b.\n");
#endif
      XcoInitError=XcoInitBadMask;
      return 1;
    }

  if ((r_bits>8) || (g_bits>8) || (b_bits>8))
    {
#if 0
      printf("Your display uses more than 8 bits per r, g and/or b.\n");
      printf("This is unexpected.\n");
#endif
      XcoInitError=XcoInitBadMask;
      return(1);
    }
  /* Compute how to do dithering. */
  if ((r_bits>=7) && (g_bits>=7) && (b_bits>=7))
    {
      do_dither=0;
    }
  else
    {
      do_dither=1;
      /* The dithering in this program adds up to four more bits of resolution
	 per component. */
      dither_rmask=((1<<(8-r_bits))-1);
      dither_gmask=((1<<(8-g_bits))-1);
      dither_bmask=((1<<(8-b_bits))-1);
      dither_radd=1<<(8-r_bits);
      dither_gadd=1<<(8-g_bits);
      dither_badd=1<<(8-b_bits);
    }

  
  __XcoInitDitherBuffers();  

  /*depth=r_bits+g_bits+b_bits; */
  pad=bpad;
  while (pad<xbpp)
    pad+=bpad;
  padbyte=pad/BITS_PER_BYTE;
  bytes_per_pixel=xbpp/BITS_PER_BYTE;
  __XcoInitObjects();

  /* Initialize fonts... */
  myfont=XcoLoadFont("-*-helvetica-*-r-*-*-12-*-*-*-*-*-*-*");

  if (myfont==NULL)
    {
      printf("Helvetica does not exist. Trying fixed as default font...\n");
      myfont=XcoLoadFont("fixed");
      if (myfont==NULL)
	{
	  printf("Not even the fixed fonts exist! Look I really need some default font!\n");
	  XcoInitError=XcoInitNoFonts;
	  return 1;
	}
    }
  XcoLabelFont(myfont);
  XcoCommandFont(myfont);
  XcoDialogFont(myfont);
  XcoListFont(myfont);
  XcoMenuFont(myfont);
  XcoPulldownListFont(myfont);
  XcoProgressWindowFont(myfont);

  XcoSetDefaultBackground(PIXEL(0xd9,0xd9,0xd9));
  XcoSetDefaultForeground(PIXEL(0,0,0));

  XcoInitError=XcoInitNoError;
  return 0;
}

int XcoGetPixel(int x, int y,int r,int g, int b)
{
  int c;
  /* dither */
  if (do_dither)
    {
      int pos=(x & 0x3)+((y & 0x3)<<2);
      r=dithertable_r[pos+(r<<4)];
      g=dithertable_g[pos+(g<<4)];
      b=dithertable_b[pos+(b<<4)];
    }
  else
    {
      r=(r>>(8-r_bits))<<r_shift;
      g=(g>>(8-g_bits))<<g_shift;
      b=(b>>(8-b_bits))<<b_shift;
    }
  /* convert rgb to pixel */
  c=r | g | b;
  if (use_alloc_colortable)
    c=alloc_colortable[c];
  return(c);
}

int XcoGetPixel32(int x, int y,int pixel)
{
  int c;
  int r=pixel&0xFF;
  int g=(pixel>>8)&0xFF;
  int b=(pixel>>16)&0xFF;

  /*  dither */
  if (do_dither)
    {
      int pos=(x & 0x3)+((y & 0x3)<<2);
      r=dithertable_r[pos+(r<<4)];
      g=dithertable_g[pos+(g<<4)];
      b=dithertable_b[pos+(b<<4)];
    }
  else
    {
      r=(r>>(8-r_bits))<<r_shift;
      g=(g>>(8-g_bits))<<g_shift;
      b=(b>>(8-b_bits))<<b_shift;
    }
  /* convert rgb to pixel */
  c=r | g | b;
  if (use_alloc_colortable)
    c=alloc_colortable[c];
  return(c);
}

int XcoGetReversePixel(int pixel)
{
  int r,g,b;
  if (use_alloc_colortable)
    {
      int i=0;
      while (pixel!=alloc_colortable[i])
	i++;
      pixel=i;
    }
  r=(((pixel&r_mask)>>r_shift)*255)/((1<<r_bits)-1);
  g=(((pixel&g_mask)>>g_shift)*255)/((1<<g_bits)-1);
  b=(((pixel&b_mask)>>b_shift)*255)/((1<<b_bits)-1);
  return(r|(g<<8)|(b<<16));
}

void XcoDitherImage(uint32 *from,unsigned char *to,int i_x,int i_y,int ditherdepth)
{
  uint32 *ptr;
  int mypadbyte;
  int x,y,posy,pos,c;

  ptr=from;
  mypadbyte=padbyte;
  /*  printf("Enter XcoDitherImage with bytes_per_pixel=%d, mypadbyte=%d, ditherdepth=%d\n",bytes_per_pixel,mypadbyte,ditherdepth);
  printf("Pad:%d, NPad:%d\n",XcoGetPad(),XcoGetNPad()); */
  if (do_dither)
    {
      switch(bytes_per_pixel)
	{
	case 1:
	  {
	    uint8 *toptr=(uint8*) to;
	    for (y=0; y<i_y; y++)
	      {
		posy=(y&0x3)<<2;
		for (x=0; x<i_x; x++)
		  {
		    pos=(x & 0x3)+posy;
		    
		    /* convert rgb to pixel */
		    c=(
			 dithertable_r[pos+(
					    (*ptr&0xFF)
					    <<4)]
			  |
		       
			 dithertable_g[pos+(
					    ((*ptr>>4)&0xFF0)
					    )]
			  |
		       
			 dithertable_b[pos+(
					    ((*ptr>>12)&0xFF0)
					    )]
			 );
		    ptr++;
		    if (use_alloc_colortable)
		      c=alloc_colortable[c];
		    *toptr++=c;
		    
		  }
		toptr+=XcoGetNPad();
	      }
	  }
	break;
	case 2:
	  {
	    if (require_byte_swap)
	      {
		uint16 *toptr=(uint16*) to;
		/* This doesn't completely cover all cases, but I can see no reason to why
		   we want to pad to something not a multiple of 16.
		   */
		int iadd=XcoGetNPad()/2;
		for (y=0; y<i_y; y++)
		  {
		    posy=(y&0x3)<<2;
		    for (x=0; x<i_x; x++)
		      {
			pos=(x & 0x3)+posy;
		    
			/* convert rgb to pixel */
			*toptr++=byteswap16((uint16)(
				    dithertable_r[pos+(
						       (*ptr&0xFF)
						       <<4)]
				    |
				  
				    dithertable_g[pos+(
						       ((*ptr>>4)&0xFF0)
						       )]
				    |
				  
				    dithertable_b[pos+(
						       ((*ptr>>12)&0xFF0)
						       )]
				  ));
			ptr++;

		      }
		    toptr+=iadd;
		  }
	      }
	    else
	      {
		uint16 *toptr=(uint16*) to;
		/* This doesn't completely cover all cases, but I can see no reason to why
		   we want to pad to something not a multiple of 16.
		   */
		int iadd=XcoGetNPad()/2;
		for (y=0; y<i_y; y++)
		  {
		    posy=(y&0x3)<<2;
		    for (x=0; x<i_x; x++)
		      {
			pos=(x & 0x3)+posy;
		    
			/* convert rgb to pixel */
			*toptr++=(
				    dithertable_r[pos+(
						       (*ptr&0xFF)
						       <<4)]
				   |
				  
				    dithertable_g[pos+(
						       ((*ptr>>4)&0xFF0)
						       )]
				    |
				  
				    dithertable_b[pos+(
						       ((*ptr>>12)&0xFF0)
						       )]
				   );
			ptr++;
		      }
		    toptr+=iadd;
		  }
	      }
	  }
	
	break;
	case 3:
	  {
	    printf("Non implemented dithered 24 bit mode\n");
	  }
	
	break;
	case 4:
	  {
	    printf("Non implemented dithered 24(32) bit mode\n");
	  }
	
	break;
	default:
	  printf("Internal error 0.\n");
	}
    }
  else
    {
      switch(bytes_per_pixel)
	{
	case 1:
	  {
	    uint8 *toptr=(uint8*) to;
	    for (y=0; y<i_y; y++)
	      {
		for (x=0; x<i_x; x++)
		  {
		    /* convert rgb to pixel */
		    c=((((*ptr&0xFF)
			     >>(8-r_bits))<<r_shift) |
			   ((((*ptr>>8)&0xFF)
			     >>(8-g_bits))<<g_shift) |
			   ((((*ptr>>16)&0xFF)
			     >>(8-b_bits))<<b_shift));
		    ptr++;

		    if (use_alloc_colortable)
		      c=alloc_colortable[c];

		    *toptr++=c;
		  }
		toptr+=XcoGetNPad();
	      }
	  }
	break;
	case 2:
	  {
	    if (require_byte_swap)
	      {
		uint16 *toptr=(uint16*) to;
		/* This doesn't completely cover all cases, but I can see no reason to why
		   we want to pad to something not a multiple of 16.
		   */
		int iadd=XcoGetNPad()/2;
		for (y=0; y<i_y; y++)
		  {
		    for (x=0; x<i_x; x++)
		      {
			/* convert rgb to pixel */
			*toptr++=byteswap16((uint16)((((*ptr&0xFF)
				    >>(8-r_bits))<<r_shift) |
				  ((((*ptr>>8)&0xFF)
				    >>(8-g_bits))<<g_shift) |
				  ((((*ptr>>16)&0xFF)
				    >>(8-b_bits))<<b_shift)));
			ptr++;
		      }
		    toptr+=iadd;
		  }
	      }
	    else
	      {
		uint16 *toptr=(uint16*) to;
		/* This doesn't completely cover all cases, but I can see no reason to why
		   we want to pad to something not a multiple of 16.
		   */
		int iadd=XcoGetNPad()/2;
		for (y=0; y<i_y; y++)
		  {
		    for (x=0; x<i_x; x++)
		      {
			/* convert rgb to pixel */
			*toptr++=((((*ptr&0xFF)
				    >>(8-r_bits))<<r_shift) |
				  ((((*ptr>>8)&0xFF)
				    >>(8-g_bits))<<g_shift) |
				  ((((*ptr>>16)&0xFF)
				    >>(8-b_bits))<<b_shift));
			ptr++;
		      }
		  }
		toptr+=iadd;
	      }
	  }
	break;
	case 3:
	  {
	    uint8 *toptr=(uint8*) to;
	    int rloc=0,gloc=0,bloc=0;
	    if (require_byte_swap)
	      {
		rloc=2;
		gloc=2;
		bloc=2;
		if (r_shift==8) rloc=1;
		if (r_shift==16) rloc=0;
		if (g_shift==8) gloc=1;
		if (g_shift==16) gloc=0;
		if (b_shift==8) bloc=1;
		if (b_shift==16) bloc=0;
	      }
	    else
	      {
		if (r_shift==8) rloc=1;
		if (r_shift==16) rloc=2;
		if (g_shift==8) gloc=1;
		if (g_shift==16) gloc=2;
		if (b_shift==8) bloc=1;
		if (b_shift==16) bloc=2;
	      }
	    for (y=0; y<i_y; y++)
	      {
		for (x=0; x<i_x; x++)
		  {
		    /* convert rgb to pixel */

		    *(toptr+rloc)=(*ptr&0xFF);
		    *(toptr+gloc)=((*ptr>>8)&0xFF);
		    *(toptr+bloc)=((*ptr++>>16)&0xFF);

		      toptr+=3;
		  }
		toptr+=XcoGetNPad();
	      }
	  }
	  break;
	case 4:
	  {
	    if (require_byte_swap)
	      {
		uint32 *toptr=(uint32*) to;
		for (y=0; y<i_y; y++)
		  {
		    for (x=0; x<i_x; x++)
		      {
			/* convert rgb to pixel */
			*toptr++=byteswap32((uint32)(((*ptr&0xFF)
				    >>(8-r_bits))<<r_shift) |
				  ((((*ptr>>8)&0xFF)
				    >>(8-g_bits))<<g_shift) |
				  ((((*ptr>>16)&0xFF)
				    >>(8-b_bits))<<b_shift));
			ptr++;
		      }
		  }
	      }
	    else
	      {
		uint32 *toptr=(uint32*) to;
		for (y=0; y<i_y; y++)
		  {
		    for (x=0; x<i_x; x++)
		      {
			/* convert rgb to pixel */
			*toptr++=((((*ptr&0xFF)
				    >>(8-r_bits))<<r_shift) |
				  ((((*ptr>>8)&0xFF)
				    >>(8-g_bits))<<g_shift) |
				  ((((*ptr>>16)&0xFF)
				    >>(8-b_bits))<<b_shift));
			ptr++;
		      }
		  }
	      }
	  }
	break;

	default:
	  printf("Internal error 1.\n");
	}
    }
}

void XcoFlush()
{
  XFlush(display);
}

Pixmap XcoCreatePixmapFromImage(XcoObject id,unsigned int *myimage,int xsize,int ysize)
{
  Pixmap mypixmap;
  unsigned char *dimage;
  XImage *myximage;

  /* printf("XcoCreatePixmapFromImage\n"); */
  mypixmap=XCreatePixmap(XcoGetDisplay(),XcoWindow(id),xsize,ysize,XcoGetDepth());

  dimage=malloc((XcoGetNPad()+bytes_per_pixel*xsize)*ysize);
  XcoDitherImage(myimage,dimage,xsize,ysize,-1);

  myximage=XCreateImage(XcoGetDisplay(),XcoGetVisual(),XcoGetDepth(),ZPixmap,0,(char*) dimage,xsize,ysize,pad,xsize*bytes_per_pixel+XcoGetNPad());

  XPutImage(XcoGetDisplay(),mypixmap,XcoGC(id),myximage,0,0,0,0,xsize,ysize);
 
  XDestroyImage(myximage);

  return(mypixmap);
}

Pixmap XcoCreatePixmapFromCimage(XcoObject id,unsigned char *data,int xsize,int ysize)
{
  unsigned int *myimage;
  Pixmap mypixmap;

  myimage=XcoCimageToImage(data,xsize,ysize);
  mypixmap=XcoCreatePixmapFromImage(id,myimage,xsize,ysize);
  free(myimage);
  return(mypixmap);
}

