/* This is horizline.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: horizline.c 2 2001-10-30 13:35:39Z daniels $";

#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"


void __expose_horizline(XcoObject id)
{
  int first=(__objects[id]->height-3)/2;
  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,PIXEL(0,0,0)));
  XDrawLine(XcoGetDisplay(),XcoWindow(id),XcoGC(id),0,first,__objects[id]->width,first);
  XDrawLine(XcoGetDisplay(),XcoWindow(id),XcoGC(id),0,first+2,__objects[id]->width,first+2);
  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,PIXEL(255,255,255)));
  XDrawLine(XcoGetDisplay(),XcoWindow(id),XcoGC(id),0,first+1,__objects[id]->width,first+1);
#if 0
  XcoDraw3DBox(id,0,0,
	       __objects[id]->width,
	       __objects[id]->height);
#endif
}

void __horizline_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_horizline(id);
      break;
    }
}

XcoObject XcoCreateHorizLine(XcoObject parent,
			     int x,int y,int width,int height)
{
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  __objects[myobject]->type=XcoTHorizLine;
  
  __expose_horizline(myobject);

  XcoAddCallback(myobject,__horizline_callback);

  return (myobject);
}

