/* This is colorsel.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: colorsel.c 2 2001-10-30 13:35:39Z daniels $";


#include <X11/Xlib.h>

#include <stdio.h>
#include <stdlib.h>

#include "Xco.h"

typedef struct
{
  unsigned char r,g,b;
  XcoObject selbox[4];
  XcoObject modetoggle;
  XcoObject showbox;
  XcoObject rgbdialog[3];
  void (*callback)(int r,int g,int b,int ok);  
} colorseldata;

typedef struct
{
  XcoObject colorselector;
} parentdata;

static void togglecallback(XcoObject id,XEvent event)
{
  if ((event.type==ButtonPress) || (event.type==MotionNotify))
    {
      int i;
      XcoObject parent=((parentdata*)(__objects[id]->parentdata))->colorselector;
      colorseldata *mydata=(colorseldata*)__objects[parent]->data;
      int sq=XcoGetToggleSelected(mydata->modetoggle);
      
      for (i=0; i<=3; i++)
	XcoSetColorselboxMode(mydata->selbox[i],sq);
    }
}

static void set_cpixmap(XcoObject id,int r,int g, int b)
{
  int i;
  Pixmap colorpixmap;
  unsigned int image[16];
  for (i=0; i<16; i++)
    image[i]=PIXEL(r,g,b);
  colorpixmap=XcoCreatePixmapFromImage(id,image,4,4);
  XcoSetBackgroundPixmap(id,colorpixmap,True);
  XFreePixmap(XcoGetDisplay(),colorpixmap);
}

static void selboxcallback(XcoObject id,XEvent event)
{
  if ((event.type==ButtonPress) || (event.type==MotionNotify))
    {
      XcoObject parent=((parentdata*)(__objects[id]->parentdata))->colorselector;
      colorseldata *mydata=(colorseldata*)__objects[parent]->data;
      int i=0,j;
      uint32 c;
      char mystr[5];
      while (mydata->selbox[i]!=id)
	i++;
      c=XcoGetColorselboxColor(mydata->selbox[i]);
      for (j=0; j<=3; j++)
	if (i!=j)
	  XcoSetColorselboxColor(mydata->selbox[j],
				 R_OF_PIXEL(c),
				 G_OF_PIXEL(c),
				 B_OF_PIXEL(c));
      mydata->r=R_OF_PIXEL(c);
      mydata->g=G_OF_PIXEL(c);
      mydata->b=B_OF_PIXEL(c);
      

      sprintf(mystr,"%d",mydata->r);      
      XcoSetDialogValue(mydata->rgbdialog[0],mystr);
      sprintf(mystr,"%d",mydata->g);      
      XcoSetDialogValue(mydata->rgbdialog[1],mystr);
      sprintf(mystr,"%d",mydata->b);      
      XcoSetDialogValue(mydata->rgbdialog[2],mystr);

      set_cpixmap(mydata->showbox,R_OF_PIXEL(c),G_OF_PIXEL(c),B_OF_PIXEL(c));
      mydata->callback(R_OF_PIXEL(c),G_OF_PIXEL(c),B_OF_PIXEL(c),0);
    }
}

void XcoCallColorselectorCallback(XcoObject id)
{
  colorseldata *mydata=(colorseldata*)__objects[id]->data;
  mydata->callback(mydata->r,mydata->g,mydata->b,1);
}

static void colorenter(XcoObject id,XEvent event)
{
  /*  printf("colorenter\n"); */
  if (XcoDialogEnter(id,event))
    {
      int j;
      char mystr[5];
      XcoObject parent=((parentdata*)(__objects[id]->parentdata))->colorselector;
      colorseldata *mydata=(colorseldata*)__objects[parent]->data;

      int rgb=atoi(XcoGetDialogValue(mydata->rgbdialog[0]));
      if (rgb<0)
	rgb=0;
      if (rgb>255)
	rgb=255;
      mydata->r=rgb;

      rgb=atoi(XcoGetDialogValue(mydata->rgbdialog[1]));
      if (rgb<0)
	rgb=0;
      if (rgb>255)
	rgb=255;
      mydata->g=rgb;

      rgb=atoi(XcoGetDialogValue(mydata->rgbdialog[2]));
      if (rgb<0)
	rgb=0;
      if (rgb>255)
	rgb=255;
      mydata->b=rgb;

      for (j=0; j<=3; j++)
	XcoSetColorselboxColor(mydata->selbox[j],
			       mydata->r,mydata->g,mydata->b);


      sprintf(mystr,"%d",mydata->r);      
      XcoSetDialogValue(mydata->rgbdialog[0],mystr);
      sprintf(mystr,"%d",mydata->g);      
      XcoSetDialogValue(mydata->rgbdialog[1],mystr);
      sprintf(mystr,"%d",mydata->b);      
      XcoSetDialogValue(mydata->rgbdialog[2],mystr);

      set_cpixmap(mydata->showbox,mydata->r,mydata->g,mydata->b);
      mydata->callback(mydata->r,mydata->g,mydata->b,0);
    }
}

XcoObject XcoCreateColorselector(XcoObject parent,
				 int x,int y,int width,int height,
				 int r,int g,int b,
				 void (*callback)(int r,int g,int b,int ok))
{
  parentdata *myparent0,*myparent1,*myparent2,*myparent3,
    *myparenttoggle,*myparentrgb0,*myparentrgb1,*myparentrgb2;
  XcoObject box;
  char mystr[10];
  int rightstop,wh;
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  XcoObject myobject2=XcoCreateDialogParent(myobject,0,0,width,height);



  colorseldata *mycolorsel=malloc(sizeof( colorseldata));

  myparent0=malloc(sizeof(parentdata));
  myparent0->colorselector=myobject;
  myparent1=malloc(sizeof(parentdata));
  myparent1->colorselector=myobject;
  myparent2=malloc(sizeof(parentdata));
  myparent2->colorselector=myobject;
  myparent3=malloc(sizeof(parentdata));
  myparent3->colorselector=myobject;
  myparenttoggle=malloc(sizeof(parentdata));
  myparenttoggle->colorselector=myobject;
  myparentrgb0=malloc(sizeof(parentdata));
  myparentrgb0->colorselector=myobject;
  myparentrgb1=malloc(sizeof(parentdata));
  myparentrgb1->colorselector=myobject;
  myparentrgb2=malloc(sizeof(parentdata));
  myparentrgb2->colorselector=myobject;
  
  mycolorsel->callback=callback;

  mycolorsel->r=r;
  mycolorsel->g=g;
  mycolorsel->b=b;

  rightstop=height-30;
  wh=(rightstop-15)/2;
  box=XcoCreateBox3D(myobject2,5,5,wh,wh,0,1);
  mycolorsel->selbox[0]=XcoCreateColorselbox(box,1,1,wh-2,wh-2,
					     r,g,b,
					     255,255,255,
					     0,0,0,
					     1,1,0);
  XcoSetResizeMethod(mycolorsel->selbox[0],XcoUpLeftDownRight);
  __objects[mycolorsel->selbox[0]]->parentdata=myparent0;
  XcoAddCallback(mycolorsel->selbox[0],selboxcallback);
  box=XcoCreateBox3D(myobject2,10+wh,5,wh,wh,0,1);
  mycolorsel->selbox[1]=XcoCreateColorselbox(box,1,1,wh-2,wh-2,
					     r,g,b,
					     255,0,0,
					     0,255,255,
					     1,1,0);
  XcoSetResizeMethod(mycolorsel->selbox[1],XcoUpLeftDownRight);
  __objects[mycolorsel->selbox[1]]->parentdata=myparent1;
  XcoAddCallback(mycolorsel->selbox[1],selboxcallback);
  box=XcoCreateBox3D(myobject2,5,10+wh,wh,wh,0,1);
  mycolorsel->selbox[2]=XcoCreateColorselbox(box,1,1,wh-2,wh-2,
					     r,g,b,
					     0,255,0,
					     255,0,255,
					     1,1,0);
  XcoSetResizeMethod(mycolorsel->selbox[2],XcoUpLeftDownRight);
  __objects[mycolorsel->selbox[2]]->parentdata=myparent2;
  XcoAddCallback(mycolorsel->selbox[2],selboxcallback);
  box=XcoCreateBox3D(myobject2,10+wh,10+wh,wh,wh,0,1);
  mycolorsel->selbox[3]=XcoCreateColorselbox(box,1,1,wh-2,wh-2,
					     r,g,b,
					     0,0,255,
					     255,255,0,
					     1,1,0);
  XcoSetResizeMethod(mycolorsel->selbox[3],XcoUpLeftDownRight);
  __objects[mycolorsel->selbox[3]]->parentdata=myparent3;
  XcoAddCallback(mycolorsel->selbox[3],selboxcallback);
  

  box=XcoCreateHole(myobject2,10,height-25,rightstop-10,20);
  XcoSetResizeMethod(box,XcoDownLeft);
  mycolorsel->modetoggle=XcoCreateToggle(box,0,5,10,10,PIXEL(255,0,0),1,0);
  XcoCreateLabel(box,10,5,"Square mode",0,0);
  __objects[mycolorsel->modetoggle]->parentdata=myparenttoggle;
  XcoAddCallback(mycolorsel->modetoggle,togglecallback);

  box=XcoCreateBox3D(myobject2,rightstop+10,10,width-rightstop-20,40,1,1);
  mycolorsel->showbox=XcoCreateHole(box,2,2,width-rightstop-24,36);
  XcoSetResizeMethod(mycolorsel->showbox,XcoUpLeftDownRight);

  set_cpixmap(mycolorsel->showbox,r,g,b);


  box=XcoCreateHole(myobject2,rightstop+10,70,width-rightstop-20,20);
  XcoCreateLabel(box,0,0,"Red:",0,0);
  sprintf(mystr,"%d",r);
  mycolorsel->rgbdialog[0]=XcoCreateDialog(box,50,0,myobject2,
					   mystr,3,50,20);
  __objects[mycolorsel->rgbdialog[0]]->parentdata=myparentrgb0;
  XcoAddCallback(mycolorsel->rgbdialog[0],colorenter);

  box=XcoCreateHole(myobject2,rightstop+10,100,width-rightstop-20,20);
  XcoCreateLabel(box,0,0,"Green:",0,0);
  sprintf(mystr,"%d",g);
  mycolorsel->rgbdialog[1]=XcoCreateDialog(box,50,0,myobject2,
					   mystr,3,50,20);
  __objects[mycolorsel->rgbdialog[1]]->parentdata=myparentrgb1;
  XcoAddCallback(mycolorsel->rgbdialog[1],colorenter);

  box=XcoCreateHole(myobject2,rightstop+10,130,width-rightstop-20,20);
  XcoCreateLabel(box,0,0,"Blue:",0,0);
  sprintf(mystr,"%d",b);

  mycolorsel->rgbdialog[2]=XcoCreateDialog(box,50,0,myobject2,
					   mystr,3,50,20);

  __objects[mycolorsel->rgbdialog[2]]->parentdata=myparentrgb2;
  XcoAddCallback(mycolorsel->rgbdialog[2],colorenter);
  
  __objects[myobject]->data=(void*) mycolorsel;
  __objects[myobject]->type=XcoTColorselector;

  return (myobject);
}


typedef struct
{
  XcoObject myselbox;
  XcoObject colorselector;
} parentdata2;

static void cselcallback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      XcoCallColorselectorCallback(((parentdata2*)(__objects[id]->parentdata))->colorselector);
    }
}

static void clcallback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      XcoObject mybox=((parentdata2*)(__objects[id]->parentdata))->myselbox;
      XcoDeleteObject(mybox);
    }
}

static void delcallback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      XcoDeleteObject(id);
    }
}

XcoObject XcoColorselector(int r,int g,int b,
		      void (*callback)(int r,int g,int b,int ok))
{
  XcoObject ok,close,id;
  parentdata2 *myparent,*myparent2;
  XcoObject myobject=XcoCreateWindow(0,0,400,300,DEFAULT_BACKGROUND,1,-1);
  XStoreName(XcoGetDisplay(),XcoWindow(myobject),"Select color");
  XcoAddCallback(myobject,delcallback);
  id=XcoCreateColorselector(myobject,
				      0,0,400,300,
				      r,g,b,
				      callback);

  ok=XcoCreateCommand(id,290,270,"Apply",0,0);
  XcoAddCallback(ok,cselcallback);
  myparent=malloc(sizeof( parentdata2));
  myparent->myselbox=myobject;
  myparent->colorselector=id;
  __objects[ok]->parentdata=myparent;

  close=XcoCreateCommand(id,350,270,"Close",0,0);
  XcoAddCallback(close,clcallback);
  myparent2=malloc(sizeof(parentdata2));
  myparent2->myselbox=myobject;
  myparent2->colorselector=id;
  __objects[close]->parentdata=myparent2;
  return myobject;
}
