/* This is box3d.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg

   */

static char rcsid[]="$Id: box3d.c 2 2001-10-30 13:35:39Z daniels $";

#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"

typedef struct
{
  int show;
  int inverted;
} box3ddata;


void __expose_box3d(XcoObject id)
{
  if (((box3ddata*)(__objects[id]->data))->show)
    if (((box3ddata*)(__objects[id]->data))->inverted==2)
      XcoDrawDecoratedBox(id,0,0,
			  __objects[id]->width,
			  __objects[id]->height);
    else if (((box3ddata*)(__objects[id]->data))->inverted==1)
      XcoDrawInverted3DBox(id,0,0,
			   __objects[id]->width,
			   __objects[id]->height);
    else
      XcoDraw3DBox(id,0,0,
		   __objects[id]->width,
		   __objects[id]->height);
  else
    XClearWindow(XcoGetDisplay(),XcoWindow(id));
}

void __box3d_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_box3d(id);
      break;
    }
}

void XcoSetBox3DStatus(XcoObject id,int show)
{
  ((box3ddata*)(__objects[id]->data))->show=show;
  __expose_box3d(id);
}

void XcoSetBox3DInverted(XcoObject id,int inverted)
{
  ((box3ddata*)(__objects[id]->data))->inverted=inverted;
  __expose_box3d(id);
}

XcoObject XcoCreateBox3D(XcoObject parent,
			 int x,int y,int width,int height,int inverted,int show)
{
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  box3ddata *mydata=malloc(sizeof( box3ddata));
  mydata->show=show;
  mydata->inverted=inverted;
  __objects[myobject]->data=(void*) mydata;


  __objects[myobject]->type=XcoTBox3D;
  
  __expose_box3d(myobject);

  XcoAddCallback(myobject,__box3d_callback);

  return (myobject);
}

