/* Compile for instance with 
   gcc -O2 -o testsock testsock.c libymol.a -lm */
#include <stdio.h>
#include <math.h>
#include "ymolsock.h"

int main()
{
  double t=0.;
  int n=200;
  double radius=5.;
  double step=1./(n*50);
  double pi=3.1415926;
  ymolsock_init();
  while (1)
    {
      int i;
      if (ymolsock_check_ymol())
	{
	  if (ymolsock_write_natoms(n))
	    {
	      for (i=0; i<n; i++)
		{
		  double x=radius*sin(3*(t+i*pi*2/n));
		  double y=radius*cos(5*(t+i*pi*2/n));
		  double z=radius*cos(7*(t+i*pi*2/n));
		  ymolsock_write_atom(i,1,x,y,z);
		}
	    }
	}
      t+=pi*2*step;
    }

  ymolsock_deinit();
  return 0;
}
