# Simple python md program to test ymol socket input.
from socket import *
from math import floor
from random import random

f=open("ymol_sockimport","r")
magic_cookie=f.readline()
hostname=f.readline().split()[0]
port=int(f.readline().split()[0])
f.close()

ipnr = gethostbyname(hostname)
print hostname,"IP address",ipnr

sock = socket(AF_INET, SOCK_STREAM)
sock.connect((ipnr, port))
sock.send(magic_cookie+'\n')

class vec(object):
    def __init__(self,tvec=[0.,0.,0.]):
        self.__vec=tvec[:]

    def get(self):
        return self.__vec

    def set(self,tvec):
        self.__vec=tvec[:]

    vec=property(get,set)

    def getx(self):
        return self.__vec[0]

    def gety(self):
        return self.__vec[1]

    def getz(self):
        return self.__vec[2]

    def setx(self,x):
        self.__vec[0]=x

    def sety(self,y):
        self.__vec[1]=y

    def setz(self,y):
        self.__vec[2]=z

    x=property(getx,setx)
    y=property(gety,sety)
    z=property(getz,setz)

    def zero(self):
        self.__vec[0]=0.
        self.__vec[1]=0.
        self.__vec[2]=0.

    def __iadd__(self,tvec):
        self.__vec[0]+=tvec.__vec[0]
        self.__vec[1]+=tvec.__vec[1]
        self.__vec[2]+=tvec.__vec[2]
        return self

    def __isub__(self,tvec):
        self.__vec[0]-=tvec.__vec[0]
        self.__vec[1]-=tvec.__vec[1]
        self.__vec[2]-=tvec.__vec[2]
        return self

    def __neg__(self):
        return vec([-self.__vec[0],-self.__vec[1],-self.__vec[2]])
        
    def __add__(self,tvec):
        return vec([self.__vec[0]+tvec.__vec[0],self.__vec[1]+tvec.__vec[1],self.__vec[2]+tvec.__vec[2]])

    def __sub__(self,tvec):
        return vec([self.__vec[0]-tvec.__vec[0],self.__vec[1]-tvec.__vec[1],self.__vec[2]-tvec.__vec[2]])

    def __div__(self,s):
        return vec([self.__vec[0]/s,self.__vec[1]/s,self.__vec[2]/s])

    def __mul__(self,s):
        return vec([self.__vec[0]*s,self.__vec[1]*s,self.__vec[2]*s])

    def __imul__(self,s):
        self.__vec[0]*=s
        self.__vec[1]*=s
        self.__vec[2]*=s
        return self

    def len2(self):
        return self.__vec[0]*self.__vec[0]+self.__vec[1]*self.__vec[1]+self.__vec[2]*self.__vec[2]

    def len(self):
        return self.len2()**0.5

class atom(object):
    def __init__(self,x=vec(),v=vec()):
        self.pos=x # Position
        self.vel=v # Velocity
        self.force=vec() # Force

class chemsystem(object):
    def __init__(self,boxlen,atoms,timestep):
        self.atoms=atoms[:]
        self.potential_energy=0.
        self.kinetic_energy=0.
        self.timestep=timestep
        self.boxlen=boxlen
        self.cutoff=2.**(1./6)

    # Compute energy and force using the WCA potential
    def compute_force(self):
        natoms=len(self.atoms) # Number of atoms
        self.potential_energy=0. # Initial potential energy
        cutoff2=self.cutoff**2 # Cut-off squared
        for atom in self.atoms: # Clear all forces on all atoms
            atom.force.zero()
        # Use a simple pair loop
        for i in xrange(natoms):
            for j in xrange(i+1,natoms):
                dv=self.atoms[i].pos-self.atoms[j].pos # Distance vector
                dv-=vec([self.boxlen*floor(0.5+dv.x/self.boxlen), # Min. im.
                         self.boxlen*floor(0.5+dv.y/self.boxlen), # Min. im.
                         self.boxlen*floor(0.5+dv.z/self.boxlen)])
                d2=dv.len2() # Distance squared
                if d2<cutoff2: # Spherical cutoff
                    self.potential_energy+=4*(1./d2**6-1./d2**3)+1.
                    force_divided_by_r=4*(12./d2**7-6./d2**4)
                    force=dv*force_divided_by_r
                    self.atoms[i].force+=force # Accumulate forces on atoms
                    self.atoms[j].force-=force

    def compute_kinetic_energy(self):
        self.kinetic_energy=0.
        for atom in self.atoms:
            self.kinetic_energy+=atom.vel.len2()
        self.kinetic_energy*=0.5

    def remove_linear_momentum(self):
        m=vec([0.,0.,0.])
        for atom in self.atoms:
            m+=atom.vel
        m/=len(self.atoms)
        for atom in self.atoms:
            atom.vel-=m

    def scale_ke(self,target):
        self.compute_kinetic_energy()
        g=(target/self.kinetic_energy)**0.5
        for atom in self.atoms:
            atom.vel=atom.vel*g

    def velocity_verlet(self): # Integrate equations of motion
        ts=self.timestep
        # First find the new positions and first half of velocities
        for atom in self.atoms:
            atom.pos+=atom.vel*ts+atom.force*(ts**2*0.5)
            atom.vel+=atom.force*ts*0.5
            # Make sure the position of the atom is within the central box
            atom.pos-=vec([self.boxlen*floor(atom.pos.x/self.boxlen),
                           self.boxlen*floor(atom.pos.y/self.boxlen),
                           self.boxlen*floor(atom.pos.z/self.boxlen)])
        # Evaluate the force
        self.compute_force()
        # Complete the velocity
        for atom in self.atoms:
            atom.vel+=atom.force*ts*0.5
        self.compute_kinetic_energy()

    def send_atoms(self):
        sock.send(`len(self.atoms)`+'\n')
        for i in range(len(self.atoms)):
            sock.send(`i`+' 1 '+
                      `self.atoms[i].pos.x`+' '+
                      `self.atoms[i].pos.y`+' '+
                      `self.atoms[i].pos.z`+'\n')

# Number of atoms in the system is iatom**3:
iatom=4
# Physical dimensions of the system (boxlen x boxlen)
boxlen=1.1*iatom

# Create a list of atoms. Atoms are placed in a regular grid.
# Velocities are random.
atoms=[]
for i in xrange(iatom):
    for j in xrange(iatom):
        for k in xrange(iatom):
            atoms.append(atom(vec([i*boxlen/iatom,j*boxlen/iatom,k*boxlen/iatom]), # POS
                              vec([10*(random()-0.5),10*(random()-0.5),10*(random()-0.5)]))) #VEL

# Setup the system (sidelength, list of atoms, timestep)
sys=chemsystem(boxlen,atoms,1e-3)

# Compute initial energy/forces
sys.compute_force()

# Simulate the system using the velocity Verlet integrator
print "time PE KE TE"
for itime in xrange(10000):
    sys.velocity_verlet()
    if itime<1000:
        sys.scale_ke(10.)
    print itime, sys.potential_energy, sys.kinetic_energy, \
          sys.potential_energy+sys.kinetic_energy
    if ((itime%10)==0):
        sys.send_atoms()
